/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.mp.SCSequence;
import io.questdb.mp.TimeoutBlockingWaitStrategy;
import io.questdb.mp.WaitStrategy;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.nifi.controller.status.history.questdb.QuestDbContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedQuestDbRolloverHandler
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedQuestDbRolloverHandler.class);
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneOffset.UTC);
    private static final String DELETION_QUERY = "ALTER TABLE %s DROP PARTITION LIST '%s'";
    static final String SELECTION_QUERY = "SELECT DISTINCT * FROM (SELECT (to_str(capturedAt, 'yyyy-MM-dd')) AS partitionName FROM %s)";
    private final Supplier<ZonedDateTime> timeSource;
    private final List<String> tables = new ArrayList<String>();
    private final int daysToKeepData;
    private final QuestDbContext dbContext;

    EmbeddedQuestDbRolloverHandler(Supplier<ZonedDateTime> timeSource, Collection<String> tables, int daysToKeepData, QuestDbContext dbContext) {
        this.timeSource = timeSource;
        this.tables.addAll(tables);
        this.daysToKeepData = daysToKeepData;
        this.dbContext = dbContext;
    }

    public EmbeddedQuestDbRolloverHandler(Collection<String> tables, int daysToKeepData, QuestDbContext dbContext) {
        this(() -> ZonedDateTime.now(), tables, daysToKeepData, dbContext);
    }

    @Override
    public void run() {
        LOGGER.debug("Starting rollover");
        this.tables.forEach(tableName -> this.rolloverTable((CharSequence)tableName));
        LOGGER.debug("Finishing rollover");
    }

    private void rolloverTable(CharSequence tableName) {
        try {
            List<String> partitions = this.getPartitions(tableName);
            String oldestPartitionToKeep = this.getOldestPartitionToKeep();
            for (int i = 0; i < partitions.size() - 1; ++i) {
                String partition = partitions.get(i);
                if (oldestPartitionToKeep.compareTo(partition) <= 0) continue;
                this.deletePartition(tableName, partition);
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not rollover table " + tableName, (Throwable)e);
        }
    }

    private void deletePartition(CharSequence tableName, String partition) {
        try (SqlCompiler compiler = this.dbContext.getCompiler();){
            CompiledQuery compile = compiler.compile((CharSequence)String.format(DELETION_QUERY, tableName, partition), this.dbContext.getSqlExecutionContext());
            compile.execute(new SCSequence((WaitStrategy)new TimeoutBlockingWaitStrategy(5L, TimeUnit.SECONDS)));
        }
        catch (Exception e) {
            LOGGER.error("Dropping partition " + partition + " of table " + tableName + " failed", (Throwable)e);
        }
    }

    private List<String> getPartitions(CharSequence tableName) throws Exception {
        SqlExecutionContext executionContext = this.dbContext.getSqlExecutionContext();
        ArrayList<String> result = new ArrayList<String>(this.daysToKeepData + 1);
        try (SqlCompiler compiler = this.dbContext.getCompiler();
             RecordCursorFactory recordCursorFactory = compiler.compile((CharSequence)String.format(SELECTION_QUERY, tableName), executionContext).getRecordCursorFactory();
             RecordCursor cursor = recordCursorFactory.getCursor(executionContext);){
            while (cursor.hasNext()) {
                Record record = cursor.getRecord();
                result.add(new StringBuilder(record.getStr(0)).toString());
            }
        }
        Collections.sort(result);
        return result;
    }

    private String getOldestPartitionToKeep() {
        ZonedDateTime now = this.timeSource.get();
        ZonedDateTime utc = now.minusDays(this.daysToKeepData).withZoneSameInstant(ZoneOffset.UTC);
        return utc.format(DATE_FORMATTER);
    }
}

