/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.AuthorizerCapabilityDetection;
import org.apache.nifi.authorization.ManagedAuthorizer;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.cluster.protocol.DataFlow;
import org.apache.nifi.cluster.protocol.StandardDataFlow;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.connectable.Size;
import org.apache.nifi.controller.AbstractComponentNode;
import org.apache.nifi.controller.BackoffMechanism;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ParameterProviderNode;
import org.apache.nifi.controller.PositionScaler;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.SnippetManager;
import org.apache.nifi.controller.StandardSnippet;
import org.apache.nifi.controller.Template;
import org.apache.nifi.controller.TemplateUtils;
import org.apache.nifi.controller.Triggerable;
import org.apache.nifi.controller.UninheritableFlowException;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.inheritance.AuthorizerCheck;
import org.apache.nifi.controller.inheritance.BundleCompatibilityCheck;
import org.apache.nifi.controller.inheritance.ConnectionMissingCheck;
import org.apache.nifi.controller.inheritance.FlowFingerprintCheck;
import org.apache.nifi.controller.inheritance.FlowInheritability;
import org.apache.nifi.controller.inheritance.MissingComponentsCheck;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.controller.queue.LoadBalanceCompression;
import org.apache.nifi.controller.queue.LoadBalanceStrategy;
import org.apache.nifi.controller.reporting.ReportingTaskInstantiationException;
import org.apache.nifi.controller.serialization.FlowEncodingVersion;
import org.apache.nifi.controller.serialization.FlowFromDOMFactory;
import org.apache.nifi.controller.serialization.FlowSerializationException;
import org.apache.nifi.controller.serialization.FlowSynchronizationException;
import org.apache.nifi.controller.serialization.FlowSynchronizer;
import org.apache.nifi.controller.serialization.StandardFlowSerializer;
import org.apache.nifi.controller.service.ControllerServiceLoader;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.groups.BundleUpdateStrategy;
import org.apache.nifi.groups.FlowFileConcurrency;
import org.apache.nifi.groups.FlowFileOutboundPolicy;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroupPortDescriptor;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterContextManager;
import org.apache.nifi.parameter.ParameterDescriptor;
import org.apache.nifi.parameter.StandardParameterProviderConfiguration;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.registry.flow.FlowRegistryClientNode;
import org.apache.nifi.registry.flow.StandardVersionControlInformation;
import org.apache.nifi.registry.flow.VersionControlInformation;
import org.apache.nifi.registry.flow.VersionedFlowState;
import org.apache.nifi.remote.PublicPort;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.remote.protocol.SiteToSiteTransportProtocol;
import org.apache.nifi.reporting.Severity;
import org.apache.nifi.scheduling.ExecutionNode;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.services.FlowService;
import org.apache.nifi.util.BundleUtils;
import org.apache.nifi.util.DomUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.file.FileUtils;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ComponentReferenceDTO;
import org.apache.nifi.web.api.dto.ConnectableDTO;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.FlowRegistryClientDTO;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.api.dto.FunnelDTO;
import org.apache.nifi.web.api.dto.LabelDTO;
import org.apache.nifi.web.api.dto.ParameterContextDTO;
import org.apache.nifi.web.api.dto.ParameterDTO;
import org.apache.nifi.web.api.dto.ParameterProviderConfigurationDTO;
import org.apache.nifi.web.api.dto.ParameterProviderDTO;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.api.dto.PositionDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.ProcessorConfigDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.ReportingTaskDTO;
import org.apache.nifi.web.api.dto.TemplateDTO;
import org.apache.nifi.web.api.dto.VersionControlInformationDTO;
import org.apache.nifi.web.api.entity.ComponentReferenceEntity;
import org.apache.nifi.web.api.entity.ParameterContextReferenceEntity;
import org.apache.nifi.web.api.entity.ParameterEntity;
import org.apache.nifi.web.api.entity.ParameterProviderConfigurationEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlFlowSynchronizer
implements FlowSynchronizer {
    private static final Logger logger = LoggerFactory.getLogger(XmlFlowSynchronizer.class);
    private final boolean autoResumeState;
    private final NiFiProperties nifiProperties;
    private final ExtensionManager extensionManager;

    public XmlFlowSynchronizer(NiFiProperties nifiProperties, ExtensionManager extensionManager) {
        this.autoResumeState = nifiProperties.getAutoResumeState();
        this.nifiProperties = nifiProperties;
        this.extensionManager = extensionManager;
    }

    @Override
    public void sync(FlowController controller, DataFlow proposedFlow, FlowService flowService, BundleUpdateStrategy bundleUpdateStrategy) throws FlowSerializationException, UninheritableFlowException, FlowSynchronizationException {
        FlowManager flowManager = controller.getFlowManager();
        ProcessGroup root = flowManager.getRootGroup();
        if (proposedFlow == null) {
            if (root.isEmpty()) {
                return;
            }
            throw new UninheritableFlowException("Proposed configuration is empty, but the controller contains a data flow.");
        }
        boolean flowAlreadySynchronized = controller.isFlowSynchronized();
        logger.debug("Synching FlowController with proposed flow: Controller is Already Synchronized = {}", (Object)flowAlreadySynchronized);
        DataFlow existingDataFlow = this.getExistingDataFlow(controller);
        boolean existingFlowEmpty = XmlFlowSynchronizer.isFlowEmpty(existingDataFlow.getFlowDocument());
        logger.trace("Parsing proposed flow bytes as DOM document");
        Document configuration = proposedFlow.getFlowDocument();
        boolean backupAndPurge = false;
        if (existingFlowEmpty) {
            logger.debug("Checking bundle compatibility");
            BundleCompatibilityCheck bundleCompatibilityCheck = new BundleCompatibilityCheck();
            FlowInheritability bundleInheritability = bundleCompatibilityCheck.checkInheritability(existingDataFlow, proposedFlow, controller);
            if (!bundleInheritability.isInheritable()) {
                throw new UninheritableFlowException("Proposed flow could not be inherited because it references one or more Bundles that are not available in this NiFi instance: " + bundleInheritability.getExplanation());
            }
            logger.debug("Bundle Compatibility check passed");
        } else {
            logger.debug("Checking flow inheritability");
            FlowFingerprintCheck fingerprintCheck = new FlowFingerprintCheck();
            FlowInheritability inheritability = fingerprintCheck.checkInheritability(existingDataFlow, proposedFlow, controller);
            if (inheritability.isInheritable()) {
                logger.debug("Proposed flow is inheritable");
            } else {
                if (controller.isInitialized()) {
                    throw new UninheritableFlowException("Proposed configuration is not inheritable by the flow controller because of flow differences: " + inheritability.getExplanation());
                }
                logger.debug("Proposed flow is not directly inheritable. However, the Controller has not been synchronized yet, so will check if the existing flow can be backed up and replaced by the proposed flow.");
                ConnectionMissingCheck connectionMissingCheck = new ConnectionMissingCheck(null);
                FlowInheritability connectionMissingInheritability = connectionMissingCheck.checkInheritability(existingDataFlow, proposedFlow, controller);
                if (connectionMissingInheritability.isInheritable()) {
                    backupAndPurge = true;
                    existingFlowEmpty = true;
                    logger.debug("Proposed flow contains all connections that currently have data queued. Will backup existing flow and replace, provided all other checks pass");
                } else {
                    throw new UninheritableFlowException("Proposed flow is not inheritable by the flow controller and cannot completely replace the current flow due to: " + connectionMissingInheritability.getExplanation());
                }
            }
        }
        logger.debug("Checking missing component inheritability");
        MissingComponentsCheck missingComponentsCheck = new MissingComponentsCheck();
        FlowInheritability componentInheritability = missingComponentsCheck.checkInheritability(existingDataFlow, proposedFlow, controller);
        if (!componentInheritability.isInheritable()) {
            throw new UninheritableFlowException("Proposed Flow is not inheritable by the flow controller because of differences in missing components: " + componentInheritability.getExplanation());
        }
        logger.debug("Missing Component Inheritability check passed");
        logger.debug("Checking authorizer inheritability");
        AuthorizerCheck authorizerCheck = new AuthorizerCheck();
        FlowInheritability authorizerInheritability = authorizerCheck.checkInheritability(existingDataFlow, proposedFlow, controller);
        Authorizer authorizer = controller.getAuthorizer();
        if (existingFlowEmpty) {
            logger.debug("Existing flow is empty so will not check Authorizer inheritability. Authorizers will be forcibly inherited if necessary.");
        } else if (!controller.isInitialized() && authorizer instanceof ManagedAuthorizer) {
            logger.debug("Authorizations are not inheritable, but Authorizer is a Managed Authorizer and the Controller has not yet been initialized, so it can be forcibly inherited.");
        } else {
            if (!authorizerInheritability.isInheritable() && authorizerInheritability.getExplanation() != null) {
                throw new UninheritableFlowException("Proposed Authorizer is not inheritable by the Flow Controller because NiFi has already started the dataflow and Authorizer has differences: " + authorizerInheritability.getExplanation());
            }
            logger.debug("Authorizer inheritability check passed");
        }
        try {
            if (backupAndPurge) {
                logger.warn("Proposed flow cannot be directly inherited. However, all data that is queued in this instance is queued in a connection that exists in the Proposed flow. As a result, the existing flow will be backed up and replaced with the proposed flow.");
                File backupFile = this.getFlowBackupFile();
                try {
                    flowService.copyCurrentFlow(backupFile);
                }
                catch (IOException ioe) {
                    throw new UninheritableFlowException("Could not inherit flow because failed to make a backup of existing flow to " + backupFile.getAbsolutePath(), ioe);
                }
                logger.info("Successfully created backup of existing flow to {}. Will now purge local flow and inherit proposed flow", (Object)backupFile.getAbsolutePath());
                controller.purge();
            }
            if (!controller.isFlowSynchronized() && !existingFlowEmpty) {
                this.updateThreadCounts(existingDataFlow.getFlowDocument().getDocumentElement(), controller);
            }
            if (configuration != null) {
                this.updateFlow(controller, configuration, existingDataFlow, existingFlowEmpty);
            }
            this.inheritSnippets(controller, proposedFlow);
            if (authorizer instanceof ManagedAuthorizer) {
                String proposedAuthFingerprint;
                ManagedAuthorizer managedAuthorizer = (ManagedAuthorizer)authorizer;
                String string = proposedAuthFingerprint = proposedFlow.getAuthorizerFingerprint() == null ? "" : new String(proposedFlow.getAuthorizerFingerprint(), StandardCharsets.UTF_8);
                if (authorizerInheritability.isInheritable()) {
                    logger.debug("Authorizations are inheritable. Will inherit from proposed fingerprint {}", (Object)proposedAuthFingerprint);
                    managedAuthorizer.inheritFingerprint(proposedAuthFingerprint);
                } else if (!Objects.equals(managedAuthorizer.getFingerprint(), proposedAuthFingerprint)) {
                    logger.debug("Authorizations are not inheritable. Will force inheritance of proposed fingerprint {}", (Object)proposedAuthFingerprint);
                    managedAuthorizer.forciblyInheritFingerprint(proposedAuthFingerprint);
                }
            }
            logger.debug("Finished syncing flows");
        }
        catch (Exception ex) {
            throw new FlowSynchronizationException(ex);
        }
    }

    private File getFlowBackupFile() {
        File flowConfigurationFile = this.nifiProperties.getFlowConfigurationFile();
        String baseFilename = StringUtils.substringBeforeLast((String)flowConfigurationFile.getName(), (String)".xml.gz");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        String timestamp = dateFormat.format(new Date());
        String backupFilename = baseFilename + "-" + timestamp + ".xml.gz";
        File backupFile = new File(flowConfigurationFile.getParentFile(), backupFilename);
        if (!backupFile.getParentFile().exists() && !backupFile.getParentFile().mkdirs()) {
            throw new UninheritableFlowException("Failed to backup existing flow because the configured directory for flow.xml.gz <" + backupFile.getParentFile().getAbsolutePath() + "> does not exist and could not be created");
        }
        return backupFile;
    }

    private DataFlow getExistingDataFlow(FlowController controller) {
        byte[] existingAuthFingerprint;
        FlowManager flowManager = controller.getFlowManager();
        ProcessGroup root = flowManager.getRootGroup();
        HashSet missingComponents = new HashSet();
        flowManager.getAllControllerServices().stream().filter(ComponentNode::isExtensionMissing).forEach(cs -> missingComponents.add(cs.getIdentifier()));
        flowManager.getAllReportingTasks().stream().filter(ComponentNode::isExtensionMissing).forEach(r -> missingComponents.add(r.getIdentifier()));
        flowManager.getAllParameterProviders().stream().filter(ComponentNode::isExtensionMissing).forEach(r -> missingComponents.add(r.getIdentifier()));
        flowManager.getAllFlowRegistryClients().stream().filter(ComponentNode::isExtensionMissing).forEach(c -> missingComponents.add(c.getIdentifier()));
        root.findAllProcessors().stream().filter(AbstractComponentNode::isExtensionMissing).forEach(p -> missingComponents.add(p.getIdentifier()));
        logger.trace("Exporting snippets from controller");
        byte[] existingSnippets = controller.getSnippetManager().export();
        Authorizer authorizer = controller.getAuthorizer();
        if (AuthorizerCapabilityDetection.isManagedAuthorizer((Authorizer)authorizer)) {
            ManagedAuthorizer managedAuthorizer = (ManagedAuthorizer)authorizer;
            existingAuthFingerprint = managedAuthorizer.getFingerprint().getBytes(StandardCharsets.UTF_8);
        } else {
            existingAuthFingerprint = null;
        }
        try {
            byte[] existingFlow;
            if (controller.isFlowSynchronized()) {
                existingFlow = this.toBytes(controller);
                return new StandardDataFlow(existingFlow, existingSnippets, existingAuthFingerprint, missingComponents);
            }
            existingFlow = this.readFlowFromDisk();
            if (existingFlow == null || existingFlow.length == 0) {
                return new StandardDataFlow(existingFlow, existingSnippets, existingAuthFingerprint, missingComponents);
            }
            return new StandardDataFlow(existingFlow, existingSnippets, existingAuthFingerprint, missingComponents);
        }
        catch (IOException e) {
            throw new FlowSerializationException((Throwable)e);
        }
    }

    private void inheritSnippets(FlowController controller, DataFlow proposedFlow) {
        logger.trace("Clearing existing snippets");
        SnippetManager snippetManager = controller.getSnippetManager();
        snippetManager.clear();
        logger.trace("Loading proposed snippets");
        byte[] proposedSnippets = proposedFlow.getSnippets();
        if (proposedSnippets != null && proposedSnippets.length > 0) {
            for (StandardSnippet snippet : SnippetManager.parseBytes(proposedSnippets)) {
                snippetManager.addSnippet(snippet);
            }
        }
    }

    private void updateFlow(FlowController controller, Document configuration, DataFlow existingFlow, boolean existingFlowEmpty) throws ReportingTaskInstantiationException {
        Element existingRootElement;
        Document existingFlowConfiguration;
        ProcessGroup rootGroup;
        boolean flowAlreadySynchronized = controller.isFlowSynchronized();
        FlowManager flowManager = controller.getFlowManager();
        PropertyEncryptor encryptor = controller.getEncryptor();
        Element rootElement = (Element)configuration.getElementsByTagName("flowController").item(0);
        FlowEncodingVersion encodingVersion = FlowEncodingVersion.parse(rootElement);
        logger.trace("Updating flow config");
        Integer maxThreadCount = XmlFlowSynchronizer.getInteger(rootElement, "maxThreadCount");
        if (maxThreadCount == null) {
            controller.setMaxTimerDrivenThreadCount(XmlFlowSynchronizer.getInt(rootElement, "maxTimerDrivenThreadCount"));
            controller.setMaxEventDrivenThreadCount(XmlFlowSynchronizer.getInt(rootElement, "maxEventDrivenThreadCount"));
        } else {
            controller.setMaxTimerDrivenThreadCount(maxThreadCount * 2 / 3);
            controller.setMaxEventDrivenThreadCount(maxThreadCount / 3);
        }
        Element rootGroupElement = (Element)rootElement.getElementsByTagName("rootGroup").item(0);
        Element parameterProvidersElement = DomUtils.getChild((Element)rootElement, (String)"parameterProviders");
        ArrayList parameterProviderElements = new ArrayList();
        if (parameterProvidersElement != null) {
            parameterProviderElements.addAll(DomUtils.getChildElementsByTagName((Element)parameterProvidersElement, (String)"parameterProvider"));
        }
        HashMap<ParameterProviderNode, ParameterProviderDTO> parameterProviderNodesToDTOs = new HashMap<ParameterProviderNode, ParameterProviderDTO>();
        for (Object taskElement : parameterProviderElements) {
            ParameterProviderDTO dto = FlowFromDOMFactory.getParameterProvider((Element)taskElement, encryptor, encodingVersion);
            ParameterProviderNode parameterProvider = this.getOrCreateParameterProvider(controller, dto, flowAlreadySynchronized, existingFlowEmpty);
            parameterProviderNodesToDTOs.put(parameterProvider, dto);
        }
        Element registriesElement = DomUtils.getChild((Element)rootElement, (String)"registries");
        if (registriesElement != null) {
            for (Element flowRegistryElement : DomUtils.getChildElementsByTagName((Element)registriesElement, (String)"flowRegistry")) {
                FlowRegistryClientDTO dto = FlowFromDOMFactory.getFlowRegistryClient(flowRegistryElement, encryptor, encodingVersion);
                this.getOrCreateFlowRegistryClient(controller, dto, flowAlreadySynchronized, existingFlowEmpty);
            }
        }
        if (!flowAlreadySynchronized || existingFlowEmpty) {
            controller.getFlowManager().withParameterContextResolution(() -> {
                Element parameterContextsElement = DomUtils.getChild((Element)rootElement, (String)"parameterContexts");
                if (parameterContextsElement != null) {
                    List contextElements = DomUtils.getChildElementsByTagName((Element)parameterContextsElement, (String)"parameterContext");
                    for (Element contextElement : contextElements) {
                        ParameterContextDTO parameterContextDto = FlowFromDOMFactory.getParameterContext(contextElement, encryptor);
                        this.createParameterContext(parameterContextDto, controller.getFlowManager());
                    }
                }
            });
            logger.trace("Adding root process group");
            rootGroup = this.addProcessGroup(controller, null, rootGroupElement, encodingVersion);
        } else {
            logger.trace("Updating root process group");
            rootGroup = this.updateProcessGroup(controller, null, rootGroupElement, encodingVersion);
        }
        rootGroup.findAllRemoteProcessGroups().forEach(RemoteProcessGroup::initialize);
        if (!existingFlowEmpty && (existingFlowConfiguration = existingFlow.getFlowDocument()) != null && (existingRootElement = (Element)existingFlowConfiguration.getElementsByTagName("flowController").item(0)) != null) {
            Element existingRootGroupElement = (Element)existingRootElement.getElementsByTagName("rootGroup").item(0);
            if (existingRootElement != null) {
                this.addLocalTemplates(existingRootGroupElement, rootGroup);
            }
        }
        Element reportingTasksElement = DomUtils.getChild((Element)rootElement, (String)"reportingTasks");
        ArrayList reportingTaskElements = new ArrayList();
        if (reportingTasksElement != null) {
            reportingTaskElements.addAll(DomUtils.getChildElementsByTagName((Element)reportingTasksElement, (String)"reportingTask"));
        }
        HashMap<ReportingTaskNode, ReportingTaskDTO> reportingTaskNodesToDTOs = new HashMap<ReportingTaskNode, ReportingTaskDTO>();
        for (Element taskElement : reportingTaskElements) {
            ReportingTaskDTO reportingTaskDTO = FlowFromDOMFactory.getReportingTask(taskElement, encryptor, encodingVersion);
            ReportingTaskNode reportingTask = this.getOrCreateReportingTask(controller, reportingTaskDTO, flowAlreadySynchronized, existingFlowEmpty);
            reportingTaskNodesToDTOs.put(reportingTask, reportingTaskDTO);
        }
        Element controllerServicesElement = DomUtils.getChild((Element)rootElement, (String)"controllerServices");
        if (controllerServicesElement != null) {
            List serviceElements = DomUtils.getChildElementsByTagName((Element)controllerServicesElement, (String)"controllerService");
            if (!flowAlreadySynchronized || existingFlowEmpty) {
                ProcessGroup processGroup = encodingVersion == null ? rootGroup : null;
                Map<ControllerServiceNode, Element> controllerServices = ControllerServiceLoader.loadControllerServices(serviceElements, controller, processGroup, encryptor, encodingVersion);
                if (processGroup != null) {
                    Set controllerServicesInReportingTasks = reportingTaskNodesToDTOs.keySet().stream().flatMap(r -> r.getEffectivePropertyValues().entrySet().stream()).filter(e -> ((PropertyDescriptor)e.getKey()).getControllerServiceDefinition() != null).map(Map.Entry::getValue).collect(Collectors.toSet());
                    Set controllerServicesInParameterProviders = parameterProviderNodesToDTOs.keySet().stream().flatMap(r -> r.getEffectivePropertyValues().entrySet().stream()).filter(e -> ((PropertyDescriptor)e.getKey()).getControllerServiceDefinition() != null).map(Map.Entry::getValue).collect(Collectors.toSet());
                    Set controllerServicesToClone = controllerServices.keySet().stream().filter(cs -> controllerServicesInReportingTasks.contains(cs.getIdentifier()) || controllerServicesInParameterProviders.contains(cs.getIdentifier())).collect(Collectors.toSet());
                    HashMap<String, ControllerServiceNode> controllerServiceMapping = new HashMap<String, ControllerServiceNode>();
                    for (ControllerServiceNode controllerService : controllerServicesToClone) {
                        ControllerServiceNode clone = ControllerServiceLoader.cloneControllerService(controller, controllerService);
                        flowManager.addRootControllerService(clone);
                        controllerServiceMapping.put(controllerService.getIdentifier(), clone);
                    }
                    this.updateControllerLevelControllerServices(reportingTaskNodesToDTOs.keySet(), controllerServiceMapping);
                    this.updateControllerLevelControllerServices(parameterProviderNodesToDTOs.keySet(), controllerServiceMapping);
                    ControllerServiceLoader.enableControllerServices(controllerServiceMapping.values(), controller, this.autoResumeState);
                }
                ControllerServiceLoader.enableControllerServices(controllerServices, controller, encryptor, this.autoResumeState, encodingVersion);
            }
        }
        for (ParameterProviderNode parameterProviderNode : parameterProviderNodesToDTOs.keySet()) {
            try {
                parameterProviderNode.fetchParameters();
            }
            catch (Exception e2) {
                logger.warn("Failed to fetch parameters for provider " + parameterProviderNode.getName(), (Throwable)e2);
            }
        }
        this.scaleRootGroup(rootGroup, encodingVersion);
        for (Map.Entry entry : reportingTaskNodesToDTOs.entrySet()) {
            this.applyReportingTaskScheduleState(controller, (ReportingTaskDTO)entry.getValue(), (ReportingTaskNode)entry.getKey(), flowAlreadySynchronized, existingFlowEmpty);
        }
    }

    private ParameterContext createParameterContext(ParameterContextDTO dto, FlowManager flowManager) {
        Map parameters = dto.getParameters().stream().map(ParameterEntity::getParameter).map(this::createParameter).collect(Collectors.toMap(param -> param.getDescriptor().getName(), Function.identity()));
        List referencedIds = dto.getInheritedParameterContexts() == null ? Collections.emptyList() : dto.getInheritedParameterContexts().stream().map(ParameterContextReferenceEntity::getId).collect(Collectors.toList());
        StandardParameterProviderConfiguration parameterProviderConfiguration = null;
        if (dto.getParameterProviderConfiguration() != null) {
            ParameterProviderConfigurationEntity parameterProviderConfigurationEntity = dto.getParameterProviderConfiguration();
            ParameterProviderConfigurationDTO configurationDTO = parameterProviderConfigurationEntity.getComponent();
            parameterProviderConfiguration = new StandardParameterProviderConfiguration(configurationDTO.getParameterProviderId(), configurationDTO.getParameterGroupName(), configurationDTO.getSynchronized());
        }
        ParameterContext context = flowManager.createParameterContext(dto.getId(), dto.getName(), parameters, referencedIds, parameterProviderConfiguration);
        context.setDescription(dto.getDescription());
        return context;
    }

    private Parameter createParameter(ParameterDTO dto) {
        ParameterDescriptor parameterDescriptor = new ParameterDescriptor.Builder().name(dto.getName()).description(dto.getDescription()).sensitive(Boolean.TRUE.equals(dto.getSensitive())).build();
        return new Parameter(parameterDescriptor, dto.getValue(), null, dto.getProvided());
    }

    public static String getReferenceId(ComponentReferenceEntity referenceEntity) {
        if (referenceEntity == null) {
            return null;
        }
        ComponentReferenceDTO dto = referenceEntity.getComponent();
        if (dto == null) {
            return null;
        }
        return dto.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateControllerLevelControllerServices(Set<? extends ComponentNode> componentNodes, Map<String, ControllerServiceNode> controllerServiceMapping) {
        for (ComponentNode componentNode : componentNodes) {
            if (componentNode.getProperties() == null) continue;
            componentNode.pauseValidationTrigger();
            try {
                Set propertyDescriptors = componentNode.getEffectivePropertyValues().entrySet().stream().filter(e -> ((PropertyDescriptor)e.getKey()).getControllerServiceDefinition() != null).filter(e -> controllerServiceMapping.containsKey(e.getValue())).collect(Collectors.toSet());
                HashMap<String, String> controllerServiceProps = new HashMap<String, String>();
                for (Map.Entry propEntry : propertyDescriptors) {
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)propEntry.getKey();
                    ControllerServiceNode clone = controllerServiceMapping.get(propEntry.getValue());
                    controllerServiceProps.put(propertyDescriptor.getName(), clone.getIdentifier());
                }
                componentNode.setProperties(controllerServiceProps);
            }
            finally {
                componentNode.resumeValidationTrigger();
            }
        }
    }

    private void addLocalTemplates(Element processGroupElement, ProcessGroup processGroup) {
        List<Element> templateNodeList = XmlFlowSynchronizer.getChildrenByTagName(processGroupElement, "template");
        if (templateNodeList != null) {
            for (Element templateElement : templateNodeList) {
                TemplateDTO templateDto = TemplateUtils.parseDto(templateElement);
                Template template = new Template(templateDto);
                if (processGroup.getTemplate(template.getIdentifier()) != null) continue;
                processGroup.addTemplate(template);
            }
        }
        List<Element> childGroupElements = XmlFlowSynchronizer.getChildrenByTagName(processGroupElement, "processGroup");
        for (Element childGroupElement : childGroupElements) {
            String childGroupId = XmlFlowSynchronizer.getString(childGroupElement, "id");
            ProcessGroup childGroup = processGroup.getProcessGroup(childGroupId);
            this.addLocalTemplates(childGroupElement, childGroup);
        }
    }

    void scaleRootGroup(ProcessGroup rootGroup, FlowEncodingVersion encodingVersion) {
        if (encodingVersion == null || encodingVersion.getMajorVersion() < 1) {
            PositionScaler.scale(rootGroup, 1.5, 1.34);
        }
    }

    private void updateThreadCounts(Element rootElement, FlowController controller) {
        logger.trace("Setting controller thread counts");
        Integer maxThreadCount = XmlFlowSynchronizer.getInteger(rootElement, "maxThreadCount");
        if (maxThreadCount == null) {
            controller.setMaxTimerDrivenThreadCount(XmlFlowSynchronizer.getInt(rootElement, "maxTimerDrivenThreadCount"));
            controller.setMaxEventDrivenThreadCount(XmlFlowSynchronizer.getInt(rootElement, "maxEventDrivenThreadCount"));
        } else {
            controller.setMaxTimerDrivenThreadCount(maxThreadCount * 2 / 3);
            controller.setMaxEventDrivenThreadCount(maxThreadCount / 3);
        }
    }

    public static boolean isFlowEmpty(Document flowDocument) {
        List contextList;
        List flowRegistryElems;
        List unrootedControllerServiceElements;
        List providerElements;
        List taskElements;
        if (flowDocument == null) {
            return true;
        }
        Element rootElement = flowDocument.getDocumentElement();
        if (rootElement == null) {
            return true;
        }
        FlowEncodingVersion encodingVersion = FlowEncodingVersion.parse(rootElement);
        Element reportingTasksElement = DomUtils.getChild((Element)rootElement, (String)"reportingTasks");
        if (reportingTasksElement != null && !(taskElements = DomUtils.getChildElementsByTagName((Element)reportingTasksElement, (String)"reportingTask")).isEmpty()) {
            return false;
        }
        Element parameterProvidersElement = DomUtils.getChild((Element)rootElement, (String)"parameterProviders");
        if (parameterProvidersElement != null && !(providerElements = DomUtils.getChildElementsByTagName((Element)parameterProvidersElement, (String)"parameterProvider")).isEmpty()) {
            return false;
        }
        Element controllerServicesElement = DomUtils.getChild((Element)rootElement, (String)"controllerServices");
        if (controllerServicesElement != null && !(unrootedControllerServiceElements = DomUtils.getChildElementsByTagName((Element)controllerServicesElement, (String)"controllerService")).isEmpty()) {
            return false;
        }
        Element registriesElement = DomUtils.getChild((Element)rootElement, (String)"registries");
        if (registriesElement != null && !(flowRegistryElems = DomUtils.getChildElementsByTagName((Element)registriesElement, (String)"flowRegistry")).isEmpty()) {
            return false;
        }
        Element parameterContextsElement = DomUtils.getChild((Element)rootElement, (String)"parameterContexts");
        if (parameterContextsElement != null && !(contextList = DomUtils.getChildElementsByTagName((Element)parameterContextsElement, (String)"parameterContext")).isEmpty()) {
            return false;
        }
        logger.trace("Parsing process group from DOM");
        Element rootGroupElement = (Element)rootElement.getElementsByTagName("rootGroup").item(0);
        ProcessGroupDTO rootGroupDto = FlowFromDOMFactory.getProcessGroup(null, rootGroupElement, null, encodingVersion);
        return XmlFlowSynchronizer.isEmpty(rootGroupDto);
    }

    private static boolean isEmpty(ProcessGroupDTO dto) {
        if (dto == null) {
            return true;
        }
        FlowSnippetDTO contents = dto.getContents();
        if (contents == null) {
            return true;
        }
        String parameterContextId = dto.getParameterContext() == null ? null : dto.getParameterContext().getId();
        return CollectionUtils.isEmpty((Collection)contents.getProcessors()) && CollectionUtils.isEmpty((Collection)contents.getConnections()) && CollectionUtils.isEmpty((Collection)contents.getFunnels()) && CollectionUtils.isEmpty((Collection)contents.getLabels()) && CollectionUtils.isEmpty((Collection)contents.getInputPorts()) && CollectionUtils.isEmpty((Collection)contents.getOutputPorts()) && CollectionUtils.isEmpty((Collection)contents.getProcessGroups()) && CollectionUtils.isEmpty((Collection)contents.getRemoteProcessGroups()) && CollectionUtils.isEmpty((Collection)contents.getControllerServices()) && parameterContextId == null;
    }

    private byte[] readFlowFromDisk() throws IOException {
        Path flowPath = this.nifiProperties.getFlowConfigurationFile().toPath();
        if (!Files.exists(flowPath, new LinkOption[0]) || Files.size(flowPath) == 0L) {
            return new byte[0];
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream in = Files.newInputStream(flowPath, StandardOpenOption.READ);
             GZIPInputStream gzipIn = new GZIPInputStream(in);){
            FileUtils.copy((InputStream)gzipIn, (OutputStream)baos);
        }
        return baos.toByteArray();
    }

    private ParameterProviderNode getOrCreateParameterProvider(FlowController controller, ParameterProviderDTO dto, boolean controllerInitialized, boolean existingFlowEmpty) {
        if (!controllerInitialized || existingFlowEmpty) {
            BundleCoordinate coordinate;
            try {
                coordinate = BundleUtils.getCompatibleBundle((ExtensionManager)this.extensionManager, (String)dto.getType(), (BundleDTO)dto.getBundle());
            }
            catch (IllegalStateException e) {
                BundleDTO bundleDTO = dto.getBundle();
                coordinate = bundleDTO == null ? BundleCoordinate.UNKNOWN_COORDINATE : new BundleCoordinate(bundleDTO.getGroup(), bundleDTO.getArtifact(), bundleDTO.getVersion());
            }
            ParameterProviderNode parameterProvider = controller.getFlowManager().createParameterProvider(dto.getType(), dto.getId(), coordinate, false);
            parameterProvider.setName(dto.getName());
            parameterProvider.setComments(dto.getComments());
            parameterProvider.setAnnotationData(dto.getAnnotationData());
            parameterProvider.setProperties(dto.getProperties());
            return parameterProvider;
        }
        return controller.getFlowManager().getParameterProvider(dto.getId());
    }

    private FlowRegistryClientNode getOrCreateFlowRegistryClient(FlowController controller, FlowRegistryClientDTO dto, boolean controllerInitialized, boolean existingFlowEmpty) {
        if (!controllerInitialized || existingFlowEmpty) {
            BundleCoordinate coordinate;
            try {
                coordinate = BundleUtils.getCompatibleBundle((ExtensionManager)this.extensionManager, (String)dto.getType(), (BundleDTO)dto.getBundle());
            }
            catch (IllegalStateException e) {
                BundleDTO bundleDTO = dto.getBundle();
                coordinate = bundleDTO == null ? BundleCoordinate.UNKNOWN_COORDINATE : new BundleCoordinate(bundleDTO.getGroup(), bundleDTO.getArtifact(), bundleDTO.getVersion());
            }
            FlowRegistryClientNode registryClient = controller.getFlowManager().createFlowRegistryClient(dto.getType(), dto.getId(), coordinate, Collections.emptySet(), false, true, null);
            registryClient.setName(dto.getName());
            registryClient.setDescription(dto.getDescription());
            registryClient.setAnnotationData(dto.getAnnotationData());
            Set<String> sensitiveDynamicPropertyNames = this.getSensitiveDynamicPropertyNames(dto.getSensitiveDynamicPropertyNames(), (ComponentNode)registryClient);
            registryClient.setProperties(dto.getProperties(), false, sensitiveDynamicPropertyNames);
            return registryClient;
        }
        return controller.getFlowManager().getFlowRegistryClient(dto.getId());
    }

    private ReportingTaskNode getOrCreateReportingTask(FlowController controller, ReportingTaskDTO dto, boolean controllerInitialized, boolean existingFlowEmpty) throws ReportingTaskInstantiationException {
        if (!controllerInitialized || existingFlowEmpty) {
            BundleCoordinate coordinate;
            try {
                coordinate = BundleUtils.getCompatibleBundle((ExtensionManager)this.extensionManager, (String)dto.getType(), (BundleDTO)dto.getBundle());
            }
            catch (IllegalStateException e) {
                BundleDTO bundleDTO = dto.getBundle();
                coordinate = bundleDTO == null ? BundleCoordinate.UNKNOWN_COORDINATE : new BundleCoordinate(bundleDTO.getGroup(), bundleDTO.getArtifact(), bundleDTO.getVersion());
            }
            ReportingTaskNode reportingTask = controller.createReportingTask(dto.getType(), dto.getId(), coordinate, false);
            reportingTask.setName(dto.getName());
            reportingTask.setComments(dto.getComments());
            reportingTask.setSchedulingPeriod(dto.getSchedulingPeriod());
            reportingTask.setSchedulingStrategy(SchedulingStrategy.valueOf((String)dto.getSchedulingStrategy()));
            reportingTask.setAnnotationData(dto.getAnnotationData());
            Set<String> sensitiveDynamicPropertyNames = this.getSensitiveDynamicPropertyNames(dto.getSensitiveDynamicPropertyNames(), (ComponentNode)reportingTask);
            reportingTask.setProperties(dto.getProperties(), false, sensitiveDynamicPropertyNames);
            return reportingTask;
        }
        return controller.getReportingTaskNode(dto.getId());
    }

    private void applyReportingTaskScheduleState(FlowController controller, ReportingTaskDTO dto, ReportingTaskNode reportingTask, boolean controllerInitialized, boolean existingFlowEmpty) {
        if (!controllerInitialized || existingFlowEmpty) {
            this.applyNewReportingTaskScheduleState(controller, dto, reportingTask);
        } else {
            this.applyExistingReportingTaskScheduleState(controller, dto, reportingTask);
        }
    }

    private void applyNewReportingTaskScheduleState(FlowController controller, ReportingTaskDTO dto, ReportingTaskNode reportingTask) {
        if (this.autoResumeState) {
            if (ScheduledState.RUNNING.name().equals(dto.getState())) {
                try {
                    controller.startReportingTask(reportingTask);
                }
                catch (Exception e) {
                    logger.error("Failed to start {} due to {}", (Object)reportingTask, (Object)e);
                    if (logger.isDebugEnabled()) {
                        logger.error("", (Throwable)e);
                    }
                    controller.getBulletinRepository().addBulletin(BulletinFactory.createBulletin((String)"Reporting Tasks", (String)Severity.ERROR.name(), (String)("Failed to start " + reportingTask + " due to " + e)));
                }
            } else if (ScheduledState.DISABLED.name().equals(dto.getState())) {
                try {
                    controller.disableReportingTask(reportingTask);
                }
                catch (Exception e) {
                    logger.error("Failed to mark {} as disabled due to {}", (Object)reportingTask, (Object)e);
                    if (logger.isDebugEnabled()) {
                        logger.error("", (Throwable)e);
                    }
                    controller.getBulletinRepository().addBulletin(BulletinFactory.createBulletin((String)"Reporting Tasks", (String)Severity.ERROR.name(), (String)("Failed to mark " + reportingTask + " as disabled due to " + e)));
                }
            }
        }
    }

    private void applyExistingReportingTaskScheduleState(FlowController controller, ReportingTaskDTO dto, ReportingTaskNode taskNode) {
        if (!taskNode.getScheduledState().name().equals(dto.getState())) {
            try {
                switch (ScheduledState.valueOf((String)dto.getState())) {
                    case DISABLED: {
                        if (taskNode.isRunning()) {
                            controller.stopReportingTask(taskNode);
                        }
                        controller.disableReportingTask(taskNode);
                        break;
                    }
                    case RUNNING: {
                        if (taskNode.getScheduledState() == ScheduledState.DISABLED) {
                            controller.enableReportingTask(taskNode);
                        }
                        controller.startReportingTask(taskNode);
                        break;
                    }
                    case STOPPED: {
                        if (taskNode.getScheduledState() == ScheduledState.DISABLED) {
                            controller.enableReportingTask(taskNode);
                            break;
                        }
                        if (taskNode.getScheduledState() != ScheduledState.RUNNING) break;
                        controller.stopReportingTask(taskNode);
                    }
                }
            }
            catch (IllegalStateException ise) {
                logger.error("Failed to change Scheduled State of {} from {} to {} due to {}", new Object[]{taskNode, taskNode.getScheduledState().name(), dto.getState(), ise.toString()});
                logger.error("", (Throwable)ise);
                controller.getBulletinRepository().addBulletin(BulletinFactory.createBulletin((String)"Node Reconnection", (String)Severity.ERROR.name(), (String)("Failed to change Scheduled State of " + taskNode + " from " + taskNode.getScheduledState().name() + " to " + dto.getState() + " due to " + ise.toString())));
                controller.getBulletinRepository().addBulletin(BulletinFactory.createBulletin((String)"Node Reconnection", (String)Severity.ERROR.name(), (String)("Failed to change Scheduled State of " + taskNode + " from " + taskNode.getScheduledState().name() + " to " + dto.getState() + " due to " + ise.toString())));
            }
        }
    }

    private ControllerServiceState getFinalTransitionState(ControllerServiceState state) {
        switch (state) {
            case DISABLED: 
            case DISABLING: {
                return ControllerServiceState.DISABLED;
            }
            case ENABLED: 
            case ENABLING: {
                return ControllerServiceState.ENABLED;
            }
        }
        throw new AssertionError();
    }

    private ProcessGroup updateProcessGroup(FlowController controller, ProcessGroup parentGroup, Element processGroupElement, FlowEncodingVersion encodingVersion) {
        ProcessGroup processGroup;
        String parentId = parentGroup == null ? null : parentGroup.getIdentifier();
        PropertyEncryptor encryptor = controller.getEncryptor();
        ProcessGroupDTO processGroupDto = FlowFromDOMFactory.getProcessGroup(parentId, processGroupElement, encryptor, encodingVersion);
        FlowManager flowManager = controller.getFlowManager();
        if (parentId == null) {
            ProcessGroup root = flowManager.getRootGroup();
            for (Label label : root.findAllLabels()) {
                label.getProcessGroup().removeLabel(label);
            }
        }
        if ((processGroup = flowManager.getGroup(processGroupDto.getId())) == null) {
            throw new IllegalStateException("No Group with ID " + processGroupDto.getId() + " exists");
        }
        this.updateProcessGroup(processGroup, processGroupDto, controller.getFlowManager().getParameterContextManager());
        List<Element> controllerServiceNodeList = XmlFlowSynchronizer.getChildrenByTagName(processGroupElement, "controllerService");
        HashSet<ControllerServiceNode> toDisable = new HashSet<ControllerServiceNode>();
        HashSet<ControllerServiceNode> toEnable = new HashSet<ControllerServiceNode>();
        for (Element serviceElement : controllerServiceNodeList) {
            ControllerServiceState controllerServiceState;
            ControllerServiceDTO dto = FlowFromDOMFactory.getControllerService(serviceElement, encryptor, encodingVersion);
            ControllerServiceNode controllerServiceNode = processGroup.getControllerService(dto.getId());
            ControllerServiceState controllerServiceState2 = this.getFinalTransitionState(controllerServiceNode.getState());
            if (controllerServiceState2 == (controllerServiceState = this.getFinalTransitionState(ControllerServiceState.valueOf((String)dto.getState())))) continue;
            switch (controllerServiceState) {
                case DISABLED: {
                    toDisable.add(controllerServiceNode);
                    break;
                }
                case ENABLED: {
                    toEnable.add(controllerServiceNode);
                }
            }
        }
        toEnable.forEach(ComponentNode::performValidation);
        ControllerServiceProvider serviceProvider = controller.getControllerServiceProvider();
        serviceProvider.disableControllerServicesAsync(toDisable);
        serviceProvider.enableControllerServices(toEnable);
        List<Element> processorNodeList = XmlFlowSynchronizer.getChildrenByTagName(processGroupElement, "processor");
        for (Element element : processorNodeList) {
            ProcessorDTO processorDTO = FlowFromDOMFactory.getProcessor(element, encryptor, encodingVersion);
            ProcessorNode processorNode = processGroup.getProcessor(processorDTO.getId());
            ScheduledState scheduledState = this.getScheduledState(processorNode, controller);
            this.updateNonFingerprintedProcessorSettings(processorNode, processorDTO);
            if (scheduledState.name().equals(processorDTO.getState())) continue;
            try {
                switch (ScheduledState.valueOf((String)processorDTO.getState())) {
                    case DISABLED: {
                        controller.stopProcessor(processorNode.getProcessGroupIdentifier(), processorNode.getIdentifier());
                        processorNode.getProcessGroup().disableProcessor(processorNode);
                        break;
                    }
                    case RUNNING: {
                        processorNode.performValidation();
                        processorNode.getProcessGroup().enableProcessor(processorNode);
                        controller.startProcessor(processorNode.getProcessGroupIdentifier(), processorNode.getIdentifier(), false);
                        break;
                    }
                    case STOPPED: 
                    case RUN_ONCE: {
                        if (scheduledState == ScheduledState.DISABLED) {
                            processorNode.getProcessGroup().enableProcessor(processorNode);
                            break;
                        }
                        if (scheduledState != ScheduledState.RUNNING && scheduledState != ScheduledState.RUN_ONCE) break;
                        controller.stopProcessor(processorNode.getProcessGroupIdentifier(), processorNode.getIdentifier());
                    }
                }
            }
            catch (IllegalStateException illegalStateException) {
                logger.error("Failed to change Scheduled State of {} from {} to {} due to {}", new Object[]{processorNode, processorNode.getScheduledState().name(), processorDTO.getState(), illegalStateException.toString()});
                logger.error("", (Throwable)illegalStateException);
                controller.getBulletinRepository().addBulletin(BulletinFactory.createBulletin((Connectable)processorNode, (String)"Node Reconnection", (String)Severity.ERROR.name(), (String)("Failed to change Scheduled State of " + processorNode + " from " + processorNode.getScheduledState().name() + " to " + processorDTO.getState() + " due to " + illegalStateException.toString())));
                controller.getBulletinRepository().addBulletin(BulletinFactory.createBulletin((String)"Node Reconnection", (String)Severity.ERROR.name(), (String)("Failed to change Scheduled State of " + processorNode + " from " + processorNode.getScheduledState().name() + " to " + processorDTO.getState() + " due to " + illegalStateException.toString())));
            }
        }
        List<Element> inputPortList = XmlFlowSynchronizer.getChildrenByTagName(processGroupElement, "inputPort");
        for (Element element : inputPortList) {
            PortDTO portDTO = FlowFromDOMFactory.getPort(element);
            Port port = processGroup.getInputPort(portDTO.getId());
            ScheduledState scheduledState = this.getScheduledState(port, controller);
            if (scheduledState.name().equals(portDTO.getState())) continue;
            switch (ScheduledState.valueOf((String)portDTO.getState())) {
                case DISABLED: {
                    controller.stopConnectable((Connectable)port);
                    port.getProcessGroup().disableInputPort(port);
                    break;
                }
                case RUNNING: {
                    port.getProcessGroup().enableInputPort(port);
                    controller.startConnectable((Connectable)port);
                    break;
                }
                case STOPPED: {
                    if (scheduledState == ScheduledState.DISABLED) {
                        port.getProcessGroup().enableInputPort(port);
                        break;
                    }
                    if (scheduledState != ScheduledState.RUNNING) break;
                    controller.stopConnectable((Connectable)port);
                }
            }
        }
        List<Element> list = XmlFlowSynchronizer.getChildrenByTagName(processGroupElement, "outputPort");
        for (Element element : list) {
            PortDTO portDTO = FlowFromDOMFactory.getPort(element);
            Port port = processGroup.getOutputPort(portDTO.getId());
            ScheduledState scheduledState = this.getScheduledState(port, controller);
            if (scheduledState.name().equals(portDTO.getState())) continue;
            switch (ScheduledState.valueOf((String)portDTO.getState())) {
                case DISABLED: {
                    controller.stopConnectable((Connectable)port);
                    port.getProcessGroup().disableOutputPort(port);
                    break;
                }
                case RUNNING: {
                    port.getProcessGroup().enableOutputPort(port);
                    controller.startConnectable((Connectable)port);
                    break;
                }
                case STOPPED: {
                    if (scheduledState == ScheduledState.DISABLED) {
                        port.getProcessGroup().enableOutputPort(port);
                        break;
                    }
                    if (scheduledState != ScheduledState.RUNNING) break;
                    controller.stopConnectable((Connectable)port);
                }
            }
        }
        List<Element> list2 = XmlFlowSynchronizer.getChildrenByTagName(processGroupElement, "remoteProcessGroup");
        for (Element element : list2) {
            RemoteProcessGroupDTO remoteProcessGroupDTO = FlowFromDOMFactory.getRemoteProcessGroup(element, encryptor);
            RemoteProcessGroup remoteProcessGroup = processGroup.getRemoteProcessGroup(remoteProcessGroupDTO.getId());
            List<Element> inputPortElements = XmlFlowSynchronizer.getChildrenByTagName(element, "inputPort");
            for (Element element2 : inputPortElements) {
                RemoteProcessGroupPortDescriptor portDescriptor = FlowFromDOMFactory.getRemoteProcessGroupPort(element2);
                String inputPortId = portDescriptor.getId();
                RemoteGroupPort inputPort = remoteProcessGroup.getInputPort(inputPortId);
                if (inputPort == null) continue;
                ScheduledState portState = this.getScheduledState(inputPort, controller);
                if (portDescriptor.isTransmitting().booleanValue()) {
                    if (portState == ScheduledState.RUNNING || portState == ScheduledState.STARTING) continue;
                    controller.startTransmitting(inputPort);
                    continue;
                }
                if (portState == ScheduledState.STOPPED || portState == ScheduledState.STOPPING) continue;
                controller.stopTransmitting(inputPort);
            }
            List<Element> outputPortElements = XmlFlowSynchronizer.getChildrenByTagName(element, "outputPort");
            for (Element outputPortElement : outputPortElements) {
                RemoteProcessGroupPortDescriptor portDescriptor = FlowFromDOMFactory.getRemoteProcessGroupPort(outputPortElement);
                String outputPortId = portDescriptor.getId();
                RemoteGroupPort outputPort = remoteProcessGroup.getOutputPort(outputPortId);
                if (outputPort == null) continue;
                ScheduledState portState = this.getScheduledState(outputPort, controller);
                if (portDescriptor.isTransmitting().booleanValue()) {
                    if (portState == ScheduledState.RUNNING || portState == ScheduledState.STARTING) continue;
                    controller.startTransmitting(outputPort);
                    continue;
                }
                if (portState == ScheduledState.STOPPED || portState == ScheduledState.STOPPING) continue;
                controller.stopTransmitting(outputPort);
            }
        }
        List<Element> list3 = XmlFlowSynchronizer.getChildrenByTagName(processGroupElement, "label");
        for (Element element : list3) {
            LabelDTO labelDTO = FlowFromDOMFactory.getLabel(element);
            Label label = flowManager.createLabel(labelDTO.getId(), labelDTO.getLabel());
            label.setStyle(labelDTO.getStyle());
            label.setPosition(new Position(labelDTO.getPosition().getX().doubleValue(), labelDTO.getPosition().getY().doubleValue()));
            label.setVersionedComponentId(labelDTO.getVersionedComponentId());
            if (labelDTO.getWidth() != null && labelDTO.getHeight() != null) {
                label.setSize(new Size(labelDTO.getWidth().doubleValue(), labelDTO.getHeight().doubleValue()));
            }
            if (labelDTO.getzIndex() != null) {
                label.setZIndex(labelDTO.getzIndex().longValue());
            }
            processGroup.addLabel(label);
        }
        List<Element> list4 = XmlFlowSynchronizer.getChildrenByTagName(processGroupElement, "processGroup");
        for (Element element : list4) {
            this.updateProcessGroup(controller, processGroup, element, encodingVersion);
        }
        List<Element> list5 = XmlFlowSynchronizer.getChildrenByTagName(processGroupElement, "connection");
        for (Element connectionElement : list5) {
            ConnectionDTO dto = FlowFromDOMFactory.getConnection(connectionElement);
            Connection connection = processGroup.getConnection(dto.getId());
            connection.setName(dto.getName());
            connection.setProcessGroup(processGroup);
            if (dto.getLabelIndex() != null) {
                connection.setLabelIndex(dto.getLabelIndex().intValue());
            }
            if (dto.getzIndex() != null) {
                connection.setZIndex(dto.getzIndex().longValue());
            }
            ArrayList<Position> bendPoints = new ArrayList<Position>();
            for (PositionDTO bend : dto.getBends()) {
                bendPoints.add(new Position(bend.getX().doubleValue(), bend.getY().doubleValue()));
            }
            connection.setBendPoints(bendPoints);
            ArrayList<FlowFilePrioritizer> newPrioritizers = null;
            List prioritizers = dto.getPrioritizers();
            if (prioritizers != null) {
                ArrayList newPrioritizersClasses = new ArrayList(prioritizers);
                newPrioritizers = new ArrayList<FlowFilePrioritizer>();
                for (String className : newPrioritizersClasses) {
                    try {
                        newPrioritizers.add(flowManager.createPrioritizer(className));
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        throw new IllegalArgumentException("Unable to set prioritizer " + className + ": " + e);
                    }
                }
            }
            if (newPrioritizers != null) {
                connection.getFlowFileQueue().setPriorities(newPrioritizers);
            }
            if (dto.getBackPressureObjectThreshold() != null) {
                connection.getFlowFileQueue().setBackPressureObjectThreshold(dto.getBackPressureObjectThreshold().longValue());
            }
            if (dto.getBackPressureDataSizeThreshold() != null && !dto.getBackPressureDataSizeThreshold().trim().isEmpty()) {
                connection.getFlowFileQueue().setBackPressureDataSizeThreshold(dto.getBackPressureDataSizeThreshold());
            }
            if (dto.getFlowFileExpiration() == null) continue;
            connection.getFlowFileQueue().setFlowFileExpiration(dto.getFlowFileExpiration());
        }
        List<Element> list6 = XmlFlowSynchronizer.getChildrenByTagName(processGroupElement, "template");
        for (Element templateElement : list6) {
            TemplateDTO templateDTO = TemplateUtils.parseDto(templateElement);
            Template template = new Template(templateDTO);
            if (processGroup.getTemplate(template.getIdentifier()) != null) {
                processGroup.removeTemplate(template);
            }
            processGroup.addTemplate(template);
        }
        return processGroup;
    }

    private void updateProcessGroup(ProcessGroup group, ProcessGroupDTO dto, ParameterContextManager parameterContextManager) {
        String parameterContextId;
        ParameterContext parameterContext;
        String name = dto.getName();
        PositionDTO position = dto.getPosition();
        String comments = dto.getComments();
        String flowfileConcurrencyName = dto.getFlowfileConcurrency();
        String flowfileOutboundPolicyName = dto.getFlowfileOutboundPolicy();
        String defaultFlowFileExpiration = dto.getDefaultFlowFileExpiration();
        Long defaultBackPressureObjectThreshold = dto.getDefaultBackPressureObjectThreshold();
        String defaultBackPressureDataSizeThreshold = dto.getDefaultBackPressureDataSizeThreshold();
        if (name != null) {
            group.setName(name);
        }
        if (position != null) {
            group.setPosition(this.toPosition(position));
        }
        if (comments != null) {
            group.setComments(comments);
        }
        if (flowfileConcurrencyName == null) {
            group.setFlowFileConcurrency(FlowFileConcurrency.UNBOUNDED);
        } else {
            group.setFlowFileConcurrency(FlowFileConcurrency.valueOf((String)flowfileConcurrencyName));
        }
        if (flowfileOutboundPolicyName == null) {
            group.setFlowFileOutboundPolicy(FlowFileOutboundPolicy.STREAM_WHEN_AVAILABLE);
        } else {
            group.setFlowFileOutboundPolicy(FlowFileOutboundPolicy.valueOf((String)flowfileOutboundPolicyName));
        }
        ParameterContextReferenceEntity parameterContextReference = dto.getParameterContext();
        if (parameterContextReference != null && parameterContextReference.getId() != null && !Objects.equals(parameterContext = parameterContextManager.getParameterContext(parameterContextId = parameterContextReference.getId()), group.getParameterContext())) {
            group.setParameterContext(parameterContext);
        }
        if (defaultFlowFileExpiration != null) {
            group.setDefaultFlowFileExpiration(defaultFlowFileExpiration);
        }
        if (defaultBackPressureObjectThreshold != null) {
            group.setDefaultBackPressureObjectThreshold(defaultBackPressureObjectThreshold);
        }
        if (defaultBackPressureDataSizeThreshold != null) {
            group.setDefaultBackPressureDataSizeThreshold(defaultBackPressureDataSizeThreshold);
        }
    }

    private <T extends Connectable & Triggerable> ScheduledState getScheduledState(T component, FlowController flowController) {
        ScheduledState componentState = component.getScheduledState();
        if (componentState == ScheduledState.STOPPED && flowController.isStartAfterInitialization(component)) {
            return ScheduledState.RUNNING;
        }
        return componentState;
    }

    private Position toPosition(PositionDTO dto) {
        return new Position(dto.getX().doubleValue(), dto.getY().doubleValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProcessor(ProcessorNode procNode, ProcessorDTO processorDTO, ProcessGroup processGroup, FlowController controller) {
        procNode.pauseValidationTrigger();
        try {
            ProcessorConfigDTO config = processorDTO.getConfig();
            procNode.setProcessGroup(processGroup);
            procNode.setLossTolerant(config.isLossTolerant().booleanValue());
            procNode.setPenalizationPeriod(config.getPenaltyDuration());
            procNode.setYieldPeriod(config.getYieldDuration());
            procNode.setBulletinLevel(LogLevel.valueOf((String)config.getBulletinLevel()));
            procNode.setRetryCount(config.getRetryCount());
            procNode.setRetriedRelationships(config.getRetriedRelationships());
            if (config.getBackoffMechanism() != null) {
                procNode.setBackoffMechanism(BackoffMechanism.valueOf((String)config.getBackoffMechanism()));
            }
            procNode.setMaxBackoffPeriod(config.getMaxBackoffPeriod());
            this.updateNonFingerprintedProcessorSettings(procNode, processorDTO);
            if (config.getSchedulingStrategy() != null) {
                procNode.setSchedulingStrategy(SchedulingStrategy.valueOf((String)config.getSchedulingStrategy()));
            }
            if (config.getExecutionNode() != null) {
                procNode.setExecutionNode(ExecutionNode.valueOf((String)config.getExecutionNode()));
            }
            procNode.setMaxConcurrentTasks(config.getConcurrentlySchedulableTaskCount().intValue());
            procNode.setSchedulingPeriod(config.getSchedulingPeriod());
            if (config.getRunDurationMillis() != null) {
                procNode.setRunDuration(config.getRunDurationMillis().longValue(), TimeUnit.MILLISECONDS);
            }
            procNode.setAnnotationData(config.getAnnotationData());
            if (config.getAutoTerminatedRelationships() != null) {
                HashSet<Relationship> relationships = new HashSet<Relationship>();
                for (String rel : config.getAutoTerminatedRelationships()) {
                    relationships.add(procNode.getRelationship(rel));
                }
                procNode.setAutoTerminatedRelationships(relationships);
            }
            Set<String> sensitiveDynamicPropertyNames = this.getSensitiveDynamicPropertyNames(config.getSensitiveDynamicPropertyNames(), (ComponentNode)procNode);
            procNode.setProperties(config.getProperties(), false, sensitiveDynamicPropertyNames);
            ScheduledState scheduledState = ScheduledState.valueOf((String)processorDTO.getState());
            if (ScheduledState.RUNNING.equals((Object)scheduledState)) {
                procNode.performValidation();
                controller.startProcessor(processGroup.getIdentifier(), procNode.getIdentifier());
            } else if (ScheduledState.DISABLED.equals((Object)scheduledState)) {
                processGroup.disableProcessor(procNode);
            } else if (ScheduledState.STOPPED.equals((Object)scheduledState)) {
                controller.stopProcessor(processGroup.getIdentifier(), procNode.getIdentifier());
            }
        }
        finally {
            procNode.resumeValidationTrigger();
        }
    }

    private Set<String> getSensitiveDynamicPropertyNames(Set<String> parsedSensitivePropertyNames, ComponentNode componentNode) {
        Set<Object> sensitivePropertyNames = parsedSensitivePropertyNames == null ? Collections.emptySet() : parsedSensitivePropertyNames;
        return sensitivePropertyNames.stream().filter(propertyName -> {
            PropertyDescriptor propertyDescriptor = componentNode.getPropertyDescriptor(propertyName);
            return propertyDescriptor.isDynamic();
        }).collect(Collectors.toSet());
    }

    private void updateNonFingerprintedProcessorSettings(ProcessorNode procNode, ProcessorDTO processorDTO) {
        procNode.setName(processorDTO.getName());
        procNode.setPosition(this.toPosition(processorDTO.getPosition()));
        procNode.setStyle(processorDTO.getStyle());
        procNode.setComments(processorDTO.getConfig().getComments());
    }

    private ProcessGroup addProcessGroup(FlowController controller, ProcessGroup parentGroup, Element processGroupElement, FlowEncodingVersion encodingVersion) {
        String parentId = parentGroup == null ? null : parentGroup.getIdentifier();
        FlowManager flowManager = controller.getFlowManager();
        PropertyEncryptor encryptor = controller.getEncryptor();
        ProcessGroupDTO processGroupDTO = FlowFromDOMFactory.getProcessGroup(parentId, processGroupElement, encryptor, encodingVersion);
        ProcessGroup processGroup = flowManager.createProcessGroup(processGroupDTO.getId());
        processGroup.setComments(processGroupDTO.getComments());
        processGroup.setVersionedComponentId(processGroupDTO.getVersionedComponentId());
        processGroup.setPosition(this.toPosition(processGroupDTO.getPosition()));
        processGroup.setName(processGroupDTO.getName());
        processGroup.setParent(parentGroup);
        if (parentGroup == null) {
            controller.setRootGroup(processGroup);
        } else {
            parentGroup.addProcessGroup(processGroup);
        }
        String flowfileConcurrencyName = processGroupDTO.getFlowfileConcurrency();
        String flowfileOutboundPolicyName = processGroupDTO.getFlowfileOutboundPolicy();
        if (flowfileConcurrencyName == null) {
            processGroup.setFlowFileConcurrency(FlowFileConcurrency.UNBOUNDED);
        } else {
            processGroup.setFlowFileConcurrency(FlowFileConcurrency.valueOf((String)flowfileConcurrencyName));
        }
        if (flowfileOutboundPolicyName == null) {
            processGroup.setFlowFileOutboundPolicy(FlowFileOutboundPolicy.STREAM_WHEN_AVAILABLE);
        } else {
            processGroup.setFlowFileOutboundPolicy(FlowFileOutboundPolicy.valueOf((String)flowfileOutboundPolicyName));
        }
        processGroup.setDefaultFlowFileExpiration(processGroupDTO.getDefaultFlowFileExpiration());
        processGroup.setDefaultBackPressureObjectThreshold(processGroupDTO.getDefaultBackPressureObjectThreshold());
        processGroup.setDefaultBackPressureDataSizeThreshold(processGroupDTO.getDefaultBackPressureDataSizeThreshold());
        String parameterContextId = XmlFlowSynchronizer.getString(processGroupElement, "parameterContextId");
        if (parameterContextId != null) {
            ParameterContext parameterContext = controller.getFlowManager().getParameterContextManager().getParameterContext(parameterContextId);
            processGroup.setParameterContext(parameterContext);
        }
        this.addVariables(processGroupElement, processGroup);
        this.addVersionControlInfo(processGroup, processGroupDTO, controller);
        this.addControllerServices(processGroupElement, processGroup, controller, encodingVersion);
        this.addProcessors(processGroupElement, processGroup, controller, encodingVersion);
        this.addInputPorts(processGroupElement, processGroup, controller);
        this.addOutputPorts(processGroupElement, processGroup, controller);
        this.addFunnels(processGroupElement, processGroup, controller);
        this.addLabels(processGroupElement, processGroup, controller);
        this.addNestedProcessGroups(processGroupElement, processGroup, controller, encodingVersion);
        this.addRemoteProcessGroups(processGroupElement, processGroup, controller);
        this.addConnections(processGroupElement, processGroup, controller);
        this.addTemplates(processGroupElement, processGroup);
        return processGroup;
    }

    private void addNestedProcessGroups(Element processGroupElement, ProcessGroup processGroup, FlowController flowController, FlowEncodingVersion encodingVersion) {
        List<Element> nestedProcessGroupNodeList = XmlFlowSynchronizer.getChildrenByTagName(processGroupElement, "processGroup");
        for (Element nestedProcessGroupElement : nestedProcessGroupNodeList) {
            this.addProcessGroup(flowController, processGroup, nestedProcessGroupElement, encodingVersion);
        }
    }

    private void addVersionControlInfo(ProcessGroup processGroup, ProcessGroupDTO processGroupDTO, FlowController flowController) {
        VersionControlInformationDTO versionControlInfoDto = processGroupDTO.getVersionControlInformation();
        if (versionControlInfoDto != null) {
            FlowRegistryClientNode flowRegistry = flowController.getFlowManager().getFlowRegistryClient(versionControlInfoDto.getRegistryId());
            String registryName = flowRegistry == null ? versionControlInfoDto.getRegistryId() : flowRegistry.getName();
            versionControlInfoDto.setState(VersionedFlowState.SYNC_FAILURE.name());
            versionControlInfoDto.setStateExplanation("Process Group has not yet been synchronized with the Flow Registry");
            StandardVersionControlInformation versionControlInformation = StandardVersionControlInformation.Builder.fromDto((VersionControlInformationDTO)versionControlInfoDto).registryName(registryName).build();
            processGroup.setVersionControlInformation((VersionControlInformation)versionControlInformation, Collections.emptyMap());
        }
    }

    private void addVariables(Element processGroupElement, ProcessGroup processGroup) {
        HashMap<String, String> variables = new HashMap<String, String>();
        List<Element> variableElements = XmlFlowSynchronizer.getChildrenByTagName(processGroupElement, "variable");
        for (Element variableElement : variableElements) {
            String variableName = variableElement.getAttribute("name");
            String variableValue = variableElement.getAttribute("value");
            if (variableName == null || variableValue == null) continue;
            variables.put(variableName, variableValue);
        }
        processGroup.setVariables(variables);
    }

    private void addControllerServices(Element processGroupElement, ProcessGroup processGroup, FlowController flowController, FlowEncodingVersion encodingVersion) {
        List<Element> serviceNodeList = XmlFlowSynchronizer.getChildrenByTagName(processGroupElement, "controllerService");
        PropertyEncryptor encryptor = flowController.getEncryptor();
        if (!serviceNodeList.isEmpty()) {
            Map<ControllerServiceNode, Element> controllerServices = ControllerServiceLoader.loadControllerServices(serviceNodeList, flowController, processGroup, encryptor, encodingVersion);
            ControllerServiceLoader.enableControllerServices(controllerServices, flowController, encryptor, this.autoResumeState, encodingVersion);
        }
    }

    private void addProcessors(Element processGroupElement, ProcessGroup processGroup, FlowController flowController, FlowEncodingVersion encodingVersion) {
        List<Element> processorNodeList = XmlFlowSynchronizer.getChildrenByTagName(processGroupElement, "processor");
        PropertyEncryptor encryptor = flowController.getEncryptor();
        for (Element processorElement : processorNodeList) {
            BundleCoordinate coordinate;
            ProcessorDTO processorDTO = FlowFromDOMFactory.getProcessor(processorElement, encryptor, encodingVersion);
            try {
                coordinate = BundleUtils.getCompatibleBundle((ExtensionManager)this.extensionManager, (String)processorDTO.getType(), (BundleDTO)processorDTO.getBundle());
            }
            catch (IllegalStateException e) {
                BundleDTO bundleDTO = processorDTO.getBundle();
                coordinate = bundleDTO == null ? BundleCoordinate.UNKNOWN_COORDINATE : new BundleCoordinate(bundleDTO.getGroup(), bundleDTO.getArtifact(), bundleDTO.getVersion());
            }
            ProcessorNode procNode = flowController.getFlowManager().createProcessor(processorDTO.getType(), processorDTO.getId(), coordinate, false);
            procNode.setVersionedComponentId(processorDTO.getVersionedComponentId());
            processGroup.addProcessor(procNode);
            this.updateProcessor(procNode, processorDTO, processGroup, flowController);
        }
    }

    private void addInputPorts(Element processGroupElement, ProcessGroup processGroup, FlowController flowController) {
        FlowManager flowManager = flowController.getFlowManager();
        List<Element> inputPortNodeList = XmlFlowSynchronizer.getChildrenByTagName(processGroupElement, "inputPort");
        for (Element inputPortElement : inputPortNodeList) {
            ScheduledState scheduledState;
            Set groupControls;
            PortDTO portDTO = FlowFromDOMFactory.getPort(inputPortElement);
            Port port = processGroup.isRootGroup() || Boolean.TRUE.equals(portDTO.getAllowRemoteAccess()) ? flowManager.createPublicInputPort(portDTO.getId(), portDTO.getName()) : flowManager.createLocalInputPort(portDTO.getId(), portDTO.getName());
            port.setVersionedComponentId(portDTO.getVersionedComponentId());
            port.setPosition(this.toPosition(portDTO.getPosition()));
            port.setComments(portDTO.getComments());
            port.setProcessGroup(processGroup);
            Set userControls = portDTO.getUserAccessControl();
            if (userControls != null && !userControls.isEmpty()) {
                if (!(port instanceof PublicPort)) {
                    throw new IllegalStateException("Attempting to add User Access Controls to " + port.getIdentifier() + ", but it is not a RootGroupPort");
                }
                ((PublicPort)port).setUserAccessControl(userControls);
            }
            if ((groupControls = portDTO.getGroupAccessControl()) != null && !groupControls.isEmpty()) {
                if (!(port instanceof PublicPort)) {
                    throw new IllegalStateException("Attempting to add Group Access Controls to " + port.getIdentifier() + ", but it is not a RootGroupPort");
                }
                ((PublicPort)port).setGroupAccessControl(groupControls);
            }
            processGroup.addInputPort(port);
            if (portDTO.getConcurrentlySchedulableTaskCount() != null) {
                port.setMaxConcurrentTasks(portDTO.getConcurrentlySchedulableTaskCount().intValue());
            }
            if (ScheduledState.RUNNING.equals((Object)(scheduledState = ScheduledState.valueOf((String)portDTO.getState())))) {
                flowController.startConnectable((Connectable)port);
                continue;
            }
            if (!ScheduledState.DISABLED.equals((Object)scheduledState)) continue;
            processGroup.disableInputPort(port);
        }
    }

    private void addOutputPorts(Element processGroupElement, ProcessGroup processGroup, FlowController flowController) {
        FlowManager flowManager = flowController.getFlowManager();
        List<Element> outputPortNodeList = XmlFlowSynchronizer.getChildrenByTagName(processGroupElement, "outputPort");
        for (Element outputPortElement : outputPortNodeList) {
            ScheduledState scheduledState;
            Set groupControls;
            PortDTO portDTO = FlowFromDOMFactory.getPort(outputPortElement);
            Port port = processGroup.isRootGroup() || Boolean.TRUE.equals(portDTO.getAllowRemoteAccess()) ? flowManager.createPublicOutputPort(portDTO.getId(), portDTO.getName()) : flowManager.createLocalOutputPort(portDTO.getId(), portDTO.getName());
            port.setVersionedComponentId(portDTO.getVersionedComponentId());
            port.setPosition(this.toPosition(portDTO.getPosition()));
            port.setComments(portDTO.getComments());
            port.setProcessGroup(processGroup);
            Set userControls = portDTO.getUserAccessControl();
            if (userControls != null && !userControls.isEmpty()) {
                if (!(port instanceof PublicPort)) {
                    throw new IllegalStateException("Attempting to add User Access Controls to " + port.getIdentifier() + ", but it is not a RootGroupPort");
                }
                ((PublicPort)port).setUserAccessControl(userControls);
            }
            if ((groupControls = portDTO.getGroupAccessControl()) != null && !groupControls.isEmpty()) {
                if (!(port instanceof PublicPort)) {
                    throw new IllegalStateException("Attempting to add Group Access Controls to " + port.getIdentifier() + ", but it is not a RootGroupPort");
                }
                ((PublicPort)port).setGroupAccessControl(groupControls);
            }
            processGroup.addOutputPort(port);
            if (portDTO.getConcurrentlySchedulableTaskCount() != null) {
                port.setMaxConcurrentTasks(portDTO.getConcurrentlySchedulableTaskCount().intValue());
            }
            if (ScheduledState.RUNNING.equals((Object)(scheduledState = ScheduledState.valueOf((String)portDTO.getState())))) {
                flowController.startConnectable((Connectable)port);
                continue;
            }
            if (!ScheduledState.DISABLED.equals((Object)scheduledState)) continue;
            processGroup.disableOutputPort(port);
        }
    }

    private void addFunnels(Element processGroupElement, ProcessGroup processGroup, FlowController controller) {
        List<Element> funnelNodeList = XmlFlowSynchronizer.getChildrenByTagName(processGroupElement, "funnel");
        for (Element funnelElement : funnelNodeList) {
            FunnelDTO funnelDTO = FlowFromDOMFactory.getFunnel(funnelElement);
            Funnel funnel = controller.getFlowManager().createFunnel(funnelDTO.getId());
            funnel.setVersionedComponentId(funnelDTO.getVersionedComponentId());
            funnel.setPosition(this.toPosition(funnelDTO.getPosition()));
            processGroup.addFunnel(funnel, false);
            controller.startConnectable((Connectable)funnel);
        }
    }

    private void addLabels(Element processGroupElement, ProcessGroup processGroup, FlowController controller) {
        List<Element> labelNodeList = XmlFlowSynchronizer.getChildrenByTagName(processGroupElement, "label");
        for (Element labelElement : labelNodeList) {
            LabelDTO labelDTO = FlowFromDOMFactory.getLabel(labelElement);
            Label label = controller.getFlowManager().createLabel(labelDTO.getId(), labelDTO.getLabel());
            label.setVersionedComponentId(labelDTO.getVersionedComponentId());
            label.setStyle(labelDTO.getStyle());
            label.setPosition(this.toPosition(labelDTO.getPosition()));
            label.setSize(new Size(labelDTO.getWidth().doubleValue(), labelDTO.getHeight().doubleValue()));
            Long zIndex = labelDTO.getzIndex();
            if (zIndex != null) {
                label.setZIndex(zIndex.longValue());
            }
            processGroup.addLabel(label);
        }
    }

    private void addRemoteProcessGroups(Element processGroupElement, ProcessGroup processGroup, FlowController controller) {
        List<Element> remoteProcessGroupNodeList = XmlFlowSynchronizer.getChildrenByTagName(processGroupElement, "remoteProcessGroup");
        PropertyEncryptor encryptor = controller.getEncryptor();
        for (Element remoteProcessGroupElement : remoteProcessGroupNodeList) {
            RemoteGroupPort port;
            String transportProtocol;
            RemoteProcessGroupDTO remoteGroupDto = FlowFromDOMFactory.getRemoteProcessGroup(remoteProcessGroupElement, encryptor);
            RemoteProcessGroup remoteGroup = controller.getFlowManager().createRemoteProcessGroup(remoteGroupDto.getId(), remoteGroupDto.getTargetUris());
            remoteGroup.setVersionedComponentId(remoteGroupDto.getVersionedComponentId());
            remoteGroup.setComments(remoteGroupDto.getComments());
            remoteGroup.setPosition(this.toPosition(remoteGroupDto.getPosition()));
            String name = remoteGroupDto.getName();
            if (name != null && !name.trim().isEmpty()) {
                remoteGroup.setName(name);
            }
            remoteGroup.setProcessGroup(processGroup);
            remoteGroup.setCommunicationsTimeout(remoteGroupDto.getCommunicationsTimeout());
            if (remoteGroupDto.getYieldDuration() != null) {
                remoteGroup.setYieldDuration(remoteGroupDto.getYieldDuration());
            }
            if ((transportProtocol = remoteGroupDto.getTransportProtocol()) != null && !transportProtocol.trim().isEmpty()) {
                remoteGroup.setTransportProtocol(SiteToSiteTransportProtocol.valueOf((String)transportProtocol.toUpperCase()));
            }
            if (remoteGroupDto.getProxyHost() != null) {
                remoteGroup.setProxyHost(remoteGroupDto.getProxyHost());
            }
            if (remoteGroupDto.getProxyPort() != null) {
                remoteGroup.setProxyPort(remoteGroupDto.getProxyPort());
            }
            if (remoteGroupDto.getProxyUser() != null) {
                remoteGroup.setProxyUser(remoteGroupDto.getProxyUser());
            }
            if (remoteGroupDto.getProxyPassword() != null) {
                remoteGroup.setProxyPassword(remoteGroupDto.getProxyPassword());
            }
            if (StringUtils.isBlank((CharSequence)remoteGroupDto.getLocalNetworkInterface())) {
                remoteGroup.setNetworkInterface(null);
            } else {
                remoteGroup.setNetworkInterface(remoteGroupDto.getLocalNetworkInterface());
            }
            HashSet<RemoteProcessGroupPortDescriptor> inputPorts = new HashSet<RemoteProcessGroupPortDescriptor>();
            for (Element portElement : XmlFlowSynchronizer.getChildrenByTagName(remoteProcessGroupElement, "inputPort")) {
                inputPorts.add(FlowFromDOMFactory.getRemoteProcessGroupPort(portElement));
            }
            remoteGroup.setInputPorts(inputPorts, false);
            HashSet<RemoteProcessGroupPortDescriptor> outputPorts = new HashSet<RemoteProcessGroupPortDescriptor>();
            for (Element portElement : XmlFlowSynchronizer.getChildrenByTagName(remoteProcessGroupElement, "outputPort")) {
                outputPorts.add(FlowFromDOMFactory.getRemoteProcessGroupPort(portElement));
            }
            remoteGroup.setOutputPorts(outputPorts, false);
            processGroup.addRemoteProcessGroup(remoteGroup);
            for (RemoteProcessGroupPortDescriptor remoteGroupPortDTO : outputPorts) {
                port = remoteGroup.getOutputPort(remoteGroupPortDTO.getId());
                if (!Boolean.TRUE.equals(remoteGroupPortDTO.isTransmitting())) continue;
                controller.startTransmitting(port);
            }
            for (RemoteProcessGroupPortDescriptor remoteGroupPortDTO : inputPorts) {
                port = remoteGroup.getInputPort(remoteGroupPortDTO.getId());
                if (!Boolean.TRUE.equals(remoteGroupPortDTO.isTransmitting())) continue;
                controller.startTransmitting(port);
            }
        }
    }

    private void addConnections(Element processGroupElement, ProcessGroup processGroup, FlowController controller) {
        FlowManager flowManager = controller.getFlowManager();
        List<Element> connectionNodeList = XmlFlowSynchronizer.getChildrenByTagName(processGroupElement, "connection");
        for (Element connectionElement : connectionNodeList) {
            RemoteGroupPort destination;
            RemoteGroupPort source;
            ConnectionDTO dto = FlowFromDOMFactory.getConnection(connectionElement);
            ConnectableDTO sourceDto = dto.getSource();
            if (ConnectableType.REMOTE_OUTPUT_PORT.name().equals(sourceDto.getType())) {
                RemoteProcessGroup remoteGroup = processGroup.getRemoteProcessGroup(sourceDto.getGroupId());
                source = remoteGroup.getOutputPort(sourceDto.getId());
            } else {
                ProcessGroup sourceGroup = flowManager.getGroup(sourceDto.getGroupId());
                if (sourceGroup == null) {
                    throw new RuntimeException("Found Invalid ProcessGroup ID for Source: " + dto.getSource().getGroupId());
                }
                source = sourceGroup.getConnectable(sourceDto.getId());
            }
            if (source == null) {
                throw new RuntimeException("Found Invalid Connectable ID for Source: " + dto.getSource().getId());
            }
            ConnectableDTO destinationDto = dto.getDestination();
            if (ConnectableType.REMOTE_INPUT_PORT.name().equals(destinationDto.getType())) {
                RemoteProcessGroup remoteGroup = processGroup.getRemoteProcessGroup(destinationDto.getGroupId());
                destination = remoteGroup.getInputPort(destinationDto.getId());
            } else {
                ProcessGroup destinationGroup = flowManager.getGroup(destinationDto.getGroupId());
                if (destinationGroup == null) {
                    throw new RuntimeException("Found Invalid ProcessGroup ID for Destination: " + dto.getDestination().getGroupId());
                }
                destination = destinationGroup.getConnectable(destinationDto.getId());
            }
            if (destination == null) {
                throw new RuntimeException("Found Invalid Connectable ID for Destination: " + dto.getDestination().getId());
            }
            Connection connection = flowManager.createConnection(dto.getId(), dto.getName(), (Connectable)source, (Connectable)destination, (Collection)dto.getSelectedRelationships());
            connection.setVersionedComponentId(dto.getVersionedComponentId());
            connection.setProcessGroup(processGroup);
            ArrayList<Position> bendPoints = new ArrayList<Position>();
            for (PositionDTO bend : dto.getBends()) {
                bendPoints.add(new Position(bend.getX().doubleValue(), bend.getY().doubleValue()));
            }
            connection.setBendPoints(bendPoints);
            Long zIndex = dto.getzIndex();
            if (zIndex != null) {
                connection.setZIndex(zIndex.longValue());
            }
            if (dto.getLabelIndex() != null) {
                connection.setLabelIndex(dto.getLabelIndex().intValue());
            }
            ArrayList<FlowFilePrioritizer> newPrioritizers = null;
            List prioritizers = dto.getPrioritizers();
            if (prioritizers != null) {
                ArrayList newPrioritizersClasses = new ArrayList(prioritizers);
                newPrioritizers = new ArrayList<FlowFilePrioritizer>();
                for (String className : newPrioritizersClasses) {
                    try {
                        newPrioritizers.add(flowManager.createPrioritizer(className));
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        throw new IllegalArgumentException("Unable to set prioritizer " + className + ": " + e);
                    }
                }
            }
            if (newPrioritizers != null) {
                connection.getFlowFileQueue().setPriorities(newPrioritizers);
            }
            if (dto.getBackPressureObjectThreshold() != null) {
                connection.getFlowFileQueue().setBackPressureObjectThreshold(dto.getBackPressureObjectThreshold().longValue());
            }
            if (dto.getBackPressureDataSizeThreshold() != null) {
                connection.getFlowFileQueue().setBackPressureDataSizeThreshold(dto.getBackPressureDataSizeThreshold());
            }
            if (dto.getFlowFileExpiration() != null) {
                connection.getFlowFileQueue().setFlowFileExpiration(dto.getFlowFileExpiration());
            }
            if (dto.getLoadBalanceStrategy() != null) {
                connection.getFlowFileQueue().setLoadBalanceStrategy(LoadBalanceStrategy.valueOf((String)dto.getLoadBalanceStrategy()), dto.getLoadBalancePartitionAttribute());
            }
            if (dto.getLoadBalanceCompression() != null) {
                connection.getFlowFileQueue().setLoadBalanceCompression(LoadBalanceCompression.valueOf((String)dto.getLoadBalanceCompression()));
            }
            processGroup.addConnection(connection);
        }
    }

    private void addTemplates(Element processGroupElement, ProcessGroup processGroup) {
        List<Element> templateNodeList = XmlFlowSynchronizer.getChildrenByTagName(processGroupElement, "template");
        for (Element templateNode : templateNodeList) {
            TemplateDTO templateDTO = TemplateUtils.parseDto(templateNode);
            Template template = new Template(templateDTO);
            processGroup.addTemplate(template);
        }
    }

    private byte[] toBytes(FlowController flowController) throws FlowSerializationException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        StandardFlowSerializer flowSerializer = new StandardFlowSerializer();
        flowController.serialize(flowSerializer, result);
        return result.toByteArray();
    }

    private static String getString(Element element, String childElementName) {
        List<Element> nodeList = XmlFlowSynchronizer.getChildrenByTagName(element, childElementName);
        if (nodeList == null || nodeList.isEmpty()) {
            return "";
        }
        Element childElement = nodeList.get(0);
        return childElement.getTextContent();
    }

    private static int getInt(Element element, String childElementName) {
        return Integer.parseInt(XmlFlowSynchronizer.getString(element, childElementName));
    }

    private static Integer getInteger(Element element, String childElementName) {
        String value = XmlFlowSynchronizer.getString(element, childElementName);
        return value == null || value.trim().equals("") ? null : Integer.valueOf(Integer.parseInt(value));
    }

    private static List<Element> getChildrenByTagName(Element element, String tagName) {
        ArrayList<Element> matches = new ArrayList<Element>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element child;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(child = (Element)nodeList.item(i)).getNodeName().equals(tagName)) continue;
            matches.add(child);
        }
        return matches;
    }
}

