/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.fingerprint;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.serialization.FlowEncodingVersion;
import org.apache.nifi.controller.serialization.FlowFromDOMFactory;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.encrypt.SensitiveValueEncoder;
import org.apache.nifi.fingerprint.FingerprintException;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.util.BundleUtils;
import org.apache.nifi.util.DomUtils;
import org.apache.nifi.util.LoggingXmlParserErrorHandler;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ComponentDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.FlowRegistryClientDTO;
import org.apache.nifi.web.api.dto.ParameterProviderDTO;
import org.apache.nifi.web.api.dto.ReportingTaskDTO;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.parsers.StandardDocumentProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;

public class FingerprintFactory {
    public static final String NO_VALUE = "NO_VALUE";
    static final String FLOW_CONFIG_XSD = "/FlowConfiguration.xsd";
    private static final String ENCRYPTED_VALUE_PREFIX = "enc{";
    private static final String ENCRYPTED_VALUE_SUFFIX = "}";
    private final PropertyEncryptor encryptor;
    private final Schema schema;
    private final ExtensionManager extensionManager;
    private final SensitiveValueEncoder sensitiveValueEncoder;
    private static final Logger logger = LoggerFactory.getLogger(FingerprintFactory.class);

    public FingerprintFactory(PropertyEncryptor encryptor, ExtensionManager extensionManager, SensitiveValueEncoder sensitiveValueEncoder) {
        this.encryptor = encryptor;
        this.extensionManager = extensionManager;
        this.sensitiveValueEncoder = sensitiveValueEncoder;
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            this.schema = schemaFactory.newSchema(FingerprintFactory.class.getResource(FLOW_CONFIG_XSD));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse schema for file flow configuration.", e);
        }
    }

    public synchronized String createFingerprint(byte[] flowBytes) throws FingerprintException {
        return this.createFingerprint(flowBytes, null);
    }

    public synchronized String createFingerprint(byte[] flowBytes, FlowController controller) throws FingerprintException {
        return this.createFingerprint(this.parseFlow(flowBytes), controller);
    }

    public synchronized String createFingerprint(Document flowDoc, FlowController controller) {
        if (flowDoc == null) {
            return "";
        }
        StringBuilder fingerprintBuilder = new StringBuilder();
        Element flowControllerElem = flowDoc.getDocumentElement();
        if (flowControllerElem == null) {
            logger.warn("Unable to create fingerprint because no 'flowController' element found in XML.");
            return "";
        }
        FlowEncodingVersion encodingVersion = FlowEncodingVersion.parse(flowControllerElem);
        this.addFlowControllerFingerprint(fingerprintBuilder, flowControllerElem, controller, encodingVersion);
        return fingerprintBuilder.toString();
    }

    private Document parseFlow(byte[] flow) throws FingerprintException {
        if (flow == null || flow.length == 0) {
            return null;
        }
        try {
            LoggingXmlParserErrorHandler errorHandler = new LoggingXmlParserErrorHandler("Flow Configuration", logger);
            StandardDocumentProvider documentProvider = new StandardDocumentProvider();
            documentProvider.setSchema(this.schema);
            documentProvider.setNamespaceAware(true);
            documentProvider.setErrorHandler((ErrorHandler)errorHandler);
            return documentProvider.parse((InputStream)new ByteArrayInputStream(flow));
        }
        catch (ProcessingException e) {
            throw new FingerprintException("Flow Parsing failed", e);
        }
    }

    private StringBuilder addFlowControllerFingerprint(StringBuilder builder, Element flowControllerElem, FlowController controller, FlowEncodingVersion encodingVersion) {
        Element parameterProvidersElem;
        Element reportingTasksElem;
        Element registriesElement = DomUtils.getChild((Element)flowControllerElem, (String)"registries");
        if (registriesElement == null) {
            builder.append(NO_VALUE);
        } else {
            List flowRegistryElems = DomUtils.getChildElementsByTagName((Element)registriesElement, (String)"flowRegistry");
            if (flowRegistryElems.isEmpty()) {
                builder.append(NO_VALUE);
            } else {
                ArrayList<FlowRegistryClientDTO> registryClientDtos = new ArrayList<FlowRegistryClientDTO>();
                for (Element flowRegistryElement : flowRegistryElems) {
                    registryClientDtos.add(FlowFromDOMFactory.getFlowRegistryClient(flowRegistryElement, this.encryptor, encodingVersion));
                }
                registryClientDtos.sort(Comparator.comparing(FlowRegistryClientDTO::getId));
                for (FlowRegistryClientDTO registryClientDto : registryClientDtos) {
                    this.addFlowRegistryFingerprint(builder, registryClientDto);
                }
            }
        }
        Element contextsElement = DomUtils.getChild((Element)flowControllerElem, (String)"parameterContexts");
        if (contextsElement == null) {
            builder.append("NO_PARAMETER_CONTEXTS");
        } else {
            List parameterContextElements = DomUtils.getChildElementsByTagName((Element)contextsElement, (String)"parameterContext");
            if (parameterContextElements.isEmpty()) {
                builder.append("NO_PARAMETER_CONTEXTS");
            } else {
                this.orderByChildElement(parameterContextElements, "id");
                for (Element parameterContextElement : parameterContextElements) {
                    this.addParameterContext(builder, parameterContextElement);
                }
            }
        }
        Element rootGroupElem = (Element)DomUtils.getChildNodesByTagName((Element)flowControllerElem, (String)"rootGroup").item(0);
        this.addProcessGroupFingerprint(builder, rootGroupElem, encodingVersion);
        Element controllerServicesElem = DomUtils.getChild((Element)flowControllerElem, (String)"controllerServices");
        if (controllerServicesElem != null) {
            ArrayList<ControllerServiceDTO> serviceDtos = new ArrayList<ControllerServiceDTO>();
            for (Element serviceElem : DomUtils.getChildElementsByTagName((Element)controllerServicesElem, (String)"controllerService")) {
                ControllerServiceDTO controllerServiceDTO = FlowFromDOMFactory.getControllerService(serviceElem, this.encryptor, encodingVersion);
                serviceDtos.add(controllerServiceDTO);
            }
            Collections.sort(serviceDtos, new Comparator<ControllerServiceDTO>(){

                @Override
                public int compare(ControllerServiceDTO o1, ControllerServiceDTO o2) {
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null && o2 != null) {
                        return 1;
                    }
                    if (o1 != null && o2 == null) {
                        return -1;
                    }
                    return o1.getId().compareTo(o2.getId());
                }
            });
            for (ControllerServiceDTO dto : serviceDtos) {
                this.addControllerServiceFingerprint(builder, dto);
            }
        }
        if ((reportingTasksElem = DomUtils.getChild((Element)flowControllerElem, (String)"reportingTasks")) != null) {
            ArrayList<ReportingTaskDTO> reportingTaskDtos = new ArrayList<ReportingTaskDTO>();
            for (Element element : DomUtils.getChildElementsByTagName((Element)reportingTasksElem, (String)"reportingTask")) {
                ReportingTaskDTO reportingTaskDTO = FlowFromDOMFactory.getReportingTask(element, this.encryptor, encodingVersion);
                reportingTaskDtos.add(reportingTaskDTO);
            }
            Collections.sort(reportingTaskDtos, new Comparator<ReportingTaskDTO>(){

                @Override
                public int compare(ReportingTaskDTO o1, ReportingTaskDTO o2) {
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null && o2 != null) {
                        return 1;
                    }
                    if (o1 != null && o2 == null) {
                        return -1;
                    }
                    return o1.getId().compareTo(o2.getId());
                }
            });
            for (ReportingTaskDTO reportingTaskDTO : reportingTaskDtos) {
                this.addReportingTaskFingerprint(builder, reportingTaskDTO);
            }
        }
        if ((parameterProvidersElem = DomUtils.getChild((Element)flowControllerElem, (String)"parameterProviders")) != null) {
            ArrayList<ParameterProviderDTO> parameterProviderDtos = new ArrayList<ParameterProviderDTO>();
            for (Element element : DomUtils.getChildElementsByTagName((Element)parameterProvidersElem, (String)"parameterProvider")) {
                ParameterProviderDTO dto = FlowFromDOMFactory.getParameterProvider(element, this.encryptor, encodingVersion);
                parameterProviderDtos.add(dto);
            }
            Collections.sort(parameterProviderDtos, Comparator.comparing(ComponentDTO::getId));
            for (ParameterProviderDTO parameterProviderDTO : parameterProviderDtos) {
                this.addParameterProviderFingerprint(builder, parameterProviderDTO);
            }
        }
        return builder;
    }

    private void orderByChildElement(List<Element> toSort, String childTagName) {
        toSort.sort((a, b) -> {
            String valueA = DomUtils.getChildText((Element)a, (String)childTagName);
            String valueB = DomUtils.getChildText((Element)b, (String)childTagName);
            return valueA.compareTo(valueB);
        });
    }

    private StringBuilder addParameterContext(StringBuilder builder, Element parameterContextElement) {
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)parameterContextElement, (String)"id"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)parameterContextElement, (String)"name"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)parameterContextElement, (String)"description"));
        List parameterElements = DomUtils.getChildElementsByTagName((Element)parameterContextElement, (String)"parameter");
        if (parameterElements == null || parameterElements.isEmpty()) {
            builder.append("NO_PARAMETERS");
        } else {
            this.orderByChildElement(parameterElements, "name");
            for (Object parameterElement : parameterElements) {
                this.addParameter(builder, (Element)parameterElement);
            }
        }
        List inheritedParameterContexts = DomUtils.getChildElementsByTagName((Element)parameterContextElement, (String)"inheritedParameterContextId");
        if (inheritedParameterContexts == null || inheritedParameterContexts.isEmpty()) {
            builder.append("NO_INHERITED_PARAMETER_CONTEXT_IDS");
        } else {
            for (Element inheritedParameterContextId : inheritedParameterContexts) {
                builder.append(inheritedParameterContextId.getTextContent());
            }
        }
        String parameterProviderId = DomUtils.getChildText((Element)parameterContextElement, (String)"parameterProviderId");
        builder.append(parameterProviderId == null ? "NO_PARAMETER_PROVIDER_ID" : parameterProviderId);
        String parameterGroupName = DomUtils.getChildText((Element)parameterContextElement, (String)"parameterGroupName");
        builder.append(parameterGroupName == null ? "NO_PARAMETER_GROUP_NAME" : parameterGroupName);
        String isSynchronized = DomUtils.getChildText((Element)parameterContextElement, (String)"isSynchronized");
        builder.append(isSynchronized == null ? "NO_PARAMETER_IS_SYNCHRONIZED" : isSynchronized);
        return builder;
    }

    private void addParameter(StringBuilder builder, Element parameterElement) {
        Stream.of("name", "description", "sensitive", "provided").forEach(elementName -> this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)parameterElement, (String)elementName)));
        String value = DomUtils.getChildText((Element)parameterElement, (String)"value");
        if (value == null) {
            builder.append(NO_VALUE);
            return;
        }
        if (this.isEncrypted(value)) {
            builder.append(this.getLoggableRepresentationOfSensitiveValue(value));
        } else {
            builder.append(this.getValue(value, NO_VALUE));
        }
    }

    private void addFlowRegistryFingerprint(StringBuilder builder, FlowRegistryClientDTO dto) {
        builder.append(dto.getId());
        builder.append(dto.getName());
        builder.append(dto.getDeprecated());
        builder.append(dto.getUri());
        builder.append(dto.getType());
        this.addBundleFingerprint(builder, dto.getBundle());
        BundleCoordinate coordinate = this.getCoordinate(dto.getType(), dto.getBundle());
        ConfigurableComponent configurableComponent = this.extensionManager.getTempComponent(dto.getType(), coordinate);
        if (configurableComponent == null) {
            logger.warn("Unable to get FlowRegistryClient of type {}; its default properties will be fingerprinted instead of being ignored.", (Object)dto.getType());
        }
        this.addPropertiesFingerprint(builder, configurableComponent, dto.getProperties());
    }

    StringBuilder addProcessGroupFingerprint(StringBuilder builder, Element processGroupElem, FlowEncodingVersion encodingVersion) throws FingerprintException {
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)processGroupElem, (String)"id"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)processGroupElem, (String)"versionedComponentId"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)processGroupElem, (String)"parameterContextId"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)processGroupElem, (String)"flowfileConcurrency"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)processGroupElem, (String)"flowfileOutboundPolicy"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)processGroupElem, (String)"defaultFlowFileExpiration"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)processGroupElem, (String)"defaultBackPressureObjectThreshold"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)processGroupElem, (String)"defaultBackPressureDataSizeThreshold"));
        Element versionControlInfo = DomUtils.getChild((Element)processGroupElem, (String)"versionControlInformation");
        if (versionControlInfo == null) {
            builder.append("NO_VERSION_CONTROL_INFORMATION");
        } else {
            this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)versionControlInfo, (String)"registryId"));
            this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)versionControlInfo, (String)"bucketId"));
            this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)versionControlInfo, (String)"flowId"));
            this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)versionControlInfo, (String)"version"));
        }
        List processorElems = DomUtils.getChildElementsByTagName((Element)processGroupElem, (String)"processor");
        processorElems.sort(this.getIdsComparator());
        for (Element processorElem : processorElems) {
            this.addFlowFileProcessorFingerprint(builder, processorElem);
        }
        NodeList inputPortElems = DomUtils.getChildNodesByTagName((Element)processGroupElem, (String)"inputPort");
        List<Element> sortedInputPortElems = this.sortElements(inputPortElems, this.getIdsComparator());
        for (Element inputPortElem : sortedInputPortElems) {
            this.addPortFingerprint(builder, inputPortElem);
        }
        NodeList labelElems = DomUtils.getChildNodesByTagName((Element)processGroupElem, (String)"label");
        List<Element> sortedLabels = this.sortElements(labelElems, this.getIdsComparator());
        for (Element labelElem : sortedLabels) {
            this.addLabelFingerprint(builder, labelElem);
        }
        NodeList outputPortElems = DomUtils.getChildNodesByTagName((Element)processGroupElem, (String)"outputPort");
        List<Element> sortedOutputPortElems = this.sortElements(outputPortElems, this.getIdsComparator());
        for (Element outputPortElem : sortedOutputPortElems) {
            this.addPortFingerprint(builder, outputPortElem);
        }
        NodeList nestedProcessGroupElems = DomUtils.getChildNodesByTagName((Element)processGroupElem, (String)"processGroup");
        List<Element> sortedNestedProcessGroupElems = this.sortElements(nestedProcessGroupElems, this.getIdsComparator());
        for (Element nestedProcessGroupElem : sortedNestedProcessGroupElems) {
            this.addProcessGroupFingerprint(builder, nestedProcessGroupElem, encodingVersion);
        }
        NodeList remoteProcessGroupElems = DomUtils.getChildNodesByTagName((Element)processGroupElem, (String)"remoteProcessGroup");
        List<Element> sortedRemoteProcessGroupElems = this.sortElements(remoteProcessGroupElems, this.getIdsComparator());
        for (Element remoteProcessGroupElem : sortedRemoteProcessGroupElems) {
            this.addRemoteProcessGroupFingerprint(builder, remoteProcessGroupElem);
        }
        NodeList connectionElems = DomUtils.getChildNodesByTagName((Element)processGroupElem, (String)"connection");
        List<Element> sortedConnectionElems = this.sortElements(connectionElems, this.getIdsComparator());
        for (Element connectionElem : sortedConnectionElems) {
            this.addConnectionFingerprint(builder, connectionElem);
        }
        NodeList funnelElems = DomUtils.getChildNodesByTagName((Element)processGroupElem, (String)"funnel");
        List<Element> sortedFunnelElems = this.sortElements(funnelElems, this.getIdsComparator());
        for (Element funnelElem : sortedFunnelElems) {
            this.addFunnelFingerprint(builder, funnelElem);
        }
        NodeList controllerServiceElems = DomUtils.getChildNodesByTagName((Element)processGroupElem, (String)"controllerService");
        List<Element> sortedControllerServiceElems = this.sortElements(controllerServiceElems, this.getIdsComparator());
        for (Element controllerServiceElem : sortedControllerServiceElems) {
            ControllerServiceDTO dto = FlowFromDOMFactory.getControllerService(controllerServiceElem, this.encryptor, encodingVersion);
            this.addControllerServiceFingerprint(builder, dto);
        }
        NodeList variableElems = DomUtils.getChildNodesByTagName((Element)processGroupElem, (String)"variable");
        List<Element> sortedVarList = this.sortElements(variableElems, this.getVariableNameComparator());
        for (Element varElem : sortedVarList) {
            this.addVariableFingerprint(builder, varElem);
        }
        return builder;
    }

    private void addVariableFingerprint(StringBuilder builder, Element variableElement) {
        String variableName = variableElement.getAttribute("name");
        String variableValue = variableElement.getAttribute("value");
        builder.append(variableName).append("=").append(variableValue);
    }

    private StringBuilder addFlowFileProcessorFingerprint(StringBuilder builder, Element processorElem) throws FingerprintException {
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)processorElem, (String)"id"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)processorElem, (String)"versionedComponentId"));
        NodeList childNodes = DomUtils.getChildNodesByTagName((Element)processorElem, (String)"class");
        String className = childNodes.item(0).getTextContent();
        this.appendFirstValue(builder, childNodes);
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)processorElem, (String)"annotationData"));
        BundleDTO bundle = FlowFromDOMFactory.getBundle(DomUtils.getChild((Element)processorElem, (String)"bundle"));
        this.addBundleFingerprint(builder, bundle);
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)processorElem, (String)"maxConcurrentTasks"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)processorElem, (String)"schedulingPeriod"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)processorElem, (String)"penalizationPeriod"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)processorElem, (String)"yieldPeriod"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)processorElem, (String)"bulletinLevel"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)processorElem, (String)"lossTolerant"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)processorElem, (String)"schedulingStrategy"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)processorElem, (String)"executionNode"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)processorElem, (String)"runDurationNanos"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)processorElem, (String)"retryCount"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)processorElem, (String)"backoffMechanism"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)processorElem, (String)"maxBackoffPeriod"));
        BundleCoordinate coordinate = this.getCoordinate(className, bundle);
        ConfigurableComponent configurableComponent = this.extensionManager.getTempComponent(className, coordinate);
        if (configurableComponent == null) {
            logger.warn("Unable to get Processor of type {}; its default properties will be fingerprinted instead of being ignored.", (Object)className);
        }
        NodeList propertyElems = DomUtils.getChildNodesByTagName((Element)processorElem, (String)"property");
        List<Element> sortedPropertyElems = this.sortElements(propertyElems, this.getProcessorPropertiesComparator());
        for (Element propertyElem : sortedPropertyElems) {
            String propName = ((Element)DomUtils.getChildElementsByTagName((Element)propertyElem, (String)"name").get(0)).getTextContent();
            String propValue = this.getFirstValue(DomUtils.getChildNodesByTagName((Element)propertyElem, (String)"value"), null);
            this.addPropertyFingerprint(builder, configurableComponent, propName, propValue);
        }
        NodeList autoTerminateElems = DomUtils.getChildNodesByTagName((Element)processorElem, (String)"autoTerminatedRelationship");
        List<Element> sortedAutoTerminateElems = this.sortElements(autoTerminateElems, this.getElementTextComparator());
        for (Element autoTerminateElem : sortedAutoTerminateElems) {
            builder.append(autoTerminateElem.getTextContent());
        }
        NodeList retriedRelationshipsElems = DomUtils.getChildNodesByTagName((Element)processorElem, (String)"retriedRelationships");
        List<Element> sortedRetriedRelationshipsElems = this.sortElements(retriedRelationshipsElems, this.getElementTextComparator());
        for (Element retriedRelationshipElem : sortedRetriedRelationshipsElems) {
            builder.append(retriedRelationshipElem.getTextContent());
        }
        return builder;
    }

    private StringBuilder addPropertyFingerprint(StringBuilder builder, ConfigurableComponent component, String propName, String propValue) throws FingerprintException {
        PropertyDescriptor descriptor;
        if (component != null && (descriptor = component.getPropertyDescriptor(propName)) != null && propValue != null && propValue.equals(descriptor.getDefaultValue())) {
            return builder;
        }
        if (propValue == null) {
            return builder;
        }
        builder.append(propName).append("=");
        if (this.isEncrypted(propValue)) {
            builder.append(this.getLoggableRepresentationOfSensitiveValue(propValue));
        } else {
            builder.append(this.getValue(propValue, NO_VALUE));
        }
        return builder;
    }

    private String getLoggableRepresentationOfSensitiveValue(String encryptedPropertyValue) {
        String plaintextValue = this.decrypt(encryptedPropertyValue);
        return this.sensitiveValueEncoder.getEncoded(plaintextValue);
    }

    private StringBuilder addPortFingerprint(StringBuilder builder, Element portElem) throws FingerprintException {
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)portElem, (String)"id"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)portElem, (String)"versionedComponentId"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)portElem, (String)"name"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)portElem, (String)"allowRemoteAccess"));
        NodeList userAccessControlNodeList = DomUtils.getChildNodesByTagName((Element)portElem, (String)"userAccessControl");
        if (userAccessControlNodeList == null || userAccessControlNodeList.getLength() == 0) {
            builder.append("NO_USER_ACCESS_CONTROL");
        } else {
            ArrayList<String> sortedAccessControl = new ArrayList<String>();
            for (int i = 0; i < userAccessControlNodeList.getLength(); ++i) {
                sortedAccessControl.add(userAccessControlNodeList.item(i).getTextContent());
            }
            Collections.sort(sortedAccessControl);
            for (String user : sortedAccessControl) {
                builder.append(user);
            }
        }
        NodeList groupAccessControlNodeList = DomUtils.getChildNodesByTagName((Element)portElem, (String)"groupAccessControl");
        if (groupAccessControlNodeList == null || groupAccessControlNodeList.getLength() == 0) {
            builder.append("NO_GROUP_ACCESS_CONTROL");
        } else {
            ArrayList<String> sortedAccessControl = new ArrayList<String>();
            for (int i = 0; i < groupAccessControlNodeList.getLength(); ++i) {
                sortedAccessControl.add(groupAccessControlNodeList.item(i).getTextContent());
            }
            Collections.sort(sortedAccessControl);
            for (String user : sortedAccessControl) {
                builder.append(user);
            }
        }
        return builder;
    }

    private StringBuilder addLabelFingerprint(StringBuilder builder, Element labelElem) {
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)labelElem, (String)"id"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)labelElem, (String)"versionedComponentId"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)labelElem, (String)"value"));
        return builder;
    }

    private StringBuilder addRemoteProcessGroupFingerprint(StringBuilder builder, Element remoteProcessGroupElem) throws FingerprintException {
        for (String tagName : new String[]{"id", "versionedComponentId", "urls", "networkInterface", "timeout", "yieldPeriod", "transportProtocol", "proxyHost", "proxyPort", "proxyUser", "proxyPassword"}) {
            String value = this.getFirstValue(DomUtils.getChildNodesByTagName((Element)remoteProcessGroupElem, (String)tagName));
            if (this.isEncrypted(value)) {
                builder.append(this.getLoggableRepresentationOfSensitiveValue(value));
                continue;
            }
            builder.append(value);
        }
        NodeList inputPortList = DomUtils.getChildNodesByTagName((Element)remoteProcessGroupElem, (String)"inputPort");
        NodeList outputPortList = DomUtils.getChildNodesByTagName((Element)remoteProcessGroupElem, (String)"outputPort");
        Comparator<Element> portComparator = new Comparator<Element>(){

            @Override
            public int compare(Element o1, Element o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                NodeList nameList1 = DomUtils.getChildNodesByTagName((Element)o1, (String)"name");
                NodeList nameList2 = DomUtils.getChildNodesByTagName((Element)o2, (String)"name");
                if (nameList1.getLength() == 0 && nameList2.getLength() == 0) {
                    return 0;
                }
                if (nameList1.getLength() == 0) {
                    return 1;
                }
                if (nameList2.getLength() == 0) {
                    return -1;
                }
                return nameList1.item(0).getTextContent().compareTo(nameList2.item(0).getTextContent());
            }
        };
        ArrayList<Element> sortedInputPorts = new ArrayList<Element>(inputPortList.getLength());
        for (int i = 0; i < inputPortList.getLength(); ++i) {
            sortedInputPorts.add((Element)inputPortList.item(i));
        }
        Collections.sort(sortedInputPorts, portComparator);
        ArrayList<Element> sortedOutputPorts = new ArrayList<Element>(outputPortList.getLength());
        for (int i = 0; i < outputPortList.getLength(); ++i) {
            sortedOutputPorts.add((Element)outputPortList.item(i));
        }
        Collections.sort(sortedOutputPorts, portComparator);
        for (Element inputPortElement : sortedInputPorts) {
            this.addRemoteGroupPortFingerprint(builder, inputPortElement);
        }
        for (Element outputPortElement : sortedOutputPorts) {
            this.addRemoteGroupPortFingerprint(builder, outputPortElement);
        }
        return builder;
    }

    private StringBuilder addRemoteGroupPortFingerprint(StringBuilder builder, Element remoteGroupPortElement) {
        for (String childName : new String[]{"id", "targetId", "versionedComponentId", "maxConcurrentTasks", "useCompression", "batchCount", "batchSize", "batchDuration"}) {
            this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)remoteGroupPortElement, (String)childName));
        }
        return builder;
    }

    private StringBuilder addConnectionFingerprint(StringBuilder builder, Element connectionElem) throws FingerprintException {
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)connectionElem, (String)"id"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)connectionElem, (String)"versionedComponentId"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)connectionElem, (String)"sourceId"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)connectionElem, (String)"sourceGroupId"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)connectionElem, (String)"sourceType"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)connectionElem, (String)"destinationId"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)connectionElem, (String)"destinationGroupId"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)connectionElem, (String)"destinationType"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)connectionElem, (String)"name"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)connectionElem, (String)"loadBalanceStrategy"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)connectionElem, (String)"partitioningAttribute"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)connectionElem, (String)"loadBalanceCompression"));
        NodeList relationshipElems = DomUtils.getChildNodesByTagName((Element)connectionElem, (String)"relationship");
        List<Element> sortedRelationshipElems = this.sortElements(relationshipElems, this.getElementTextComparator());
        for (Element relationshipElem : sortedRelationshipElems) {
            builder.append(this.getValue(relationshipElem, NO_VALUE));
        }
        return builder;
    }

    private StringBuilder addFunnelFingerprint(StringBuilder builder, Element funnelElem) throws FingerprintException {
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)funnelElem, (String)"id"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName((Element)funnelElem, (String)"versionedComponentId"));
        return builder;
    }

    private void addControllerServiceFingerprint(StringBuilder builder, ControllerServiceDTO dto) {
        builder.append(dto.getId());
        builder.append(dto.getVersionedComponentId());
        builder.append(dto.getType());
        builder.append(dto.getName());
        this.addBundleFingerprint(builder, dto.getBundle());
        builder.append(dto.getComments());
        builder.append(dto.getBulletinLevel());
        builder.append(dto.getAnnotationData());
        builder.append(dto.getState());
        BundleCoordinate coordinate = this.getCoordinate(dto.getType(), dto.getBundle());
        ConfigurableComponent configurableComponent = this.extensionManager.getTempComponent(dto.getType(), coordinate);
        if (configurableComponent == null) {
            logger.warn("Unable to get ControllerService of type {}; its default properties will be fingerprinted instead of being ignored.", (Object)dto.getType());
        }
        this.addPropertiesFingerprint(builder, configurableComponent, dto.getProperties());
    }

    private void addPropertiesFingerprint(StringBuilder builder, ConfigurableComponent component, Map<String, String> properties) {
        if (properties == null) {
            builder.append("NO_PROPERTIES");
        } else {
            TreeMap<String, String> sortedProps = new TreeMap<String, String>(properties);
            for (Map.Entry entry : sortedProps.entrySet()) {
                this.addPropertyFingerprint(builder, component, (String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private void addBundleFingerprint(StringBuilder builder, BundleDTO bundle) {
        if (bundle != null) {
            builder.append(bundle.getGroup());
            builder.append(bundle.getArtifact());
            builder.append(bundle.getVersion());
        } else {
            builder.append("MISSING_BUNDLE");
        }
    }

    private BundleCoordinate getCoordinate(String type, BundleDTO dto) {
        BundleCoordinate coordinate;
        try {
            coordinate = BundleUtils.getCompatibleBundle((ExtensionManager)this.extensionManager, (String)type, (BundleDTO)dto);
        }
        catch (IllegalStateException e) {
            coordinate = dto == null ? BundleCoordinate.UNKNOWN_COORDINATE : new BundleCoordinate(dto.getGroup(), dto.getArtifact(), dto.getVersion());
        }
        return coordinate;
    }

    private void addReportingTaskFingerprint(StringBuilder builder, ReportingTaskDTO dto) {
        builder.append(dto.getId());
        builder.append(dto.getType());
        builder.append(dto.getName());
        this.addBundleFingerprint(builder, dto.getBundle());
        builder.append(dto.getComments());
        builder.append(dto.getSchedulingPeriod());
        builder.append(dto.getSchedulingStrategy());
        builder.append(dto.getAnnotationData());
        BundleCoordinate coordinate = this.getCoordinate(dto.getType(), dto.getBundle());
        ConfigurableComponent configurableComponent = this.extensionManager.getTempComponent(dto.getType(), coordinate);
        if (configurableComponent == null) {
            logger.warn("Unable to get ReportingTask of type {}; its default properties will be fingerprinted instead of being ignored.", (Object)dto.getType());
        }
        this.addPropertiesFingerprint(builder, configurableComponent, dto.getProperties());
    }

    private void addParameterProviderFingerprint(StringBuilder builder, ParameterProviderDTO dto) {
        builder.append(dto.getId());
        builder.append(dto.getType());
        builder.append(dto.getName());
        this.addBundleFingerprint(builder, dto.getBundle());
        builder.append(dto.getComments());
        builder.append(dto.getAnnotationData());
        BundleCoordinate coordinate = this.getCoordinate(dto.getType(), dto.getBundle());
        ConfigurableComponent configurableComponent = this.extensionManager.getTempComponent(dto.getType(), coordinate);
        if (configurableComponent == null) {
            logger.warn("Unable to get ParameterProvider of type {}; its default properties will be fingerprinted instead of being ignored.", (Object)dto.getType());
        }
        this.addPropertiesFingerprint(builder, configurableComponent, dto.getProperties());
    }

    private Comparator<Element> getIdsComparator() {
        return new Comparator<Element>(){

            @Override
            public int compare(Element e1, Element e2) {
                String e1Id = FingerprintFactory.this.getFirstValue(DomUtils.getChildNodesByTagName((Element)e1, (String)"id"));
                String e2Id = FingerprintFactory.this.getFirstValue(DomUtils.getChildNodesByTagName((Element)e2, (String)"id"));
                return e1Id.compareTo(e2Id);
            }
        };
    }

    private Comparator<Element> getVariableNameComparator() {
        return new Comparator<Element>(){

            @Override
            public int compare(Element e1, Element e2) {
                if (e1 == null && e2 == null) {
                    return 0;
                }
                if (e1 == null) {
                    return 1;
                }
                if (e2 == null) {
                    return -1;
                }
                String varName1 = e1.getAttribute("name");
                String varName2 = e2.getAttribute("name");
                return varName1.compareTo(varName2);
            }
        };
    }

    private Comparator<Element> getProcessorPropertiesComparator() {
        return new Comparator<Element>(){

            @Override
            public int compare(Element e1, Element e2) {
                String e1PropName = FingerprintFactory.this.getFirstValue(DomUtils.getChildNodesByTagName((Element)e1, (String)"name"));
                String e1PropValue = FingerprintFactory.this.getFirstValue(DomUtils.getChildNodesByTagName((Element)e1, (String)"value"));
                if (FingerprintFactory.this.isEncrypted(e1PropValue)) {
                    e1PropValue = FingerprintFactory.this.getLoggableRepresentationOfSensitiveValue(e1PropValue);
                }
                String e1CombinedValue = e1PropName + e1PropValue;
                String e2PropName = FingerprintFactory.this.getFirstValue(DomUtils.getChildNodesByTagName((Element)e2, (String)"name"));
                String e2PropValue = FingerprintFactory.this.getFirstValue(DomUtils.getChildNodesByTagName((Element)e2, (String)"value"));
                if (FingerprintFactory.this.isEncrypted(e2PropValue)) {
                    e2PropValue = FingerprintFactory.this.getLoggableRepresentationOfSensitiveValue(e2PropValue);
                }
                String e2CombinedValue = e2PropName + e2PropValue;
                return e1CombinedValue.compareTo(e2CombinedValue);
            }
        };
    }

    private Comparator<Element> getElementTextComparator() {
        return new Comparator<Element>(){

            @Override
            public int compare(Element e1, Element e2) {
                if (e2 == null) {
                    return -1;
                }
                if (e1 == null) {
                    return 1;
                }
                return e1.getTextContent().compareTo(e2.getTextContent());
            }
        };
    }

    private List<Element> sortElements(NodeList nodeList, Comparator<Element> comparator) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            result.add((Element)nodeList.item(i));
        }
        Collections.sort(result, comparator);
        return result;
    }

    private String getValue(Node node) {
        return this.getValue(node, NO_VALUE);
    }

    private String getValue(Node node, String defaultValue) {
        return StringUtils.isBlank((CharSequence)node.getTextContent()) ? defaultValue : node.getTextContent().trim();
    }

    private String getValue(String value, String defaultValue) {
        return StringUtils.isBlank((CharSequence)value) ? defaultValue : value;
    }

    private String getFirstValue(NodeList nodeList) {
        return this.getFirstValue(nodeList, NO_VALUE);
    }

    private String getFirstValue(NodeList nodeList, String defaultValue) {
        return nodeList == null || nodeList.getLength() == 0 ? defaultValue : this.getValue(nodeList.item(0));
    }

    private StringBuilder appendFirstValue(StringBuilder builder, NodeList nodeList) {
        return this.appendFirstValue(builder, nodeList, NO_VALUE);
    }

    private StringBuilder appendFirstValue(StringBuilder builder, NodeList nodeList, String defaultValue) {
        return builder.append(this.getFirstValue(nodeList, defaultValue));
    }

    private boolean isEncrypted(String value) {
        return value.startsWith(ENCRYPTED_VALUE_PREFIX) && value.endsWith(ENCRYPTED_VALUE_SUFFIX);
    }

    private String decrypt(String value) throws FingerprintException {
        int decryptStartIdx = ENCRYPTED_VALUE_PREFIX.length();
        int decryptEndIdx = value.length() - ENCRYPTED_VALUE_SUFFIX.length();
        return this.encryptor.decrypt(value.substring(decryptStartIdx, decryptEndIdx));
    }
}

