/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.ClassUtils;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.configuration.DefaultSettings;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.components.validation.ValidationTrigger;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.LoggableComponent;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.controller.ParameterProviderNode;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReloadComponent;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.StandardProcessorNode;
import org.apache.nifi.controller.TerminationAwareLogger;
import org.apache.nifi.controller.ValidationContextFactory;
import org.apache.nifi.controller.exception.ProcessorInstantiationException;
import org.apache.nifi.controller.flowrepository.FlowRepositoryClientInstantiationException;
import org.apache.nifi.controller.kerberos.KerberosConfig;
import org.apache.nifi.controller.parameter.ParameterProviderInstantiationException;
import org.apache.nifi.controller.parameter.StandardParameterProviderNode;
import org.apache.nifi.controller.reporting.ReportingTaskInstantiationException;
import org.apache.nifi.controller.reporting.StandardReportingInitializationContext;
import org.apache.nifi.controller.reporting.StandardReportingTaskNode;
import org.apache.nifi.controller.service.ControllerServiceInvocationHandler;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.GhostControllerService;
import org.apache.nifi.controller.service.StandardControllerServiceInitializationContext;
import org.apache.nifi.controller.service.StandardControllerServiceInvocationHandler;
import org.apache.nifi.controller.service.StandardControllerServiceNode;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.GroupedComponent;
import org.apache.nifi.logging.LoggingContext;
import org.apache.nifi.logging.StandardLoggingContext;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.InstanceClassLoader;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.parameter.GhostParameterProvider;
import org.apache.nifi.parameter.ParameterProvider;
import org.apache.nifi.parameter.ParameterProviderInitializationContext;
import org.apache.nifi.parameter.StandardParameterProviderInitializationContext;
import org.apache.nifi.processor.GhostProcessor;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.processor.StandardProcessorInitializationContext;
import org.apache.nifi.processor.StandardValidationContextFactory;
import org.apache.nifi.registry.ComponentVariableRegistry;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.registry.flow.FlowRegistryClient;
import org.apache.nifi.registry.flow.FlowRegistryClientInitializationContext;
import org.apache.nifi.registry.flow.FlowRegistryClientNode;
import org.apache.nifi.registry.flow.GhostFlowRegistryClient;
import org.apache.nifi.registry.flow.StandardFlowRegistryClientInitializationContext;
import org.apache.nifi.registry.flow.StandardFlowRegistryClientNode;
import org.apache.nifi.registry.variable.StandardComponentVariableRegistry;
import org.apache.nifi.reporting.GhostReportingTask;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.reporting.ReportingInitializationContext;
import org.apache.nifi.reporting.ReportingTask;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionBuilder.class);
    private String type;
    private String identifier;
    private BundleCoordinate bundleCoordinate;
    private ExtensionManager extensionManager;
    private Set<URL> classpathUrls;
    private KerberosConfig kerberosConfig = KerberosConfig.NOT_CONFIGURED;
    private ControllerServiceProvider serviceProvider;
    private NodeTypeProvider nodeTypeProvider;
    private VariableRegistry variableRegistry;
    private ProcessScheduler processScheduler;
    private ValidationTrigger validationTrigger;
    private ReloadComponent reloadComponent;
    private FlowController flowController;
    private StateManagerProvider stateManagerProvider;
    private String classloaderIsolationKey;
    private SSLContext systemSslContext;

    public ExtensionBuilder type(String type) {
        this.type = type;
        return this;
    }

    public ExtensionBuilder identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public ExtensionBuilder bundleCoordinate(BundleCoordinate coordinate) {
        this.bundleCoordinate = coordinate;
        return this;
    }

    public ExtensionBuilder addClasspathUrls(Set<URL> urls) {
        if (urls == null || urls.isEmpty()) {
            return this;
        }
        if (this.classpathUrls == null) {
            this.classpathUrls = new HashSet<URL>();
        }
        this.classpathUrls.addAll(urls);
        return this;
    }

    public ExtensionBuilder kerberosConfig(KerberosConfig kerberosConfig) {
        this.kerberosConfig = kerberosConfig;
        return this;
    }

    public ExtensionBuilder controllerServiceProvider(ControllerServiceProvider serviceProvider) {
        this.serviceProvider = serviceProvider;
        return this;
    }

    public ExtensionBuilder nodeTypeProvider(NodeTypeProvider nodeTypeProvider) {
        this.nodeTypeProvider = nodeTypeProvider;
        return this;
    }

    public ExtensionBuilder variableRegistry(VariableRegistry variableRegistry) {
        this.variableRegistry = variableRegistry;
        return this;
    }

    public ExtensionBuilder processScheduler(ProcessScheduler scheduler) {
        this.processScheduler = scheduler;
        return this;
    }

    public ExtensionBuilder validationTrigger(ValidationTrigger validationTrigger) {
        this.validationTrigger = validationTrigger;
        return this;
    }

    public ExtensionBuilder reloadComponent(ReloadComponent reloadComponent) {
        this.reloadComponent = reloadComponent;
        return this;
    }

    public ExtensionBuilder flowController(FlowController flowController) {
        this.flowController = flowController;
        return this;
    }

    public ExtensionBuilder stateManagerProvider(StateManagerProvider stateManagerProvider) {
        this.stateManagerProvider = stateManagerProvider;
        return this;
    }

    public ExtensionBuilder extensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
        return this;
    }

    public ExtensionBuilder classloaderIsolationKey(String classloaderIsolationKey) {
        this.classloaderIsolationKey = classloaderIsolationKey;
        return this;
    }

    public ExtensionBuilder systemSslContext(SSLContext systemSslContext) {
        this.systemSslContext = systemSslContext;
        return this;
    }

    public ProcessorNode buildProcessor() {
        LoggableComponent loggableComponent;
        if (this.identifier == null) {
            throw new IllegalStateException("Processor ID must be specified");
        }
        if (this.type == null) {
            throw new IllegalStateException("Processor Type must be specified");
        }
        if (this.bundleCoordinate == null) {
            throw new IllegalStateException("Bundle Coordinate must be specified");
        }
        if (this.extensionManager == null) {
            throw new IllegalStateException("Extension Manager must be specified");
        }
        if (this.serviceProvider == null) {
            throw new IllegalStateException("Controller Service Provider must be specified");
        }
        if (this.nodeTypeProvider == null) {
            throw new IllegalStateException("Node Type Provider must be specified");
        }
        if (this.variableRegistry == null) {
            throw new IllegalStateException("Variable Registry must be specified");
        }
        if (this.reloadComponent == null) {
            throw new IllegalStateException("Reload Component must be specified");
        }
        boolean creationSuccessful = true;
        StandardLoggingContext loggingContext = new StandardLoggingContext(null);
        try {
            loggableComponent = this.createLoggableProcessor((LoggingContext)loggingContext);
        }
        catch (ProcessorInstantiationException pie) {
            logger.error("Could not create Processor of type " + this.type + " for ID " + this.identifier + " due to: " + pie.getMessage() + "; creating \"Ghost\" implementation");
            if (logger.isDebugEnabled()) {
                logger.debug(pie.getMessage(), (Throwable)pie);
            }
            GhostProcessor ghostProc = new GhostProcessor();
            ghostProc.setIdentifier(this.identifier);
            ghostProc.setCanonicalClassName(this.type);
            loggableComponent = new LoggableComponent((ConfigurableComponent)ghostProc, this.bundleCoordinate, null);
            creationSuccessful = false;
        }
        ProcessorNode processorNode = this.createProcessorNode(loggableComponent, creationSuccessful);
        return processorNode;
    }

    public FlowRegistryClientNode buildFlowRegistryClient() {
        LoggableComponent loggableComponent;
        if (this.identifier == null) {
            throw new IllegalStateException("ReportingTask ID must be specified");
        }
        if (this.type == null) {
            throw new IllegalStateException("ReportingTask Type must be specified");
        }
        if (this.bundleCoordinate == null) {
            throw new IllegalStateException("Bundle Coordinate must be specified");
        }
        if (this.serviceProvider == null) {
            throw new IllegalStateException("Controller Service Provider must be specified");
        }
        if (this.extensionManager == null) {
            throw new IllegalStateException("Extension Manager must be specified");
        }
        if (this.nodeTypeProvider == null) {
            throw new IllegalStateException("Node Type Provider must be specified");
        }
        if (this.variableRegistry == null) {
            throw new IllegalStateException("Variable Registry must be specified");
        }
        if (this.reloadComponent == null) {
            throw new IllegalStateException("Reload Component must be specified");
        }
        if (this.flowController == null) {
            throw new IllegalStateException("FlowController must be specified");
        }
        boolean creationSuccessful = true;
        try {
            loggableComponent = this.createLoggableFlowRegistryClient();
        }
        catch (FlowRepositoryClientInstantiationException e) {
            logger.error("Could not create Flow Registry Component of type " + this.type + " for ID " + this.identifier + "; creating \"Ghost\" implementation", (Throwable)e);
            GhostFlowRegistryClient ghostFlowRegistryClient = new GhostFlowRegistryClient(this.identifier, this.type);
            loggableComponent = new LoggableComponent((ConfigurableComponent)ghostFlowRegistryClient, this.bundleCoordinate, null);
            creationSuccessful = false;
        }
        FlowRegistryClientNode clientNode = this.createFlowRegistryClientNode(loggableComponent, creationSuccessful);
        return clientNode;
    }

    public ReportingTaskNode buildReportingTask() {
        LoggableComponent loggableComponent;
        if (this.identifier == null) {
            throw new IllegalStateException("ReportingTask ID must be specified");
        }
        if (this.type == null) {
            throw new IllegalStateException("ReportingTask Type must be specified");
        }
        if (this.bundleCoordinate == null) {
            throw new IllegalStateException("Bundle Coordinate must be specified");
        }
        if (this.extensionManager == null) {
            throw new IllegalStateException("Extension Manager must be specified");
        }
        if (this.serviceProvider == null) {
            throw new IllegalStateException("Controller Service Provider must be specified");
        }
        if (this.nodeTypeProvider == null) {
            throw new IllegalStateException("Node Type Provider must be specified");
        }
        if (this.variableRegistry == null) {
            throw new IllegalStateException("Variable Registry must be specified");
        }
        if (this.reloadComponent == null) {
            throw new IllegalStateException("Reload Component must be specified");
        }
        if (this.flowController == null) {
            throw new IllegalStateException("FlowController must be specified");
        }
        boolean creationSuccessful = true;
        try {
            loggableComponent = this.createLoggableReportingTask();
        }
        catch (ReportingTaskInstantiationException rtie) {
            logger.error("Could not create ReportingTask of type " + this.type + " for ID " + this.identifier + "; creating \"Ghost\" implementation", (Throwable)rtie);
            GhostReportingTask ghostReportingTask = new GhostReportingTask();
            ghostReportingTask.setIdentifier(this.identifier);
            ghostReportingTask.setCanonicalClassName(this.type);
            loggableComponent = new LoggableComponent((ConfigurableComponent)ghostReportingTask, this.bundleCoordinate, null);
            creationSuccessful = false;
        }
        ReportingTaskNode taskNode = this.createReportingTaskNode(loggableComponent, creationSuccessful);
        return taskNode;
    }

    public ParameterProviderNode buildParameterProvider() {
        LoggableComponent loggableComponent;
        if (this.identifier == null) {
            throw new IllegalStateException("ParameterProvider ID must be specified");
        }
        if (this.type == null) {
            throw new IllegalStateException("ParameterProvider Type must be specified");
        }
        if (this.bundleCoordinate == null) {
            throw new IllegalStateException("Bundle Coordinate must be specified");
        }
        if (this.extensionManager == null) {
            throw new IllegalStateException("Extension Manager must be specified");
        }
        if (this.serviceProvider == null) {
            throw new IllegalStateException("Controller Service Provider must be specified");
        }
        if (this.nodeTypeProvider == null) {
            throw new IllegalStateException("Node Type Provider must be specified");
        }
        if (this.variableRegistry == null) {
            throw new IllegalStateException("Variable Registry must be specified");
        }
        if (this.reloadComponent == null) {
            throw new IllegalStateException("Reload Component must be specified");
        }
        if (this.flowController == null) {
            throw new IllegalStateException("FlowController must be specified");
        }
        boolean creationSuccessful = true;
        try {
            loggableComponent = this.createLoggableParameterProvider();
        }
        catch (ParameterProviderInstantiationException rtie) {
            logger.error("Could not create ParameterProvider of type " + this.type + " for ID " + this.identifier + "; creating \"Ghost\" implementation", (Throwable)rtie);
            GhostParameterProvider ghostParameterProvider = new GhostParameterProvider();
            ghostParameterProvider.setIdentifier(this.identifier);
            ghostParameterProvider.setCanonicalClassName(this.type);
            loggableComponent = new LoggableComponent((ConfigurableComponent)ghostParameterProvider, this.bundleCoordinate, null);
            creationSuccessful = false;
        }
        ParameterProviderNode taskNode = this.createParameterProviderNode(loggableComponent, creationSuccessful);
        return taskNode;
    }

    public ControllerServiceNode buildControllerService() {
        if (this.identifier == null) {
            throw new IllegalStateException("ReportingTask ID must be specified");
        }
        if (this.type == null) {
            throw new IllegalStateException("ReportingTask Type must be specified");
        }
        if (this.bundleCoordinate == null) {
            throw new IllegalStateException("Bundle Coordinate must be specified");
        }
        if (this.extensionManager == null) {
            throw new IllegalStateException("Extension Manager must be specified");
        }
        if (this.serviceProvider == null) {
            throw new IllegalStateException("Controller Service Provider must be specified");
        }
        if (this.nodeTypeProvider == null) {
            throw new IllegalStateException("Node Type Provider must be specified");
        }
        if (this.variableRegistry == null) {
            throw new IllegalStateException("Variable Registry must be specified");
        }
        if (this.reloadComponent == null) {
            throw new IllegalStateException("Reload Component must be specified");
        }
        if (this.stateManagerProvider == null) {
            throw new IllegalStateException("State Manager Provider must be specified");
        }
        StandardLoggingContext loggingContext = new StandardLoggingContext(null);
        try {
            return this.createControllerServiceNode(loggingContext);
        }
        catch (Exception e) {
            logger.error("Could not create Controller Service of type " + this.type + " for ID " + this.identifier + " due to: " + e.getMessage() + "; creating \"Ghost\" implementation");
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            return this.createGhostControllerServiceNode();
        }
    }

    private ProcessorNode createProcessorNode(LoggableComponent<Processor> processor, boolean creationSuccessful) {
        StandardProcessorNode procNode;
        StandardComponentVariableRegistry componentVarRegistry = new StandardComponentVariableRegistry(this.variableRegistry);
        StandardValidationContextFactory validationContextFactory = new StandardValidationContextFactory(this.serviceProvider, (VariableRegistry)componentVarRegistry);
        if (creationSuccessful) {
            procNode = new StandardProcessorNode(processor, this.identifier, (ValidationContextFactory)validationContextFactory, this.processScheduler, this.serviceProvider, (ComponentVariableRegistry)componentVarRegistry, this.reloadComponent, this.extensionManager, this.validationTrigger);
        } else {
            String simpleClassName = this.type.contains(".") ? org.apache.commons.lang3.StringUtils.substringAfterLast((String)this.type, (String)".") : this.type;
            String componentType = "(Missing) " + simpleClassName;
            procNode = new StandardProcessorNode(processor, this.identifier, (ValidationContextFactory)validationContextFactory, this.processScheduler, this.serviceProvider, componentType, this.type, (ComponentVariableRegistry)componentVarRegistry, this.reloadComponent, this.extensionManager, this.validationTrigger, true);
        }
        this.applyDefaultSettings((ProcessorNode)procNode);
        this.applyDefaultRunDuration((ProcessorNode)procNode);
        return procNode;
    }

    private ReportingTaskNode createReportingTaskNode(LoggableComponent<ReportingTask> reportingTask, boolean creationSuccessful) {
        StandardReportingTaskNode taskNode;
        StandardComponentVariableRegistry componentVarRegistry = new StandardComponentVariableRegistry(this.variableRegistry);
        StandardValidationContextFactory validationContextFactory = new StandardValidationContextFactory(this.serviceProvider, (VariableRegistry)componentVarRegistry);
        if (creationSuccessful) {
            taskNode = new StandardReportingTaskNode(reportingTask, this.identifier, this.flowController, this.processScheduler, (ValidationContextFactory)validationContextFactory, (ComponentVariableRegistry)componentVarRegistry, this.reloadComponent, this.extensionManager, this.validationTrigger);
            taskNode.setName(taskNode.getReportingTask().getClass().getSimpleName());
        } else {
            String simpleClassName = this.type.contains(".") ? org.apache.commons.lang3.StringUtils.substringAfterLast((String)this.type, (String)".") : this.type;
            String componentType = "(Missing) " + simpleClassName;
            taskNode = new StandardReportingTaskNode(reportingTask, this.identifier, this.flowController, this.processScheduler, (ValidationContextFactory)validationContextFactory, componentType, this.type, (ComponentVariableRegistry)componentVarRegistry, this.reloadComponent, this.extensionManager, this.validationTrigger, true);
            taskNode.setName(componentType);
        }
        return taskNode;
    }

    private ParameterProviderNode createParameterProviderNode(LoggableComponent<ParameterProvider> parameterProvider, boolean creationSuccessful) {
        StandardParameterProviderNode parameterProviderNode;
        StandardComponentVariableRegistry componentVarRegistry = new StandardComponentVariableRegistry(this.variableRegistry);
        StandardValidationContextFactory validationContextFactory = new StandardValidationContextFactory(this.serviceProvider, (VariableRegistry)componentVarRegistry);
        if (creationSuccessful) {
            parameterProviderNode = new StandardParameterProviderNode(parameterProvider, this.identifier, (Authorizable)this.flowController, this.flowController.getControllerServiceProvider(), (ValidationContextFactory)validationContextFactory, (ComponentVariableRegistry)componentVarRegistry, this.reloadComponent, this.extensionManager, this.validationTrigger);
            parameterProviderNode.setName(parameterProviderNode.getParameterProvider().getClass().getSimpleName());
        } else {
            String simpleClassName = this.type.contains(".") ? org.apache.commons.lang3.StringUtils.substringAfterLast((String)this.type, (String)".") : this.type;
            String componentType = "(Missing) " + simpleClassName;
            parameterProviderNode = new StandardParameterProviderNode(parameterProvider, this.identifier, (Authorizable)this.flowController, this.flowController.getControllerServiceProvider(), (ValidationContextFactory)validationContextFactory, componentType, this.type, (ComponentVariableRegistry)componentVarRegistry, this.reloadComponent, this.extensionManager, this.validationTrigger, true);
            parameterProviderNode.setName(componentType);
        }
        return parameterProviderNode;
    }

    private FlowRegistryClientNode createFlowRegistryClientNode(LoggableComponent<FlowRegistryClient> client, boolean creationSuccessful) {
        StandardFlowRegistryClientNode clientNode;
        StandardComponentVariableRegistry componentVarRegistry = new StandardComponentVariableRegistry(this.variableRegistry);
        StandardValidationContextFactory validationContextFactory = new StandardValidationContextFactory(this.serviceProvider, (VariableRegistry)componentVarRegistry);
        if (creationSuccessful) {
            clientNode = new StandardFlowRegistryClientNode((Authorizable)this.flowController, this.flowController.getFlowManager(), client, this.identifier, (ValidationContextFactory)validationContextFactory, this.serviceProvider, this.type, ((FlowRegistryClient)client.getComponent()).getClass().getCanonicalName(), (ComponentVariableRegistry)componentVarRegistry, this.reloadComponent, this.extensionManager, this.validationTrigger, false);
        } else {
            String simpleClassName = this.type.contains(".") ? org.apache.commons.lang3.StringUtils.substringAfterLast((String)this.type, (String)".") : this.type;
            String componentType = "(Missing) " + simpleClassName;
            clientNode = new StandardFlowRegistryClientNode((Authorizable)this.flowController, this.flowController.getFlowManager(), client, this.identifier, (ValidationContextFactory)validationContextFactory, this.serviceProvider, componentType, this.type, (ComponentVariableRegistry)componentVarRegistry, this.reloadComponent, this.extensionManager, this.validationTrigger, true);
        }
        return clientNode;
    }

    private void applyDefaultSettings(ProcessorNode processorNode) {
        try {
            Class<?> procClass = processorNode.getProcessor().getClass();
            DefaultSettings ds = procClass.getAnnotation(DefaultSettings.class);
            if (ds != null) {
                processorNode.setYieldPeriod(ds.yieldDuration());
                processorNode.setPenalizationPeriod(ds.penaltyDuration());
                processorNode.setBulletinLevel(ds.bulletinLevel());
            }
        }
        catch (Exception ex) {
            logger.error("Error while setting default settings from DefaultSettings annotation: {}", (Object)ex.toString(), (Object)ex);
        }
    }

    private void applyDefaultRunDuration(ProcessorNode processorNode) {
        try {
            Class<?> procClass = processorNode.getProcessor().getClass();
            SupportsBatching sb = procClass.getAnnotation(SupportsBatching.class);
            if (sb != null) {
                processorNode.setRunDuration(sb.defaultDuration().getDuration().toMillis(), TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception ex) {
            logger.error("Set Default Run Duration failed", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ControllerServiceNode createControllerServiceNode(StandardLoggingContext loggingContext) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InitializationException {
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Bundle bundle = this.extensionManager.getBundle(this.bundleCoordinate);
            if (bundle == null) {
                throw new IllegalStateException("Unable to find bundle for coordinate " + this.bundleCoordinate.getCoordinate());
            }
            InstanceClassLoader detectedClassLoader = this.extensionManager.createInstanceClassLoader(this.type, this.identifier, bundle, this.classpathUrls == null ? Collections.emptySet() : this.classpathUrls);
            Class<?> rawClass = Class.forName(this.type, true, (ClassLoader)detectedClassLoader);
            Thread.currentThread().setContextClassLoader((ClassLoader)detectedClassLoader);
            Class<ControllerService> controllerServiceClass = rawClass.asSubclass(ControllerService.class);
            ControllerService serviceImpl = controllerServiceClass.newInstance();
            StandardControllerServiceInvocationHandler invocationHandler = new StandardControllerServiceInvocationHandler(this.extensionManager, serviceImpl);
            List interfaceList = ClassUtils.getAllInterfaces(controllerServiceClass);
            Class[] interfaces = interfaceList.toArray(new Class[0]);
            ControllerService proxiedService = detectedClassLoader == null ? (ControllerService)Proxy.newProxyInstance(this.getClass().getClassLoader(), interfaces, (InvocationHandler)invocationHandler) : (ControllerService)Proxy.newProxyInstance((ClassLoader)detectedClassLoader, interfaces, (InvocationHandler)invocationHandler);
            logger.info("Created Controller Service of type {} with identifier {}", (Object)this.type, (Object)this.identifier);
            SimpleProcessLogger serviceLogger = new SimpleProcessLogger(this.identifier, (Object)serviceImpl, (LoggingContext)new StandardLoggingContext(null));
            TerminationAwareLogger terminationAwareLogger = new TerminationAwareLogger((ComponentLog)serviceLogger);
            StateManager stateManager = this.stateManagerProvider.getStateManager(this.identifier);
            StandardControllerServiceInitializationContext initContext = new StandardControllerServiceInitializationContext(this.identifier, (ComponentLog)terminationAwareLogger, this.serviceProvider, stateManager, this.kerberosConfig, this.nodeTypeProvider);
            serviceImpl.initialize((ControllerServiceInitializationContext)initContext);
            ExtensionBuilder.verifyControllerServiceReferences((ConfigurableComponent)serviceImpl, bundle.getClassLoader());
            LoggableComponent originalLoggableComponent = new LoggableComponent((ConfigurableComponent)serviceImpl, this.bundleCoordinate, terminationAwareLogger);
            LoggableComponent proxiedLoggableComponent = new LoggableComponent((ConfigurableComponent)proxiedService, this.bundleCoordinate, terminationAwareLogger);
            StandardComponentVariableRegistry componentVarRegistry = new StandardComponentVariableRegistry(this.variableRegistry);
            StandardValidationContextFactory validationContextFactory = new StandardValidationContextFactory(this.serviceProvider, (VariableRegistry)componentVarRegistry);
            StandardControllerServiceNode serviceNode = new StandardControllerServiceNode(originalLoggableComponent, proxiedLoggableComponent, (ControllerServiceInvocationHandler)invocationHandler, this.identifier, (ValidationContextFactory)validationContextFactory, this.serviceProvider, (ComponentVariableRegistry)componentVarRegistry, this.reloadComponent, this.extensionManager, this.validationTrigger);
            serviceNode.setName(rawClass.getSimpleName());
            loggingContext.setComponent((GroupedComponent)serviceNode);
            invocationHandler.setServiceNode((ControllerServiceNode)serviceNode);
            StandardControllerServiceNode standardControllerServiceNode = serviceNode;
            return standardControllerServiceNode;
        }
        finally {
            if (ctxClassLoader != null) {
                Thread.currentThread().setContextClassLoader(ctxClassLoader);
            }
        }
    }

    private static void verifyControllerServiceReferences(ConfigurableComponent component, ClassLoader bundleClassLoader) throws InstantiationException {
        boolean requiresInstanceClassLoading = component.getClass().isAnnotationPresent(RequiresInstanceClassLoading.class);
        if (!requiresInstanceClassLoading) {
            logger.debug("Instance ClassLoading is not required for {}", (Object)component);
            return;
        }
        logger.debug("Component {} requires Instance Class Loading", (Object)component);
        Class<?> originalExtensionType = component.getClass();
        ClassLoader originalExtensionClassLoader = originalExtensionType.getClassLoader();
        HashSet cobundledApis = new HashSet();
        Class<?>[] classArray = null;
        try (NarCloseable closeable = NarCloseable.withComponentNarLoader((ClassLoader)component.getClass().getClassLoader());){
            List descriptors = component.getPropertyDescriptors();
            if (descriptors != null && !descriptors.isEmpty()) {
                for (PropertyDescriptor descriptor : descriptors) {
                    Class serviceApi = descriptor.getControllerServiceDefinition();
                    if (serviceApi == null || !bundleClassLoader.equals(serviceApi.getClassLoader())) continue;
                    cobundledApis.add(serviceApi);
                }
            }
        }
        catch (Throwable object) {
            classArray = object;
            throw object;
        }
        logger.debug("Component {} is co-bundled with {} Controller Service APIs based on referenced Controller Services: {}", new Object[]{component, cobundledApis.size(), cobundledApis});
        if (component instanceof ControllerService) {
            for (Class<?> extensionType = component.getClass(); extensionType != null; extensionType = extensionType.getSuperclass()) {
                for (Class<?> ifc : extensionType.getInterfaces()) {
                    if (!originalExtensionClassLoader.equals(ifc.getClassLoader())) continue;
                    cobundledApis.add(ifc);
                }
            }
            logger.debug("Component {} is co-bundled with {} Controller Service APIs based on referenced Controller Services and services that are implemented: {}", new Object[]{component, cobundledApis.size(), cobundledApis});
        }
        if (!cobundledApis.isEmpty()) {
            String message = String.format("Controller Service %s is bundled with its supporting APIs %s. The service APIs should not be bundled with the implementations.", originalExtensionType.getName(), StringUtils.join((Collection)cobundledApis.stream().map(Class::getName).collect(Collectors.toSet()), (String)", "));
            throw new InstantiationException(message);
        }
    }

    private ControllerServiceNode createGhostControllerServiceNode() {
        String simpleClassName = this.type.contains(".") ? org.apache.commons.lang3.StringUtils.substringAfterLast((String)this.type, (String)".") : this.type;
        String componentType = "(Missing) " + simpleClassName;
        GhostControllerService ghostService = new GhostControllerService(this.identifier, this.type);
        LoggableComponent proxiedLoggableComponent = new LoggableComponent((ConfigurableComponent)ghostService, this.bundleCoordinate, null);
        StandardControllerServiceInvocationHandler invocationHandler = new StandardControllerServiceInvocationHandler(this.extensionManager, (ControllerService)ghostService);
        StandardComponentVariableRegistry componentVarRegistry = new StandardComponentVariableRegistry(this.variableRegistry);
        StandardValidationContextFactory validationContextFactory = new StandardValidationContextFactory(this.serviceProvider, this.variableRegistry);
        StandardControllerServiceNode serviceNode = new StandardControllerServiceNode(proxiedLoggableComponent, proxiedLoggableComponent, (ControllerServiceInvocationHandler)invocationHandler, this.identifier, (ValidationContextFactory)validationContextFactory, this.serviceProvider, componentType, this.type, (ComponentVariableRegistry)componentVarRegistry, this.reloadComponent, this.extensionManager, this.validationTrigger, true);
        return serviceNode;
    }

    private LoggableComponent<Processor> createLoggableProcessor(LoggingContext loggingContext) throws ProcessorInstantiationException {
        try {
            LoggableComponent<Processor> processorComponent = this.createLoggableComponent(Processor.class, loggingContext);
            Processor processor = (Processor)processorComponent.getComponent();
            StandardProcessorInitializationContext initiContext = new StandardProcessorInitializationContext(this.identifier, (ComponentLog)processorComponent.getLogger(), this.serviceProvider, this.nodeTypeProvider, this.kerberosConfig);
            processor.initialize((ProcessorInitializationContext)initiContext);
            Bundle bundle = this.extensionManager.getBundle(this.bundleCoordinate);
            ExtensionBuilder.verifyControllerServiceReferences((ConfigurableComponent)processor, bundle.getClassLoader());
            return processorComponent;
        }
        catch (Exception e) {
            throw new ProcessorInstantiationException(this.type, (Throwable)e);
        }
    }

    private LoggableComponent<ReportingTask> createLoggableReportingTask() throws ReportingTaskInstantiationException {
        try {
            LoggableComponent<ReportingTask> taskComponent = this.createLoggableComponent(ReportingTask.class, (LoggingContext)new StandardLoggingContext(null));
            String taskName = ((ReportingTask)taskComponent.getComponent()).getClass().getSimpleName();
            StandardReportingInitializationContext config = new StandardReportingInitializationContext(this.identifier, taskName, SchedulingStrategy.TIMER_DRIVEN, "1 min", (ComponentLog)taskComponent.getLogger(), this.serviceProvider, this.kerberosConfig, this.nodeTypeProvider);
            ((ReportingTask)taskComponent.getComponent()).initialize((ReportingInitializationContext)config);
            Bundle bundle = this.extensionManager.getBundle(this.bundleCoordinate);
            ExtensionBuilder.verifyControllerServiceReferences(taskComponent.getComponent(), bundle.getClassLoader());
            return taskComponent;
        }
        catch (Exception e) {
            throw new ReportingTaskInstantiationException(this.type, (Throwable)e);
        }
    }

    private LoggableComponent<FlowRegistryClient> createLoggableFlowRegistryClient() throws FlowRepositoryClientInstantiationException {
        try {
            LoggableComponent<FlowRegistryClient> clientComponent = this.createLoggableComponent(FlowRegistryClient.class, (LoggingContext)new StandardLoggingContext(null));
            StandardFlowRegistryClientInitializationContext context = new StandardFlowRegistryClientInitializationContext(this.identifier, (ComponentLog)clientComponent.getLogger(), this.systemSslContext);
            ((FlowRegistryClient)clientComponent.getComponent()).initialize((FlowRegistryClientInitializationContext)context);
            return clientComponent;
        }
        catch (Exception e) {
            throw new FlowRepositoryClientInstantiationException(this.type, (Throwable)e);
        }
    }

    private LoggableComponent<ParameterProvider> createLoggableParameterProvider() throws ParameterProviderInstantiationException {
        try {
            LoggableComponent<ParameterProvider> providerComponent = this.createLoggableComponent(ParameterProvider.class, (LoggingContext)new StandardLoggingContext(null));
            String taskName = ((ParameterProvider)providerComponent.getComponent()).getClass().getSimpleName();
            StandardParameterProviderInitializationContext config = new StandardParameterProviderInitializationContext(this.identifier, taskName, (ComponentLog)providerComponent.getLogger(), this.kerberosConfig, this.nodeTypeProvider);
            ((ParameterProvider)providerComponent.getComponent()).initialize((ParameterProviderInitializationContext)config);
            Bundle bundle = this.extensionManager.getBundle(this.bundleCoordinate);
            ExtensionBuilder.verifyControllerServiceReferences(providerComponent.getComponent(), bundle.getClassLoader());
            return providerComponent;
        }
        catch (Exception e) {
            throw new ParameterProviderInstantiationException(this.type, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ConfigurableComponent> LoggableComponent<T> createLoggableComponent(Class<T> nodeType, LoggingContext loggingContext) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Bundle bundle = this.extensionManager.getBundle(this.bundleCoordinate);
            if (bundle == null) {
                throw new IllegalStateException("Unable to find bundle for coordinate " + this.bundleCoordinate.getCoordinate());
            }
            InstanceClassLoader detectedClassLoader = this.extensionManager.createInstanceClassLoader(this.type, this.identifier, bundle, this.classpathUrls == null ? Collections.emptySet() : this.classpathUrls, true, this.classloaderIsolationKey);
            Class<?> rawClass = Class.forName(this.type, true, (ClassLoader)detectedClassLoader);
            Thread.currentThread().setContextClassLoader((ClassLoader)detectedClassLoader);
            Object extensionInstance = rawClass.newInstance();
            SimpleProcessLogger componentLog = new SimpleProcessLogger(this.identifier, extensionInstance, loggingContext);
            TerminationAwareLogger terminationAwareLogger = new TerminationAwareLogger((ComponentLog)componentLog);
            ConfigurableComponent cast = (ConfigurableComponent)nodeType.cast(extensionInstance);
            LoggableComponent loggableComponent = new LoggableComponent(cast, this.bundleCoordinate, terminationAwareLogger);
            return loggableComponent;
        }
        finally {
            if (ctxClassLoader != null) {
                Thread.currentThread().setContextClassLoader(ctxClassLoader);
            }
        }
    }
}

