/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history.storage.questdb;

import io.questdb.cairo.TableWriter;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.history.questdb.QuestDbWritingTemplate;

class ComponentCounterWritingTemplate
extends QuestDbWritingTemplate<Pair<Instant, ProcessorStatus>> {
    public ComponentCounterWritingTemplate() {
        super("componentCounter");
    }

    @Override
    protected void addRows(TableWriter tableWriter, Collection<Pair<Instant, ProcessorStatus>> entries) {
        for (Pair<Instant, ProcessorStatus> entry : entries) {
            Map counters = ((ProcessorStatus)entry.getRight()).getCounters();
            if (counters == null || counters.size() <= 0) continue;
            for (Map.Entry counter : counters.entrySet()) {
                long capturedAt = TimeUnit.MILLISECONDS.toMicros(((Instant)entry.getLeft()).toEpochMilli());
                TableWriter.Row counterRow = tableWriter.newRow(capturedAt);
                counterRow.putSym(1, (CharSequence)((ProcessorStatus)entry.getRight()).getId());
                counterRow.putSym(2, (CharSequence)counter.getKey());
                counterRow.putLong(3, ((Long)counter.getValue()).longValue());
                counterRow.append();
            }
        }
    }
}

