/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.claim;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.repository.claim.StandardContentClaim;

public class ContentClaimWriteCache {
    private final ContentRepository contentRepo;
    private final Map<ResourceClaim, OutputStream> streamMap = new HashMap<ResourceClaim, OutputStream>();
    private final Queue<ContentClaim> queue = new LinkedList<ContentClaim>();
    private final int bufferSize;

    public ContentClaimWriteCache(ContentRepository contentRepo) {
        this(contentRepo, 8192);
    }

    public ContentClaimWriteCache(ContentRepository contentRepo, int bufferSize) {
        this.contentRepo = contentRepo;
        this.bufferSize = bufferSize;
    }

    public void reset() throws IOException {
        try {
            this.forEachStream(OutputStream::close);
        }
        finally {
            this.streamMap.clear();
            this.queue.clear();
        }
    }

    public ContentClaim getContentClaim() throws IOException {
        ContentClaim contentClaim = this.queue.poll();
        if (contentClaim != null) {
            this.contentRepo.incrementClaimaintCount(contentClaim);
            return contentClaim;
        }
        ContentClaim claim = this.contentRepo.create(false);
        this.registerStream(claim);
        return claim;
    }

    private OutputStream registerStream(ContentClaim contentClaim) throws IOException {
        OutputStream out = this.contentRepo.write(contentClaim);
        BufferedOutputStream buffered = new BufferedOutputStream(out, this.bufferSize);
        this.streamMap.put(contentClaim.getResourceClaim(), buffered);
        return buffered;
    }

    public OutputStream write(final ContentClaim claim) throws IOException {
        OutputStream out = this.streamMap.get(claim.getResourceClaim());
        if (out == null) {
            out = this.registerStream(claim);
        }
        if (!(claim instanceof StandardContentClaim)) {
            throw new IllegalArgumentException("Cannot write to " + claim + " because that Content Claim does belong to this Claim Cache");
        }
        final StandardContentClaim scc = (StandardContentClaim)claim;
        final long initialLength = Math.max(0L, scc.getLength());
        final OutputStream bcos = out;
        return new OutputStream(){
            private long bytesWritten = 0L;

            @Override
            public void write(int b) throws IOException {
                bcos.write(b);
                ++this.bytesWritten;
                scc.setLength(initialLength + this.bytesWritten);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                bcos.write(b, off, len);
                this.bytesWritten += (long)len;
                scc.setLength(initialLength + this.bytesWritten);
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
                ContentClaimWriteCache.this.queue.offer(claim);
            }
        };
    }

    public void flush(ContentClaim contentClaim) throws IOException {
        if (contentClaim == null) {
            return;
        }
        this.flush(contentClaim.getResourceClaim());
    }

    public void flush(ResourceClaim claim) throws IOException {
        OutputStream out = this.streamMap.get(claim);
        if (out != null) {
            out.flush();
        }
    }

    public void flush() throws IOException {
        this.forEachStream(OutputStream::flush);
    }

    private void forEachStream(StreamProcessor proc) throws IOException {
        IOException exception = null;
        for (OutputStream out : this.streamMap.values()) {
            try {
                proc.process(out);
            }
            catch (IOException ioe) {
                if (exception == null) {
                    exception = ioe;
                    continue;
                }
                ioe.addSuppressed(exception);
                exception = ioe;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private static interface StreamProcessor {
        public void process(OutputStream var1) throws IOException;
    }
}

