/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.controller.status.RemoteProcessGroupStatus;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.StandardMetricDescriptor;
import org.apache.nifi.controller.status.history.StatusSnapshot;
import org.apache.nifi.controller.status.history.ValueMapper;
import org.apache.nifi.controller.status.history.ValueReducer;

public enum RemoteProcessGroupStatusDescriptor {
    SENT_BYTES(new StandardMetricDescriptor<RemoteProcessGroupStatus>("sentBytes", "Bytes Sent (5 mins)", "The cumulative size of all FlowFiles that have been successfully sent to the remote system in the past 5 minutes", MetricDescriptor.Formatter.DATA_SIZE, s -> s.getSentContentSize())),
    SENT_COUNT(new StandardMetricDescriptor<RemoteProcessGroupStatus>("sentCount", "FlowFiles Sent (5 mins)", "The number of FlowFiles that have been successfully sent to the remote system in the past 5 minutes", MetricDescriptor.Formatter.COUNT, s -> s.getSentCount().longValue())),
    RECEIVED_BYTES(new StandardMetricDescriptor<RemoteProcessGroupStatus>("receivedBytes", "Bytes Received (5 mins)", "The cumulative size of all FlowFiles that have been received from the remote system in the past 5 minutes", MetricDescriptor.Formatter.DATA_SIZE, s -> s.getReceivedContentSize())),
    RECEIVED_COUNT(new StandardMetricDescriptor<RemoteProcessGroupStatus>("receivedCount", "FlowFiles Received (5 mins)", "The number of FlowFiles that have been received from the remote system in the past 5 minutes", MetricDescriptor.Formatter.COUNT, s -> s.getReceivedCount().longValue())),
    RECEIVED_BYTES_PER_SECOND(new StandardMetricDescriptor<RemoteProcessGroupStatus>("receivedBytesPerSecond", "Received Bytes Per Second", "The data rate at which data was received from the remote system in the past 5 minutes in terms of Bytes Per Second", MetricDescriptor.Formatter.DATA_SIZE, s -> s.getReceivedContentSize() / 300L)),
    SENT_BYTES_PER_SECOND(new StandardMetricDescriptor<RemoteProcessGroupStatus>("sentBytesPerSecond", "Sent Bytes Per Second", "The data rate at which data was received from the remote system in the past 5 minutes in terms of Bytes Per Second", MetricDescriptor.Formatter.DATA_SIZE, s -> s.getSentContentSize() / 300L)),
    TOTAL_BYTES_PER_SECOND(new StandardMetricDescriptor<RemoteProcessGroupStatus>("totalBytesPerSecond", "Total Bytes Per Second", "The sum of the send and receive data rate from the remote system in the past 5 minutes in terms of Bytes Per Second", MetricDescriptor.Formatter.DATA_SIZE, new ValueMapper<RemoteProcessGroupStatus>(){

        public Long getValue(RemoteProcessGroupStatus status) {
            return (status.getReceivedContentSize() + status.getSentContentSize()) / 300L;
        }
    })),
    AVERAGE_LINEAGE_DURATION(new StandardMetricDescriptor<RemoteProcessGroupStatus>("averageLineageDuration", "Average Lineage Duration (5 mins)", "The average amount of time that a FlowFile took to process from receipt to drop in the past 5 minutes. For Processors that do not terminate FlowFiles, this value will be 0.", MetricDescriptor.Formatter.DURATION, s -> s.getAverageLineageDuration(TimeUnit.MILLISECONDS), new ValueReducer<StatusSnapshot, Long>(){

        public Long reduce(List<StatusSnapshot> values) {
            long millis = 0L;
            int count = 0;
            for (StatusSnapshot snapshot : values) {
                long sent = (Long)snapshot.getStatusMetrics().get(SENT_COUNT.getDescriptor());
                count = (int)((long)count + sent);
                long avgMillis = (Long)snapshot.getStatusMetrics().get(AVERAGE_LINEAGE_DURATION.getDescriptor());
                long totalMillis = avgMillis * sent;
                millis += totalMillis;
            }
            return count == 0 ? 0L : millis / (long)count;
        }
    }));

    private final MetricDescriptor<RemoteProcessGroupStatus> descriptor;

    private RemoteProcessGroupStatusDescriptor(MetricDescriptor<RemoteProcessGroupStatus> descriptor) {
        this.descriptor = descriptor;
    }

    public String getField() {
        return this.descriptor.getField();
    }

    public MetricDescriptor<RemoteProcessGroupStatus> getDescriptor() {
        return this.descriptor;
    }
}

