/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.web.api.dto.BundleDTO;

public final class BundleUtils {
    private static BundleCoordinate findBundleForType(String type, BundleCoordinate desiredCoordinate) {
        List bundles = ExtensionManager.getBundles((String)type);
        if (bundles.isEmpty()) {
            throw new IllegalStateException(String.format("%s is not known to this NiFi instance.", type));
        }
        if (bundles.size() > 1) {
            if (desiredCoordinate == null) {
                throw new IllegalStateException(String.format("Multiple versions of %s exist.", type));
            }
            throw new IllegalStateException(String.format("Multiple versions of %s exist. No exact match for %s.", type, desiredCoordinate));
        }
        return ((Bundle)bundles.get(0)).getBundleDetails().getCoordinate();
    }

    private static BundleCoordinate findCompatibleBundle(String type, BundleDTO bundleDTO, boolean allowCompatibleBundle) {
        BundleCoordinate coordinate = new BundleCoordinate(bundleDTO.getGroup(), bundleDTO.getArtifact(), bundleDTO.getVersion());
        Bundle bundle = ExtensionManager.getBundle((BundleCoordinate)coordinate);
        if (bundle == null) {
            if (allowCompatibleBundle) {
                return BundleUtils.findBundleForType(type, coordinate);
            }
            throw new IllegalStateException(String.format("%s from %s is not known to this NiFi instance.", type, coordinate));
        }
        List bundlesForType = ExtensionManager.getBundles((String)type).stream().map(b -> b.getBundleDetails().getCoordinate()).collect(Collectors.toList());
        if (bundlesForType.contains(coordinate)) {
            return coordinate;
        }
        throw new IllegalStateException(String.format("Found bundle %s but does not support %s", coordinate, type));
    }

    public static BundleCoordinate getBundle(String type, BundleDTO bundleDTO) {
        if (bundleDTO == null) {
            return BundleUtils.findBundleForType(type, null);
        }
        return BundleUtils.findCompatibleBundle(type, bundleDTO, false);
    }

    public static BundleCoordinate getCompatibleBundle(String type, BundleDTO bundleDTO) {
        if (bundleDTO == null) {
            return BundleUtils.findBundleForType(type, null);
        }
        return BundleUtils.findCompatibleBundle(type, bundleDTO, true);
    }
}

