/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.label;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.resource.ResourceType;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.connectable.Size;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.util.CharacterFilterUtils;

public class StandardLabel
implements Label {
    private final String identifier;
    private final AtomicReference<Position> position;
    private final AtomicReference<Size> size;
    private final AtomicReference<Map<String, String>> style;
    private final AtomicReference<String> value;
    private final AtomicReference<ProcessGroup> processGroup;

    public StandardLabel(String identifier, String value) {
        this(identifier, new Position(0.0, 0.0), new HashMap<String, String>(), value, null);
    }

    public StandardLabel(String identifier, Position position, Map<String, String> style, String value, ProcessGroup processGroup) {
        this.identifier = identifier;
        this.position = new AtomicReference<Position>(position);
        this.style = new AtomicReference<Map<String, String>>(Collections.unmodifiableMap(new HashMap<String, String>(style)));
        this.size = new AtomicReference<Size>(new Size(150.0, 150.0));
        this.value = new AtomicReference<String>(CharacterFilterUtils.filterInvalidXmlCharacters((String)value));
        this.processGroup = new AtomicReference<ProcessGroup>(processGroup);
    }

    public Position getPosition() {
        return this.position.get();
    }

    public void setPosition(Position position) {
        if (position != null) {
            this.position.set(position);
        }
    }

    public Size getSize() {
        return this.size.get();
    }

    public void setSize(Size size) {
        if (size != null) {
            this.size.set(size);
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getProcessGroupIdentifier() {
        ProcessGroup procGroup = this.getProcessGroup();
        return procGroup == null ? null : procGroup.getIdentifier();
    }

    public Authorizable getParentAuthorizable() {
        return this.getProcessGroup();
    }

    public Resource getResource() {
        return ResourceFactory.getComponentResource((ResourceType)ResourceType.Label, (String)this.getIdentifier(), (String)"Label");
    }

    public Map<String, String> getStyle() {
        return this.style.get();
    }

    public void setStyle(Map<String, String> style) {
        if (style != null) {
            boolean updated = false;
            while (!updated) {
                Map<String, String> existingStyles = this.style.get();
                HashMap<String, String> updatedStyles = new HashMap<String, String>(existingStyles);
                updatedStyles.putAll(style);
                updated = this.style.compareAndSet(existingStyles, Collections.unmodifiableMap(updatedStyles));
            }
        }
    }

    public String getValue() {
        return this.value.get();
    }

    public void setValue(String value) {
        this.value.set(CharacterFilterUtils.filterInvalidXmlCharacters((String)value));
    }

    public void setProcessGroup(ProcessGroup group) {
        this.processGroup.set(group);
    }

    public ProcessGroup getProcessGroup() {
        return this.processGroup.get();
    }
}

