/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.metrics;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.controller.repository.FlowFileEvent;
import org.apache.nifi.controller.repository.metrics.EventSumValue;

public class EventSum {
    private final AtomicReference<EventSumValue> ref = new AtomicReference();

    public EventSumValue getValue() {
        EventSumValue value = this.ref.get();
        return value == null ? new EventSumValue() : value;
    }

    public void addOrReset(FlowFileEvent event) {
        EventSumValue curValue;
        long expectedMinute = System.currentTimeMillis() / 60000L;
        while ((curValue = this.ref.get()) == null || curValue.getMinuteTimestamp() != expectedMinute) {
            EventSumValue newValue = new EventSumValue();
            boolean replaced = this.ref.compareAndSet(curValue, newValue);
            if (!replaced) continue;
            curValue = newValue;
            break;
        }
        curValue.add(event);
    }
}

