/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.metrics;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.controller.repository.FlowFileEvent;
import org.apache.nifi.controller.repository.metrics.StandardFlowFileEvent;

public class EventSumValue {
    private final AtomicInteger flowFilesIn = new AtomicInteger(0);
    private final AtomicInteger flowFilesOut = new AtomicInteger(0);
    private final AtomicInteger flowFilesRemoved = new AtomicInteger(0);
    private final AtomicInteger flowFilesReceived = new AtomicInteger(0);
    private final AtomicInteger flowFilesSent = new AtomicInteger(0);
    private final AtomicLong contentSizeIn = new AtomicLong(0L);
    private final AtomicLong contentSizeOut = new AtomicLong(0L);
    private final AtomicLong contentSizeRemoved = new AtomicLong(0L);
    private final AtomicLong bytesRead = new AtomicLong(0L);
    private final AtomicLong bytesWritten = new AtomicLong(0L);
    private final AtomicLong bytesReceived = new AtomicLong(0L);
    private final AtomicLong bytesSent = new AtomicLong(0L);
    private final AtomicLong processingNanos = new AtomicLong(0L);
    private final AtomicLong aggregateLineageMillis = new AtomicLong(0L);
    private final AtomicInteger invocations = new AtomicInteger(0);
    private final ConcurrentMap<String, Long> counters = new ConcurrentHashMap<String, Long>();
    private final long minuteTimestamp;
    private final long millisecondTimestamp = System.currentTimeMillis();

    public EventSumValue() {
        this.minuteTimestamp = this.millisecondTimestamp / 60000L;
    }

    public void add(FlowFileEvent flowFileEvent) {
        this.aggregateLineageMillis.addAndGet(flowFileEvent.getAggregateLineageMillis());
        this.bytesRead.addAndGet(flowFileEvent.getBytesRead());
        this.bytesReceived.addAndGet(flowFileEvent.getBytesReceived());
        this.bytesSent.addAndGet(flowFileEvent.getBytesSent());
        this.bytesWritten.addAndGet(flowFileEvent.getBytesWritten());
        this.contentSizeIn.addAndGet(flowFileEvent.getContentSizeIn());
        this.contentSizeOut.addAndGet(flowFileEvent.getContentSizeOut());
        this.contentSizeRemoved.addAndGet(flowFileEvent.getContentSizeRemoved());
        this.flowFilesIn.addAndGet(flowFileEvent.getFlowFilesIn());
        this.flowFilesOut.addAndGet(flowFileEvent.getFlowFilesOut());
        this.flowFilesReceived.addAndGet(flowFileEvent.getFlowFilesReceived());
        this.flowFilesRemoved.addAndGet(flowFileEvent.getFlowFilesRemoved());
        this.flowFilesSent.addAndGet(flowFileEvent.getFlowFilesSent());
        this.invocations.addAndGet(flowFileEvent.getInvocations());
        this.processingNanos.addAndGet(flowFileEvent.getProcessingNanoseconds());
        Map eventCounters = flowFileEvent.getCounters();
        if (eventCounters != null) {
            for (Map.Entry entry : eventCounters.entrySet()) {
                String counterName = (String)entry.getKey();
                Long counterValue = (Long)entry.getValue();
                this.counters.compute(counterName, (key, value) -> value == null ? counterValue : value + counterValue);
            }
        }
    }

    public FlowFileEvent toFlowFileEvent(String componentId) {
        StandardFlowFileEvent event = new StandardFlowFileEvent(componentId);
        event.setAggregateLineageMillis(this.getAggregateLineageMillis());
        event.setBytesRead(this.getBytesRead());
        event.setBytesReceived(this.getBytesReceived());
        event.setBytesSent(this.getBytesSent());
        event.setBytesWritten(this.getBytesWritten());
        event.setContentSizeIn(this.getContentSizeIn());
        event.setContentSizeOut(this.getContentSizeOut());
        event.setContentSizeRemoved(this.getContentSizeRemoved());
        event.setFlowFilesIn(this.getFlowFilesIn());
        event.setFlowFilesOut(this.getFlowFilesOut());
        event.setFlowFilesReceived(this.getFlowFilesReceived());
        event.setFlowFilesRemoved(this.getFlowFilesRemoved());
        event.setFlowFilesSent(this.getFlowFilesSent());
        event.setInvocations(this.getInvocations());
        event.setProcessingNanos(this.getProcessingNanoseconds());
        event.setCounters(Collections.unmodifiableMap(this.counters));
        return event;
    }

    public void add(EventSumValue other) {
        this.aggregateLineageMillis.addAndGet(other.getAggregateLineageMillis());
        this.bytesRead.addAndGet(other.getBytesRead());
        this.bytesReceived.addAndGet(other.getBytesReceived());
        this.bytesSent.addAndGet(other.getBytesSent());
        this.bytesWritten.addAndGet(other.getBytesWritten());
        this.contentSizeIn.addAndGet(other.getContentSizeIn());
        this.contentSizeOut.addAndGet(other.getContentSizeOut());
        this.contentSizeRemoved.addAndGet(other.getContentSizeRemoved());
        this.flowFilesIn.addAndGet(other.getFlowFilesIn());
        this.flowFilesOut.addAndGet(other.getFlowFilesOut());
        this.flowFilesReceived.addAndGet(other.getFlowFilesReceived());
        this.flowFilesRemoved.addAndGet(other.getFlowFilesRemoved());
        this.flowFilesSent.addAndGet(other.getFlowFilesSent());
        this.invocations.addAndGet(other.getInvocations());
        this.processingNanos.addAndGet(other.getProcessingNanoseconds());
        Map<String, Long> eventCounters = other.getCounters();
        if (eventCounters != null) {
            for (Map.Entry<String, Long> entry : eventCounters.entrySet()) {
                String counterName = entry.getKey();
                Long counterValue = entry.getValue();
                this.counters.compute(counterName, (key, value) -> value == null ? counterValue : value + counterValue);
            }
        }
    }

    public long getTimestamp() {
        return this.millisecondTimestamp;
    }

    public long getMinuteTimestamp() {
        return this.minuteTimestamp;
    }

    public long getBytesRead() {
        return this.bytesRead.get();
    }

    public long getBytesWritten() {
        return this.bytesWritten.get();
    }

    public int getFlowFilesIn() {
        return this.flowFilesIn.get();
    }

    public int getFlowFilesOut() {
        return this.flowFilesOut.get();
    }

    public long getContentSizeIn() {
        return this.contentSizeIn.get();
    }

    public long getContentSizeOut() {
        return this.contentSizeOut.get();
    }

    public int getFlowFilesRemoved() {
        return this.flowFilesRemoved.get();
    }

    public long getContentSizeRemoved() {
        return this.contentSizeRemoved.get();
    }

    public long getProcessingNanoseconds() {
        return this.processingNanos.get();
    }

    public int getInvocations() {
        return this.invocations.get();
    }

    public long getAggregateLineageMillis() {
        return this.aggregateLineageMillis.get();
    }

    public int getFlowFilesReceived() {
        return this.flowFilesReceived.get();
    }

    public int getFlowFilesSent() {
        return this.flowFilesSent.get();
    }

    public long getBytesReceived() {
        return this.bytesReceived.get();
    }

    public long getBytesSent() {
        return this.bytesSent.get();
    }

    public Map<String, Long> getCounters() {
        return this.counters;
    }
}

