/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.metrics;

import org.apache.nifi.controller.repository.FlowFileEvent;
import org.apache.nifi.controller.repository.metrics.EventContainer;
import org.apache.nifi.controller.repository.metrics.EventSum;
import org.apache.nifi.controller.repository.metrics.EventSumValue;

public class SecondPrecisionEventContainer
implements EventContainer {
    private final int numBins;
    private final EventSum[] sums;

    public SecondPrecisionEventContainer(int numMinutes) {
        this.numBins = 1 + numMinutes * 60;
        this.sums = new EventSum[this.numBins];
        for (int i = 0; i < this.numBins; ++i) {
            this.sums[i] = new EventSum();
        }
    }

    @Override
    public void addEvent(FlowFileEvent event) {
        int second = (int)(System.currentTimeMillis() / 1000L);
        int binIdx = second % this.numBins;
        EventSum sum = this.sums[binIdx];
        sum.addOrReset(event);
    }

    @Override
    public void purgeEvents(long cutoffEpochMilliseconds) {
    }

    @Override
    public FlowFileEvent generateReport(String componentId, long sinceEpochMillis) {
        EventSumValue eventSumValue = new EventSumValue();
        long second = sinceEpochMillis / 1000L;
        int startBinIdx = (int)(second % (long)this.numBins);
        for (int i = 0; i < this.numBins; ++i) {
            int binIdx = (startBinIdx + i) % this.numBins;
            EventSum sum = this.sums[binIdx];
            EventSumValue sumValue = sum.getValue();
            if (sumValue.getTimestamp() < sinceEpochMillis) continue;
            eventSumValue.add(sumValue);
        }
        FlowFileEvent flowFileEvent = eventSumValue.toFlowFileEvent(componentId);
        return flowFileEvent;
    }
}

