/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.attribute.expression.language.PreparedQuery;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardPropertyValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ConfiguredComponent;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.util.FormatUtils;

public class StandardConfigurationContext
implements ConfigurationContext {
    private final ConfiguredComponent component;
    private final ControllerServiceLookup serviceLookup;
    private final Map<PropertyDescriptor, PreparedQuery> preparedQueries;
    private final VariableRegistry variableRegistry;
    private final String schedulingPeriod;
    private final Long schedulingNanos;

    public StandardConfigurationContext(ConfiguredComponent component, ControllerServiceLookup serviceLookup, String schedulingPeriod, VariableRegistry variableRegistry) {
        this.component = component;
        this.serviceLookup = serviceLookup;
        this.schedulingPeriod = schedulingPeriod;
        this.variableRegistry = variableRegistry;
        this.schedulingNanos = schedulingPeriod == null ? null : (FormatUtils.TIME_DURATION_PATTERN.matcher(schedulingPeriod).matches() ? Long.valueOf(FormatUtils.getTimeDuration((String)schedulingPeriod, (TimeUnit)TimeUnit.NANOSECONDS)) : null);
        this.preparedQueries = new HashMap<PropertyDescriptor, PreparedQuery>();
        for (Map.Entry entry : component.getProperties().entrySet()) {
            PropertyDescriptor desc = (PropertyDescriptor)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null) {
                value = desc.getDefaultValue();
            }
            PreparedQuery pq = Query.prepare((String)value);
            this.preparedQueries.put(desc, pq);
        }
    }

    public PropertyValue getProperty(PropertyDescriptor property) {
        String configuredValue = this.component.getProperty(property);
        return new StandardPropertyValue(configuredValue == null ? property.getDefaultValue() : configuredValue, this.serviceLookup, this.preparedQueries.get(property), this.variableRegistry);
    }

    public Map<PropertyDescriptor, String> getProperties() {
        return this.component.getProperties();
    }

    public Map<String, String> getAllProperties() {
        LinkedHashMap<String, String> propValueMap = new LinkedHashMap<String, String>();
        for (Map.Entry<PropertyDescriptor, String> entry : this.getProperties().entrySet()) {
            propValueMap.put(entry.getKey().getName(), entry.getValue());
        }
        return propValueMap;
    }

    public String getSchedulingPeriod() {
        return this.schedulingPeriod;
    }

    public Long getSchedulingPeriod(TimeUnit timeUnit) {
        return this.schedulingNanos == null ? null : Long.valueOf(timeUnit.convert(this.schedulingNanos, TimeUnit.NANOSECONDS));
    }
}

