/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.variable;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.registry.VariableDescriptor;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.registry.variable.StandardComponentVariableRegistry;

public class MutableVariableRegistry
extends StandardComponentVariableRegistry
implements VariableRegistry {
    private volatile Map<VariableDescriptor, String> variableMap = new HashMap<VariableDescriptor, String>();

    public MutableVariableRegistry(VariableRegistry parent) {
        super(parent);
    }

    @Override
    public Map<VariableDescriptor, String> getVariableMap() {
        return this.variableMap;
    }

    public void setVariables(Map<VariableDescriptor, String> variables) {
        Map<VariableDescriptor, String> curVariableMap = this.variableMap;
        HashMap<VariableDescriptor, String> updatedVariableMap = new HashMap<VariableDescriptor, String>(curVariableMap);
        for (Map.Entry<VariableDescriptor, String> entry : variables.entrySet()) {
            if (entry.getValue() == null) {
                updatedVariableMap.remove(entry.getKey());
                continue;
            }
            updatedVariableMap.put(entry.getKey(), entry.getValue());
        }
        this.variableMap = Collections.unmodifiableMap(updatedVariableMap);
    }
}

