/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.swap;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.SwapContents;
import org.apache.nifi.controller.repository.SwapSummary;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;
import org.apache.nifi.controller.repository.schema.FlowFileRecordFieldMap;
import org.apache.nifi.controller.swap.StandardSwapContents;
import org.apache.nifi.controller.swap.SwapDeserializer;
import org.apache.nifi.controller.swap.SwapSummaryFieldMap;
import org.apache.nifi.repository.schema.ComplexRecordField;
import org.apache.nifi.repository.schema.Record;
import org.apache.nifi.repository.schema.RecordSchema;
import org.apache.nifi.repository.schema.Repetition;
import org.apache.nifi.repository.schema.SchemaRecordReader;

public class SchemaSwapDeserializer
implements SwapDeserializer {
    @Override
    public SwapContents deserializeFlowFiles(DataInputStream in, String swapLocation, FlowFileQueue queue, ResourceClaimManager claimManager) throws IOException {
        RecordSchema schema = RecordSchema.readFrom((InputStream)in);
        SchemaRecordReader reader = SchemaRecordReader.fromSchema((RecordSchema)schema);
        Record parentRecord = reader.readRecord((InputStream)in);
        List flowFileRecords = (List)parentRecord.getFieldValue("FlowFiles");
        ArrayList<FlowFileRecord> flowFiles = new ArrayList<FlowFileRecord>(flowFileRecords.size());
        for (Record record : flowFileRecords) {
            flowFiles.add(FlowFileRecordFieldMap.getFlowFile((Record)record, (ResourceClaimManager)claimManager));
        }
        Record summaryRecord = (Record)parentRecord.getFieldValue("Swap Summary");
        SwapSummary swapSummary = SwapSummaryFieldMap.getSwapSummary(summaryRecord, claimManager);
        return new StandardSwapContents(swapSummary, flowFiles);
    }

    @Override
    public SwapSummary getSwapSummary(DataInputStream in, String swapLocation, ResourceClaimManager claimManager) throws IOException {
        RecordSchema schema = RecordSchema.readFrom((InputStream)in);
        List summaryFields = schema.getField("Swap Summary").getSubFields();
        ComplexRecordField summaryRecordField = new ComplexRecordField("Swap Summary", Repetition.EXACTLY_ONE, summaryFields);
        RecordSchema summarySchema = new RecordSchema(Collections.singletonList(summaryRecordField));
        Record summaryRecordParent = SchemaRecordReader.fromSchema((RecordSchema)summarySchema).readRecord((InputStream)in);
        Record summaryRecord = (Record)summaryRecordParent.getFieldValue("Swap Summary");
        SwapSummary swapSummary = SwapSummaryFieldMap.getSwapSummary(summaryRecord, claimManager);
        return swapSummary;
    }

    public static String getSerializationName() {
        return "Schema Swap Serialization";
    }
}

