/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.reporting;

import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.resource.ResourceType;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.LoggableComponent;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ReloadComponent;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.ValidationContextFactory;
import org.apache.nifi.controller.reporting.AbstractReportingTaskNode;
import org.apache.nifi.controller.reporting.StandardReportingContext;
import org.apache.nifi.registry.ComponentVariableRegistry;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.ReportingTask;

public class StandardReportingTaskNode
extends AbstractReportingTaskNode
implements ReportingTaskNode {
    private final FlowController flowController;

    public StandardReportingTaskNode(LoggableComponent<ReportingTask> reportingTask, String id, FlowController controller, ProcessScheduler processScheduler, ValidationContextFactory validationContextFactory, ComponentVariableRegistry variableRegistry, ReloadComponent reloadComponent) {
        super(reportingTask, id, controller, processScheduler, validationContextFactory, variableRegistry, reloadComponent);
        this.flowController = controller;
    }

    public StandardReportingTaskNode(LoggableComponent<ReportingTask> reportingTask, String id, FlowController controller, ProcessScheduler processScheduler, ValidationContextFactory validationContextFactory, String componentType, String canonicalClassName, ComponentVariableRegistry variableRegistry, ReloadComponent reloadComponent, boolean isExtensionMissing) {
        super(reportingTask, id, controller, processScheduler, validationContextFactory, componentType, canonicalClassName, variableRegistry, reloadComponent, isExtensionMissing);
        this.flowController = controller;
    }

    public Authorizable getParentAuthorizable() {
        return this.flowController;
    }

    public Resource getResource() {
        return ResourceFactory.getComponentResource((ResourceType)ResourceType.ReportingTask, (String)this.getIdentifier(), (String)this.getName());
    }

    public boolean isRestricted() {
        return this.getReportingTask().getClass().isAnnotationPresent(Restricted.class);
    }

    public Class<?> getComponentClass() {
        return this.getReportingContext().getClass();
    }

    public boolean isDeprecated() {
        return this.getReportingTask().getClass().isAnnotationPresent(DeprecationNotice.class);
    }

    public ReportingContext getReportingContext() {
        return new StandardReportingContext(this.flowController, this.flowController.getBulletinRepository(), this.getProperties(), this.flowController, this.getReportingTask(), (VariableRegistry)this.getVariableRegistry());
    }
}

