/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.nifi.controller.service.ControllerServiceState;

public class ServiceStateTransition {
    private ControllerServiceState state = ControllerServiceState.DISABLED;
    private final List<CompletableFuture<?>> enabledFutures = new ArrayList();
    private final List<CompletableFuture<?>> disabledFutures = new ArrayList();

    public synchronized boolean transitionToEnabling(ControllerServiceState expectedState, CompletableFuture<?> enabledFuture) {
        if (expectedState != this.state) {
            return false;
        }
        this.state = ControllerServiceState.ENABLING;
        this.enabledFutures.add(enabledFuture);
        return true;
    }

    public synchronized boolean enable() {
        if (this.state != ControllerServiceState.ENABLING) {
            return false;
        }
        this.state = ControllerServiceState.ENABLED;
        this.enabledFutures.stream().forEach(future -> future.complete(null));
        return true;
    }

    public synchronized boolean transitionToDisabling(ControllerServiceState expectedState, CompletableFuture<?> disabledFuture) {
        if (expectedState != this.state) {
            return false;
        }
        this.state = ControllerServiceState.DISABLING;
        this.disabledFutures.add(disabledFuture);
        return true;
    }

    public synchronized void disable() {
        this.state = ControllerServiceState.DISABLED;
        this.disabledFutures.stream().forEach(future -> future.complete(null));
    }

    public synchronized ControllerServiceState getState() {
        return this.state;
    }
}

