/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.tasks;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.repository.RepositoryContext;
import org.apache.nifi.controller.repository.StandardProcessSession;
import org.apache.nifi.controller.repository.StandardProcessSessionFactory;
import org.apache.nifi.controller.scheduling.RepositoryContextFactory;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpireFlowFiles
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ExpireFlowFiles.class);
    private final FlowController flowController;
    private final RepositoryContextFactory contextFactory;

    public ExpireFlowFiles(FlowController flowController, RepositoryContextFactory contextFactory) {
        this.flowController = flowController;
        this.contextFactory = contextFactory;
    }

    @Override
    public void run() {
        ProcessGroup rootGroup = this.flowController.getGroup(this.flowController.getRootGroupId());
        try {
            this.expireFlowFiles(rootGroup);
        }
        catch (Exception e) {
            logger.error("Failed to expire FlowFiles due to {}", (Object)e.toString(), (Object)e);
        }
    }

    private StandardProcessSession createSession(Connectable connectable) {
        RepositoryContext context = this.contextFactory.newProcessContext(connectable, new AtomicLong(0L));
        StandardProcessSessionFactory sessionFactory = new StandardProcessSessionFactory(context, () -> false);
        return sessionFactory.createSession();
    }

    private void expireFlowFiles(Connectable connectable) {
        boolean expirationConfigured = false;
        for (Connection incomingConn : connectable.getIncomingConnections()) {
            if (FormatUtils.getTimeDuration((String)incomingConn.getFlowFileQueue().getFlowFileExpiration(), (TimeUnit)TimeUnit.MILLISECONDS) <= 0L) continue;
            expirationConfigured = true;
            break;
        }
        if (!expirationConfigured) {
            return;
        }
        StandardProcessSession session = this.createSession(connectable);
        session.expireFlowFiles();
        session.commit();
    }

    private void expireFlowFiles(ProcessGroup group) {
        for (ProcessorNode procNode : group.getProcessors()) {
            this.expireFlowFiles((Connectable)procNode);
        }
        for (Port port : group.getInputPorts()) {
            this.expireFlowFiles((Connectable)port);
        }
        for (Port port : group.getOutputPorts()) {
            this.expireFlowFiles((Connectable)port);
        }
        for (Funnel funnel : group.getFunnels()) {
            this.expireFlowFiles((Connectable)funnel);
        }
        for (RemoteProcessGroup rpg : group.getRemoteProcessGroups()) {
            for (Port port : rpg.getInputPorts()) {
                this.expireFlowFiles((Connectable)port);
            }
            for (Port port : rpg.getOutputPorts()) {
                this.expireFlowFiles((Connectable)port);
            }
        }
        for (ProcessGroup child : group.getProcessGroups()) {
            this.expireFlowFiles(child);
        }
    }
}

