/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.controller.ConfiguredComponent;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.SchedulingContext;

public class StandardSchedulingContext
implements SchedulingContext {
    private final ProcessContext processContext;
    private final ControllerServiceProvider serviceProvider;
    private final ProcessorNode processorNode;
    private final StateManager stateManager;

    public StandardSchedulingContext(ProcessContext processContext, ControllerServiceProvider serviceProvider, ProcessorNode processorNode, StateManager stateManager) {
        this.processContext = processContext;
        this.serviceProvider = serviceProvider;
        this.processorNode = processorNode;
        this.stateManager = stateManager;
    }

    public void leaseControllerService(String identifier) {
        ControllerServiceNode serviceNode = this.serviceProvider.getControllerServiceNode(identifier);
        if (serviceNode == null) {
            throw new IllegalArgumentException("Cannot lease Controller Service because no Controller Service exists with identifier " + identifier);
        }
        if (serviceNode.getState() != ControllerServiceState.ENABLED) {
            throw new IllegalStateException("Cannot lease Controller Service because Controller Service " + serviceNode.getProxiedControllerService().getIdentifier() + " is not currently enabled");
        }
        if (!serviceNode.isValid()) {
            throw new IllegalStateException("Cannot lease Controller Service because Controller Service " + serviceNode.getProxiedControllerService().getIdentifier() + " is not currently valid");
        }
        serviceNode.addReference((ConfiguredComponent)this.processorNode);
    }

    public PropertyValue getProperty(PropertyDescriptor descriptor) {
        return this.processContext.getProperty(descriptor);
    }

    public PropertyValue getProperty(String propertyName) {
        return this.processContext.getProperty(propertyName);
    }

    public PropertyValue newPropertyValue(String rawValue) {
        return this.processContext.newPropertyValue(rawValue);
    }

    public void yield() {
        this.processContext.yield();
    }

    public int getMaxConcurrentTasks() {
        return this.processContext.getMaxConcurrentTasks();
    }

    public String getAnnotationData() {
        return this.processContext.getAnnotationData();
    }

    public Map<PropertyDescriptor, String> getProperties() {
        return this.processContext.getProperties();
    }

    public Map<String, String> getAllProperties() {
        LinkedHashMap<String, String> propValueMap = new LinkedHashMap<String, String>();
        for (Map.Entry<PropertyDescriptor, String> entry : this.getProperties().entrySet()) {
            propValueMap.put(entry.getKey().getName(), entry.getValue());
        }
        return propValueMap;
    }

    public String encrypt(String unencrypted) {
        return this.processContext.encrypt(unencrypted);
    }

    public String decrypt(String encrypted) {
        return this.processContext.decrypt(encrypted);
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return this.processContext.getControllerServiceLookup();
    }

    public Set<Relationship> getAvailableRelationships() {
        return this.processContext.getAvailableRelationships();
    }

    public boolean hasIncomingConnection() {
        return this.processContext.hasIncomingConnection();
    }

    public boolean hasNonLoopConnection() {
        return this.processContext.hasNonLoopConnection();
    }

    public boolean hasConnection(Relationship relationship) {
        return this.processContext.hasConnection(relationship);
    }

    public boolean isExpressionLanguagePresent(PropertyDescriptor property) {
        if (property == null || !property.isExpressionLanguageSupported()) {
            return false;
        }
        List elRanges = Query.extractExpressionRanges((String)this.getProperty(property).getValue());
        return elRanges != null && !elRanges.isEmpty();
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    public String getName() {
        return this.processorNode.getName();
    }
}

