/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.function.Predicate;
import org.apache.nifi.registry.flow.ComponentType;
import org.apache.nifi.registry.flow.VersionedComponent;
import org.apache.nifi.registry.flow.diff.DifferenceType;
import org.apache.nifi.registry.flow.diff.FlowDifference;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedComponent;

public class FlowDifferenceFilters {
    public static Predicate<FlowDifference> FILTER_ADDED_REMOVED_REMOTE_PORTS = fd -> !FlowDifferenceFilters.isAddedOrRemovedRemotePort(fd);

    public static boolean isAddedOrRemovedRemotePort(FlowDifference fd) {
        if (fd.getDifferenceType() == DifferenceType.COMPONENT_ADDED || fd.getDifferenceType() == DifferenceType.COMPONENT_REMOVED) {
            VersionedComponent component = fd.getComponentA();
            if (component == null || fd.getComponentB() instanceof InstantiatedVersionedComponent) {
                component = fd.getComponentB();
            }
            if (component.getComponentType() == ComponentType.REMOTE_INPUT_PORT || component.getComponentType() == ComponentType.REMOTE_OUTPUT_PORT) {
                return true;
            }
        }
        return false;
    }
}

