/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.nifi.logging.ComponentLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;

public class ReflectionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectionUtils.class);

    public static void invokeMethodsWithAnnotation(Class<? extends Annotation> annotation, Object instance, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ReflectionUtils.invokeMethodsWithAnnotations(annotation, null, instance, args);
    }

    public static void invokeMethodsWithAnnotations(Class<? extends Annotation> preferredAnnotation, Class<? extends Annotation> alternateAnnotation, Object instance, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class[] classArray;
        if (alternateAnnotation != null) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = preferredAnnotation;
            classArray = classArray2;
            classArray2[1] = alternateAnnotation;
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = preferredAnnotation;
        }
        Class[] annotationArray = classArray;
        ReflectionUtils.invokeMethodsWithAnnotations(false, null, instance, annotationArray, args);
    }

    public static boolean quietlyInvokeMethodsWithAnnotation(Class<? extends Annotation> annotation, Object instance, Object ... args) {
        return ReflectionUtils.quietlyInvokeMethodsWithAnnotations(annotation, null, instance, null, args);
    }

    public static boolean quietlyInvokeMethodsWithAnnotation(Class<? extends Annotation> annotation, Object instance, ComponentLog logger, Object ... args) {
        return ReflectionUtils.quietlyInvokeMethodsWithAnnotations(annotation, null, instance, logger, args);
    }

    public static boolean quietlyInvokeMethodsWithAnnotations(Class<? extends Annotation> preferredAnnotation, Class<? extends Annotation> alternateAnnotation, Object instance, Object ... args) {
        return ReflectionUtils.quietlyInvokeMethodsWithAnnotations(preferredAnnotation, alternateAnnotation, instance, null, args);
    }

    private static boolean invokeMethodsWithAnnotations(boolean quietly, ComponentLog logger, Object instance, Class<? extends Annotation>[] annotations, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return ReflectionUtils.invokeMethodsWithAnnotations(quietly, logger, instance, instance.getClass(), annotations, args);
    }

    private static boolean invokeMethodsWithAnnotations(boolean quietly, ComponentLog logger, Object instance, Class<?> clazz, Class<? extends Annotation>[] annotations, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        boolean isSuccess = true;
        for (Method method : clazz.getMethods()) {
            Object[] modifiedArgs;
            if (!ReflectionUtils.isAnyAnnotationPresent(method, annotations) || (modifiedArgs = ReflectionUtils.buildUpdatedArgumentsList(quietly, method, annotations, logger, args)) == null) continue;
            try {
                method.invoke(instance, modifiedArgs);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                isSuccess = false;
                if (quietly) {
                    ReflectionUtils.logErrorMessage("Failed while invoking annotated method '" + method + "' with arguments '" + Arrays.asList(modifiedArgs) + "'.", logger, e);
                    continue;
                }
                throw e;
            }
        }
        return isSuccess;
    }

    private static boolean isAnyAnnotationPresent(Method method, Class<? extends Annotation>[] annotations) {
        for (Class<? extends Annotation> annotation : annotations) {
            if (AnnotationUtils.findAnnotation((Method)method, annotation) == null) continue;
            return true;
        }
        return false;
    }

    private static Object[] buildUpdatedArgumentsList(boolean quietly, Method method, Class<?>[] annotations, ComponentLog processLogger, Object ... args) {
        boolean parametersCompatible = true;
        int argsCount = 0;
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int i = 0; parametersCompatible && i < paramTypes.length && i < args.length; ++i) {
            if (paramTypes[i].isAssignableFrom(args[i].getClass())) {
                ++argsCount;
                continue;
            }
            ReflectionUtils.logErrorMessage("Can not invoke method '" + method + "' with provided arguments since argument " + i + " of type '" + paramTypes[i] + "' is not assignable from provided value of type '" + args[i].getClass() + "'.", processLogger, null);
            if (quietly) {
                parametersCompatible = false;
                continue;
            }
            ++argsCount;
        }
        Object[] updatedArguments = null;
        if (parametersCompatible) {
            updatedArguments = Arrays.copyOf(args, argsCount);
        }
        return updatedArguments;
    }

    private static void logErrorMessage(String message, ComponentLog processLogger, Exception e) {
        if (processLogger != null) {
            if (e != null) {
                processLogger.error(message, (Throwable)e);
            } else {
                processLogger.error(message);
            }
        } else if (e != null) {
            LOG.error(message, (Throwable)e);
        } else {
            LOG.error(message);
        }
    }

    public static boolean quietlyInvokeMethodsWithAnnotations(Class<? extends Annotation> preferredAnnotation, Class<? extends Annotation> alternateAnnotation, Object instance, ComponentLog logger, Object ... args) {
        Class[] classArray;
        if (alternateAnnotation != null) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = preferredAnnotation;
            classArray = classArray2;
            classArray2[1] = alternateAnnotation;
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = preferredAnnotation;
        }
        Class[] annotationArray = classArray;
        try {
            return ReflectionUtils.invokeMethodsWithAnnotations(true, logger, instance, annotationArray, args);
        }
        catch (Exception e) {
            LOG.error("Failed while attempting to invoke methods with '" + Arrays.asList(annotationArray) + "' annotations", (Throwable)e);
            return false;
        }
    }
}

