/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.nifi.controller.repository.ContentNotFoundException;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.exception.FlowFileAccessException;

public class FlowFileAccessInputStream
extends FilterInputStream {
    private final FlowFile flowFile;
    private final ContentClaim claim;
    private long bytesConsumed;
    private ContentNotFoundException thrown;

    public FlowFileAccessInputStream(InputStream in, FlowFile flowFile, ContentClaim claim) {
        super(in);
        this.flowFile = flowFile;
        this.claim = claim;
    }

    private void ensureAllContentRead() throws ContentNotFoundException {
        if (this.bytesConsumed < this.flowFile.getSize()) {
            this.thrown = new ContentNotFoundException(this.claim, "Stream contained only " + this.bytesConsumed + " bytes but should have contained " + this.flowFile.getSize());
            throw this.thrown;
        }
    }

    public ContentNotFoundException getContentNotFoundException() {
        return this.thrown;
    }

    @Override
    public int read() throws IOException {
        try {
            int byteRead = super.read();
            if (byteRead < 0) {
                this.ensureAllContentRead();
            } else {
                ++this.bytesConsumed;
            }
            return byteRead;
        }
        catch (ContentNotFoundException cnfe) {
            throw cnfe;
        }
        catch (IOException ioe) {
            throw new FlowFileAccessException("Could not read from " + this.flowFile, (Throwable)ioe);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int count = super.read(b, off, len);
            if (count < 0) {
                this.ensureAllContentRead();
            } else {
                this.bytesConsumed += (long)count;
            }
            return count;
        }
        catch (ContentNotFoundException cnfe) {
            throw cnfe;
        }
        catch (IOException ioe) {
            throw new FlowFileAccessException("Could not read from " + this.flowFile, (Throwable)ioe);
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        try {
            int count = super.read(b);
            if (count < 0) {
                this.ensureAllContentRead();
            } else {
                this.bytesConsumed += (long)count;
            }
            return count;
        }
        catch (ContentNotFoundException cnfe) {
            throw cnfe;
        }
        catch (IOException ioe) {
            throw new FlowFileAccessException("Could not read from " + this.flowFile, (Throwable)ioe);
        }
    }

    @Override
    public int available() throws IOException {
        try {
            return super.available();
        }
        catch (IOException ioe) {
            throw new FlowFileAccessException("Could not determine amount of data available from " + this.flowFile, (Throwable)ioe);
        }
    }

    @Override
    public boolean markSupported() {
        return super.markSupported();
    }

    @Override
    public long skip(long n) throws IOException {
        try {
            long count = super.skip(n);
            this.bytesConsumed += count;
            return count;
        }
        catch (IOException ioe) {
            throw new FlowFileAccessException("Could not skip data in " + this.flowFile, (Throwable)ioe);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void reset() throws IOException {
        try {
            super.reset();
        }
        catch (IOException ioe) {
            throw new FlowFileAccessException("Could not reset stream from " + this.flowFile, (Throwable)ioe);
        }
    }

    @Override
    public void mark(int n) {
        super.mark(n);
    }
}

