/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.metrics;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.nifi.controller.repository.FlowFileEvent;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.repository.StandardRepositoryStatusReport;
import org.apache.nifi.controller.repository.metrics.EventContainer;
import org.apache.nifi.controller.repository.metrics.SecondPrecisionEventContainer;

public class RingBufferEventRepository
implements FlowFileEventRepository {
    private final int numMinutes;
    private final ConcurrentMap<String, EventContainer> componentEventMap = new ConcurrentHashMap<String, EventContainer>();

    public RingBufferEventRepository(int numMinutes) {
        this.numMinutes = numMinutes;
    }

    public void close() throws IOException {
    }

    public void updateRepository(FlowFileEvent event) {
        String componentId = event.getComponentIdentifier();
        EventContainer eventContainer = this.componentEventMap.computeIfAbsent(componentId, id -> new SecondPrecisionEventContainer(this.numMinutes));
        eventContainer.addEvent(event);
    }

    public StandardRepositoryStatusReport reportTransferEvents(long sinceEpochMillis) {
        StandardRepositoryStatusReport report = new StandardRepositoryStatusReport();
        this.componentEventMap.entrySet().stream().map(entry -> ((EventContainer)entry.getValue()).generateReport((String)entry.getKey(), sinceEpochMillis)).forEach(event -> report.addReportEntry((FlowFileEvent)event));
        return report;
    }

    public void purgeTransferEvents(long cutoffEpochMilliseconds) {
        for (EventContainer container : this.componentEventMap.values()) {
            container.purgeEvents(cutoffEpochMilliseconds);
        }
    }

    public void purgeTransferEvents(String componentIdentifier) {
        this.componentEventMap.remove(componentIdentifier);
    }
}

