/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.service.ControllerServiceDisabledException;
import org.apache.nifi.controller.service.ControllerServiceInvocationHandler;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.nar.NarCloseable;

public class StandardControllerServiceInvocationHandler
implements ControllerServiceInvocationHandler {
    private static final Set<Method> validDisabledMethods;
    private final ControllerService originalService;
    private final AtomicReference<ControllerServiceNode> serviceNodeHolder = new AtomicReference<Object>(null);

    public StandardControllerServiceInvocationHandler(ControllerService originalService) {
        this(originalService, null);
    }

    public StandardControllerServiceInvocationHandler(ControllerService originalService, ControllerServiceNode serviceNode) {
        this.originalService = originalService;
        this.serviceNodeHolder.set(serviceNode);
    }

    public void setServiceNode(ControllerServiceNode serviceNode) {
        this.serviceNodeHolder.set(serviceNode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        boolean disabled;
        String methodName = method.getName();
        if ("initialize".equals(methodName)) throw new UnsupportedOperationException(method + " may only be invoked by the NiFi framework");
        if ("onPropertyModified".equals(methodName)) {
            throw new UnsupportedOperationException(method + " may only be invoked by the NiFi framework");
        }
        ControllerServiceNode node = this.serviceNodeHolder.get();
        ControllerServiceState state = node.getState();
        boolean bl = disabled = state != ControllerServiceState.ENABLED;
        if (disabled && !validDisabledMethods.contains(method)) {
            throw new ControllerServiceDisabledException(node.getIdentifier(), "Cannot invoke method " + method + " on Controller Service with identifier " + this.serviceNodeHolder.get().getIdentifier() + " because the Controller Service's State is currently " + state);
        }
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader(this.originalService.getClass(), (String)this.originalService.getIdentifier());){
            Object object = method.invoke((Object)this.originalService, args);
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    static {
        HashSet<Method> validMethods = new HashSet<Method>();
        for (Method method : ControllerService.class.getMethods()) {
            validMethods.add(method);
        }
        for (Method method : Object.class.getMethods()) {
            validMethods.add(method);
        }
        validDisabledMethods = Collections.unmodifiableSet(validMethods);
    }
}

