/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.resource.ResourceType;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.validation.ValidationState;
import org.apache.nifi.components.validation.ValidationTrigger;
import org.apache.nifi.controller.AbstractComponentNode;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.LoggableComponent;
import org.apache.nifi.controller.ReloadComponent;
import org.apache.nifi.controller.TerminationAwareLogger;
import org.apache.nifi.controller.ValidationContextFactory;
import org.apache.nifi.controller.exception.ControllerServiceInstantiationException;
import org.apache.nifi.controller.service.ControllerServiceDetails;
import org.apache.nifi.controller.service.ControllerServiceInvocationHandler;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.ControllerServiceReference;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.controller.service.ServiceStateTransition;
import org.apache.nifi.controller.service.StandardConfigurationContext;
import org.apache.nifi.controller.service.StandardControllerServiceReference;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.registry.ComponentVariableRegistry;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.util.CharacterFilterUtils;
import org.apache.nifi.util.ReflectionUtils;
import org.apache.nifi.util.file.classloader.ClassLoaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardControllerServiceNode
extends AbstractComponentNode
implements ControllerServiceNode {
    private static final Logger LOG = LoggerFactory.getLogger(StandardControllerServiceNode.class);
    private final AtomicReference<ControllerServiceDetails> controllerServiceHolder = new AtomicReference<Object>(null);
    private final ControllerServiceProvider serviceProvider;
    private final ServiceStateTransition stateTransition;
    private final AtomicReference<String> versionedComponentId = new AtomicReference();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private final Set<ComponentNode> referencingComponents = new HashSet<ComponentNode>();
    private String comment;
    private ProcessGroup processGroup;
    private final AtomicBoolean active;

    public StandardControllerServiceNode(LoggableComponent<ControllerService> implementation, LoggableComponent<ControllerService> proxiedControllerService, ControllerServiceInvocationHandler invocationHandler, String id, ValidationContextFactory validationContextFactory, ControllerServiceProvider serviceProvider, ComponentVariableRegistry variableRegistry, ReloadComponent reloadComponent, ValidationTrigger validationTrigger) {
        this(implementation, proxiedControllerService, invocationHandler, id, validationContextFactory, serviceProvider, ((ControllerService)implementation.getComponent()).getClass().getSimpleName(), ((ControllerService)implementation.getComponent()).getClass().getCanonicalName(), variableRegistry, reloadComponent, validationTrigger, false);
    }

    public StandardControllerServiceNode(LoggableComponent<ControllerService> implementation, LoggableComponent<ControllerService> proxiedControllerService, ControllerServiceInvocationHandler invocationHandler, String id, ValidationContextFactory validationContextFactory, ControllerServiceProvider serviceProvider, String componentType, String componentCanonicalClass, ComponentVariableRegistry variableRegistry, ReloadComponent reloadComponent, ValidationTrigger validationTrigger, boolean isExtensionMissing) {
        super(id, validationContextFactory, serviceProvider, componentType, componentCanonicalClass, variableRegistry, reloadComponent, validationTrigger, isExtensionMissing);
        this.serviceProvider = serviceProvider;
        this.active = new AtomicBoolean();
        this.setControllerServiceAndProxy(implementation, proxiedControllerService, invocationHandler);
        this.stateTransition = new ServiceStateTransition(this);
    }

    public ConfigurableComponent getComponent() {
        return this.controllerServiceHolder.get().getImplementation();
    }

    public TerminationAwareLogger getLogger() {
        return this.controllerServiceHolder.get().getComponentLog();
    }

    public BundleCoordinate getBundleCoordinate() {
        return this.controllerServiceHolder.get().getBundleCoordinate();
    }

    public Authorizable getParentAuthorizable() {
        ProcessGroup processGroup = this.getProcessGroup();
        if (processGroup == null) {
            return new Authorizable(){

                public Authorizable getParentAuthorizable() {
                    return null;
                }

                public Resource getResource() {
                    return ResourceFactory.getControllerResource();
                }
            };
        }
        return processGroup;
    }

    public Resource getResource() {
        return ResourceFactory.getComponentResource((ResourceType)ResourceType.ControllerService, (String)this.getIdentifier(), (String)this.getName());
    }

    public boolean isRestricted() {
        return this.getControllerServiceImplementation().getClass().isAnnotationPresent(Restricted.class);
    }

    public Class<?> getComponentClass() {
        return this.getControllerServiceImplementation().getClass();
    }

    public boolean isDeprecated() {
        return this.getControllerServiceImplementation().getClass().isAnnotationPresent(DeprecationNotice.class);
    }

    public ControllerService getControllerServiceImplementation() {
        return this.controllerServiceHolder.get().getImplementation();
    }

    public ControllerService getProxiedControllerService() {
        return this.controllerServiceHolder.get().getProxiedControllerService();
    }

    public ControllerServiceInvocationHandler getInvocationHandler() {
        return this.controllerServiceHolder.get().getInvocationHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setControllerServiceAndProxy(LoggableComponent<ControllerService> implementation, LoggableComponent<ControllerService> proxiedControllerService, ControllerServiceInvocationHandler invocationHandler) {
        AtomicBoolean atomicBoolean = this.active;
        synchronized (atomicBoolean) {
            if (this.isActive()) {
                throw new IllegalStateException("Cannot modify Controller Service configuration while service is active");
            }
            ControllerServiceDetails controllerServiceDetails = new ControllerServiceDetails(implementation, proxiedControllerService, invocationHandler);
            this.controllerServiceHolder.set(controllerServiceDetails);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(Set<URL> additionalUrls) throws ControllerServiceInstantiationException {
        AtomicBoolean atomicBoolean = this.active;
        synchronized (atomicBoolean) {
            if (this.isActive()) {
                throw new IllegalStateException("Cannot reload Controller Service while service is active");
            }
            String additionalResourcesFingerprint = ClassLoaderUtils.generateAdditionalUrlsFingerprint(additionalUrls);
            this.setAdditionalResourcesFingerprint(additionalResourcesFingerprint);
            this.getReloadComponent().reload((ControllerServiceNode)this, this.getCanonicalClassName(), this.getBundleCoordinate(), additionalUrls);
        }
    }

    public ProcessGroup getProcessGroup() {
        this.readLock.lock();
        try {
            ProcessGroup processGroup = this.processGroup;
            return processGroup;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setProcessGroup(ProcessGroup group) {
        this.writeLock.lock();
        try {
            this.processGroup = group;
            LOG.debug("Resetting Validation State of {} due to setting process group", (Object)this);
            this.resetValidationState();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ControllerServiceReference getReferences() {
        this.readLock.lock();
        try {
            StandardControllerServiceReference standardControllerServiceReference = new StandardControllerServiceReference(this, this.referencingComponents);
            return standardControllerServiceReference;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void addReference(ComponentNode referencingComponent) {
        this.writeLock.lock();
        try {
            this.referencingComponents.add(referencingComponent);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public List<ControllerServiceNode> getRequiredControllerServices() {
        HashSet<ControllerServiceNode> requiredServices = new HashSet<ControllerServiceNode>();
        for (Map.Entry entry : this.getProperties().entrySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            if (descriptor.getControllerServiceDefinition() == null || entry.getValue() == null) continue;
            ControllerServiceNode requiredNode = this.serviceProvider.getControllerServiceNode((String)entry.getValue());
            requiredServices.add(requiredNode);
        }
        return new ArrayList<ControllerServiceNode>(requiredServices);
    }

    public void removeReference(ComponentNode referencingComponent) {
        this.writeLock.lock();
        try {
            this.referencingComponents.remove(referencingComponent);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void verifyModifiable() throws IllegalStateException {
        if (this.getState() != ControllerServiceState.DISABLED) {
            throw new IllegalStateException("Cannot modify Controller Service configuration because it is currently enabled. Please disable the Controller Service first.");
        }
    }

    public void verifyCanDelete() {
        if (this.getState() != ControllerServiceState.DISABLED) {
            throw new IllegalStateException("Controller Service " + this.getControllerServiceImplementation().getIdentifier() + " cannot be deleted because it is not disabled");
        }
    }

    public void verifyCanDisable() {
        this.verifyCanDisable(Collections.emptySet());
    }

    public void verifyCanDisable(Set<ControllerServiceNode> ignoreReferences) {
        if (!this.isActive()) {
            throw new IllegalStateException("Cannot disable " + this.getControllerServiceImplementation().getIdentifier() + " because it is not enabled");
        }
        ControllerServiceReference references = this.getReferences();
        HashSet<String> activeReferencesIdentifiers = new HashSet<String>();
        for (ComponentNode activeReference : references.getActiveReferences()) {
            if (ignoreReferences.contains(activeReference)) continue;
            activeReferencesIdentifiers.add(activeReference.getIdentifier());
        }
        if (!activeReferencesIdentifiers.isEmpty()) {
            throw new IllegalStateException(this.getControllerServiceImplementation().getIdentifier() + " cannot be disabled because it is referenced by " + activeReferencesIdentifiers.size() + " components that are currently running: [" + StringUtils.join(activeReferencesIdentifiers, (String)", ") + "]");
        }
    }

    public void verifyCanEnable() {
        if (this.getState() != ControllerServiceState.DISABLED) {
            throw new IllegalStateException(this.getControllerServiceImplementation().getIdentifier() + " cannot be enabled because it is not disabled");
        }
        ValidationState validationState = this.getValidationState();
        switch (validationState.getStatus()) {
            case INVALID: {
                throw new IllegalStateException(this.getControllerServiceImplementation().getIdentifier() + " cannot be enabled because it is not valid: " + validationState.getValidationErrors());
            }
            case VALIDATING: {
                throw new IllegalStateException(this.getControllerServiceImplementation().getIdentifier() + " cannot be enabled because its validation has not yet completed");
            }
        }
    }

    public void verifyCanEnable(Set<ControllerServiceNode> ignoredReferences) {
        if (this.getState() != ControllerServiceState.DISABLED) {
            throw new IllegalStateException(this.getControllerServiceImplementation().getIdentifier() + " cannot be enabled because it is not disabled");
        }
        Collection validationErrors = this.getValidationErrors(ignoredReferences);
        if (ignoredReferences != null && !validationErrors.isEmpty()) {
            throw new IllegalStateException("Controller Service with ID " + this.getIdentifier() + " cannot be enabled because it is not currently valid");
        }
    }

    public void verifyCanUpdate() {
        if (this.getState() != ControllerServiceState.DISABLED) {
            throw new IllegalStateException(this.getControllerServiceImplementation().getIdentifier() + " cannot be updated because it is not disabled");
        }
    }

    public void verifyCanClearState() {
        this.verifyCanUpdate();
    }

    public String getComments() {
        this.readLock.lock();
        try {
            String string = this.comment;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setComments(String comment) {
        this.writeLock.lock();
        try {
            this.comment = CharacterFilterUtils.filterInvalidXmlCharacters((String)comment);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ControllerServiceState getState() {
        return this.stateTransition.getState();
    }

    public boolean isActive() {
        return this.active.get();
    }

    public boolean isValidationNecessary() {
        switch (this.getState()) {
            case DISABLED: 
            case DISABLING: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> enable(final ScheduledExecutorService scheduler, final long administrativeYieldMillis) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.stateTransition.transitionToEnabling(ControllerServiceState.DISABLED, future)) {
            AtomicBoolean atomicBoolean = this.active;
            synchronized (atomicBoolean) {
                this.active.set(true);
            }
            final StandardControllerServiceNode service = this;
            final StandardConfigurationContext configContext = new StandardConfigurationContext((ComponentNode)this, (ControllerServiceLookup)this.serviceProvider, null, (VariableRegistry)this.getVariableRegistry());
            scheduler.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        boolean shouldEnable;
                        NarCloseable nc = NarCloseable.withComponentNarLoader(StandardControllerServiceNode.this.getControllerServiceImplementation().getClass(), (String)StandardControllerServiceNode.this.getIdentifier());
                        Serializable serializable = null;
                        try {
                            ReflectionUtils.invokeMethodsWithAnnotation(OnEnabled.class, StandardControllerServiceNode.this.getControllerServiceImplementation(), configContext);
                        }
                        catch (Throwable throwable) {
                            serializable = throwable;
                            throw throwable;
                        }
                        finally {
                            if (nc != null) {
                                if (serializable != null) {
                                    try {
                                        nc.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)serializable).addSuppressed(throwable);
                                    }
                                } else {
                                    nc.close();
                                }
                            }
                        }
                        serializable = StandardControllerServiceNode.this.active;
                        synchronized (serializable) {
                            shouldEnable = StandardControllerServiceNode.this.active.get() && StandardControllerServiceNode.this.stateTransition.enable();
                        }
                        if (!shouldEnable) {
                            LOG.debug("Disabling service {} after it has been enabled due to disable action being initiated.", (Object)service);
                            StandardControllerServiceNode.this.invokeDisable(configContext);
                            StandardControllerServiceNode.this.stateTransition.disable();
                        } else {
                            LOG.debug("Successfully enabled {}", (Object)service);
                        }
                    }
                    catch (Exception e) {
                        future.completeExceptionally(e);
                        Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
                        SimpleProcessLogger componentLog = new SimpleProcessLogger(StandardControllerServiceNode.this.getIdentifier(), (Object)StandardControllerServiceNode.this);
                        componentLog.error("Failed to invoke @OnEnabled method due to {}", cause);
                        LOG.error("Failed to invoke @OnEnabled method of {} due to {}", (Object)StandardControllerServiceNode.this.getControllerServiceImplementation(), (Object)cause.toString());
                        StandardControllerServiceNode.this.invokeDisable(configContext);
                        if (StandardControllerServiceNode.this.isActive()) {
                            scheduler.schedule(this, administrativeYieldMillis, TimeUnit.MILLISECONDS);
                        }
                        try (NarCloseable nc = NarCloseable.withComponentNarLoader(StandardControllerServiceNode.this.getControllerServiceImplementation().getClass(), (String)StandardControllerServiceNode.this.getIdentifier());){
                            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnDisabled.class, (Object)StandardControllerServiceNode.this.getControllerServiceImplementation(), configContext);
                        }
                        StandardControllerServiceNode.this.stateTransition.disable();
                    }
                }
            });
        } else {
            future.complete(null);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> disable(ScheduledExecutorService scheduler) {
        AtomicBoolean atomicBoolean = this.active;
        synchronized (atomicBoolean) {
            this.active.set(false);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.stateTransition.transitionToDisabling(ControllerServiceState.ENABLED, future)) {
            final StandardConfigurationContext configContext = new StandardConfigurationContext((ComponentNode)this, (ControllerServiceLookup)this.serviceProvider, null, (VariableRegistry)this.getVariableRegistry());
            scheduler.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        StandardControllerServiceNode.this.invokeDisable(configContext);
                    }
                    finally {
                        StandardControllerServiceNode.this.stateTransition.disable();
                        for (ComponentNode component : StandardControllerServiceNode.this.getReferences().getReferencingComponents()) {
                            component.performValidation();
                        }
                    }
                }
            });
        } else {
            this.stateTransition.transitionToDisabling(ControllerServiceState.ENABLING, future);
        }
        return future;
    }

    private void invokeDisable(ConfigurationContext configContext) {
        try (NarCloseable nc = NarCloseable.withComponentNarLoader(this.getControllerServiceImplementation().getClass(), (String)this.getIdentifier());){
            ReflectionUtils.invokeMethodsWithAnnotation(OnDisabled.class, this.getControllerServiceImplementation(), configContext);
            LOG.debug("Successfully disabled {}", (Object)this);
        }
        catch (Exception e) {
            Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
            SimpleProcessLogger componentLog = new SimpleProcessLogger(this.getIdentifier(), (Object)this);
            componentLog.error("Failed to invoke @OnDisabled method due to {}", cause);
            LOG.error("Failed to invoke @OnDisabled method of {} due to {}", (Object)this.getControllerServiceImplementation(), (Object)cause.toString());
        }
    }

    public String getProcessGroupIdentifier() {
        ProcessGroup procGroup = this.getProcessGroup();
        return procGroup == null ? null : procGroup.getIdentifier();
    }

    public Optional<String> getVersionedComponentId() {
        return Optional.ofNullable(this.versionedComponentId.get());
    }

    public void setVersionedComponentId(String versionedComponentId) {
        boolean updated = false;
        while (!updated) {
            String currentId = this.versionedComponentId.get();
            if (currentId == null) {
                updated = this.versionedComponentId.compareAndSet(null, versionedComponentId);
                continue;
            }
            if (currentId.equals(versionedComponentId)) {
                return;
            }
            if (versionedComponentId == null) {
                updated = this.versionedComponentId.compareAndSet(currentId, null);
                continue;
            }
            throw new IllegalStateException((Object)((Object)this) + " is already under version control");
        }
    }
}

