/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history;

import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.StandardMetricDescriptor;

public enum ConnectionStatusDescriptor {
    INPUT_BYTES(new StandardMetricDescriptor<ConnectionStatus>("inputBytes", "Bytes In (5 mins)", "The cumulative size of all FlowFiles that were transferred to this Connection in the past 5 minutes", MetricDescriptor.Formatter.DATA_SIZE, s -> s.getInputBytes())),
    INPUT_COUNT(new StandardMetricDescriptor<ConnectionStatus>("inputCount", "FlowFiles In (5 mins)", "The number of FlowFiles that were transferred to this Connection in the past 5 minutes", MetricDescriptor.Formatter.COUNT, s -> s.getInputCount())),
    OUTPUT_BYTES(new StandardMetricDescriptor<ConnectionStatus>("outputBytes", "Bytes Out (5 mins)", "The cumulative size of all FlowFiles that were pulled from this Connection in the past 5 minutes", MetricDescriptor.Formatter.DATA_SIZE, s -> s.getOutputBytes())),
    OUTPUT_COUNT(new StandardMetricDescriptor<ConnectionStatus>("outputCount", "FlowFiles Out (5 mins)", "The number of FlowFiles that were pulled from this Connection in the past 5 minutes", MetricDescriptor.Formatter.COUNT, s -> s.getOutputCount())),
    QUEUED_BYTES(new StandardMetricDescriptor<ConnectionStatus>("queuedBytes", "Queued Bytes", "The number of Bytes queued in this Connection", MetricDescriptor.Formatter.DATA_SIZE, s -> s.getQueuedBytes())),
    QUEUED_COUNT(new StandardMetricDescriptor<ConnectionStatus>("queuedCount", "Queued Count", "The number of FlowFiles queued in this Connection", MetricDescriptor.Formatter.COUNT, s -> s.getQueuedCount()));

    private MetricDescriptor<ConnectionStatus> descriptor;

    private ConnectionStatusDescriptor(MetricDescriptor<ConnectionStatus> descriptor) {
        this.descriptor = descriptor;
    }

    public String getField() {
        return this.descriptor.getField();
    }

    public MetricDescriptor<ConnectionStatus> getDescriptor() {
        return this.descriptor;
    }
}

