/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor;

import java.io.File;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.util.NiFiProperties;

public class StandardProcessorInitializationContext
implements ProcessorInitializationContext {
    private final String identifier;
    private final ComponentLog logger;
    private final ControllerServiceProvider serviceProvider;
    private final NodeTypeProvider nodeTypeProvider;
    private final NiFiProperties nifiProperties;

    public StandardProcessorInitializationContext(String identifier, ComponentLog componentLog, ControllerServiceProvider serviceProvider, NodeTypeProvider nodeTypeProvider, NiFiProperties nifiProperties) {
        this.identifier = identifier;
        this.logger = componentLog;
        this.serviceProvider = serviceProvider;
        this.nodeTypeProvider = nodeTypeProvider;
        this.nifiProperties = nifiProperties;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ComponentLog getLogger() {
        return this.logger;
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return this.serviceProvider;
    }

    public NodeTypeProvider getNodeTypeProvider() {
        return this.nodeTypeProvider;
    }

    public String getKerberosServicePrincipal() {
        return this.nifiProperties.getKerberosServicePrincipal();
    }

    public File getKerberosServiceKeytab() {
        return this.nifiProperties.getKerberosServiceKeytabLocation() == null ? null : new File(this.nifiProperties.getKerberosServiceKeytabLocation());
    }

    public File getKerberosConfigurationFile() {
        return this.nifiProperties.getKerberosConfigurationFile();
    }
}

