/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.registry.flow.Bundle;
import org.apache.nifi.registry.flow.VersionedProcessGroup;
import org.apache.nifi.web.api.dto.BundleDTO;

public final class BundleUtils {
    private static BundleCoordinate findBundleForType(String type, BundleCoordinate desiredCoordinate) {
        List bundles = ExtensionManager.getBundles((String)type);
        if (bundles.isEmpty()) {
            throw new IllegalStateException(String.format("%s is not known to this NiFi instance.", type));
        }
        if (bundles.size() > 1) {
            if (desiredCoordinate == null) {
                throw new IllegalStateException(String.format("Multiple versions of %s exist.", type));
            }
            throw new IllegalStateException(String.format("Multiple versions of %s exist. No exact match for %s.", type, desiredCoordinate));
        }
        return ((org.apache.nifi.bundle.Bundle)bundles.get(0)).getBundleDetails().getCoordinate();
    }

    private static BundleCoordinate findCompatibleBundle(String type, BundleDTO bundleDTO, boolean allowCompatibleBundle) {
        BundleCoordinate coordinate = new BundleCoordinate(bundleDTO.getGroup(), bundleDTO.getArtifact(), bundleDTO.getVersion());
        org.apache.nifi.bundle.Bundle bundle = ExtensionManager.getBundle((BundleCoordinate)coordinate);
        if (bundle == null) {
            if (allowCompatibleBundle) {
                return BundleUtils.findBundleForType(type, coordinate);
            }
            throw new IllegalStateException(String.format("%s from %s is not known to this NiFi instance.", type, coordinate));
        }
        List bundlesForType = ExtensionManager.getBundles((String)type).stream().map(b -> b.getBundleDetails().getCoordinate()).collect(Collectors.toList());
        if (bundlesForType.contains(coordinate)) {
            return coordinate;
        }
        throw new IllegalStateException(String.format("Found bundle %s but does not support %s", coordinate, type));
    }

    public static BundleCoordinate getBundle(String type, BundleDTO bundleDTO) {
        if (bundleDTO == null) {
            return BundleUtils.findBundleForType(type, null);
        }
        return BundleUtils.findCompatibleBundle(type, bundleDTO, false);
    }

    public static BundleCoordinate getCompatibleBundle(String type, BundleDTO bundleDTO) {
        if (bundleDTO == null) {
            return BundleUtils.findBundleForType(type, null);
        }
        return BundleUtils.findCompatibleBundle(type, bundleDTO, true);
    }

    public static void discoverCompatibleBundles(VersionedProcessGroup versionedGroup) {
        if (versionedGroup.getProcessors() != null) {
            versionedGroup.getProcessors().forEach(processor -> {
                BundleCoordinate coordinate = BundleUtils.getCompatibleBundle(processor.getType(), BundleUtils.createBundleDto(processor.getBundle()));
                Bundle bundle = new Bundle();
                bundle.setArtifact(coordinate.getId());
                bundle.setGroup(coordinate.getGroup());
                bundle.setVersion(coordinate.getVersion());
                processor.setBundle(bundle);
            });
        }
        if (versionedGroup.getControllerServices() != null) {
            versionedGroup.getControllerServices().forEach(controllerService -> {
                BundleCoordinate coordinate = BundleUtils.getCompatibleBundle(controllerService.getType(), BundleUtils.createBundleDto(controllerService.getBundle()));
                Bundle bundle = new Bundle();
                bundle.setArtifact(coordinate.getId());
                bundle.setGroup(coordinate.getGroup());
                bundle.setVersion(coordinate.getVersion());
                controllerService.setBundle(bundle);
            });
        }
        if (versionedGroup.getProcessGroups() != null) {
            versionedGroup.getProcessGroups().forEach(processGroup -> BundleUtils.discoverCompatibleBundles(processGroup));
        }
    }

    public static BundleDTO createBundleDto(Bundle bundle) {
        BundleDTO dto = new BundleDTO();
        dto.setArtifact(bundle.getArtifact());
        dto.setGroup(bundle.getGroup());
        dto.setVersion(bundle.getVersion());
        return dto;
    }
}

