/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.configuration.DefaultSchedule;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.annotation.lifecycle.OnUnscheduled;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.resource.ResourceType;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.validation.ValidationState;
import org.apache.nifi.components.validation.ValidationTrigger;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.controller.ActiveThreadInfo;
import org.apache.nifi.controller.LoggableComponent;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ProcessorDetails;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReloadComponent;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.SchedulingAgentCallback;
import org.apache.nifi.controller.TerminationAwareLogger;
import org.apache.nifi.controller.ValidationContextFactory;
import org.apache.nifi.controller.exception.ProcessorInstantiationException;
import org.apache.nifi.controller.scheduling.LifecycleState;
import org.apache.nifi.controller.scheduling.SchedulingAgent;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.tasks.ActiveTask;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogRepositoryFactory;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.registry.ComponentVariableRegistry;
import org.apache.nifi.scheduling.ExecutionNode;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.util.CharacterFilterUtils;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.ReflectionUtils;
import org.apache.nifi.util.ThreadUtils;
import org.apache.nifi.util.file.classloader.ClassLoaderUtils;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class StandardProcessorNode
extends ProcessorNode
implements Connectable {
    private static final Logger LOG = LoggerFactory.getLogger(StandardProcessorNode.class);
    public static final String BULLETIN_OBSERVER_ID = "bulletin-observer";
    public static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.MILLISECONDS;
    public static final String DEFAULT_YIELD_PERIOD = "1 sec";
    public static final String DEFAULT_PENALIZATION_PERIOD = "30 sec";
    private final AtomicReference<ProcessGroup> processGroup;
    private final AtomicReference<ProcessorDetails> processorRef;
    private final AtomicReference<String> identifier;
    private final Map<Connection, Connectable> destinations;
    private final Map<Relationship, Set<Connection>> connections;
    private final AtomicReference<Set<Relationship>> undefinedRelationshipsToTerminate;
    private final AtomicReference<List<Connection>> incomingConnections;
    private final AtomicBoolean lossTolerant;
    private final AtomicReference<String> comments;
    private final AtomicReference<Position> position;
    private final AtomicReference<String> schedulingPeriod;
    private final AtomicReference<String> yieldPeriod;
    private final AtomicReference<String> penalizationPeriod;
    private final AtomicReference<Map<String, String>> style;
    private final AtomicInteger concurrentTaskCount;
    private final AtomicLong yieldExpiration;
    private final AtomicLong schedulingNanos;
    private final AtomicReference<String> versionedComponentId;
    private final ProcessScheduler processScheduler;
    private long runNanos;
    private volatile long yieldNanos;
    private volatile ScheduledState desiredState;
    private SchedulingStrategy schedulingStrategy;
    private ExecutionNode executionNode;
    private final long onScheduleTimeoutMillis;
    private final Map<Thread, ActiveTask> activeThreads;
    private final int hashCode;
    private volatile boolean hasActiveThreads;

    public StandardProcessorNode(LoggableComponent<Processor> processor, String uuid, ValidationContextFactory validationContextFactory, ProcessScheduler scheduler, ControllerServiceProvider controllerServiceProvider, NiFiProperties nifiProperties, ComponentVariableRegistry variableRegistry, ReloadComponent reloadComponent, ValidationTrigger validationTrigger) {
        this(processor, uuid, validationContextFactory, scheduler, controllerServiceProvider, ((Processor)processor.getComponent()).getClass().getSimpleName(), ((Processor)processor.getComponent()).getClass().getCanonicalName(), nifiProperties, variableRegistry, reloadComponent, validationTrigger, false);
    }

    public StandardProcessorNode(LoggableComponent<Processor> processor, String uuid, ValidationContextFactory validationContextFactory, ProcessScheduler scheduler, ControllerServiceProvider controllerServiceProvider, String componentType, String componentCanonicalClass, NiFiProperties nifiProperties, ComponentVariableRegistry variableRegistry, ReloadComponent reloadComponent, ValidationTrigger validationTrigger, boolean isExtensionMissing) {
        block9: {
            super(uuid, validationContextFactory, controllerServiceProvider, componentType, componentCanonicalClass, variableRegistry, reloadComponent, validationTrigger, isExtensionMissing);
            this.versionedComponentId = new AtomicReference();
            this.runNanos = 0L;
            this.activeThreads = new HashMap<Thread, ActiveTask>(48);
            this.hasActiveThreads = false;
            ProcessorDetails processorDetails = new ProcessorDetails(processor);
            this.processorRef = new AtomicReference<ProcessorDetails>(processorDetails);
            this.identifier = new AtomicReference<String>(uuid);
            this.destinations = new HashMap<Connection, Connectable>();
            this.connections = new HashMap<Relationship, Set<Connection>>();
            this.incomingConnections = new AtomicReference(new ArrayList());
            this.lossTolerant = new AtomicBoolean(false);
            HashSet emptySetOfRelationships = new HashSet();
            this.undefinedRelationshipsToTerminate = new AtomicReference(emptySetOfRelationships);
            this.comments = new AtomicReference<String>("");
            this.schedulingPeriod = new AtomicReference<String>("0 sec");
            this.schedulingNanos = new AtomicLong(1L);
            this.yieldPeriod = new AtomicReference<String>(DEFAULT_YIELD_PERIOD);
            this.yieldExpiration = new AtomicLong(0L);
            this.concurrentTaskCount = new AtomicInteger(1);
            this.position = new AtomicReference<Position>(new Position(0.0, 0.0));
            this.style = new AtomicReference(Collections.unmodifiableMap(new HashMap()));
            this.processGroup = new AtomicReference();
            this.processScheduler = scheduler;
            this.penalizationPeriod = new AtomicReference<String>(DEFAULT_PENALIZATION_PERIOD);
            String timeoutString = nifiProperties.getProperty("nifi.processor.scheduling.timeout");
            this.onScheduleTimeoutMillis = timeoutString == null ? 60000L : FormatUtils.getTimeDuration((String)timeoutString.trim(), (TimeUnit)TimeUnit.MILLISECONDS);
            this.schedulingStrategy = SchedulingStrategy.TIMER_DRIVEN;
            this.executionNode = this.isExecutionNodeRestricted() ? ExecutionNode.PRIMARY : ExecutionNode.ALL;
            this.hashCode = new HashCodeBuilder(7, 67).append(this.identifier).toHashCode();
            try {
                if (!processorDetails.getProcClass().isAnnotationPresent(DefaultSchedule.class)) break block9;
                DefaultSchedule dsc = processorDetails.getProcClass().getAnnotation(DefaultSchedule.class);
                try {
                    this.setSchedulingStrategy(dsc.strategy());
                }
                catch (Throwable ex) {
                    LOG.error(String.format("Error while setting scheduling strategy from DefaultSchedule annotation: %s", ex.getMessage()), ex);
                }
                try {
                    this.setScheduldingPeriod(dsc.period());
                }
                catch (Throwable ex) {
                    this.setSchedulingStrategy(SchedulingStrategy.TIMER_DRIVEN);
                    LOG.error(String.format("Error while setting scheduling period from DefaultSchedule annotation: %s", ex.getMessage()), ex);
                }
                if (!processorDetails.isTriggeredSerially()) {
                    try {
                        this.setMaxConcurrentTasks(dsc.concurrentTasks());
                    }
                    catch (Throwable ex) {
                        LOG.error(String.format("Error while setting max concurrent tasks from DefaultSchedule annotation: %s", ex.getMessage()), ex);
                    }
                }
            }
            catch (Throwable ex) {
                LOG.error(String.format("Error while setting default schedule from DefaultSchedule annotation: %s", ex.getMessage()), ex);
            }
        }
    }

    public ConfigurableComponent getComponent() {
        return this.processorRef.get().getProcessor();
    }

    public TerminationAwareLogger getLogger() {
        return this.processorRef.get().getComponentLog();
    }

    public Object getRunnableComponent() {
        return this.getProcessor();
    }

    public BundleCoordinate getBundleCoordinate() {
        return this.processorRef.get().getBundleCoordinate();
    }

    public String getComments() {
        return this.comments.get();
    }

    public Authorizable getParentAuthorizable() {
        return this.getProcessGroup();
    }

    public Resource getResource() {
        return ResourceFactory.getComponentResource((ResourceType)ResourceType.Processor, (String)this.getIdentifier(), (String)this.getName());
    }

    public boolean isRestricted() {
        return this.getProcessor().getClass().isAnnotationPresent(Restricted.class);
    }

    public Class<?> getComponentClass() {
        return this.getProcessor().getClass();
    }

    public boolean isDeprecated() {
        return this.getProcessor().getClass().isAnnotationPresent(DeprecationNotice.class);
    }

    public synchronized void setComments(String comments) {
        this.comments.set(CharacterFilterUtils.filterInvalidXmlCharacters((String)comments));
    }

    public Position getPosition() {
        return this.position.get();
    }

    public synchronized void setPosition(Position position) {
        this.position.set(position);
    }

    public Map<String, String> getStyle() {
        return this.style.get();
    }

    public synchronized void setStyle(Map<String, String> style) {
        if (style != null) {
            this.style.set(Collections.unmodifiableMap(new HashMap<String, String>(style)));
        }
    }

    public String getIdentifier() {
        return this.identifier.get();
    }

    public boolean isLossTolerant() {
        return this.lossTolerant.get();
    }

    public boolean isIsolated() {
        return this.schedulingStrategy == SchedulingStrategy.PRIMARY_NODE_ONLY || this.executionNode == ExecutionNode.PRIMARY;
    }

    public boolean isTriggerWhenEmpty() {
        return this.processorRef.get().isTriggerWhenEmpty();
    }

    public boolean isSideEffectFree() {
        return this.processorRef.get().isSideEffectFree();
    }

    public boolean isSessionBatchingSupported() {
        return this.processorRef.get().isBatchSupported();
    }

    public boolean isTriggerWhenAnyDestinationAvailable() {
        return this.processorRef.get().isTriggerWhenAnyDestinationAvailable();
    }

    public boolean isExecutionNodeRestricted() {
        return this.processorRef.get().isExecutionNodeRestricted();
    }

    public synchronized void setLossTolerant(boolean lossTolerant) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify Processor configuration while the Processor is running");
        }
        this.lossTolerant.set(lossTolerant);
    }

    public boolean isAutoTerminated(Relationship relationship) {
        if (relationship.isAutoTerminated() && this.getConnections(relationship).isEmpty()) {
            return true;
        }
        Set<Relationship> terminatable = this.undefinedRelationshipsToTerminate.get();
        return terminatable == null ? false : terminatable.contains(relationship);
    }

    public void setAutoTerminatedRelationships(Set<Relationship> terminate) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify Processor configuration while the Processor is running");
        }
        for (Relationship rel : terminate) {
            if (this.getConnections(rel).isEmpty()) continue;
            throw new IllegalStateException("Cannot mark relationship '" + rel.getName() + "' as auto-terminated because Connection already exists with this relationship");
        }
        this.undefinedRelationshipsToTerminate.set(new HashSet<Relationship>(terminate));
        LOG.debug("Resetting Validation State of {} due to setting auto-terminated relationships", (Object)this);
        this.resetValidationState();
    }

    public Set<Relationship> getAutoTerminatedRelationships() {
        Set<Relationship> relationships = this.undefinedRelationshipsToTerminate.get();
        if (relationships == null) {
            relationships = new HashSet<Relationship>();
        }
        return Collections.unmodifiableSet(relationships);
    }

    public String getProcessorDescription() {
        Processor processor = this.processorRef.get().getProcessor();
        CapabilityDescription capDesc = processor.getClass().getAnnotation(CapabilityDescription.class);
        String description = null;
        if (capDesc != null) {
            description = capDesc.value();
        }
        return description;
    }

    public synchronized void setName(String name) {
        super.setName(name);
    }

    public long getSchedulingPeriod(TimeUnit timeUnit) {
        return timeUnit.convert(this.schedulingNanos.get(), TimeUnit.NANOSECONDS);
    }

    public boolean isEventDrivenSupported() {
        return this.processorRef.get().isEventDrivenSupported();
    }

    public synchronized void setSchedulingStrategy(SchedulingStrategy schedulingStrategy) {
        if (schedulingStrategy == SchedulingStrategy.EVENT_DRIVEN && !this.processorRef.get().isEventDrivenSupported()) {
            return;
        }
        this.schedulingStrategy = schedulingStrategy;
    }

    public SchedulingStrategy getSchedulingStrategy() {
        return this.schedulingStrategy;
    }

    public String getSchedulingPeriod() {
        return this.schedulingPeriod.get();
    }

    public synchronized void setScheduldingPeriod(String schedulingPeriod) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify Processor configuration while the Processor is running");
        }
        switch (this.schedulingStrategy) {
            case CRON_DRIVEN: {
                try {
                    new CronExpression(schedulingPeriod);
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Scheduling Period is not a valid cron expression: " + schedulingPeriod);
                }
            }
            case PRIMARY_NODE_ONLY: 
            case TIMER_DRIVEN: {
                long schedulingNanos = FormatUtils.getTimeDuration((String)Objects.requireNonNull(schedulingPeriod), (TimeUnit)TimeUnit.NANOSECONDS);
                if (schedulingNanos < 0L) {
                    throw new IllegalArgumentException("Scheduling Period must be positive");
                }
                this.schedulingNanos.set(Math.max(1L, schedulingNanos));
                break;
            }
            default: {
                return;
            }
        }
        this.schedulingPeriod.set(schedulingPeriod);
    }

    public synchronized void setExecutionNode(ExecutionNode executionNode) {
        this.executionNode = this.isExecutionNodeRestricted() ? ExecutionNode.PRIMARY : executionNode;
    }

    public ExecutionNode getExecutionNode() {
        return this.executionNode;
    }

    public long getRunDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.runNanos, TimeUnit.NANOSECONDS);
    }

    public synchronized void setRunDuration(long duration, TimeUnit timeUnit) {
        if (duration < 0L) {
            throw new IllegalArgumentException("Run Duration must be non-negative value; cannot set to " + timeUnit.toSeconds(duration) + " seconds");
        }
        this.runNanos = timeUnit.toNanos(duration);
    }

    public long getYieldPeriod(TimeUnit timeUnit) {
        TimeUnit unit = timeUnit == null ? DEFAULT_TIME_UNIT : timeUnit;
        return unit.convert(this.yieldNanos, TimeUnit.NANOSECONDS);
    }

    public String getYieldPeriod() {
        return this.yieldPeriod.get();
    }

    public synchronized void setYieldPeriod(String yieldPeriod) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify Processor configuration while the Processor is running");
        }
        long yieldNanos = FormatUtils.getTimeDuration((String)Objects.requireNonNull(yieldPeriod), (TimeUnit)TimeUnit.NANOSECONDS);
        if (yieldNanos < 0L) {
            throw new IllegalArgumentException("Yield duration must be positive");
        }
        this.yieldPeriod.set(yieldPeriod);
        this.yieldNanos = yieldNanos;
    }

    public void yield() {
        Processor processor = this.processorRef.get().getProcessor();
        long yieldMillis = this.getYieldPeriod(TimeUnit.MILLISECONDS);
        this.yield(yieldMillis, TimeUnit.MILLISECONDS);
        String yieldDuration = yieldMillis > 1000L ? yieldMillis / 1000L + " seconds" : yieldMillis + " milliseconds";
        LoggerFactory.getLogger(processor.getClass()).debug("{} has chosen to yield its resources; will not be scheduled to run again for {}", (Object)processor, (Object)yieldDuration);
    }

    public void yield(long period, TimeUnit timeUnit) {
        long yieldMillis = TimeUnit.MILLISECONDS.convert(period, timeUnit);
        this.yieldExpiration.set(Math.max(this.yieldExpiration.get(), System.currentTimeMillis() + yieldMillis));
        this.processScheduler.yield((ProcessorNode)this);
    }

    public long getYieldExpiration() {
        return this.yieldExpiration.get();
    }

    public long getPenalizationPeriod(TimeUnit timeUnit) {
        return FormatUtils.getTimeDuration((String)this.getPenalizationPeriod(), (TimeUnit)(timeUnit == null ? DEFAULT_TIME_UNIT : timeUnit));
    }

    public String getPenalizationPeriod() {
        return this.penalizationPeriod.get();
    }

    public synchronized void setPenalizationPeriod(String penalizationPeriod) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify Processor configuration while the Processor is running");
        }
        long penalizationMillis = FormatUtils.getTimeDuration((String)Objects.requireNonNull(penalizationPeriod), (TimeUnit)TimeUnit.MILLISECONDS);
        if (penalizationMillis < 0L) {
            throw new IllegalArgumentException("Penalization duration must be positive");
        }
        this.penalizationPeriod.set(penalizationPeriod);
    }

    public synchronized void setMaxConcurrentTasks(int taskCount) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify Processor configuration while the Processor is running");
        }
        if (taskCount < 1 && this.getSchedulingStrategy() != SchedulingStrategy.EVENT_DRIVEN) {
            throw new IllegalArgumentException("Cannot set Concurrent Tasks to " + taskCount + " for component " + this.getIdentifier() + " because Scheduling Strategy is not Event Driven");
        }
        if (!this.isTriggeredSerially()) {
            this.concurrentTaskCount.set(taskCount);
        }
    }

    public boolean isTriggeredSerially() {
        return this.processorRef.get().isTriggeredSerially();
    }

    public int getMaxConcurrentTasks() {
        return this.concurrentTaskCount.get();
    }

    public LogLevel getBulletinLevel() {
        return LogRepositoryFactory.getRepository((String)this.getIdentifier()).getObservationLevel(BULLETIN_OBSERVER_ID);
    }

    public synchronized void setBulletinLevel(LogLevel level) {
        LogRepositoryFactory.getRepository((String)this.getIdentifier()).setObservationLevel(BULLETIN_OBSERVER_ID, level);
    }

    public Set<Connection> getConnections() {
        HashSet<Connection> allConnections = new HashSet<Connection>();
        for (Set<Connection> connectionSet : this.connections.values()) {
            allConnections.addAll(connectionSet);
        }
        return allConnections;
    }

    public List<Connection> getIncomingConnections() {
        return this.incomingConnections.get();
    }

    public Set<Connection> getConnections(Relationship relationship) {
        Set<Connection> applicableConnections = this.connections.get(relationship);
        return applicableConnections == null ? Collections.emptySet() : Collections.unmodifiableSet(applicableConnections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(Connection connection) {
        Objects.requireNonNull(connection, "connection cannot be null");
        if (!connection.getSource().equals((Object)this) && !connection.getDestination().equals((Object)this)) {
            throw new IllegalStateException("Cannot a connection to a ProcessorNode for which the ProcessorNode is neither the Source nor the Destination");
        }
        try {
            Object incomingConnections;
            ArrayList<Connection> updatedIncoming = null;
            if (connection.getDestination().equals((Object)this) && !(updatedIncoming = new ArrayList<Connection>((Collection<Connection>)(incomingConnections = this.getIncomingConnections()))).contains(connection)) {
                updatedIncoming.add(connection);
            }
            if (connection.getSource().equals((Object)this) && !this.destinations.containsKey(connection)) {
                for (Relationship relationship : connection.getRelationships()) {
                    Relationship rel = this.getRelationship(relationship.getName());
                    Set<Connection> set = this.connections.get(rel);
                    if (set == null) {
                        set = new HashSet<Connection>();
                        this.connections.put(rel, set);
                    }
                    set.add(connection);
                    this.destinations.put(connection, connection.getDestination());
                }
                Set<Relationship> autoTerminated = this.undefinedRelationshipsToTerminate.get();
                if (autoTerminated != null) {
                    autoTerminated.removeAll(connection.getRelationships());
                    this.undefinedRelationshipsToTerminate.set(autoTerminated);
                }
            }
            if (updatedIncoming != null) {
                this.setIncomingConnections(Collections.unmodifiableList(updatedIncoming));
            }
        }
        finally {
            LOG.debug("Resetting Validation State of {} due to connection added", (Object)this);
            this.resetValidationState();
        }
    }

    public boolean hasIncomingConnection() {
        return !this.getIncomingConnections().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConnection(Connection connection) throws IllegalStateException {
        try {
            if (Objects.requireNonNull(connection).getSource().equals((Object)this)) {
                ArrayList<Relationship> existingRelationships = new ArrayList<Relationship>();
                for (Map.Entry<Relationship, Set<Connection>> entry : this.connections.entrySet()) {
                    if (!entry.getValue().contains(connection)) continue;
                    existingRelationships.add(entry.getKey());
                }
                for (Relationship relationship : connection.getRelationships()) {
                    Set<Connection> connectionsForRelationship;
                    if (existingRelationships.contains(relationship) || (connectionsForRelationship = this.getConnections(relationship)) == null || connectionsForRelationship.size() != 1 || !this.isRunning() || this.isAutoTerminated(relationship) || !this.getRelationships().contains(relationship)) continue;
                    throw new IllegalStateException("Cannot remove relationship " + relationship.getName() + " from Connection because doing so would invalidate Processor " + (Object)((Object)this) + ", which is currently running");
                }
                for (Set set : this.connections.values()) {
                    set.remove(connection);
                }
                for (Relationship relationship : connection.getRelationships()) {
                    Set<Connection> set = this.connections.get(relationship);
                    if (set == null) {
                        set = new HashSet<Connection>();
                        this.connections.put(relationship, set);
                    }
                    set.add(connection);
                }
                this.destinations.put(connection, connection.getDestination());
                Set<Relationship> autoTerminated = this.undefinedRelationshipsToTerminate.get();
                if (autoTerminated != null) {
                    autoTerminated.removeAll(connection.getRelationships());
                    this.undefinedRelationshipsToTerminate.set(autoTerminated);
                }
            }
            if (connection.getDestination().equals((Object)this)) {
                List<Connection> incomingConnections = this.getIncomingConnections();
                ArrayList<Connection> updatedIncoming = new ArrayList<Connection>(incomingConnections);
                updatedIncoming.remove(connection);
                updatedIncoming.add(connection);
                this.setIncomingConnections(Collections.unmodifiableList(updatedIncoming));
            }
        }
        finally {
            LOG.debug("Resetting Validation State of {} due to updating connection", (Object)this);
            this.resetValidationState();
        }
    }

    public void removeConnection(Connection connection) {
        List<Connection> incomingConnections;
        boolean connectionRemoved = false;
        if (Objects.requireNonNull(connection).getSource().equals((Object)this)) {
            for (Relationship relationship : connection.getRelationships()) {
                Set<Connection> connectionsForRelationship = this.getConnections(relationship);
                if (connectionsForRelationship != null && connectionsForRelationship.size() > 1 || !this.isRunning()) continue;
                throw new IllegalStateException("This connection cannot be removed because its source is running and removing it will invalidate this processor");
            }
            for (Set set : this.connections.values()) {
                set.remove(connection);
            }
            boolean bl = connectionRemoved = this.destinations.remove(connection) != null;
        }
        if (connection.getDestination().equals((Object)this) && (incomingConnections = this.getIncomingConnections()).contains(connection)) {
            ArrayList<Connection> arrayList = new ArrayList<Connection>(incomingConnections);
            arrayList.remove(connection);
            this.setIncomingConnections(Collections.unmodifiableList(arrayList));
            return;
        }
        if (!connectionRemoved) {
            throw new IllegalArgumentException("Cannot remove a connection from a ProcessorNode for which the ProcessorNode is not the Source");
        }
        LOG.debug("Resetting Validation State of {} due to connection removed", (Object)this);
        this.resetValidationState();
    }

    private void setIncomingConnections(List<Connection> incoming) {
        this.incomingConnections.set(incoming);
        LOG.debug("Resetting Validation State of {} due to setting incoming connections", (Object)this);
        this.resetValidationState();
    }

    public Relationship getRelationship(String relationshipName) {
        Set relationships;
        Relationship specRel;
        Relationship returnRel = specRel = new Relationship.Builder().name(relationshipName).build();
        Processor processor = this.processorRef.get().getProcessor();
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader(processor.getClass(), (String)processor.getIdentifier());){
            relationships = processor.getRelationships();
        }
        for (Relationship rel : relationships) {
            if (!rel.equals((Object)specRel)) continue;
            returnRel = rel;
            break;
        }
        return returnRel;
    }

    public Processor getProcessor() {
        return this.processorRef.get().getProcessor();
    }

    public synchronized void setProcessor(LoggableComponent<Processor> processor) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify Processor configuration while the Processor is running");
        }
        ProcessorDetails processorDetails = new ProcessorDetails(processor);
        this.processorRef.set(processorDetails);
    }

    public synchronized void reload(Set<URL> additionalUrls) throws ProcessorInstantiationException {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot reload Processor while the Processor is running");
        }
        String additionalResourcesFingerprint = ClassLoaderUtils.generateAdditionalUrlsFingerprint(additionalUrls);
        this.setAdditionalResourcesFingerprint(additionalResourcesFingerprint);
        this.getReloadComponent().reload((ProcessorNode)this, this.getCanonicalClassName(), this.getBundleCoordinate(), additionalUrls);
    }

    public Set<Connectable> getDestinations() {
        HashSet<Connectable> nonSelfDestinations = new HashSet<Connectable>();
        for (Connectable connectable : this.destinations.values()) {
            if (connectable == this) continue;
            nonSelfDestinations.add(connectable);
        }
        return nonSelfDestinations;
    }

    public Set<Connectable> getDestinations(Relationship relationship) {
        HashSet<Connectable> destinationSet = new HashSet<Connectable>();
        Set<Connection> relationshipConnections = this.connections.get(relationship);
        if (relationshipConnections != null) {
            for (Connection connection : relationshipConnections) {
                destinationSet.add(this.destinations.get(connection));
            }
        }
        return destinationSet;
    }

    public Set<Relationship> getUndefinedRelationships() {
        Set relationships;
        HashSet<Relationship> undefined = new HashSet<Relationship>();
        Processor processor = this.processorRef.get().getProcessor();
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader(processor.getClass(), (String)processor.getIdentifier());){
            relationships = processor.getRelationships();
        }
        if (relationships == null) {
            return undefined;
        }
        for (Relationship relation : relationships) {
            Set<Connection> connectionSet = this.connections.get(relation);
            if (connectionSet != null && !connectionSet.isEmpty()) continue;
            undefined.add(relation);
        }
        return undefined;
    }

    boolean isRelated(ProcessorNode node) {
        return this.destinations.containsValue(node);
    }

    public boolean isRunning() {
        return this.getScheduledState().equals((Object)ScheduledState.RUNNING) || this.hasActiveThreads;
    }

    public boolean isValidationNecessary() {
        switch (this.getScheduledState()) {
            case STOPPED: 
            case STOPPING: {
                return true;
            }
        }
        return false;
    }

    public int getActiveThreadCount() {
        return this.processScheduler.getActiveThreadCount((Object)this);
    }

    List<Connection> getIncomingNonLoopConnections() {
        List<Connection> connections = this.getIncomingConnections();
        ArrayList<Connection> nonLoopConnections = new ArrayList<Connection>(connections.size());
        for (Connection connection : connections) {
            if (connection.getSource().equals((Object)this)) continue;
            nonLoopConnections.add(connection);
        }
        return nonLoopConnections;
    }

    public Collection<ValidationResult> getValidationErrors() {
        ValidationState validationState = this.getValidationState();
        return validationState.getValidationErrors();
    }

    protected Collection<ValidationResult> computeValidationErrors(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        try {
            Collection validationResults = super.computeValidationErrors(validationContext);
            validationResults.stream().filter(result -> !result.isValid()).forEach(results::add);
            for (Relationship relationship : this.getUndefinedRelationships()) {
                if (this.isAutoTerminated(relationship)) continue;
                ValidationResult error = new ValidationResult.Builder().explanation("Relationship '" + relationship.getName() + "' is not connected to any component and is not auto-terminated").subject("Relationship " + relationship.getName()).valid(false).build();
                results.add(error);
            }
            switch (this.getInputRequirement()) {
                case INPUT_ALLOWED: {
                    break;
                }
                case INPUT_FORBIDDEN: {
                    int incomingConnCount = this.getIncomingNonLoopConnections().size();
                    if (incomingConnCount == 0) break;
                    results.add(new ValidationResult.Builder().explanation("Processor does not allow upstream connections but currently has " + incomingConnCount).subject("Upstream Connections").valid(false).build());
                    break;
                }
                case INPUT_REQUIRED: {
                    if (!this.getIncomingNonLoopConnections().isEmpty()) break;
                    results.add(new ValidationResult.Builder().explanation("Processor requires an upstream connection but currently has none").subject("Upstream Connections").valid(false).build());
                }
            }
        }
        catch (Throwable t) {
            LOG.error("Failed to perform validation", t);
            results.add(new ValidationResult.Builder().explanation("Failed to run validation due to " + t.toString()).valid(false).build());
        }
        return results;
    }

    public InputRequirement.Requirement getInputRequirement() {
        return this.processorRef.get().getInputRequirement();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ProcessorNode)) {
            return false;
        }
        ProcessorNode on = (ProcessorNode)other;
        return new EqualsBuilder().append((Object)this.identifier.get(), (Object)on.getIdentifier()).isEquals();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Collection<Relationship> getRelationships() {
        Processor processor = this.processorRef.get().getProcessor();
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader(processor.getClass(), (String)processor.getIdentifier());){
            Set set = this.getProcessor().getRelationships();
            return set;
        }
    }

    public String toString() {
        Processor processor = this.processorRef.get().getProcessor();
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader(processor.getClass(), (String)processor.getIdentifier());){
            String string = this.getProcessor().toString();
            return string;
        }
    }

    public ProcessGroup getProcessGroup() {
        return this.processGroup.get();
    }

    public synchronized void setProcessGroup(ProcessGroup group) {
        this.processGroup.set(group);
        LOG.debug("Resetting Validation State of {} due to setting process group", (Object)this);
        this.resetValidationState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) {
        Processor processor = this.processorRef.get().getProcessor();
        this.activateThread();
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader(processor.getClass(), (String)processor.getIdentifier());){
            processor.onTrigger(context, sessionFactory);
        }
        finally {
            this.deactivateThread();
        }
    }

    public ConnectableType getConnectableType() {
        return ConnectableType.PROCESSOR;
    }

    public void setAnnotationData(String data) {
        Assert.state((!this.isRunning() ? 1 : 0) != 0, (String)"Cannot set AnnotationData while processor is running");
        super.setAnnotationData(data);
    }

    public void verifyCanDelete() throws IllegalStateException {
        this.verifyCanDelete(false);
    }

    public void verifyCanDelete(boolean ignoreConnections) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getIdentifier() + " is running");
        }
        if (!ignoreConnections) {
            for (Set<Connection> connectionSet : this.connections.values()) {
                for (Connection connection : connectionSet) {
                    connection.verifyCanDelete();
                }
            }
            for (Connection connection : this.getIncomingConnections()) {
                if (connection.getSource().equals((Object)this)) {
                    connection.verifyCanDelete();
                    continue;
                }
                throw new IllegalStateException(this.getIdentifier() + " is the destination of another component");
            }
        }
    }

    public void verifyCanStart() {
        this.verifyCanStart(null);
    }

    public void verifyCanStart(Set<ControllerServiceNode> ignoredReferences) {
        ScheduledState currentState = this.getPhysicalScheduledState();
        if (currentState != ScheduledState.STOPPED && currentState != ScheduledState.DISABLED) {
            throw new IllegalStateException(this.getIdentifier() + " cannot be started because it is not stopped. Current state is " + currentState.name());
        }
        this.verifyNoActiveThreads();
        switch (this.getValidationStatus()) {
            case VALID: {
                return;
            }
            case VALIDATING: {
                throw new IllegalStateException("Processor with ID " + this.getIdentifier() + " cannot be started because its validation is still being performed");
            }
        }
        Collection validationErrors = this.getValidationErrors(ignoredReferences);
        if (ignoredReferences != null && !validationErrors.isEmpty()) {
            throw new IllegalStateException("Processor with ID " + this.getIdentifier() + " cannot be started because it is not currently valid");
        }
    }

    public void verifyCanStop() {
        if (this.getScheduledState() != ScheduledState.RUNNING) {
            throw new IllegalStateException(this.getIdentifier() + " is not scheduled to run");
        }
    }

    public void verifyCanUpdate() {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getIdentifier() + " is not stopped");
        }
    }

    public void verifyCanEnable() {
        if (this.getScheduledState() != ScheduledState.DISABLED) {
            throw new IllegalStateException(this.getIdentifier() + " is not disabled");
        }
        this.verifyNoActiveThreads();
    }

    public void verifyCanDisable() {
        if (this.getScheduledState() != ScheduledState.STOPPED) {
            throw new IllegalStateException(this.getIdentifier() + " is not stopped");
        }
        this.verifyNoActiveThreads();
    }

    public void verifyCanClearState() throws IllegalStateException {
        this.verifyCanUpdate();
    }

    private void verifyNoActiveThreads() throws IllegalStateException {
        int threadCount;
        if (this.hasActiveThreads && (threadCount = this.getActiveThreadCount()) > 0) {
            throw new IllegalStateException(this.getIdentifier() + " has " + threadCount + " threads still active");
        }
    }

    public void verifyModifiable() throws IllegalStateException {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify Processor configuration while the Processor is running");
        }
    }

    public void enable() {
        this.desiredState = ScheduledState.STOPPED;
        boolean updated = this.scheduledState.compareAndSet(ScheduledState.DISABLED, ScheduledState.STOPPED);
        if (updated) {
            LOG.info("{} enabled so ScheduledState transitioned from DISABLED to STOPPED", (Object)this);
        } else {
            LOG.info("{} enabled but not currently DISABLED so set desired state to STOPPED; current state is {}", (Object)this, this.scheduledState.get());
        }
    }

    public void disable() {
        this.desiredState = ScheduledState.DISABLED;
        boolean updated = this.scheduledState.compareAndSet(ScheduledState.STOPPED, ScheduledState.DISABLED);
        if (updated) {
            LOG.info("{} disabled so ScheduledState transitioned from STOPPED to DISABLED", (Object)this);
        } else {
            LOG.info("{} disabled but not currently STOPPED so set desired state to DISABLED; current state is {}", (Object)this, this.scheduledState.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ScheduledExecutorService taskScheduler, long administrativeYieldMillis, ProcessContext processContext, SchedulingAgentCallback schedulingAgentCallback, boolean failIfStopping) {
        boolean starting;
        ScheduledState currentState;
        switch (this.getValidationStatus()) {
            case INVALID: {
                throw new IllegalStateException("Processor " + this.getName() + " is not in a valid state due to " + this.getValidationErrors());
            }
            case VALIDATING: {
                throw new IllegalStateException("Processor " + this.getName() + " cannot be started because its validation is still being performed");
            }
        }
        Processor processor = this.processorRef.get().getProcessor();
        SimpleProcessLogger procLog = new SimpleProcessLogger(this.getIdentifier(), processor);
        StandardProcessorNode standardProcessorNode = this;
        synchronized (standardProcessorNode) {
            currentState = (ScheduledState)this.scheduledState.get();
            if (currentState == ScheduledState.STOPPED) {
                starting = this.scheduledState.compareAndSet(ScheduledState.STOPPED, ScheduledState.STARTING);
                if (starting) {
                    this.desiredState = ScheduledState.RUNNING;
                }
            } else {
                if (currentState == ScheduledState.STOPPING && !failIfStopping) {
                    this.desiredState = ScheduledState.RUNNING;
                    return;
                }
                starting = false;
            }
        }
        if (starting) {
            this.hasActiveThreads = true;
            this.initiateStart(taskScheduler, administrativeYieldMillis, processContext, schedulingAgentCallback);
        } else {
            String procName = this.processorRef.get().toString();
            LOG.warn("Cannot start {} because it is not currently stopped. Current state is {}", (Object)procName, (Object)currentState);
            procLog.warn("Cannot start {} because it is not currently stopped. Current state is {}", new Object[]{procName, currentState});
        }
    }

    private synchronized void activateThread() {
        Thread thread = Thread.currentThread();
        Long timestamp = System.currentTimeMillis();
        this.activeThreads.put(thread, new ActiveTask(timestamp));
    }

    private synchronized void deactivateThread() {
        this.activeThreads.remove(Thread.currentThread());
    }

    public synchronized List<ActiveThreadInfo> getActiveThreads() {
        long now = System.currentTimeMillis();
        ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] infos = mbean.dumpAllThreads(true, true);
        long[] deadlockedThreadIds = mbean.findDeadlockedThreads();
        long[] monitorDeadlockThreadIds = mbean.findMonitorDeadlockedThreads();
        Map threadInfoMap = Stream.of(infos).collect(Collectors.toMap(info -> info.getThreadId(), Function.identity(), (a, b) -> a));
        ArrayList<ActiveThreadInfo> threadList = new ArrayList<ActiveThreadInfo>(this.activeThreads.size());
        for (Map.Entry<Thread, ActiveTask> entry : this.activeThreads.entrySet()) {
            Thread thread = entry.getKey();
            ActiveTask activeTask = entry.getValue();
            Long timestamp = activeTask.getStartTime();
            long activeMillis = now - timestamp;
            ThreadInfo threadInfo = (ThreadInfo)threadInfoMap.get(thread.getId());
            String stackTrace = ThreadUtils.createStackTrace(thread, threadInfo, deadlockedThreadIds, monitorDeadlockThreadIds, activeMillis);
            ActiveThreadInfo activeThreadInfo = new ActiveThreadInfo(thread.getName(), stackTrace, activeMillis, activeTask.isTerminated());
            threadList.add(activeThreadInfo);
        }
        return threadList;
    }

    public synchronized int getTerminatedThreadCount() {
        return (int)this.activeThreads.values().stream().filter(ActiveTask::isTerminated).count();
    }

    public int terminate() {
        this.verifyCanTerminate();
        int count = 0;
        for (Map.Entry<Thread, ActiveTask> entry : this.activeThreads.entrySet()) {
            Thread thread = entry.getKey();
            ActiveTask activeTask = entry.getValue();
            if (!activeTask.isTerminated()) {
                activeTask.terminate();
                thread.setName(thread.getName() + " <Terminated Task>");
                ++count;
            }
            thread.interrupt();
        }
        this.getLogger().terminate();
        this.scheduledState.set(ScheduledState.STOPPED);
        this.hasActiveThreads = false;
        return count;
    }

    public boolean isTerminated(Thread thread) {
        ActiveTask activeTask = this.activeThreads.get(thread);
        if (activeTask == null) {
            return false;
        }
        return activeTask.isTerminated();
    }

    public void verifyCanTerminate() {
        if (this.getScheduledState() != ScheduledState.STOPPED) {
            throw new IllegalStateException("Processor is not stopped");
        }
    }

    private void initiateStart(ScheduledExecutorService taskScheduler, long administrativeYieldMillis, ProcessContext processContext, SchedulingAgentCallback schedulingAgentCallback) {
        Processor processor = this.getProcessor();
        SimpleProcessLogger procLog = new SimpleProcessLogger(this.getIdentifier(), processor);
        final AtomicLong completionTimestampRef = new AtomicLong(Long.MAX_VALUE);
        Callable<Void> startupTask = () -> {
            block42: {
                LOG.debug("Invoking @OnScheduled methods of {}", (Object)processor);
                completionTimestampRef.set(System.currentTimeMillis() + this.onScheduleTimeoutMillis);
                try (NarCloseable nc = NarCloseable.withComponentNarLoader(processor.getClass(), (String)processor.getIdentifier());){
                    try {
                        boolean disabled;
                        this.activateThread();
                        try {
                            ReflectionUtils.invokeMethodsWithAnnotation(OnScheduled.class, processor, processContext);
                        }
                        finally {
                            this.deactivateThread();
                        }
                        if (this.desiredState == ScheduledState.RUNNING && this.scheduledState.compareAndSet(ScheduledState.STARTING, ScheduledState.RUNNING)) {
                            LOG.debug("Successfully completed the @OnScheduled methods of {}; will now start triggering processor to run", (Object)processor);
                            schedulingAgentCallback.trigger();
                            break block42;
                        }
                        LOG.info("Successfully invoked @OnScheduled methods of {} but scheduled state is no longer STARTING so will stop processor now; current state = {}, desired state = {}", new Object[]{processor, this.scheduledState.get(), this.desiredState});
                        this.activateThread();
                        try {
                            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnUnscheduled.class, (Object)processor, processContext);
                            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnStopped.class, (Object)processor, processContext);
                            this.hasActiveThreads = false;
                        }
                        finally {
                            this.deactivateThread();
                        }
                        this.scheduledState.set(ScheduledState.STOPPED);
                        if (this.desiredState == ScheduledState.DISABLED && (disabled = this.scheduledState.compareAndSet(ScheduledState.STOPPED, ScheduledState.DISABLED))) {
                            LOG.info("After stopping {}, determined that Desired State is DISABLED so disabled processor", (Object)processor);
                        }
                    }
                    finally {
                        schedulingAgentCallback.onTaskComplete();
                    }
                }
                catch (Exception e) {
                    procLog.error("Failed to properly initialize Processor. If still scheduled to run, NiFi will attempt to initialize and run the Processor again after the 'Administrative Yield Duration' has elapsed. Failure is due to " + e, e);
                    try (NarCloseable nc2 = NarCloseable.withComponentNarLoader(processor.getClass(), (String)processor.getIdentifier());){
                        this.activateThread();
                        try {
                            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnUnscheduled.class, (Object)processor, processContext);
                            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnStopped.class, (Object)processor, processContext);
                            this.hasActiveThreads = false;
                        }
                        finally {
                            this.deactivateThread();
                        }
                    }
                    if (this.scheduledState.get() != ScheduledState.STOPPING) {
                        Runnable initiateStartTask = () -> this.initiateStart(taskScheduler, administrativeYieldMillis, processContext, schedulingAgentCallback);
                        taskScheduler.schedule(initiateStartTask, administrativeYieldMillis, TimeUnit.MILLISECONDS);
                    }
                    this.scheduledState.set(ScheduledState.STOPPED);
                }
            }
            return null;
        };
        final Future taskFuture = schedulingAgentCallback.scheduleTask(startupTask);
        final AtomicReference futureRef = new AtomicReference();
        Runnable monitoringTask = new Runnable(){

            @Override
            public void run() {
                Future monitoringFuture = (Future)futureRef.get();
                if (monitoringFuture == null) {
                    return;
                }
                StandardProcessorNode.this.monitorAsyncTask(taskFuture, monitoringFuture, completionTimestampRef.get());
            }
        };
        ScheduledFuture<?> future = taskScheduler.scheduleWithFixedDelay(monitoringTask, 1L, 10L, TimeUnit.MILLISECONDS);
        futureRef.set(future);
    }

    public CompletableFuture<Void> stop(final ProcessScheduler processScheduler, final ScheduledExecutorService executor, final ProcessContext processContext, final SchedulingAgent schedulingAgent, final LifecycleState scheduleState) {
        final Processor processor = this.processorRef.get().getProcessor();
        LOG.info("Stopping processor: " + processor.getClass());
        this.desiredState = ScheduledState.STOPPED;
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.scheduledState.compareAndSet(ScheduledState.RUNNING, ScheduledState.STOPPING)) {
            scheduleState.incrementActiveThreadCount(null);
            executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block41: {
                        try {
                            boolean allThreadsComplete;
                            if (scheduleState.isScheduled()) {
                                schedulingAgent.unschedule((Connectable)StandardProcessorNode.this, scheduleState);
                                StandardProcessorNode.this.activateThread();
                                try (NarCloseable nc = NarCloseable.withComponentNarLoader(processor.getClass(), (String)processor.getIdentifier());){
                                    ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnUnscheduled.class, (Object)processor, processContext);
                                }
                                finally {
                                    StandardProcessorNode.this.deactivateThread();
                                }
                            }
                            boolean bl = allThreadsComplete = scheduleState.getActiveThreadCount() == 1;
                            if (allThreadsComplete) {
                                StandardProcessorNode.this.activateThread();
                                try (NarCloseable nc = NarCloseable.withComponentNarLoader(processor.getClass(), (String)processor.getIdentifier());){
                                    ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnStopped.class, (Object)processor, processContext);
                                }
                                finally {
                                    StandardProcessorNode.this.deactivateThread();
                                }
                                scheduleState.decrementActiveThreadCount(null);
                                StandardProcessorNode.this.hasActiveThreads = false;
                                StandardProcessorNode.this.scheduledState.set(ScheduledState.STOPPED);
                                future.complete(null);
                                ScheduledState desired = StandardProcessorNode.this.desiredState;
                                if (desired == ScheduledState.RUNNING) {
                                    LOG.info("Finished stopping {} but desired state is now RUNNING so will start processor", (Object)this);
                                    processScheduler.startProcessor((ProcessorNode)StandardProcessorNode.this, true);
                                } else if (desired == ScheduledState.DISABLED) {
                                    boolean updated = StandardProcessorNode.this.scheduledState.compareAndSet(ScheduledState.STOPPED, ScheduledState.DISABLED);
                                    if (updated) {
                                        LOG.info("Finished stopping {} but desired state is now DISABLED so disabled processor", (Object)this);
                                    } else {
                                        LOG.info("Finished stopping {} but desired state is now DISABLED. Scheduled State could not be transitioned from STOPPED to DISABLED, though, so will allow the other thread to finish state transition. Current state is {}", (Object)this, StandardProcessorNode.this.scheduledState.get());
                                    }
                                }
                                break block41;
                            }
                            executor.schedule(this, 100L, TimeUnit.MILLISECONDS);
                        }
                        catch (Exception e) {
                            LOG.warn("Failed while shutting down processor " + processor, (Throwable)e);
                        }
                    }
                }
            });
        } else {
            this.scheduledState.compareAndSet(ScheduledState.STARTING, ScheduledState.STOPPING);
            future.complete(null);
        }
        return future;
    }

    private void monitorAsyncTask(Future<?> taskFuture, Future<?> monitoringFuture, long completionTimestamp) {
        if (taskFuture.isDone()) {
            monitoringFuture.cancel(false);
        } else if (System.currentTimeMillis() > completionTimestamp) {
            taskFuture.cancel(true);
            monitoringFuture.cancel(false);
            Processor processor = this.processorRef.get().getProcessor();
            LOG.warn("Timed out while waiting for OnScheduled of " + processor + " to finish. An attempt is made to cancel the task via Thread.interrupt(). However it does not guarantee that the task will be canceled since the code inside current OnScheduled operation may have been written to ignore interrupts which may result in a runaway thread. This could lead to more issues, eventually requiring NiFi to be restarted. This is usually a bug in the target Processor '" + processor + "' that needs to be documented, reported and eventually fixed.");
        }
    }

    public String getProcessGroupIdentifier() {
        ProcessGroup group = this.getProcessGroup();
        return group == null ? null : group.getIdentifier();
    }

    public Optional<String> getVersionedComponentId() {
        return Optional.ofNullable(this.versionedComponentId.get());
    }

    public void setVersionedComponentId(String versionedComponentId) {
        boolean updated = false;
        while (!updated) {
            String currentId = this.versionedComponentId.get();
            if (currentId == null) {
                updated = this.versionedComponentId.compareAndSet(null, versionedComponentId);
                continue;
            }
            if (currentId.equals(versionedComponentId)) {
                return;
            }
            if (versionedComponentId == null) {
                updated = this.versionedComponentId.compareAndSet(currentId, null);
                continue;
            }
            throw new IllegalStateException((Object)((Object)this) + " is already under version control");
        }
    }
}

