/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history;

import java.util.concurrent.TimeUnit;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.StandardMetricDescriptor;

public enum ProcessGroupStatusDescriptor {
    BYTES_READ(new StandardMetricDescriptor<ProcessGroupStatus>("bytesRead", "Bytes Read (5 mins)", "The total number of bytes read from Content Repository by Processors in this Process Group in the past 5 minutes", MetricDescriptor.Formatter.DATA_SIZE, s -> s.getBytesRead())),
    BYTES_WRITTEN(new StandardMetricDescriptor<ProcessGroupStatus>("bytesWritten", "Bytes Written (5 mins)", "The total number of bytes written to Content Repository by Processors in this Process Group in the past 5 minutes", MetricDescriptor.Formatter.DATA_SIZE, s -> s.getBytesWritten())),
    BYTES_TRANSFERRED(new StandardMetricDescriptor<ProcessGroupStatus>("bytesTransferred", "Bytes Transferred (5 mins)", "The total number of bytes read from or written to Content Repository by Processors in this Process Group in the past 5 minutes", MetricDescriptor.Formatter.DATA_SIZE, s -> s.getBytesRead() + s.getBytesWritten())),
    INPUT_BYTES(new StandardMetricDescriptor<ProcessGroupStatus>("inputBytes", "Bytes In (5 mins)", "The cumulative size of all FlowFiles that have entered this Process Group via its Input Ports in the past 5 minutes", MetricDescriptor.Formatter.DATA_SIZE, s -> s.getInputContentSize())),
    INPUT_COUNT(new StandardMetricDescriptor<ProcessGroupStatus>("inputCount", "FlowFiles In (5 mins)", "The number of FlowFiles that have entered this Process Group via its Input Ports in the past 5 minutes", MetricDescriptor.Formatter.COUNT, s -> s.getInputCount().longValue())),
    OUTPUT_BYTES(new StandardMetricDescriptor<ProcessGroupStatus>("outputBytes", "Bytes Out (5 mins)", "The cumulative size of all FlowFiles that have exited this Process Group via its Output Ports in the past 5 minutes", MetricDescriptor.Formatter.DATA_SIZE, s -> s.getOutputContentSize())),
    OUTPUT_COUNT(new StandardMetricDescriptor<ProcessGroupStatus>("outputCount", "FlowFiles Out (5 mins)", "The number of FlowFiles that have exited this Process Group via its Output Ports in the past 5 minutes", MetricDescriptor.Formatter.COUNT, s -> s.getOutputCount().longValue())),
    QUEUED_BYTES(new StandardMetricDescriptor<ProcessGroupStatus>("queuedBytes", "Queued Bytes", "The cumulative size of all FlowFiles queued in all Connections of this Process Group", MetricDescriptor.Formatter.DATA_SIZE, s -> s.getQueuedContentSize())),
    QUEUED_COUNT(new StandardMetricDescriptor<ProcessGroupStatus>("queuedCount", "Queued Count", "The number of FlowFiles queued in all Connections of this Process Group", MetricDescriptor.Formatter.COUNT, s -> s.getQueuedCount().longValue())),
    TASK_MILLIS(new StandardMetricDescriptor<ProcessGroupStatus>("taskMillis", "Total Task Duration (5 mins)", "The total number of thread-milliseconds that the Processors within this ProcessGroup have used to complete their tasks in the past 5 minutes", MetricDescriptor.Formatter.DURATION, s -> ProcessGroupStatusDescriptor.calculateTaskMillis(s)));

    private MetricDescriptor<ProcessGroupStatus> descriptor;

    private ProcessGroupStatusDescriptor(MetricDescriptor<ProcessGroupStatus> descriptor) {
        this.descriptor = descriptor;
    }

    public String getField() {
        return this.descriptor.getField();
    }

    public MetricDescriptor<ProcessGroupStatus> getDescriptor() {
        return this.descriptor;
    }

    private static long calculateTaskMillis(ProcessGroupStatus status) {
        long nanos = 0L;
        for (ProcessorStatus procStatus : status.getProcessorStatus()) {
            nanos += procStatus.getProcessingNanos();
        }
        for (ProcessGroupStatus childStatus : status.getProcessGroupStatus()) {
            nanos += ProcessGroupStatusDescriptor.calculateTaskMillis(childStatus);
        }
        return TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS);
    }
}

