/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.SSLContext;
import org.apache.nifi.framework.security.util.SslContextFactory;
import org.apache.nifi.registry.flow.FlowRegistry;
import org.apache.nifi.registry.flow.FlowRegistryClient;
import org.apache.nifi.registry.flow.RestBasedFlowRegistry;
import org.apache.nifi.util.NiFiProperties;

public class StandardFlowRegistryClient
implements FlowRegistryClient {
    private NiFiProperties nifiProperties;
    private ConcurrentMap<String, FlowRegistry> registryById = new ConcurrentHashMap<String, FlowRegistry>();

    public FlowRegistry getFlowRegistry(String registryId) {
        return (FlowRegistry)this.registryById.get(registryId);
    }

    public Set<String> getRegistryIdentifiers() {
        return this.registryById.keySet();
    }

    public void addFlowRegistry(FlowRegistry registry) {
        boolean duplicateName = this.registryById.values().stream().anyMatch(reg -> reg.getName().equals(registry.getName()));
        if (duplicateName) {
            throw new IllegalStateException("Cannot add Flow Registry because a Flow Registry already exists with the name " + registry.getName());
        }
        FlowRegistry existing = this.registryById.putIfAbsent(registry.getIdentifier(), registry);
        if (existing != null) {
            throw new IllegalStateException("Cannot add Flow Registry " + registry + " because a Flow Registry already exists with the ID " + registry.getIdentifier());
        }
    }

    public FlowRegistry addFlowRegistry(String registryId, String registryName, String registryUrl, String description) {
        SSLContext sslContext;
        URI uri;
        try {
            uri = new URI(registryUrl);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("The given Registry URL is not valid: " + registryUrl);
        }
        String uriScheme = uri.getScheme();
        if (uriScheme == null) {
            throw new IllegalArgumentException("The given Registry URL is not valid: " + registryUrl);
        }
        if (uriScheme.equalsIgnoreCase("http") || uriScheme.equalsIgnoreCase("https")) {
            sslContext = SslContextFactory.createSslContext((NiFiProperties)this.nifiProperties, (boolean)false);
            if (sslContext == null && uriScheme.equalsIgnoreCase("https")) {
                throw new IllegalStateException("Failed to create Flow Registry for URI " + registryUrl + " because this NiFi is not configured with a Keystore/Truststore, so it is not capable of communicating with a secure Registry. Please populate NiFi's Keystore/Truststore properties or connect to a NiFi Registry over http instead of https.");
            }
        } else {
            throw new IllegalArgumentException("Cannot create Flow Registry with URI of " + registryUrl + " because there are no known implementations of Flow Registries that can handle URIs of scheme " + uriScheme);
        }
        RestBasedFlowRegistry registry = new RestBasedFlowRegistry(this, registryId, registryUrl, sslContext, registryName);
        registry.setDescription(description);
        this.addFlowRegistry(registry);
        return registry;
    }

    public FlowRegistry removeFlowRegistry(String registryId) {
        return (FlowRegistry)this.registryById.remove(registryId);
    }

    public void setProperties(NiFiProperties nifiProperties) {
        this.nifiProperties = nifiProperties;
    }
}

