/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.components.validation;

import org.apache.nifi.components.validation.ValidationTrigger;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.FlowController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerValidationTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(TriggerValidationTask.class);
    private final FlowController controller;
    private final ValidationTrigger validationTrigger;

    public TriggerValidationTask(FlowController controller, ValidationTrigger validationTrigger) {
        this.controller = controller;
        this.validationTrigger = validationTrigger;
    }

    @Override
    public void run() {
        try {
            logger.debug("Triggering validation of all components");
            for (ComponentNode componentNode : this.controller.getAllControllerServices()) {
                this.validationTrigger.trigger(componentNode);
            }
            for (ComponentNode componentNode : this.controller.getAllReportingTasks()) {
                this.validationTrigger.trigger(componentNode);
            }
            for (ComponentNode componentNode : this.controller.getRootGroup().findAllProcessors()) {
                this.validationTrigger.trigger(componentNode);
            }
        }
        catch (Throwable t) {
            logger.error("Encountered unexpected error when attempting to validate components", t);
        }
    }
}

