/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.AuthorizerCapabilityDetection;
import org.apache.nifi.authorization.ManagedAuthorizer;
import org.apache.nifi.authorization.exception.UninheritableAuthorizationsException;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.cluster.protocol.DataFlow;
import org.apache.nifi.cluster.protocol.StandardDataFlow;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.connectable.Size;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.MissingBundleException;
import org.apache.nifi.controller.PositionScaler;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.SnippetManager;
import org.apache.nifi.controller.StandardSnippet;
import org.apache.nifi.controller.Template;
import org.apache.nifi.controller.TemplateUtils;
import org.apache.nifi.controller.Triggerable;
import org.apache.nifi.controller.UninheritableFlowException;
import org.apache.nifi.controller.exception.ProcessorInstantiationException;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.controller.queue.LoadBalanceCompression;
import org.apache.nifi.controller.queue.LoadBalanceStrategy;
import org.apache.nifi.controller.reporting.ReportingTaskInstantiationException;
import org.apache.nifi.controller.reporting.StandardReportingInitializationContext;
import org.apache.nifi.controller.serialization.FlowEncodingVersion;
import org.apache.nifi.controller.serialization.FlowFromDOMFactory;
import org.apache.nifi.controller.serialization.FlowSerializationException;
import org.apache.nifi.controller.serialization.FlowSynchronizationException;
import org.apache.nifi.controller.serialization.FlowSynchronizer;
import org.apache.nifi.controller.serialization.StandardFlowSerializer;
import org.apache.nifi.controller.service.ControllerServiceLoader;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.encrypt.StringEncryptor;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.fingerprint.FingerprintException;
import org.apache.nifi.fingerprint.FingerprintFactory;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroupPortDescriptor;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.registry.flow.FlowRegistry;
import org.apache.nifi.registry.flow.FlowRegistryClient;
import org.apache.nifi.registry.flow.StandardVersionControlInformation;
import org.apache.nifi.registry.flow.VersionControlInformation;
import org.apache.nifi.registry.flow.VersionedFlowState;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.remote.RootGroupPort;
import org.apache.nifi.remote.protocol.SiteToSiteTransportProtocol;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.reporting.ReportingInitializationContext;
import org.apache.nifi.reporting.Severity;
import org.apache.nifi.scheduling.ExecutionNode;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.util.BundleUtils;
import org.apache.nifi.util.DomUtils;
import org.apache.nifi.util.LoggingXmlParserErrorHandler;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.file.FileUtils;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ConnectableDTO;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.api.dto.FunnelDTO;
import org.apache.nifi.web.api.dto.LabelDTO;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.api.dto.PositionDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.ProcessorConfigDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.ReportingTaskDTO;
import org.apache.nifi.web.api.dto.TemplateDTO;
import org.apache.nifi.web.api.dto.VersionControlInformationDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StandardFlowSynchronizer
implements FlowSynchronizer {
    private static final Logger logger = LoggerFactory.getLogger(StandardFlowSynchronizer.class);
    public static final URL FLOW_XSD_RESOURCE = StandardFlowSynchronizer.class.getResource("/FlowConfiguration.xsd");
    private final StringEncryptor encryptor;
    private final boolean autoResumeState;
    private final NiFiProperties nifiProperties;

    public StandardFlowSynchronizer(StringEncryptor encryptor, NiFiProperties nifiProperties) {
        this.encryptor = encryptor;
        this.autoResumeState = nifiProperties.getAutoResumeState();
        this.nifiProperties = nifiProperties;
    }

    public static boolean isEmpty(DataFlow dataFlow) {
        if (dataFlow == null || dataFlow.getFlow() == null || dataFlow.getFlow().length == 0) {
            return true;
        }
        Document document = StandardFlowSynchronizer.parseFlowBytes(dataFlow.getFlow());
        Element rootElement = document.getDocumentElement();
        Element rootGroupElement = (Element)rootElement.getElementsByTagName("rootGroup").item(0);
        FlowEncodingVersion encodingVersion = FlowEncodingVersion.parse(rootGroupElement);
        ProcessGroupDTO rootGroupDto = FlowFromDOMFactory.getProcessGroup(null, rootGroupElement, null, encodingVersion);
        NodeList reportingTasks = rootElement.getElementsByTagName("reportingTask");
        ReportingTaskDTO reportingTaskDTO = reportingTasks.getLength() == 0 ? null : FlowFromDOMFactory.getReportingTask((Element)reportingTasks.item(0), null);
        NodeList controllerServices = rootElement.getElementsByTagName("controllerService");
        ControllerServiceDTO controllerServiceDTO = controllerServices.getLength() == 0 ? null : FlowFromDOMFactory.getControllerService((Element)controllerServices.item(0), null);
        return StandardFlowSynchronizer.isEmpty(rootGroupDto) && StandardFlowSynchronizer.isEmpty(reportingTaskDTO) && StandardFlowSynchronizer.isEmpty(controllerServiceDTO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync(FlowController controller, DataFlow proposedFlow, StringEncryptor encryptor) throws FlowSerializationException, UninheritableFlowException, FlowSynchronizationException, MissingBundleException {
        byte[] existingAuthFingerprint;
        ManagedAuthorizer managedAuthorizer;
        Node registriesElement;
        boolean existingFlowEmpty;
        byte[] existingFlow;
        if (proposedFlow == null) {
            if (controller.getGroup(controller.getRootGroupId()).isEmpty()) {
                return;
            }
            throw new UninheritableFlowException("Proposed configuration is empty, but the controller contains a data flow.");
        }
        boolean flowAlreadySynchronized = controller.isFlowSynchronized();
        logger.debug("Synching FlowController with proposed flow: Controller is Already Synchronized = {}", (Object)flowAlreadySynchronized);
        try {
            if (flowAlreadySynchronized) {
                existingFlow = this.toBytes(controller);
                existingFlowEmpty = controller.getGroup(controller.getRootGroupId()).isEmpty() && controller.getAllReportingTasks().isEmpty() && controller.getAllControllerServices().isEmpty() && controller.getFlowRegistryClient().getRegistryIdentifiers().isEmpty();
            } else {
                existingFlow = this.readFlowFromDisk();
                if (existingFlow == null || existingFlow.length == 0) {
                    existingFlowEmpty = true;
                } else {
                    List<Element> flowRegistryElems;
                    Document document = StandardFlowSynchronizer.parseFlowBytes(existingFlow);
                    Element rootElement = document.getDocumentElement();
                    FlowEncodingVersion encodingVersion = FlowEncodingVersion.parse(rootElement);
                    logger.trace("Setting controller thread counts");
                    Integer maxThreadCount = StandardFlowSynchronizer.getInteger(rootElement, "maxThreadCount");
                    if (maxThreadCount == null) {
                        controller.setMaxTimerDrivenThreadCount(StandardFlowSynchronizer.getInt(rootElement, "maxTimerDrivenThreadCount"));
                        controller.setMaxEventDrivenThreadCount(StandardFlowSynchronizer.getInt(rootElement, "maxEventDrivenThreadCount"));
                    } else {
                        controller.setMaxTimerDrivenThreadCount(maxThreadCount * 2 / 3);
                        controller.setMaxEventDrivenThreadCount(maxThreadCount / 3);
                    }
                    Element reportingTasksElement = DomUtils.getChild(rootElement, "reportingTasks");
                    List<Object> taskElements = reportingTasksElement == null ? Collections.emptyList() : DomUtils.getChildElementsByTagName(reportingTasksElement, "reportingTask");
                    Element controllerServicesElement = DomUtils.getChild(rootElement, "controllerServices");
                    List<Object> unrootedControllerServiceElements = controllerServicesElement == null ? Collections.emptyList() : DomUtils.getChildElementsByTagName(controllerServicesElement, "controllerService");
                    registriesElement = DomUtils.getChild(rootElement, "registries");
                    boolean registriesPresent = registriesElement == null ? false : !(flowRegistryElems = DomUtils.getChildElementsByTagName(registriesElement, "flowRegistry")).isEmpty();
                    logger.trace("Parsing process group from DOM");
                    Element rootGroupElement = (Element)rootElement.getElementsByTagName("rootGroup").item(0);
                    ProcessGroupDTO rootGroupDto = FlowFromDOMFactory.getProcessGroup(null, rootGroupElement, encryptor, encodingVersion);
                    existingFlowEmpty = taskElements.isEmpty() && unrootedControllerServiceElements.isEmpty() && StandardFlowSynchronizer.isEmpty(rootGroupDto) && !registriesPresent;
                    logger.debug("Existing Flow Empty = {}", (Object)existingFlowEmpty);
                }
            }
        }
        catch (IOException e2) {
            throw new FlowSerializationException(e2);
        }
        logger.trace("Exporting snippets from controller");
        byte[] existingSnippets = controller.getSnippetManager().export();
        logger.trace("Getting Authorizer fingerprint from controller");
        Authorizer authorizer = controller.getAuthorizer();
        if (AuthorizerCapabilityDetection.isManagedAuthorizer((Authorizer)authorizer)) {
            managedAuthorizer = (ManagedAuthorizer)authorizer;
            existingAuthFingerprint = managedAuthorizer.getFingerprint().getBytes(StandardCharsets.UTF_8);
        } else {
            existingAuthFingerprint = null;
            managedAuthorizer = null;
        }
        HashSet missingComponents = new HashSet();
        controller.getAllControllerServices().stream().filter(cs -> cs.isExtensionMissing()).forEach(cs -> missingComponents.add(cs.getIdentifier()));
        controller.getAllReportingTasks().stream().filter(r -> r.isExtensionMissing()).forEach(r -> missingComponents.add(r.getIdentifier()));
        controller.getRootGroup().findAllProcessors().stream().filter(p -> p.isExtensionMissing()).forEach(p -> missingComponents.add(p.getIdentifier()));
        StandardDataFlow existingDataFlow = new StandardDataFlow(existingFlow, existingSnippets, existingAuthFingerprint, missingComponents);
        Document configuration = null;
        try {
            if (existingFlowEmpty) {
                configuration = StandardFlowSynchronizer.parseFlowBytes(proposedFlow.getFlow());
                if (configuration != null) {
                    logger.trace("Checking bundle compatibility");
                    this.checkBundleCompatibility(configuration);
                }
            } else {
                logger.trace("Checking flow inheritability");
                String problemInheritingFlow = this.checkFlowInheritability((DataFlow)existingDataFlow, proposedFlow, controller);
                if (problemInheritingFlow != null) {
                    throw new UninheritableFlowException("Proposed configuration is not inheritable by the flow controller because of flow differences: " + problemInheritingFlow);
                }
            }
        }
        catch (FingerprintException fe) {
            throw new FlowSerializationException("Failed to generate flow fingerprints", fe);
        }
        logger.trace("Checking missing component inheritability");
        String problemInheritingMissingComponents = this.checkMissingComponentsInheritability((DataFlow)existingDataFlow, proposedFlow);
        if (problemInheritingMissingComponents != null) {
            throw new UninheritableFlowException("Proposed Flow is not inheritable by the flow controller because of differences in missing components: " + problemInheritingMissingComponents);
        }
        logger.trace("Checking authorizer inheritability");
        AuthorizerInheritability authInheritability = this.checkAuthorizerInheritability(authorizer, (DataFlow)existingDataFlow, proposedFlow);
        if (!authInheritability.isInheritable() && authInheritability.getReason() != null) {
            throw new UninheritableFlowException("Proposed Authorizer is not inheritable by the flow controller because of Authorizer differences: " + authInheritability.getReason());
        }
        logger.trace("Parsing proposed flow bytes as DOM document");
        if (configuration == null) {
            configuration = StandardFlowSynchronizer.parseFlowBytes(proposedFlow.getFlow());
        }
        try {
            if (configuration != null) {
                registriesElement = configuration;
                synchronized (registriesElement) {
                    Element existingRootElement;
                    ProcessGroup rootGroup;
                    Element registriesElement2;
                    Element rootElement = (Element)configuration.getElementsByTagName("flowController").item(0);
                    FlowEncodingVersion encodingVersion = FlowEncodingVersion.parse(rootElement);
                    logger.trace("Updating flow config");
                    Integer maxThreadCount = StandardFlowSynchronizer.getInteger(rootElement, "maxThreadCount");
                    if (maxThreadCount == null) {
                        controller.setMaxTimerDrivenThreadCount(StandardFlowSynchronizer.getInt(rootElement, "maxTimerDrivenThreadCount"));
                        controller.setMaxEventDrivenThreadCount(StandardFlowSynchronizer.getInt(rootElement, "maxEventDrivenThreadCount"));
                    } else {
                        controller.setMaxTimerDrivenThreadCount(maxThreadCount * 2 / 3);
                        controller.setMaxEventDrivenThreadCount(maxThreadCount / 3);
                    }
                    Element rootGroupElement = (Element)rootElement.getElementsByTagName("rootGroup").item(0);
                    if ((!flowAlreadySynchronized || existingFlowEmpty) && (registriesElement2 = DomUtils.getChild(rootElement, "registries")) != null) {
                        List<Element> flowRegistryElems = DomUtils.getChildElementsByTagName(registriesElement2, "flowRegistry");
                        for (Element flowRegistryElement : flowRegistryElems) {
                            String registryId = StandardFlowSynchronizer.getString(flowRegistryElement, "id");
                            String registryName = StandardFlowSynchronizer.getString(flowRegistryElement, "name");
                            String registryUrl = StandardFlowSynchronizer.getString(flowRegistryElement, "url");
                            String description = StandardFlowSynchronizer.getString(flowRegistryElement, "description");
                            FlowRegistryClient client = controller.getFlowRegistryClient();
                            client.addFlowRegistry(registryId, registryName, registryUrl, description);
                        }
                    }
                    if (!flowAlreadySynchronized || existingFlowEmpty) {
                        logger.trace("Adding root process group");
                        rootGroup = this.addProcessGroup(controller, null, rootGroupElement, encryptor, encodingVersion);
                    } else {
                        logger.trace("Updating root process group");
                        rootGroup = this.updateProcessGroup(controller, null, rootGroupElement, encryptor, encodingVersion);
                    }
                    rootGroup.findAllRemoteProcessGroups().forEach(RemoteProcessGroup::initialize);
                    Document existingFlowConfiguration = StandardFlowSynchronizer.parseFlowBytes(existingFlow);
                    if (existingFlowConfiguration != null && (existingRootElement = (Element)existingFlowConfiguration.getElementsByTagName("flowController").item(0)) != null) {
                        Element existingRootGroupElement = (Element)existingRootElement.getElementsByTagName("rootGroup").item(0);
                        if (existingRootElement != null) {
                            FlowEncodingVersion existingEncodingVersion = FlowEncodingVersion.parse(existingFlowConfiguration.getDocumentElement());
                            this.addLocalTemplates(existingRootGroupElement, rootGroup, existingEncodingVersion);
                        }
                    }
                    Element reportingTasksElement = DomUtils.getChild(rootElement, "reportingTasks");
                    ArrayList<Element> reportingTaskElements = new ArrayList<Element>();
                    if (reportingTasksElement != null) {
                        reportingTaskElements.addAll(DomUtils.getChildElementsByTagName(reportingTasksElement, "reportingTask"));
                    }
                    HashMap<ReportingTaskNode, ReportingTaskDTO> reportingTaskNodesToDTOs = new HashMap<ReportingTaskNode, ReportingTaskDTO>();
                    for (Element taskElement : reportingTaskElements) {
                        ReportingTaskDTO dto = FlowFromDOMFactory.getReportingTask(taskElement, encryptor);
                        ReportingTaskNode reportingTask = this.getOrCreateReportingTask(controller, dto, flowAlreadySynchronized, existingFlowEmpty);
                        reportingTaskNodesToDTOs.put(reportingTask, dto);
                    }
                    Element controllerServicesElement = DomUtils.getChild(rootElement, "controllerServices");
                    if (controllerServicesElement != null) {
                        List<Element> serviceElements = DomUtils.getChildElementsByTagName(controllerServicesElement, "controllerService");
                        if (!flowAlreadySynchronized || existingFlowEmpty) {
                            ProcessGroup group = encodingVersion == null ? rootGroup : null;
                            Map<ControllerServiceNode, Element> controllerServices = ControllerServiceLoader.loadControllerServices(serviceElements, controller, group, encryptor);
                            if (group != null) {
                                Set controllerServicesInReportingTasks = reportingTaskNodesToDTOs.keySet().stream().flatMap(r -> r.getProperties().entrySet().stream()).filter(e -> ((PropertyDescriptor)e.getKey()).getControllerServiceDefinition() != null).map(e -> (String)e.getValue()).collect(Collectors.toSet());
                                Set controllerServicesToClone = controllerServices.keySet().stream().filter(cs -> controllerServicesInReportingTasks.contains(cs.getIdentifier())).collect(Collectors.toSet());
                                HashMap<String, ControllerServiceNode> controllerServiceMapping = new HashMap<String, ControllerServiceNode>();
                                for (ControllerServiceNode controllerService : controllerServicesToClone) {
                                    ControllerServiceNode clone = ControllerServiceLoader.cloneControllerService(controller, controllerService);
                                    controller.addRootControllerService(clone);
                                    controllerServiceMapping.put(controllerService.getIdentifier(), clone);
                                }
                                this.updateReportingTaskControllerServices(reportingTaskNodesToDTOs.keySet(), controllerServiceMapping);
                                ControllerServiceLoader.enableControllerServices(controllerServiceMapping.values(), controller, this.autoResumeState);
                            }
                            ControllerServiceLoader.enableControllerServices(controllerServices, controller, encryptor, this.autoResumeState);
                        }
                    }
                    this.scaleRootGroup(rootGroup, encodingVersion);
                    for (Map.Entry entry : reportingTaskNodesToDTOs.entrySet()) {
                        this.applyReportingTaskScheduleState(controller, (ReportingTaskDTO)entry.getValue(), (ReportingTaskNode)entry.getKey(), flowAlreadySynchronized, existingFlowEmpty);
                    }
                }
            }
            logger.trace("Clearing existing snippets");
            SnippetManager snippetManager = controller.getSnippetManager();
            snippetManager.clear();
            logger.trace("Loading proposed snippets");
            byte[] proposedSnippets = proposedFlow.getSnippets();
            if (proposedSnippets != null && proposedSnippets.length > 0) {
                for (StandardSnippet snippet : SnippetManager.parseBytes(proposedSnippets)) {
                    snippetManager.addSnippet(snippet);
                }
            }
            if (authInheritability.isInheritable() && managedAuthorizer != null) {
                logger.trace("Inheriting authorizations");
                String proposedAuthFingerprint = new String(proposedFlow.getAuthorizerFingerprint(), StandardCharsets.UTF_8);
                managedAuthorizer.inheritFingerprint(proposedAuthFingerprint);
            }
            logger.debug("Finished syncing flows");
        }
        catch (Exception ex) {
            throw new FlowSynchronizationException(ex);
        }
    }

    private void checkBundleCompatibility(Document configuration) {
        NodeList bundleNodes = configuration.getElementsByTagName("bundle");
        for (int i = 0; i < bundleNodes.getLength(); ++i) {
            Element componentElement;
            Element bundleElement;
            Node componentNode;
            Node bundleNode = bundleNodes.item(i);
            if (!(bundleNode instanceof Element) || !((componentNode = (bundleElement = (Element)bundleNode).getParentNode()) instanceof Element) || this.withinTemplate(componentElement = (Element)componentNode)) continue;
            String componentType = DomUtils.getChildText(componentElement, "class");
            try {
                BundleUtils.getBundle(componentType, FlowFromDOMFactory.getBundle(bundleElement));
                continue;
            }
            catch (IllegalStateException e) {
                throw new MissingBundleException(e.getMessage(), e);
            }
        }
    }

    private boolean withinTemplate(Element element) {
        if ("template".equals(element.getTagName())) {
            return true;
        }
        Node parentNode = element.getParentNode();
        if (parentNode instanceof Element) {
            return this.withinTemplate((Element)parentNode);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateReportingTaskControllerServices(Set<ReportingTaskNode> reportingTasks, Map<String, ControllerServiceNode> controllerServiceMapping) {
        for (ReportingTaskNode reportingTask : reportingTasks) {
            if (reportingTask.getProperties() == null) continue;
            reportingTask.pauseValidationTrigger();
            try {
                Set propertyDescriptors = reportingTask.getProperties().entrySet().stream().filter(e -> ((PropertyDescriptor)e.getKey()).getControllerServiceDefinition() != null).filter(e -> controllerServiceMapping.containsKey(e.getValue())).collect(Collectors.toSet());
                HashMap<String, String> controllerServiceProps = new HashMap<String, String>();
                for (Map.Entry propEntry : propertyDescriptors) {
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)propEntry.getKey();
                    ControllerServiceNode clone = controllerServiceMapping.get(propEntry.getValue());
                    controllerServiceProps.put(propertyDescriptor.getName(), clone.getIdentifier());
                }
                reportingTask.setProperties(controllerServiceProps);
            }
            finally {
                reportingTask.resumeValidationTrigger();
            }
        }
    }

    private void addLocalTemplates(Element processGroupElement, ProcessGroup processGroup, FlowEncodingVersion encodingVersion) {
        List<Element> templateNodeList = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "template");
        if (templateNodeList != null) {
            for (Element templateElement : templateNodeList) {
                TemplateDTO templateDto = TemplateUtils.parseDto(templateElement);
                Template template = new Template(templateDto);
                if (processGroup.getTemplate(template.getIdentifier()) != null) continue;
                processGroup.addTemplate(template);
            }
        }
        List<Element> childGroupElements = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "processGroup");
        for (Element childGroupElement : childGroupElements) {
            String childGroupId = StandardFlowSynchronizer.getString(childGroupElement, "id");
            ProcessGroup childGroup = processGroup.getProcessGroup(childGroupId);
            this.addLocalTemplates(childGroupElement, childGroup, encodingVersion);
        }
    }

    void scaleRootGroup(ProcessGroup rootGroup, FlowEncodingVersion encodingVersion) {
        if (encodingVersion == null || encodingVersion.getMajorVersion() < 1) {
            PositionScaler.scale(rootGroup, 1.5, 1.34);
        }
    }

    private static boolean isEmpty(ProcessGroupDTO dto) {
        if (dto == null) {
            return true;
        }
        FlowSnippetDTO contents = dto.getContents();
        if (contents == null) {
            return true;
        }
        return CollectionUtils.isEmpty((Collection)contents.getProcessors()) && CollectionUtils.isEmpty((Collection)contents.getConnections()) && CollectionUtils.isEmpty((Collection)contents.getFunnels()) && CollectionUtils.isEmpty((Collection)contents.getLabels()) && CollectionUtils.isEmpty((Collection)contents.getOutputPorts()) && CollectionUtils.isEmpty((Collection)contents.getProcessGroups()) && CollectionUtils.isEmpty((Collection)contents.getProcessors()) && CollectionUtils.isEmpty((Collection)contents.getRemoteProcessGroups());
    }

    private static boolean isEmpty(ReportingTaskDTO reportingTaskDTO) {
        return reportingTaskDTO == null || StringUtils.isEmpty((CharSequence)reportingTaskDTO.getName());
    }

    private static boolean isEmpty(ControllerServiceDTO controllerServiceDTO) {
        return controllerServiceDTO == null || StringUtils.isEmpty((CharSequence)controllerServiceDTO.getName());
    }

    private static Document parseFlowBytes(byte[] flow) throws FlowSerializationException {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(FLOW_XSD_RESOURCE);
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            docFactory.setSchema(schema);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            docBuilder.setErrorHandler(new LoggingXmlParserErrorHandler("Flow Configuration", logger));
            return flow == null || flow.length == 0 ? null : docBuilder.parse(new ByteArrayInputStream(flow));
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            throw new FlowSerializationException(ex);
        }
    }

    private byte[] readFlowFromDisk() throws IOException {
        Path flowPath = this.nifiProperties.getFlowConfigurationFile().toPath();
        if (!Files.exists(flowPath, new LinkOption[0]) || Files.size(flowPath) == 0L) {
            return new byte[0];
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream in = Files.newInputStream(flowPath, StandardOpenOption.READ);
             GZIPInputStream gzipIn = new GZIPInputStream(in);){
            FileUtils.copy((InputStream)gzipIn, (OutputStream)baos);
        }
        return baos.toByteArray();
    }

    private ReportingTaskNode getOrCreateReportingTask(FlowController controller, ReportingTaskDTO dto, boolean controllerInitialized, boolean existingFlowEmpty) throws ReportingTaskInstantiationException {
        if (!controllerInitialized || existingFlowEmpty) {
            BundleCoordinate coordinate;
            try {
                coordinate = BundleUtils.getCompatibleBundle(dto.getType(), dto.getBundle());
            }
            catch (IllegalStateException e) {
                BundleDTO bundleDTO = dto.getBundle();
                coordinate = bundleDTO == null ? BundleCoordinate.UNKNOWN_COORDINATE : new BundleCoordinate(bundleDTO.getGroup(), bundleDTO.getArtifact(), bundleDTO.getVersion());
            }
            ReportingTaskNode reportingTask = controller.createReportingTask(dto.getType(), dto.getId(), coordinate, false);
            reportingTask.setName(dto.getName());
            reportingTask.setComments(dto.getComments());
            reportingTask.setSchedulingPeriod(dto.getSchedulingPeriod());
            reportingTask.setSchedulingStrategy(SchedulingStrategy.valueOf((String)dto.getSchedulingStrategy()));
            reportingTask.setAnnotationData(dto.getAnnotationData());
            reportingTask.setProperties(dto.getProperties());
            SimpleProcessLogger componentLog = new SimpleProcessLogger(dto.getId(), reportingTask.getReportingTask());
            StandardReportingInitializationContext config = new StandardReportingInitializationContext(dto.getId(), dto.getName(), SchedulingStrategy.valueOf((String)dto.getSchedulingStrategy()), dto.getSchedulingPeriod(), componentLog, controller, this.nifiProperties, controller);
            try {
                reportingTask.getReportingTask().initialize((ReportingInitializationContext)config);
            }
            catch (InitializationException ie) {
                throw new ReportingTaskInstantiationException("Failed to initialize reporting task of type " + dto.getType(), (Throwable)ie);
            }
            return reportingTask;
        }
        return controller.getReportingTaskNode(dto.getId());
    }

    private void applyReportingTaskScheduleState(FlowController controller, ReportingTaskDTO dto, ReportingTaskNode reportingTask, boolean controllerInitialized, boolean existingFlowEmpty) {
        if (!controllerInitialized || existingFlowEmpty) {
            this.applyNewReportingTaskScheduleState(controller, dto, reportingTask);
        } else {
            this.applyExistingReportingTaskScheduleState(controller, dto, reportingTask);
        }
    }

    private void applyNewReportingTaskScheduleState(FlowController controller, ReportingTaskDTO dto, ReportingTaskNode reportingTask) {
        if (this.autoResumeState) {
            if (ScheduledState.RUNNING.name().equals(dto.getState())) {
                try {
                    controller.startReportingTask(reportingTask);
                }
                catch (Exception e) {
                    logger.error("Failed to start {} due to {}", (Object)reportingTask, (Object)e);
                    if (logger.isDebugEnabled()) {
                        logger.error("", (Throwable)e);
                    }
                    controller.getBulletinRepository().addBulletin(BulletinFactory.createBulletin((String)"Reporting Tasks", (String)Severity.ERROR.name(), (String)("Failed to start " + reportingTask + " due to " + e)));
                }
            } else if (ScheduledState.DISABLED.name().equals(dto.getState())) {
                try {
                    controller.disableReportingTask(reportingTask);
                }
                catch (Exception e) {
                    logger.error("Failed to mark {} as disabled due to {}", (Object)reportingTask, (Object)e);
                    if (logger.isDebugEnabled()) {
                        logger.error("", (Throwable)e);
                    }
                    controller.getBulletinRepository().addBulletin(BulletinFactory.createBulletin((String)"Reporting Tasks", (String)Severity.ERROR.name(), (String)("Failed to mark " + reportingTask + " as disabled due to " + e)));
                }
            }
        }
    }

    private void applyExistingReportingTaskScheduleState(FlowController controller, ReportingTaskDTO dto, ReportingTaskNode taskNode) {
        if (!taskNode.getScheduledState().name().equals(dto.getState())) {
            try {
                switch (ScheduledState.valueOf((String)dto.getState())) {
                    case DISABLED: {
                        if (taskNode.isRunning()) {
                            controller.stopReportingTask(taskNode);
                        }
                        controller.disableReportingTask(taskNode);
                        break;
                    }
                    case RUNNING: {
                        if (taskNode.getScheduledState() == ScheduledState.DISABLED) {
                            controller.enableReportingTask(taskNode);
                        }
                        controller.startReportingTask(taskNode);
                        break;
                    }
                    case STOPPED: {
                        if (taskNode.getScheduledState() == ScheduledState.DISABLED) {
                            controller.enableReportingTask(taskNode);
                            break;
                        }
                        if (taskNode.getScheduledState() != ScheduledState.RUNNING) break;
                        controller.stopReportingTask(taskNode);
                    }
                }
            }
            catch (IllegalStateException ise) {
                logger.error("Failed to change Scheduled State of {} from {} to {} due to {}", new Object[]{taskNode, taskNode.getScheduledState().name(), dto.getState(), ise.toString()});
                logger.error("", (Throwable)ise);
                controller.getBulletinRepository().addBulletin(BulletinFactory.createBulletin((String)"Node Reconnection", (String)Severity.ERROR.name(), (String)("Failed to change Scheduled State of " + taskNode + " from " + taskNode.getScheduledState().name() + " to " + dto.getState() + " due to " + ise.toString())));
                controller.getBulletinRepository().addBulletin(BulletinFactory.createBulletin((String)"Node Reconnection", (String)Severity.ERROR.name(), (String)("Failed to change Scheduled State of " + taskNode + " from " + taskNode.getScheduledState().name() + " to " + dto.getState() + " due to " + ise.toString())));
            }
        }
    }

    private ControllerServiceState getFinalTransitionState(ControllerServiceState state) {
        switch (state) {
            case DISABLED: 
            case DISABLING: {
                return ControllerServiceState.DISABLED;
            }
            case ENABLED: 
            case ENABLING: {
                return ControllerServiceState.ENABLED;
            }
        }
        throw new AssertionError();
    }

    private ProcessGroup updateProcessGroup(FlowController controller, ProcessGroup parentGroup, Element processGroupElement, StringEncryptor encryptor, FlowEncodingVersion encodingVersion) throws ProcessorInstantiationException {
        String parentId = parentGroup == null ? null : parentGroup.getIdentifier();
        ProcessGroupDTO processGroupDto = FlowFromDOMFactory.getProcessGroup(parentId, processGroupElement, encryptor, encodingVersion);
        if (parentId == null) {
            ProcessGroup root = controller.getGroup(controller.getRootGroupId());
            for (Label label : root.findAllLabels()) {
                label.getProcessGroup().removeLabel(label);
            }
        }
        controller.updateProcessGroup(processGroupDto);
        ProcessGroup processGroup = controller.getGroup(processGroupDto.getId());
        List<Element> controllerServiceNodeList = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "controllerService");
        HashSet<ControllerServiceNode> toDisable = new HashSet<ControllerServiceNode>();
        HashSet<ControllerServiceNode> toEnable = new HashSet<ControllerServiceNode>();
        for (Element element : controllerServiceNodeList) {
            ControllerServiceState controllerServiceState;
            ControllerServiceDTO controllerServiceDTO = FlowFromDOMFactory.getControllerService(element, encryptor);
            ControllerServiceNode controllerServiceNode = processGroup.getControllerService(controllerServiceDTO.getId());
            ControllerServiceState controllerServiceState2 = this.getFinalTransitionState(controllerServiceNode.getState());
            if (controllerServiceState2 == (controllerServiceState = this.getFinalTransitionState(ControllerServiceState.valueOf((String)controllerServiceDTO.getState())))) continue;
            switch (controllerServiceState) {
                case DISABLED: {
                    toDisable.add(controllerServiceNode);
                    break;
                }
                case ENABLED: {
                    toEnable.add(controllerServiceNode);
                }
            }
        }
        toEnable.stream().forEach(ComponentNode::performValidation);
        controller.disableControllerServicesAsync(toDisable);
        controller.enableControllerServices(toEnable);
        List<Element> processorNodeList = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "processor");
        for (Element element : processorNodeList) {
            ProcessorDTO processorDTO = FlowFromDOMFactory.getProcessor(element, encryptor);
            ProcessorNode processorNode = processGroup.getProcessor(processorDTO.getId());
            ScheduledState scheduledState = this.getScheduledState(processorNode, controller);
            this.updateNonFingerprintedProcessorSettings(processorNode, processorDTO);
            if (scheduledState.name().equals(processorDTO.getState())) continue;
            try {
                switch (ScheduledState.valueOf((String)processorDTO.getState())) {
                    case DISABLED: {
                        controller.stopProcessor(processorNode.getProcessGroupIdentifier(), processorNode.getIdentifier());
                        processorNode.getProcessGroup().disableProcessor(processorNode);
                        break;
                    }
                    case RUNNING: {
                        processorNode.performValidation();
                        processorNode.getProcessGroup().enableProcessor(processorNode);
                        controller.startProcessor(processorNode.getProcessGroupIdentifier(), processorNode.getIdentifier(), false);
                        break;
                    }
                    case STOPPED: {
                        if (scheduledState == ScheduledState.DISABLED) {
                            processorNode.getProcessGroup().enableProcessor(processorNode);
                            break;
                        }
                        if (scheduledState != ScheduledState.RUNNING) break;
                        controller.stopProcessor(processorNode.getProcessGroupIdentifier(), processorNode.getIdentifier());
                    }
                }
            }
            catch (IllegalStateException illegalStateException) {
                logger.error("Failed to change Scheduled State of {} from {} to {} due to {}", new Object[]{processorNode, processorNode.getScheduledState().name(), processorDTO.getState(), illegalStateException.toString()});
                logger.error("", (Throwable)illegalStateException);
                controller.getBulletinRepository().addBulletin(BulletinFactory.createBulletin((Connectable)processorNode, (String)"Node Reconnection", (String)Severity.ERROR.name(), (String)("Failed to change Scheduled State of " + processorNode + " from " + processorNode.getScheduledState().name() + " to " + processorDTO.getState() + " due to " + illegalStateException.toString())));
                controller.getBulletinRepository().addBulletin(BulletinFactory.createBulletin((String)"Node Reconnection", (String)Severity.ERROR.name(), (String)("Failed to change Scheduled State of " + processorNode + " from " + processorNode.getScheduledState().name() + " to " + processorDTO.getState() + " due to " + illegalStateException.toString())));
            }
        }
        List<Element> list = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "inputPort");
        for (Element element : list) {
            PortDTO portDTO = FlowFromDOMFactory.getPort(element);
            Port port = processGroup.getInputPort(portDTO.getId());
            ScheduledState scheduledState = this.getScheduledState(port, controller);
            if (scheduledState.name().equals(portDTO.getState())) continue;
            switch (ScheduledState.valueOf((String)portDTO.getState())) {
                case DISABLED: {
                    controller.stopConnectable((Connectable)port);
                    port.getProcessGroup().disableInputPort(port);
                    break;
                }
                case RUNNING: {
                    port.getProcessGroup().enableInputPort(port);
                    controller.startConnectable((Connectable)port);
                    break;
                }
                case STOPPED: {
                    if (scheduledState == ScheduledState.DISABLED) {
                        port.getProcessGroup().enableInputPort(port);
                        break;
                    }
                    if (scheduledState != ScheduledState.RUNNING) break;
                    controller.stopConnectable((Connectable)port);
                }
            }
        }
        List<Element> list2 = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "outputPort");
        for (Element element : list2) {
            PortDTO portDTO = FlowFromDOMFactory.getPort(element);
            Port port = processGroup.getOutputPort(portDTO.getId());
            ScheduledState scheduledState = this.getScheduledState(port, controller);
            if (scheduledState.name().equals(portDTO.getState())) continue;
            switch (ScheduledState.valueOf((String)portDTO.getState())) {
                case DISABLED: {
                    controller.stopConnectable((Connectable)port);
                    port.getProcessGroup().disableOutputPort(port);
                    break;
                }
                case RUNNING: {
                    port.getProcessGroup().enableOutputPort(port);
                    controller.startConnectable((Connectable)port);
                    break;
                }
                case STOPPED: {
                    if (scheduledState == ScheduledState.DISABLED) {
                        port.getProcessGroup().enableOutputPort(port);
                        break;
                    }
                    if (scheduledState != ScheduledState.RUNNING) break;
                    controller.stopConnectable((Connectable)port);
                }
            }
        }
        List<Element> list3 = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "remoteProcessGroup");
        for (Element element : list3) {
            RemoteProcessGroupDTO remoteProcessGroupDTO = FlowFromDOMFactory.getRemoteProcessGroup(element, encryptor);
            RemoteProcessGroup remoteProcessGroup = processGroup.getRemoteProcessGroup(remoteProcessGroupDTO.getId());
            List<Element> inputPortElements = StandardFlowSynchronizer.getChildrenByTagName(element, "inputPort");
            for (Element element2 : inputPortElements) {
                RemoteProcessGroupPortDescriptor portDescriptor = FlowFromDOMFactory.getRemoteProcessGroupPort(element2);
                String inputPortId = portDescriptor.getId();
                RemoteGroupPort inputPort = remoteProcessGroup.getInputPort(inputPortId);
                if (inputPort == null) continue;
                ScheduledState portState = this.getScheduledState(inputPort, controller);
                if (portDescriptor.isTransmitting().booleanValue()) {
                    if (portState == ScheduledState.RUNNING || portState == ScheduledState.STARTING) continue;
                    controller.startTransmitting(inputPort);
                    continue;
                }
                if (portState == ScheduledState.STOPPED || portState == ScheduledState.STOPPING) continue;
                controller.stopTransmitting(inputPort);
            }
            List<Element> outputPortElements = StandardFlowSynchronizer.getChildrenByTagName(element, "outputPort");
            for (Element outputPortElement : outputPortElements) {
                RemoteProcessGroupPortDescriptor portDescriptor = FlowFromDOMFactory.getRemoteProcessGroupPort(outputPortElement);
                String outputPortId = portDescriptor.getId();
                RemoteGroupPort outputPort = remoteProcessGroup.getOutputPort(outputPortId);
                if (outputPort == null) continue;
                ScheduledState portState = this.getScheduledState(outputPort, controller);
                if (portDescriptor.isTransmitting().booleanValue()) {
                    if (portState == ScheduledState.RUNNING || portState == ScheduledState.STARTING) continue;
                    controller.startTransmitting(outputPort);
                    continue;
                }
                if (portState == ScheduledState.STOPPED || portState == ScheduledState.STOPPING) continue;
                controller.stopTransmitting(outputPort);
            }
        }
        List<Element> list4 = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "label");
        for (Element element : list4) {
            LabelDTO labelDTO = FlowFromDOMFactory.getLabel(element);
            Label label = controller.createLabel(labelDTO.getId(), labelDTO.getLabel());
            label.setStyle(labelDTO.getStyle());
            label.setPosition(new Position(labelDTO.getPosition().getX().doubleValue(), labelDTO.getPosition().getY().doubleValue()));
            label.setVersionedComponentId(labelDTO.getVersionedComponentId());
            if (labelDTO.getWidth() != null && labelDTO.getHeight() != null) {
                label.setSize(new Size(labelDTO.getWidth().doubleValue(), labelDTO.getHeight().doubleValue()));
            }
            processGroup.addLabel(label);
        }
        List<Element> list5 = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "processGroup");
        for (Element element : list5) {
            this.updateProcessGroup(controller, processGroup, element, encryptor, encodingVersion);
        }
        List<Element> list6 = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "connection");
        for (Element connectionElement : list6) {
            ConnectionDTO dto = FlowFromDOMFactory.getConnection(connectionElement);
            Connection connection = processGroup.getConnection(dto.getId());
            connection.setName(dto.getName());
            connection.setProcessGroup(processGroup);
            if (dto.getLabelIndex() != null) {
                connection.setLabelIndex(dto.getLabelIndex().intValue());
            }
            if (dto.getzIndex() != null) {
                connection.setZIndex(dto.getzIndex().longValue());
            }
            ArrayList<Position> bendPoints = new ArrayList<Position>();
            for (PositionDTO bend : dto.getBends()) {
                bendPoints.add(new Position(bend.getX().doubleValue(), bend.getY().doubleValue()));
            }
            connection.setBendPoints(bendPoints);
            ArrayList<FlowFilePrioritizer> newPrioritizers = null;
            List prioritizers = dto.getPrioritizers();
            if (prioritizers != null) {
                ArrayList newPrioritizersClasses = new ArrayList(prioritizers);
                newPrioritizers = new ArrayList<FlowFilePrioritizer>();
                for (String className : newPrioritizersClasses) {
                    try {
                        newPrioritizers.add(controller.createPrioritizer(className));
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        throw new IllegalArgumentException("Unable to set prioritizer " + className + ": " + e);
                    }
                }
            }
            if (newPrioritizers != null) {
                connection.getFlowFileQueue().setPriorities(newPrioritizers);
            }
            if (dto.getBackPressureObjectThreshold() != null) {
                connection.getFlowFileQueue().setBackPressureObjectThreshold(dto.getBackPressureObjectThreshold().longValue());
            }
            if (dto.getBackPressureDataSizeThreshold() != null && !dto.getBackPressureDataSizeThreshold().trim().isEmpty()) {
                connection.getFlowFileQueue().setBackPressureDataSizeThreshold(dto.getBackPressureDataSizeThreshold());
            }
            if (dto.getFlowFileExpiration() == null) continue;
            connection.getFlowFileQueue().setFlowFileExpiration(dto.getFlowFileExpiration());
        }
        List<Element> list7 = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "template");
        for (Element templateElement : list7) {
            TemplateDTO templateDTO = TemplateUtils.parseDto(templateElement);
            Template template = new Template(templateDTO);
            if (processGroup.getTemplate(template.getIdentifier()) != null) {
                processGroup.removeTemplate(template);
            }
            processGroup.addTemplate(template);
        }
        return processGroup;
    }

    private <T extends Connectable & Triggerable> ScheduledState getScheduledState(T component, FlowController flowController) {
        ScheduledState componentState = component.getScheduledState();
        if (componentState == ScheduledState.STOPPED && flowController.isStartAfterInitialization(component)) {
            return ScheduledState.RUNNING;
        }
        return componentState;
    }

    private Position toPosition(PositionDTO dto) {
        return new Position(dto.getX().doubleValue(), dto.getY().doubleValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProcessor(ProcessorNode procNode, ProcessorDTO processorDTO, ProcessGroup processGroup, FlowController controller) throws ProcessorInstantiationException {
        procNode.pauseValidationTrigger();
        try {
            ProcessorConfigDTO config = processorDTO.getConfig();
            procNode.setProcessGroup(processGroup);
            procNode.setLossTolerant(config.isLossTolerant().booleanValue());
            procNode.setPenalizationPeriod(config.getPenaltyDuration());
            procNode.setYieldPeriod(config.getYieldDuration());
            procNode.setBulletinLevel(LogLevel.valueOf((String)config.getBulletinLevel()));
            this.updateNonFingerprintedProcessorSettings(procNode, processorDTO);
            if (config.getSchedulingStrategy() != null) {
                procNode.setSchedulingStrategy(SchedulingStrategy.valueOf((String)config.getSchedulingStrategy()));
            }
            if (config.getExecutionNode() != null) {
                procNode.setExecutionNode(ExecutionNode.valueOf((String)config.getExecutionNode()));
            }
            procNode.setMaxConcurrentTasks(config.getConcurrentlySchedulableTaskCount().intValue());
            procNode.setScheduldingPeriod(config.getSchedulingPeriod());
            if (config.getRunDurationMillis() != null) {
                procNode.setRunDuration(config.getRunDurationMillis().longValue(), TimeUnit.MILLISECONDS);
            }
            procNode.setAnnotationData(config.getAnnotationData());
            if (config.getAutoTerminatedRelationships() != null) {
                HashSet<Relationship> relationships = new HashSet<Relationship>();
                for (String rel : config.getAutoTerminatedRelationships()) {
                    relationships.add(procNode.getRelationship(rel));
                }
                procNode.setAutoTerminatedRelationships(relationships);
            }
            procNode.setProperties(config.getProperties());
            ScheduledState scheduledState = ScheduledState.valueOf((String)processorDTO.getState());
            if (ScheduledState.RUNNING.equals((Object)scheduledState)) {
                procNode.performValidation();
                controller.startProcessor(processGroup.getIdentifier(), procNode.getIdentifier());
            } else if (ScheduledState.DISABLED.equals((Object)scheduledState)) {
                processGroup.disableProcessor(procNode);
            } else if (ScheduledState.STOPPED.equals((Object)scheduledState)) {
                controller.stopProcessor(processGroup.getIdentifier(), procNode.getIdentifier());
            }
        }
        finally {
            procNode.resumeValidationTrigger();
        }
    }

    private void updateNonFingerprintedProcessorSettings(ProcessorNode procNode, ProcessorDTO processorDTO) {
        procNode.setName(processorDTO.getName());
        procNode.setPosition(this.toPosition(processorDTO.getPosition()));
        procNode.setStyle(processorDTO.getStyle());
        procNode.setComments(processorDTO.getConfig().getComments());
    }

    /*
     * WARNING - void declaration
     */
    private ProcessGroup addProcessGroup(FlowController controller, ProcessGroup parentGroup, Element processGroupElement, StringEncryptor encryptor, FlowEncodingVersion encodingVersion) throws ProcessorInstantiationException {
        List<Element> serviceNodeList;
        String parentId = parentGroup == null ? null : parentGroup.getIdentifier();
        ProcessGroupDTO processGroupDTO = FlowFromDOMFactory.getProcessGroup(parentId, processGroupElement, encryptor, encodingVersion);
        ProcessGroup processGroup = controller.createProcessGroup(processGroupDTO.getId());
        processGroup.setComments(processGroupDTO.getComments());
        processGroup.setVersionedComponentId(processGroupDTO.getVersionedComponentId());
        processGroup.setPosition(this.toPosition(processGroupDTO.getPosition()));
        processGroup.setName(processGroupDTO.getName());
        processGroup.setParent(parentGroup);
        if (parentGroup == null) {
            controller.setRootGroup(processGroup);
        } else {
            parentGroup.addProcessGroup(processGroup);
        }
        HashMap<String, String> variables = new HashMap<String, String>();
        List<Element> variableElements = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "variable");
        for (Element variableElement : variableElements) {
            String variableName = variableElement.getAttribute("name");
            String variableValue = variableElement.getAttribute("value");
            if (variableName == null || variableValue == null) continue;
            variables.put(variableName, variableValue);
        }
        processGroup.setVariables(variables);
        VersionControlInformationDTO versionControlInfoDto = processGroupDTO.getVersionControlInformation();
        if (versionControlInfoDto != null) {
            FlowRegistry flowRegistry = controller.getFlowRegistryClient().getFlowRegistry(versionControlInfoDto.getRegistryId());
            String registryName = flowRegistry == null ? versionControlInfoDto.getRegistryId() : flowRegistry.getName();
            versionControlInfoDto.setState(VersionedFlowState.SYNC_FAILURE.name());
            versionControlInfoDto.setStateExplanation("Process Group has not yet been synchronized with the Flow Registry");
            StandardVersionControlInformation versionControlInformation = StandardVersionControlInformation.Builder.fromDto(versionControlInfoDto).registryName(registryName).build();
            processGroup.setVersionControlInformation((VersionControlInformation)versionControlInformation, Collections.emptyMap());
        }
        if (!(serviceNodeList = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "controllerService")).isEmpty()) {
            Map<ControllerServiceNode, Element> controllerServices = ControllerServiceLoader.loadControllerServices(serviceNodeList, controller, processGroup, encryptor);
            ControllerServiceLoader.enableControllerServices(controllerServices, controller, encryptor, this.autoResumeState);
        }
        List<Element> processorNodeList = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "processor");
        for (Element element : processorNodeList) {
            void var17_23;
            ProcessorDTO processorDTO = FlowFromDOMFactory.getProcessor(element, encryptor);
            try {
                BundleCoordinate bundleCoordinate = BundleUtils.getCompatibleBundle(processorDTO.getType(), processorDTO.getBundle());
            }
            catch (IllegalStateException illegalStateException) {
                BundleDTO bundleDTO = processorDTO.getBundle();
                if (bundleDTO == null) {
                    BundleCoordinate bundleCoordinate = BundleCoordinate.UNKNOWN_COORDINATE;
                }
                BundleCoordinate bundleCoordinate = new BundleCoordinate(bundleDTO.getGroup(), bundleDTO.getArtifact(), bundleDTO.getVersion());
            }
            ProcessorNode processorNode = controller.createProcessor(processorDTO.getType(), processorDTO.getId(), (BundleCoordinate)var17_23, false);
            processorNode.setVersionedComponentId(processorDTO.getVersionedComponentId());
            processGroup.addProcessor(processorNode);
            this.updateProcessor(processorNode, processorDTO, processGroup, controller);
        }
        List<Element> inputPortNodeList = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "inputPort");
        for (Element element : inputPortNodeList) {
            ScheduledState scheduledState;
            Set set;
            void var18_39;
            PortDTO portDTO = FlowFromDOMFactory.getPort(element);
            if (processGroup.isRootGroup()) {
                Port port = controller.createRemoteInputPort(portDTO.getId(), portDTO.getName());
            } else {
                Port port = controller.createLocalInputPort(portDTO.getId(), portDTO.getName());
            }
            var18_39.setVersionedComponentId(portDTO.getVersionedComponentId());
            var18_39.setPosition(this.toPosition(portDTO.getPosition()));
            var18_39.setComments(portDTO.getComments());
            var18_39.setProcessGroup(processGroup);
            Set set2 = portDTO.getUserAccessControl();
            if (set2 != null && !set2.isEmpty()) {
                if (!(var18_39 instanceof RootGroupPort)) {
                    throw new IllegalStateException("Attempting to add User Access Controls to " + var18_39.getIdentifier() + ", but it is not a RootGroupPort");
                }
                ((RootGroupPort)var18_39).setUserAccessControl(set2);
            }
            if ((set = portDTO.getGroupAccessControl()) != null && !set.isEmpty()) {
                if (!(var18_39 instanceof RootGroupPort)) {
                    throw new IllegalStateException("Attempting to add Group Access Controls to " + var18_39.getIdentifier() + ", but it is not a RootGroupPort");
                }
                ((RootGroupPort)var18_39).setGroupAccessControl(set);
            }
            processGroup.addInputPort((Port)var18_39);
            if (portDTO.getConcurrentlySchedulableTaskCount() != null) {
                var18_39.setMaxConcurrentTasks(portDTO.getConcurrentlySchedulableTaskCount().intValue());
            }
            if (ScheduledState.RUNNING.equals((Object)(scheduledState = ScheduledState.valueOf((String)portDTO.getState())))) {
                controller.startConnectable((Connectable)var18_39);
                continue;
            }
            if (!ScheduledState.DISABLED.equals((Object)scheduledState)) continue;
            processGroup.disableInputPort((Port)var18_39);
        }
        List<Element> list = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "outputPort");
        for (Element element : list) {
            ScheduledState scheduledState;
            Set set;
            void var19_52;
            PortDTO portDTO = FlowFromDOMFactory.getPort(element);
            if (processGroup.isRootGroup()) {
                Port port = controller.createRemoteOutputPort(portDTO.getId(), portDTO.getName());
            } else {
                Port port = controller.createLocalOutputPort(portDTO.getId(), portDTO.getName());
            }
            var19_52.setVersionedComponentId(portDTO.getVersionedComponentId());
            var19_52.setPosition(this.toPosition(portDTO.getPosition()));
            var19_52.setComments(portDTO.getComments());
            var19_52.setProcessGroup(processGroup);
            Set set3 = portDTO.getUserAccessControl();
            if (set3 != null && !set3.isEmpty()) {
                if (!(var19_52 instanceof RootGroupPort)) {
                    throw new IllegalStateException("Attempting to add User Access Controls to " + var19_52.getIdentifier() + ", but it is not a RootGroupPort");
                }
                ((RootGroupPort)var19_52).setUserAccessControl(set3);
            }
            if ((set = portDTO.getGroupAccessControl()) != null && !set.isEmpty()) {
                if (!(var19_52 instanceof RootGroupPort)) {
                    throw new IllegalStateException("Attempting to add Group Access Controls to " + var19_52.getIdentifier() + ", but it is not a RootGroupPort");
                }
                ((RootGroupPort)var19_52).setGroupAccessControl(set);
            }
            processGroup.addOutputPort((Port)var19_52);
            if (portDTO.getConcurrentlySchedulableTaskCount() != null) {
                var19_52.setMaxConcurrentTasks(portDTO.getConcurrentlySchedulableTaskCount().intValue());
            }
            if (ScheduledState.RUNNING.equals((Object)(scheduledState = ScheduledState.valueOf((String)portDTO.getState())))) {
                controller.startConnectable((Connectable)var19_52);
                continue;
            }
            if (!ScheduledState.DISABLED.equals((Object)scheduledState)) continue;
            processGroup.disableOutputPort((Port)var19_52);
        }
        List<Element> list2 = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "funnel");
        for (Element element : list2) {
            FunnelDTO funnelDTO = FlowFromDOMFactory.getFunnel(element);
            Funnel funnel = controller.createFunnel(funnelDTO.getId());
            funnel.setVersionedComponentId(funnelDTO.getVersionedComponentId());
            funnel.setPosition(this.toPosition(funnelDTO.getPosition()));
            processGroup.addFunnel(funnel, false);
            controller.startConnectable((Connectable)funnel);
        }
        List<Element> list3 = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "label");
        for (Element element : list3) {
            LabelDTO labelDTO = FlowFromDOMFactory.getLabel(element);
            Label label = controller.createLabel(labelDTO.getId(), labelDTO.getLabel());
            label.setVersionedComponentId(labelDTO.getVersionedComponentId());
            label.setStyle(labelDTO.getStyle());
            label.setPosition(this.toPosition(labelDTO.getPosition()));
            label.setSize(new Size(labelDTO.getWidth().doubleValue(), labelDTO.getHeight().doubleValue()));
            processGroup.addLabel(label);
        }
        List<Element> list4 = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "processGroup");
        for (Element element : list4) {
            this.addProcessGroup(controller, processGroup, element, encryptor, encodingVersion);
        }
        List<Element> list5 = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "remoteProcessGroup");
        for (Element element : list5) {
            RemoteGroupPort port;
            String transportProtocol;
            RemoteProcessGroupDTO remoteGroupDto = FlowFromDOMFactory.getRemoteProcessGroup(element, encryptor);
            RemoteProcessGroup remoteGroup = controller.createRemoteProcessGroup(remoteGroupDto.getId(), remoteGroupDto.getTargetUris());
            remoteGroup.setVersionedComponentId(remoteGroupDto.getVersionedComponentId());
            remoteGroup.setComments(remoteGroupDto.getComments());
            remoteGroup.setPosition(this.toPosition(remoteGroupDto.getPosition()));
            String name = remoteGroupDto.getName();
            if (name != null && !name.trim().isEmpty()) {
                remoteGroup.setName(name);
            }
            remoteGroup.setProcessGroup(processGroup);
            remoteGroup.setCommunicationsTimeout(remoteGroupDto.getCommunicationsTimeout());
            if (remoteGroupDto.getYieldDuration() != null) {
                remoteGroup.setYieldDuration(remoteGroupDto.getYieldDuration());
            }
            if ((transportProtocol = remoteGroupDto.getTransportProtocol()) != null && !transportProtocol.trim().isEmpty()) {
                remoteGroup.setTransportProtocol(SiteToSiteTransportProtocol.valueOf((String)transportProtocol.toUpperCase()));
            }
            if (remoteGroupDto.getProxyHost() != null) {
                remoteGroup.setProxyHost(remoteGroupDto.getProxyHost());
            }
            if (remoteGroupDto.getProxyPort() != null) {
                remoteGroup.setProxyPort(remoteGroupDto.getProxyPort());
            }
            if (remoteGroupDto.getProxyUser() != null) {
                remoteGroup.setProxyUser(remoteGroupDto.getProxyUser());
            }
            if (remoteGroupDto.getProxyPassword() != null) {
                remoteGroup.setProxyPassword(remoteGroupDto.getProxyPassword());
            }
            if (StringUtils.isBlank((CharSequence)remoteGroupDto.getLocalNetworkInterface())) {
                remoteGroup.setNetworkInterface(null);
            } else {
                remoteGroup.setNetworkInterface(remoteGroupDto.getLocalNetworkInterface());
            }
            HashSet<RemoteProcessGroupPortDescriptor> inputPorts = new HashSet<RemoteProcessGroupPortDescriptor>();
            for (Element element2 : StandardFlowSynchronizer.getChildrenByTagName(element, "inputPort")) {
                inputPorts.add(FlowFromDOMFactory.getRemoteProcessGroupPort(element2));
            }
            remoteGroup.setInputPorts(inputPorts, false);
            HashSet<RemoteProcessGroupPortDescriptor> outputPorts = new HashSet<RemoteProcessGroupPortDescriptor>();
            for (Element portElement3 : StandardFlowSynchronizer.getChildrenByTagName(element, "outputPort")) {
                outputPorts.add(FlowFromDOMFactory.getRemoteProcessGroupPort(portElement3));
            }
            remoteGroup.setOutputPorts(outputPorts, false);
            processGroup.addRemoteProcessGroup(remoteGroup);
            for (RemoteProcessGroupPortDescriptor remoteGroupPortDTO : outputPorts) {
                port = remoteGroup.getOutputPort(remoteGroupPortDTO.getId());
                if (!Boolean.TRUE.equals(remoteGroupPortDTO.isTransmitting())) continue;
                controller.startTransmitting(port);
            }
            for (RemoteProcessGroupPortDescriptor remoteGroupPortDTO : inputPorts) {
                port = remoteGroup.getInputPort(remoteGroupPortDTO.getId());
                if (!Boolean.TRUE.equals(remoteGroupPortDTO.isTransmitting())) continue;
                controller.startTransmitting(port);
            }
        }
        List<Element> list6 = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "connection");
        for (Element connectionElement : list6) {
            RemoteGroupPort destination;
            RemoteGroupPort source;
            ConnectionDTO dto = FlowFromDOMFactory.getConnection(connectionElement);
            ConnectableDTO sourceDto = dto.getSource();
            if (ConnectableType.REMOTE_OUTPUT_PORT.name().equals(sourceDto.getType())) {
                RemoteProcessGroup remoteGroup = processGroup.getRemoteProcessGroup(sourceDto.getGroupId());
                source = remoteGroup.getOutputPort(sourceDto.getId());
            } else {
                ProcessGroup sourceGroup = controller.getGroup(sourceDto.getGroupId());
                if (sourceGroup == null) {
                    throw new RuntimeException("Found Invalid ProcessGroup ID for Source: " + dto.getSource().getGroupId());
                }
                source = sourceGroup.getConnectable(sourceDto.getId());
            }
            if (source == null) {
                throw new RuntimeException("Found Invalid Connectable ID for Source: " + dto.getSource().getId());
            }
            ConnectableDTO destinationDto = dto.getDestination();
            if (ConnectableType.REMOTE_INPUT_PORT.name().equals(destinationDto.getType())) {
                RemoteProcessGroup remoteProcessGroup = processGroup.getRemoteProcessGroup(destinationDto.getGroupId());
                destination = remoteProcessGroup.getInputPort(destinationDto.getId());
            } else {
                ProcessGroup processGroup2 = controller.getGroup(destinationDto.getGroupId());
                if (processGroup2 == null) {
                    throw new RuntimeException("Found Invalid ProcessGroup ID for Destination: " + dto.getDestination().getGroupId());
                }
                destination = processGroup2.getConnectable(destinationDto.getId());
            }
            if (destination == null) {
                throw new RuntimeException("Found Invalid Connectable ID for Destination: " + dto.getDestination().getId());
            }
            Connection connection = controller.createConnection(dto.getId(), dto.getName(), (Connectable)source, (Connectable)destination, dto.getSelectedRelationships());
            connection.setVersionedComponentId(dto.getVersionedComponentId());
            connection.setProcessGroup(processGroup);
            ArrayList<Position> bendPoints = new ArrayList<Position>();
            for (PositionDTO bend : dto.getBends()) {
                bendPoints.add(new Position(bend.getX().doubleValue(), bend.getY().doubleValue()));
            }
            connection.setBendPoints(bendPoints);
            Long zIndex = dto.getzIndex();
            if (zIndex != null) {
                connection.setZIndex(zIndex.longValue());
            }
            if (dto.getLabelIndex() != null) {
                connection.setLabelIndex(dto.getLabelIndex().intValue());
            }
            ArrayList<FlowFilePrioritizer> newPrioritizers = null;
            List prioritizers = dto.getPrioritizers();
            if (prioritizers != null) {
                ArrayList newPrioritizersClasses = new ArrayList(prioritizers);
                newPrioritizers = new ArrayList<FlowFilePrioritizer>();
                for (String className : newPrioritizersClasses) {
                    try {
                        newPrioritizers.add(controller.createPrioritizer(className));
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        throw new IllegalArgumentException("Unable to set prioritizer " + className + ": " + e);
                    }
                }
            }
            if (newPrioritizers != null) {
                connection.getFlowFileQueue().setPriorities(newPrioritizers);
            }
            if (dto.getBackPressureObjectThreshold() != null) {
                connection.getFlowFileQueue().setBackPressureObjectThreshold(dto.getBackPressureObjectThreshold().longValue());
            }
            if (dto.getBackPressureDataSizeThreshold() != null) {
                connection.getFlowFileQueue().setBackPressureDataSizeThreshold(dto.getBackPressureDataSizeThreshold());
            }
            if (dto.getFlowFileExpiration() != null) {
                connection.getFlowFileQueue().setFlowFileExpiration(dto.getFlowFileExpiration());
            }
            if (dto.getLoadBalanceStrategy() != null) {
                connection.getFlowFileQueue().setLoadBalanceStrategy(LoadBalanceStrategy.valueOf((String)dto.getLoadBalanceStrategy()), dto.getLoadBalancePartitionAttribute());
            }
            if (dto.getLoadBalanceCompression() != null) {
                connection.getFlowFileQueue().setLoadBalanceCompression(LoadBalanceCompression.valueOf((String)dto.getLoadBalanceCompression()));
            }
            processGroup.addConnection(connection);
        }
        List<Element> list7 = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "template");
        for (Element templateNode : list7) {
            TemplateDTO templateDTO = TemplateUtils.parseDto(templateNode);
            Template template = new Template(templateDTO);
            processGroup.addTemplate(template);
        }
        return processGroup;
    }

    public String checkMissingComponentsInheritability(DataFlow existingFlow, DataFlow proposedFlow) {
        if (existingFlow == null) {
            return null;
        }
        HashSet existingMissingComponents = new HashSet(existingFlow.getMissingComponents());
        existingMissingComponents.removeAll(proposedFlow.getMissingComponents());
        if (existingMissingComponents.size() > 0) {
            String missingIds = StringUtils.join(existingMissingComponents, (String)",");
            return "Current flow has missing components that are not considered missing in the proposed flow (" + missingIds + ")";
        }
        HashSet proposedMissingComponents = new HashSet(proposedFlow.getMissingComponents());
        proposedMissingComponents.removeAll(existingFlow.getMissingComponents());
        if (proposedMissingComponents.size() > 0) {
            String missingIds = StringUtils.join(proposedMissingComponents, (String)",");
            return "Proposed flow has missing components that are not considered missing in the current flow (" + missingIds + ")";
        }
        return null;
    }

    private AuthorizerInheritability checkAuthorizerInheritability(Authorizer authorizer, DataFlow existingFlow, DataFlow proposedFlow) {
        byte[] existing = existingFlow.getAuthorizerFingerprint();
        byte[] proposed = proposedFlow.getAuthorizerFingerprint();
        if (existing == null && proposed == null) {
            return AuthorizerInheritability.uninheritable(null);
        }
        if (existing == null && proposed != null) {
            return AuthorizerInheritability.uninheritable("Current Authorizer is an external Authorizer, but proposed Authorizer is an internal Authorizer");
        }
        if (existing != null && proposed == null) {
            return AuthorizerInheritability.uninheritable("Current Authorizer is an internal Authorizer, but proposed Authorizer is an external Authorizer");
        }
        if (!Arrays.equals(existing, proposed)) {
            if (AuthorizerCapabilityDetection.isManagedAuthorizer((Authorizer)authorizer)) {
                ManagedAuthorizer managedAuthorizer = (ManagedAuthorizer)authorizer;
                try {
                    managedAuthorizer.checkInheritability(new String(proposed, StandardCharsets.UTF_8));
                    return AuthorizerInheritability.inheritable();
                }
                catch (UninheritableAuthorizationsException e) {
                    return AuthorizerInheritability.uninheritable("Proposed Authorizations do not match current Authorizations: " + e.getMessage());
                }
            }
            return AuthorizerInheritability.uninheritable("Proposed Authorizations do not match current Authorizations and are not configured with an internal Authorizer");
        }
        return AuthorizerInheritability.uninheritable(null);
    }

    public String checkFlowInheritability(DataFlow existingFlow, DataFlow proposedFlow, FlowController controller) throws FingerprintException {
        if (existingFlow == null) {
            return null;
        }
        return this.checkFlowInheritability(existingFlow.getFlow(), proposedFlow.getFlow(), controller);
    }

    private String checkFlowInheritability(byte[] existingFlow, byte[] proposedFlow, FlowController controller) {
        boolean inheritable;
        if (existingFlow == null) {
            return null;
        }
        FingerprintFactory fingerprintFactory = new FingerprintFactory(this.encryptor);
        String existingFlowFingerprintBeforeHash = fingerprintFactory.createFingerprint(existingFlow, controller);
        if (existingFlowFingerprintBeforeHash.trim().isEmpty()) {
            return null;
        }
        if (proposedFlow == null || proposedFlow.length == 0) {
            return "Proposed Flow was empty but Current Flow is not";
        }
        String proposedFlowFingerprintBeforeHash = fingerprintFactory.createFingerprint(proposedFlow, controller);
        if (proposedFlowFingerprintBeforeHash.trim().isEmpty()) {
            return "Proposed Flow was empty but Current Flow is not";
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Local Fingerprint Before Hash = {}", new Object[]{existingFlowFingerprintBeforeHash});
            logger.trace("Proposed Fingerprint Before Hash = {}", new Object[]{proposedFlowFingerprintBeforeHash});
        }
        if (!(inheritable = existingFlowFingerprintBeforeHash.equals(proposedFlowFingerprintBeforeHash))) {
            return this.findFirstDiscrepancy(existingFlowFingerprintBeforeHash, proposedFlowFingerprintBeforeHash, "Flows");
        }
        return null;
    }

    private String findFirstDiscrepancy(String existing, String proposed, String comparisonDescription) {
        int shortestFileLength = Math.min(existing.length(), proposed.length());
        for (int i = 0; i < shortestFileLength; ++i) {
            if (existing.charAt(i) == proposed.charAt(i)) continue;
            String formattedExistingDelta = this.formatFlowDiscrepancy(existing, i, 100);
            String formattedProposedDelta = this.formatFlowDiscrepancy(proposed, i, 100);
            return String.format("Found difference in %s:\nLocal Fingerprint:   %s\nCluster Fingerprint: %s", comparisonDescription, formattedExistingDelta, formattedProposedDelta);
        }
        if (existing.length() > proposed.length()) {
            String formattedExistingDelta = existing.substring(proposed.length(), Math.min(existing.length(), proposed.length() + 200));
            return String.format("Found difference in %s:\nLocal Fingerprint contains additional configuration from Cluster Fingerprint: %s", comparisonDescription, formattedExistingDelta);
        }
        if (proposed.length() > existing.length()) {
            String formattedProposedDelta = proposed.substring(existing.length(), Math.min(proposed.length(), existing.length() + 200));
            return String.format("Found difference in %s:\nCluster Fingerprint contains additional configuration from Local Fingerprint: %s", comparisonDescription, formattedProposedDelta);
        }
        return "Unable to find any discrepancies between fingerprints. Please contact the NiFi support team";
    }

    private byte[] toBytes(FlowController flowController) throws FlowSerializationException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        StandardFlowSerializer flowSerializer = new StandardFlowSerializer(this.encryptor);
        flowController.serialize(flowSerializer, result);
        return result.toByteArray();
    }

    private static String getString(Element element, String childElementName) {
        List<Element> nodeList = StandardFlowSynchronizer.getChildrenByTagName(element, childElementName);
        if (nodeList == null || nodeList.isEmpty()) {
            return "";
        }
        Element childElement = nodeList.get(0);
        return childElement.getTextContent();
    }

    private static int getInt(Element element, String childElementName) {
        return Integer.parseInt(StandardFlowSynchronizer.getString(element, childElementName));
    }

    private static Integer getInteger(Element element, String childElementName) {
        String value = StandardFlowSynchronizer.getString(element, childElementName);
        return value == null || value.trim().equals("") ? null : Integer.valueOf(Integer.parseInt(value));
    }

    private static List<Element> getChildrenByTagName(Element element, String tagName) {
        ArrayList<Element> matches = new ArrayList<Element>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element child;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(child = (Element)nodeList.item(i)).getNodeName().equals(tagName)) continue;
            matches.add(child);
        }
        return matches;
    }

    private String formatFlowDiscrepancy(String flowFingerprint, int deltaIndex, int deltaPad) {
        return flowFingerprint.substring(Math.max(0, deltaIndex - deltaPad), Math.min(flowFingerprint.length(), deltaIndex + deltaPad));
    }

    private static final class AuthorizerInheritability {
        private final boolean inheritable;
        private final String reason;

        public AuthorizerInheritability(boolean inheritable, String reason) {
            this.inheritable = inheritable;
            this.reason = reason;
        }

        public boolean isInheritable() {
            return this.inheritable;
        }

        public String getReason() {
            return this.reason;
        }

        public static AuthorizerInheritability uninheritable(String reason) {
            return new AuthorizerInheritability(false, reason);
        }

        public static AuthorizerInheritability inheritable() {
            return new AuthorizerInheritability(true, null);
        }
    }
}

