/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue.clustered.client.async.nio;

import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.apache.nifi.controller.queue.LoadBalanceCompression;
import org.apache.nifi.controller.queue.clustered.client.async.TransactionCompleteCallback;
import org.apache.nifi.controller.queue.clustered.client.async.TransactionFailureCallback;
import org.apache.nifi.controller.repository.FlowFileRecord;

public class RegisteredPartition {
    private final String connectionId;
    private final Supplier<FlowFileRecord> flowFileRecordSupplier;
    private final TransactionFailureCallback failureCallback;
    private final BooleanSupplier emptySupplier;
    private final TransactionCompleteCallback successCallback;
    private final Supplier<LoadBalanceCompression> compressionSupplier;
    private final BooleanSupplier honorBackpressureSupplier;

    public RegisteredPartition(String connectionId, BooleanSupplier emptySupplier, Supplier<FlowFileRecord> flowFileSupplier, TransactionFailureCallback failureCallback, TransactionCompleteCallback successCallback, Supplier<LoadBalanceCompression> compressionSupplier, BooleanSupplier honorBackpressureSupplier) {
        this.connectionId = connectionId;
        this.emptySupplier = emptySupplier;
        this.flowFileRecordSupplier = flowFileSupplier;
        this.failureCallback = failureCallback;
        this.successCallback = successCallback;
        this.compressionSupplier = compressionSupplier;
        this.honorBackpressureSupplier = honorBackpressureSupplier;
    }

    public boolean isEmpty() {
        return this.emptySupplier.getAsBoolean();
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public Supplier<FlowFileRecord> getFlowFileRecordSupplier() {
        return this.flowFileRecordSupplier;
    }

    public TransactionFailureCallback getFailureCallback() {
        return this.failureCallback;
    }

    public TransactionCompleteCallback getSuccessCallback() {
        return this.successCallback;
    }

    public LoadBalanceCompression getCompression() {
        return this.compressionSupplier.get();
    }

    public boolean isHonorBackpressure() {
        return this.honorBackpressureSupplier.getAsBoolean();
    }
}

