/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue.clustered.server;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.node.NodeConnectionState;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.controller.queue.clustered.server.LoadBalanceAuthorizer;
import org.apache.nifi.controller.queue.clustered.server.NotAuthorizedException;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.reporting.Severity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterLoadBalanceAuthorizer
implements LoadBalanceAuthorizer {
    private static final Logger logger = LoggerFactory.getLogger(ClusterLoadBalanceAuthorizer.class);
    private final ClusterCoordinator clusterCoordinator;
    private final EventReporter eventReporter;

    public ClusterLoadBalanceAuthorizer(ClusterCoordinator clusterCoordinator, EventReporter eventReporter) {
        this.clusterCoordinator = clusterCoordinator;
        this.eventReporter = eventReporter;
    }

    @Override
    public void authorize(Collection<String> clientIdentities) throws NotAuthorizedException {
        if (clientIdentities == null) {
            logger.debug("Client Identities is null, so assuming that Load Balancing communications are not secure. Authorizing client to participate in Load Balancing");
            return;
        }
        Set nodeIds = this.clusterCoordinator.getNodeIdentifiers(new NodeConnectionState[0]).stream().map(NodeIdentifier::getApiAddress).collect(Collectors.toSet());
        for (String clientId : clientIdentities) {
            if (!nodeIds.contains(clientId)) continue;
            logger.debug("Client ID '{}' is in the list of Nodes in the Cluster. Authorizing Client to Load Balance data", (Object)clientId);
            return;
        }
        String message = String.format("Authorization failed for Client ID's %s to Load Balance data because none of the ID's are known Cluster Node Identifiers", clientIdentities);
        logger.warn(message);
        this.eventReporter.reportEvent(Severity.WARNING, "Load Balanced Connections", message);
        throw new NotAuthorizedException("Client ID's " + clientIdentities + " are not authorized to Load Balance data");
    }
}

