/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history;

import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.RemoteProcessGroupStatus;

public class ComponentDetails {
    private final String componentId;
    private final String groupId;
    private final String componentName;
    private final String componentType;
    private final String sourceName;
    private final String destinationName;
    private final String targetUri;

    public ComponentDetails(String id, String groupId, String componentName, String componentType, String sourceName, String destinationName, String remoteUri) {
        this.componentId = id;
        this.groupId = groupId;
        this.componentName = componentName;
        this.componentType = componentType;
        this.sourceName = sourceName;
        this.destinationName = destinationName;
        this.targetUri = remoteUri;
    }

    public static ComponentDetails forProcessor(ProcessorStatus status) {
        return ComponentDetails.forProcessor(status.getId(), status.getGroupId(), status.getName(), status.getType());
    }

    public static ComponentDetails forProcessor(String id, String groupId, String processorName, String processorType) {
        return new ComponentDetails(id, groupId, processorName, processorType, null, null, null);
    }

    public static ComponentDetails forConnection(ConnectionStatus status) {
        return ComponentDetails.forConnection(status.getId(), status.getGroupId(), status.getName(), status.getSourceName(), status.getDestinationName());
    }

    public static ComponentDetails forConnection(String id, String groupId, String connectionName, String sourceName, String destinationName) {
        return new ComponentDetails(id, groupId, connectionName, sourceName, destinationName, null, null);
    }

    public static ComponentDetails forProcessGroup(ProcessGroupStatus status) {
        return ComponentDetails.forProcessGroup(status.getId(), status.getName());
    }

    public static ComponentDetails forProcessGroup(String id, String groupName) {
        return new ComponentDetails(id, null, groupName, null, null, null, null);
    }

    public static ComponentDetails forRemoteProcessGroup(RemoteProcessGroupStatus status) {
        return ComponentDetails.forRemoteProcessGroup(status.getId(), status.getGroupId(), status.getName(), status.getTargetUri());
    }

    public static ComponentDetails forRemoteProcessGroup(String id, String parentGroupId, String rpgName, String remoteUri) {
        return new ComponentDetails(id, parentGroupId, rpgName, null, null, null, remoteUri);
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public String getTargetUri() {
        return this.targetUri;
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Id", this.componentId);
        map.put("Group Id", this.groupId);
        map.put("Name", this.componentName);
        map.put("Type", this.componentType);
        map.put("Source Name", this.sourceName);
        map.put("Destination Name", this.destinationName);
        map.put("Uri", this.targetUri);
        return map;
    }
}

