/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.StatusSnapshot;
import org.apache.nifi.controller.status.history.ValueReducer;

public class StandardStatusSnapshot
implements StatusSnapshot {
    private final Set<MetricDescriptor<?>> metricDescriptors;
    private final long[] values;
    private Map<MetricDescriptor<?>, Long> counterValues = null;
    private Date timestamp = new Date();
    private Set<MetricDescriptor<?>> metricDescriptorsWithCounters = null;

    public StandardStatusSnapshot(Set<MetricDescriptor<?>> metricDescriptors) {
        this.metricDescriptors = metricDescriptors;
        this.values = new long[metricDescriptors.size()];
    }

    private StandardStatusSnapshot(Set<MetricDescriptor<?>> metricDescriptors, long[] values) {
        this.metricDescriptors = metricDescriptors;
        this.values = values;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Set<MetricDescriptor<?>> getMetricDescriptors() {
        if (this.counterValues == null || this.counterValues.isEmpty()) {
            return this.metricDescriptors;
        }
        if (this.metricDescriptorsWithCounters == null) {
            this.metricDescriptorsWithCounters = new LinkedHashSet();
            this.metricDescriptorsWithCounters.addAll(this.metricDescriptors);
            this.metricDescriptorsWithCounters.addAll(this.counterValues.keySet());
        }
        return this.metricDescriptorsWithCounters;
    }

    public Long getStatusMetric(MetricDescriptor<?> descriptor) {
        return this.values[descriptor.getMetricIdentifier()];
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public void addStatusMetric(MetricDescriptor<?> metric, Long value) {
        this.values[metric.getMetricIdentifier()] = value;
    }

    public void addCounterStatusMetric(MetricDescriptor<?> metric, Long value) {
        if (this.counterValues == null) {
            this.counterValues = new HashMap();
        }
        this.counterValues.put(metric, value);
    }

    public StandardStatusSnapshot withoutCounters() {
        if (this.counterValues == null || this.counterValues.isEmpty()) {
            return this;
        }
        StandardStatusSnapshot without = new StandardStatusSnapshot(this.metricDescriptors, this.values);
        without.setTimestamp(this.timestamp);
        return without;
    }

    public ValueReducer<StatusSnapshot, StatusSnapshot> getValueReducer() {
        return new ValueReducer<StatusSnapshot, StatusSnapshot>(){

            public StatusSnapshot reduce(List<StatusSnapshot> values) {
                Date reducedTimestamp = null;
                LinkedHashSet allDescriptors = new LinkedHashSet(StandardStatusSnapshot.this.getMetricDescriptors());
                for (StatusSnapshot statusSnapshot : values) {
                    if (reducedTimestamp == null) {
                        reducedTimestamp = statusSnapshot.getTimestamp();
                    }
                    allDescriptors.addAll(statusSnapshot.getMetricDescriptors());
                }
                StandardStatusSnapshot reduced = new StandardStatusSnapshot(allDescriptors);
                if (reducedTimestamp != null) {
                    reduced.setTimestamp(reducedTimestamp);
                }
                for (MetricDescriptor metricDescriptor : allDescriptors) {
                    Long descriptorValue = (Long)metricDescriptor.getValueReducer().reduce(values);
                    reduced.addStatusMetric(metricDescriptor, descriptorValue);
                }
                return reduced;
            }
        };
    }
}

