/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.function.Predicate;
import org.apache.nifi.registry.flow.ComponentType;
import org.apache.nifi.registry.flow.VersionedComponent;
import org.apache.nifi.registry.flow.VersionedFlowCoordinates;
import org.apache.nifi.registry.flow.VersionedProcessGroup;
import org.apache.nifi.registry.flow.diff.DifferenceType;
import org.apache.nifi.registry.flow.diff.FlowDifference;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedComponent;

public class FlowDifferenceFilters {
    public static Predicate<FlowDifference> FILTER_ADDED_REMOVED_REMOTE_PORTS = fd -> !FlowDifferenceFilters.isAddedOrRemovedRemotePort(fd);
    public static Predicate<FlowDifference> FILTER_IGNORABLE_VERSIONED_FLOW_COORDINATE_CHANGES = fd -> !FlowDifferenceFilters.isIgnorableVersionedFlowCoordinateChange(fd);

    public static boolean isAddedOrRemovedRemotePort(FlowDifference fd) {
        if (fd.getDifferenceType() == DifferenceType.COMPONENT_ADDED || fd.getDifferenceType() == DifferenceType.COMPONENT_REMOVED) {
            VersionedComponent component = fd.getComponentA();
            if (component == null || fd.getComponentB() instanceof InstantiatedVersionedComponent) {
                component = fd.getComponentB();
            }
            if (component.getComponentType() == ComponentType.REMOTE_INPUT_PORT || component.getComponentType() == ComponentType.REMOTE_OUTPUT_PORT) {
                return true;
            }
        }
        return false;
    }

    public static boolean isIgnorableVersionedFlowCoordinateChange(FlowDifference fd) {
        if (fd.getDifferenceType() == DifferenceType.VERSIONED_FLOW_COORDINATES_CHANGED) {
            VersionedComponent componentA = fd.getComponentA();
            VersionedComponent componentB = fd.getComponentB();
            if (componentA != null && componentB != null && componentA instanceof VersionedProcessGroup && componentB instanceof VersionedProcessGroup) {
                VersionedProcessGroup versionedProcessGroupA = (VersionedProcessGroup)componentA;
                VersionedProcessGroup versionedProcessGroupB = (VersionedProcessGroup)componentB;
                VersionedFlowCoordinates coordinatesA = versionedProcessGroupA.getVersionedFlowCoordinates();
                VersionedFlowCoordinates coordinatesB = versionedProcessGroupB.getVersionedFlowCoordinates();
                if (coordinatesA != null && coordinatesB != null) {
                    String registryUrlA = coordinatesA.getRegistryUrl();
                    String registryUrlB = coordinatesB.getRegistryUrl();
                    if (registryUrlA != null && registryUrlB != null && !registryUrlA.equals(registryUrlB)) {
                        if (registryUrlA.endsWith("/")) {
                            registryUrlA = registryUrlA.substring(0, registryUrlA.length() - 1);
                        }
                        if (registryUrlB.endsWith("/")) {
                            registryUrlB = registryUrlB.substring(0, registryUrlB.length() - 1);
                        }
                        if (registryUrlA.equals(registryUrlB)) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }
}

