/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceState;

public class ServiceStateTransition {
    private ControllerServiceState state = ControllerServiceState.DISABLED;
    private final List<CompletableFuture<?>> enabledFutures = new ArrayList();
    private final List<CompletableFuture<?>> disabledFutures = new ArrayList();
    private final ControllerServiceNode serviceNode;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private final Lock readLock = this.rwLock.readLock();

    public ServiceStateTransition(ControllerServiceNode serviceNode) {
        this.serviceNode = serviceNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transitionToEnabling(ControllerServiceState expectedState, CompletableFuture<?> enabledFuture) {
        this.writeLock.lock();
        try {
            if (expectedState != this.state) {
                boolean bl = false;
                return bl;
            }
            this.state = ControllerServiceState.ENABLING;
            this.enabledFutures.add(enabledFuture);
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean enable() {
        this.writeLock.lock();
        try {
            if (this.state != ControllerServiceState.ENABLING) {
                boolean bl = false;
                return bl;
            }
            this.state = ControllerServiceState.ENABLED;
            this.validateReferences(this.serviceNode);
            this.enabledFutures.stream().forEach(future -> future.complete(null));
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void validateReferences(ControllerServiceNode service) {
        List referencingComponents = service.getReferences().findRecursiveReferences(ComponentNode.class);
        for (ComponentNode component : referencingComponents) {
            component.performValidation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transitionToDisabling(ControllerServiceState expectedState, CompletableFuture<?> disabledFuture) {
        this.writeLock.lock();
        try {
            if (expectedState != this.state) {
                boolean bl = false;
                return bl;
            }
            this.state = ControllerServiceState.DISABLING;
            this.disabledFutures.add(disabledFuture);
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void disable() {
        this.writeLock.lock();
        try {
            this.state = ControllerServiceState.DISABLED;
            this.disabledFutures.stream().forEach(future -> future.complete(null));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ControllerServiceState getState() {
        this.readLock.lock();
        try {
            ControllerServiceState controllerServiceState = this.state;
            return controllerServiceState;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

