/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.io.File;
import java.util.Set;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.kerberos.KerberosConfig;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.logging.ComponentLog;

public class StandardControllerServiceInitializationContext
implements ControllerServiceInitializationContext,
ControllerServiceLookup {
    private final String id;
    private final ControllerServiceProvider serviceProvider;
    private final ComponentLog logger;
    private final StateManager stateManager;
    private final KerberosConfig kerberosConfig;

    public StandardControllerServiceInitializationContext(String identifier, ComponentLog logger, ControllerServiceProvider serviceProvider, StateManager stateManager, KerberosConfig kerberosConfig) {
        this.id = identifier;
        this.logger = logger;
        this.serviceProvider = serviceProvider;
        this.stateManager = stateManager;
        this.kerberosConfig = kerberosConfig;
    }

    public String getIdentifier() {
        return this.id;
    }

    public ControllerService getControllerService(String identifier) {
        return this.serviceProvider.getControllerService(identifier);
    }

    public Set<String> getControllerServiceIdentifiers(Class<? extends ControllerService> serviceType) {
        return this.serviceProvider.getControllerServiceIdentifiers(serviceType);
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return this;
    }

    public boolean isControllerServiceEnabled(String serviceIdentifier) {
        return this.serviceProvider.isControllerServiceEnabled(serviceIdentifier);
    }

    public boolean isControllerServiceEnabled(ControllerService service) {
        return this.serviceProvider.isControllerServiceEnabled(service);
    }

    public boolean isControllerServiceEnabling(String serviceIdentifier) {
        return this.serviceProvider.isControllerServiceEnabling(serviceIdentifier);
    }

    public String getControllerServiceName(String serviceIdentifier) {
        return this.serviceProvider.getControllerServiceName(serviceIdentifier);
    }

    public ComponentLog getLogger() {
        return this.logger;
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    public String getKerberosServicePrincipal() {
        return this.kerberosConfig.getPrincipal();
    }

    public File getKerberosServiceKeytab() {
        return this.kerberosConfig.getKeytabLocation();
    }

    public File getKerberosConfigurationFile() {
        return this.kerberosConfig.getConfigFile();
    }
}

