/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.RemoteProcessGroupStatus;
import org.apache.nifi.controller.status.history.ComponentDetails;
import org.apache.nifi.controller.status.history.ComponentStatusHistory;
import org.apache.nifi.controller.status.history.ComponentStatusRepository;
import org.apache.nifi.controller.status.history.ConnectionStatusDescriptor;
import org.apache.nifi.controller.status.history.GarbageCollectionHistory;
import org.apache.nifi.controller.status.history.GarbageCollectionStatus;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.ProcessGroupStatusDescriptor;
import org.apache.nifi.controller.status.history.ProcessorStatusDescriptor;
import org.apache.nifi.controller.status.history.RemoteProcessGroupStatusDescriptor;
import org.apache.nifi.controller.status.history.StandardGarbageCollectionHistory;
import org.apache.nifi.controller.status.history.StatusHistory;
import org.apache.nifi.controller.status.history.StatusSnapshot;
import org.apache.nifi.util.ComponentMetrics;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.RingBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolatileComponentStatusRepository
implements ComponentStatusRepository {
    private static final Logger logger = LoggerFactory.getLogger(VolatileComponentStatusRepository.class);
    private static final Set<MetricDescriptor<?>> DEFAULT_PROCESSOR_METRICS = Arrays.stream(ProcessorStatusDescriptor.values()).map(ProcessorStatusDescriptor::getDescriptor).collect(Collectors.toSet());
    private static final Set<MetricDescriptor<?>> DEFAULT_CONNECTION_METRICS = Arrays.stream(ConnectionStatusDescriptor.values()).map(ConnectionStatusDescriptor::getDescriptor).collect(Collectors.toSet());
    private static final Set<MetricDescriptor<?>> DEFAULT_GROUP_METRICS = Arrays.stream(ProcessGroupStatusDescriptor.values()).map(ProcessGroupStatusDescriptor::getDescriptor).collect(Collectors.toSet());
    private static final Set<MetricDescriptor<?>> DEFAULT_RPG_METRICS = Arrays.stream(RemoteProcessGroupStatusDescriptor.values()).map(RemoteProcessGroupStatusDescriptor::getDescriptor).collect(Collectors.toSet());
    public static final String NUM_DATA_POINTS_PROPERTY = "nifi.components.status.repository.buffer.size";
    public static final int DEFAULT_NUM_DATA_POINTS = 288;
    private final Map<String, ComponentStatusHistory> componentStatusHistories = new HashMap<String, ComponentStatusHistory>();
    private final RingBuffer<Date> timestamps;
    private final RingBuffer<List<GarbageCollectionStatus>> gcStatuses;
    private final int numDataPoints;
    private volatile long lastCaptureTime = 0L;

    public VolatileComponentStatusRepository() {
        this.numDataPoints = 288;
        this.gcStatuses = null;
        this.timestamps = null;
    }

    public VolatileComponentStatusRepository(NiFiProperties nifiProperties) {
        this.numDataPoints = nifiProperties.getIntegerProperty(NUM_DATA_POINTS_PROPERTY, Integer.valueOf(288));
        this.gcStatuses = new RingBuffer(this.numDataPoints);
        this.timestamps = new RingBuffer(this.numDataPoints);
    }

    public void capture(ProcessGroupStatus rootGroupStatus, List<GarbageCollectionStatus> gcStatus) {
        this.capture(rootGroupStatus, gcStatus, new Date());
    }

    public synchronized void capture(ProcessGroupStatus rootGroupStatus, List<GarbageCollectionStatus> gcStatus, Date timestamp) {
        Date evicted = (Date)this.timestamps.add((Object)timestamp);
        if (evicted != null) {
            this.componentStatusHistories.values().forEach(history -> history.expireBefore(evicted));
        }
        this.capture(rootGroupStatus, timestamp);
        this.gcStatuses.add(gcStatus);
        logger.debug("Captured metrics for {}", (Object)this);
        this.lastCaptureTime = Math.max(this.lastCaptureTime, timestamp.getTime());
    }

    private void capture(ProcessGroupStatus groupStatus, Date timestamp) {
        StatusSnapshot snapshot;
        ComponentDetails componentDetails;
        ComponentDetails groupDetails = ComponentDetails.forProcessGroup(groupStatus);
        StatusSnapshot groupSnapshot = ComponentMetrics.createSnapshot(groupStatus, timestamp);
        this.updateStatusHistory(groupSnapshot, groupDetails, timestamp);
        for (ProcessorStatus processorStatus : groupStatus.getProcessorStatus()) {
            componentDetails = ComponentDetails.forProcessor(processorStatus);
            snapshot = ComponentMetrics.createSnapshot(processorStatus, timestamp);
            this.updateStatusHistory(snapshot, componentDetails, timestamp);
        }
        for (ConnectionStatus connectionStatus : groupStatus.getConnectionStatus()) {
            componentDetails = ComponentDetails.forConnection(connectionStatus);
            snapshot = ComponentMetrics.createSnapshot(connectionStatus, timestamp);
            this.updateStatusHistory(snapshot, componentDetails, timestamp);
        }
        for (RemoteProcessGroupStatus rpgStatus : groupStatus.getRemoteProcessGroupStatus()) {
            componentDetails = ComponentDetails.forRemoteProcessGroup(rpgStatus);
            snapshot = ComponentMetrics.createSnapshot(rpgStatus, timestamp);
            this.updateStatusHistory(snapshot, componentDetails, timestamp);
        }
        for (ProcessGroupStatus childStatus : groupStatus.getProcessGroupStatus()) {
            this.capture(childStatus, timestamp);
        }
    }

    private void updateStatusHistory(StatusSnapshot statusSnapshot, ComponentDetails componentDetails, Date timestamp) {
        String componentId = componentDetails.getComponentId();
        ComponentStatusHistory procHistory = this.componentStatusHistories.computeIfAbsent(componentId, id -> new ComponentStatusHistory(componentDetails, this.numDataPoints));
        procHistory.update(statusSnapshot, componentDetails);
    }

    public Date getLastCaptureDate() {
        return new Date(this.lastCaptureTime);
    }

    public StatusHistory getProcessorStatusHistory(String processorId, Date start, Date end, int preferredDataPoints, boolean includeCounters) {
        return this.getStatusHistory(processorId, includeCounters, DEFAULT_PROCESSOR_METRICS);
    }

    public StatusHistory getConnectionStatusHistory(String connectionId, Date start, Date end, int preferredDataPoints) {
        return this.getStatusHistory(connectionId, true, DEFAULT_CONNECTION_METRICS);
    }

    public StatusHistory getProcessGroupStatusHistory(String processGroupId, Date start, Date end, int preferredDataPoints) {
        return this.getStatusHistory(processGroupId, true, DEFAULT_GROUP_METRICS);
    }

    public StatusHistory getRemoteProcessGroupStatusHistory(String remoteGroupId, Date start, Date end, int preferredDataPoints) {
        return this.getStatusHistory(remoteGroupId, true, DEFAULT_RPG_METRICS);
    }

    private synchronized StatusHistory getStatusHistory(String componentId, boolean includeCounters, Set<MetricDescriptor<?>> defaultMetricDescriptors) {
        ComponentStatusHistory history = this.componentStatusHistories.get(componentId);
        if (history == null) {
            return this.createEmptyStatusHistory();
        }
        List dates = this.timestamps.asList();
        return history.toStatusHistory(dates, includeCounters, defaultMetricDescriptors);
    }

    private StatusHistory createEmptyStatusHistory() {
        final Date dateGenerated = new Date();
        return new StatusHistory(){

            public Date getDateGenerated() {
                return dateGenerated;
            }

            public Map<String, String> getComponentDetails() {
                return Collections.emptyMap();
            }

            public List<StatusSnapshot> getStatusSnapshots() {
                return Collections.emptyList();
            }
        };
    }

    public GarbageCollectionHistory getGarbageCollectionHistory(Date start, Date end) {
        StandardGarbageCollectionHistory history = new StandardGarbageCollectionHistory();
        this.gcStatuses.forEach(statusSet -> {
            for (GarbageCollectionStatus gcStatus : statusSet) {
                if (gcStatus.getTimestamp().before(start) || gcStatus.getTimestamp().after(end)) continue;
                history.addGarbageCollectionStatus(gcStatus);
            }
            return true;
        });
        return history;
    }
}

