/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.RemoteProcessGroupStatus;
import org.apache.nifi.controller.status.history.ConnectionStatusDescriptor;
import org.apache.nifi.controller.status.history.CounterMetricDescriptor;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.ProcessGroupStatusDescriptor;
import org.apache.nifi.controller.status.history.ProcessorStatusDescriptor;
import org.apache.nifi.controller.status.history.RemoteProcessGroupStatusDescriptor;
import org.apache.nifi.controller.status.history.StandardStatusSnapshot;
import org.apache.nifi.controller.status.history.StatusSnapshot;

public class ComponentMetrics {
    private static final Set<MetricDescriptor<?>> PROCESSOR_METRICS = new HashSet();
    private static final Set<MetricDescriptor<?>> CONNECTION_METRICS = new HashSet();
    private static final Set<MetricDescriptor<?>> PROCESS_GROUP_METRICS = new HashSet();
    private static final Set<MetricDescriptor<?>> RPG_METRICS = new HashSet();

    public static StatusSnapshot createSnapshot(ProcessorStatus status, Date timestamp) {
        if (ComponentMetrics.isEmpty(status)) {
            return null;
        }
        StandardStatusSnapshot snapshot = new StandardStatusSnapshot(PROCESSOR_METRICS);
        snapshot.setTimestamp(timestamp);
        for (ProcessorStatusDescriptor descriptor : ProcessorStatusDescriptor.values()) {
            if (!descriptor.isVisible()) continue;
            snapshot.addStatusMetric(descriptor.getDescriptor(), descriptor.getDescriptor().getValueFunction().getValue((Object)status));
        }
        Map counters = status.getCounters();
        if (counters != null) {
            for (Map.Entry entry : counters.entrySet()) {
                String counterName = (String)entry.getKey();
                String label = (String)entry.getKey() + " (5 mins)";
                CounterMetricDescriptor metricDescriptor = new CounterMetricDescriptor((String)entry.getKey(), label, label, MetricDescriptor.Formatter.COUNT, s -> s.getCounters() == null ? null : (Long)s.getCounters().get(counterName));
                snapshot.addCounterStatusMetric(metricDescriptor, (Long)entry.getValue());
            }
        }
        return snapshot;
    }

    public static boolean isEmpty(ProcessorStatus status) {
        for (ProcessorStatusDescriptor descriptor : ProcessorStatusDescriptor.values()) {
            Long value;
            if (!descriptor.isVisible() || (value = descriptor.getDescriptor().getValueFunction().getValue((Object)status)) == null || value <= 0L) continue;
            return false;
        }
        return true;
    }

    public static StatusSnapshot createSnapshot(ConnectionStatus status, Date timestamp) {
        if (ComponentMetrics.isEmpty(status)) {
            return null;
        }
        StandardStatusSnapshot snapshot = new StandardStatusSnapshot(CONNECTION_METRICS);
        snapshot.setTimestamp(timestamp);
        for (ConnectionStatusDescriptor descriptor : ConnectionStatusDescriptor.values()) {
            snapshot.addStatusMetric(descriptor.getDescriptor(), descriptor.getDescriptor().getValueFunction().getValue((Object)status));
        }
        return snapshot;
    }

    public static boolean isEmpty(ConnectionStatus status) {
        for (ConnectionStatusDescriptor descriptor : ConnectionStatusDescriptor.values()) {
            Long value = descriptor.getDescriptor().getValueFunction().getValue((Object)status);
            if (value == null || value <= 0L) continue;
            return false;
        }
        return true;
    }

    public static StatusSnapshot createSnapshot(ProcessGroupStatus status, Date timestamp) {
        if (ComponentMetrics.isEmpty(status)) {
            return null;
        }
        StandardStatusSnapshot snapshot = new StandardStatusSnapshot(PROCESS_GROUP_METRICS);
        snapshot.setTimestamp(timestamp);
        for (ProcessGroupStatusDescriptor descriptor : ProcessGroupStatusDescriptor.values()) {
            snapshot.addStatusMetric(descriptor.getDescriptor(), descriptor.getDescriptor().getValueFunction().getValue((Object)status));
        }
        return snapshot;
    }

    private static boolean isEmpty(ProcessGroupStatus status) {
        for (ProcessGroupStatusDescriptor descriptor : ProcessGroupStatusDescriptor.values()) {
            Long value = descriptor.getDescriptor().getValueFunction().getValue((Object)status);
            if (value == null || value <= 0L) continue;
            return false;
        }
        return true;
    }

    public static StatusSnapshot createSnapshot(RemoteProcessGroupStatus status, Date timestamp) {
        if (ComponentMetrics.isEmpty(status)) {
            return null;
        }
        StandardStatusSnapshot snapshot = new StandardStatusSnapshot(RPG_METRICS);
        snapshot.setTimestamp(timestamp);
        for (RemoteProcessGroupStatusDescriptor descriptor : RemoteProcessGroupStatusDescriptor.values()) {
            snapshot.addStatusMetric(descriptor.getDescriptor(), descriptor.getDescriptor().getValueFunction().getValue((Object)status));
        }
        return snapshot;
    }

    private static boolean isEmpty(RemoteProcessGroupStatus status) {
        for (RemoteProcessGroupStatusDescriptor descriptor : RemoteProcessGroupStatusDescriptor.values()) {
            Long value = descriptor.getDescriptor().getValueFunction().getValue((Object)status);
            if (value == null || value <= 0L) continue;
            return false;
        }
        return true;
    }

    static {
        for (ProcessorStatusDescriptor processorStatusDescriptor : ProcessorStatusDescriptor.values()) {
            PROCESSOR_METRICS.add(processorStatusDescriptor.getDescriptor());
        }
        for (Enum enum_ : ConnectionStatusDescriptor.values()) {
            CONNECTION_METRICS.add(((ConnectionStatusDescriptor)enum_).getDescriptor());
        }
        for (Enum enum_ : ProcessGroupStatusDescriptor.values()) {
            PROCESS_GROUP_METRICS.add(((ProcessGroupStatusDescriptor)enum_).getDescriptor());
        }
        for (Enum enum_ : RemoteProcessGroupStatusDescriptor.values()) {
            RPG_METRICS.add(((RemoteProcessGroupStatusDescriptor)enum_).getDescriptor());
        }
    }
}

