/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.connectable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.controller.AbstractPort;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.scheduling.SchedulingStrategy;

public class LocalPort
extends AbstractPort {
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();

    public LocalPort(String id, String name, ProcessGroup processGroup, ConnectableType type, ProcessScheduler scheduler) {
        super(id, name, processGroup, type, scheduler);
    }

    public boolean isValid() {
        return !this.getConnections(Relationship.ANONYMOUS).isEmpty();
    }

    public Collection<ValidationResult> getValidationErrors() {
        ArrayList<ValidationResult> validationErrors = new ArrayList<ValidationResult>();
        if (!this.isValid()) {
            ValidationResult error = new ValidationResult.Builder().explanation(String.format("Output connection for port '%s' is not defined.", this.getName())).subject(String.format("Port '%s'", this.getName())).valid(false).build();
            validationErrors.add(error);
        }
        return validationErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSession session) {
        this.readLock.lock();
        try {
            Set available = context.getAvailableRelationships();
            int iterations = 0;
            while (!available.isEmpty()) {
                List flowFiles = session.get(1000);
                if (flowFiles.isEmpty()) {
                    break;
                }
                session.transfer((Collection)flowFiles, Relationship.ANONYMOUS);
                session.commit();
                if (flowFiles.size() < 1000) break;
                if (++iterations >= 10) {
                    break;
                }
                available = context.getAvailableRelationships();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void updateConnection(Connection connection) throws IllegalStateException {
        this.writeLock.lock();
        try {
            super.updateConnection(connection);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void addConnection(Connection connection) throws IllegalArgumentException {
        this.writeLock.lock();
        try {
            super.addConnection(connection);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeConnection(Connection connection) throws IllegalArgumentException, IllegalStateException {
        this.writeLock.lock();
        try {
            super.removeConnection(connection);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<Connection> getConnections() {
        this.readLock.lock();
        try {
            Set set = super.getConnections();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<Connection> getConnections(Relationship relationship) {
        this.readLock.lock();
        try {
            Set set = super.getConnections(relationship);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<Connection> getIncomingConnections() {
        this.readLock.lock();
        try {
            List list = super.getIncomingConnections();
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean hasIncomingConnection() {
        this.readLock.lock();
        try {
            boolean bl = super.hasIncomingConnection();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isTriggerWhenEmpty() {
        return false;
    }

    public SchedulingStrategy getSchedulingStrategy() {
        return SchedulingStrategy.TIMER_DRIVEN;
    }

    public boolean isSideEffectFree() {
        return true;
    }

    public String getComponentType() {
        return "Local Port";
    }
}

