/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.flow;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.SSLContext;
import org.apache.nifi.annotation.lifecycle.OnAdded;
import org.apache.nifi.annotation.lifecycle.OnConfigurationRestored;
import org.apache.nifi.annotation.lifecycle.OnRemoved;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.LocalPort;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.ExtensionBuilder;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.StandardFlowSnippet;
import org.apache.nifi.controller.StandardFunnel;
import org.apache.nifi.controller.exception.ComponentLifeCycleException;
import org.apache.nifi.controller.exception.ProcessorInstantiationException;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.controller.label.StandardLabel;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.scheduling.StandardProcessScheduler;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.StandardConfigurationContext;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.groups.StandardProcessGroup;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.ControllerServiceLogObserver;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogObserver;
import org.apache.nifi.logging.LogRepository;
import org.apache.nifi.logging.LogRepositoryFactory;
import org.apache.nifi.logging.ProcessorLogObserver;
import org.apache.nifi.logging.ReportingTaskLogObserver;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.registry.variable.MutableVariableRegistry;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.remote.StandardRemoteProcessGroup;
import org.apache.nifi.remote.StandardRootGroupPort;
import org.apache.nifi.remote.TransferDirection;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.ReflectionUtils;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardFlowManager
implements FlowManager {
    private static final Logger logger = LoggerFactory.getLogger(StandardFlowManager.class);
    private final NiFiProperties nifiProperties;
    private final BulletinRepository bulletinRepository;
    private final StandardProcessScheduler processScheduler;
    private final Authorizer authorizer;
    private final SSLContext sslContext;
    private final FlowController flowController;
    private final FlowFileEventRepository flowFileEventRepository;
    private final boolean isSiteToSiteSecure;
    private volatile ProcessGroup rootGroup;
    private final ConcurrentMap<String, ProcessGroup> allProcessGroups = new ConcurrentHashMap<String, ProcessGroup>();
    private final ConcurrentMap<String, ProcessorNode> allProcessors = new ConcurrentHashMap<String, ProcessorNode>();
    private final ConcurrentMap<String, ReportingTaskNode> allReportingTasks = new ConcurrentHashMap<String, ReportingTaskNode>();
    private final ConcurrentMap<String, ControllerServiceNode> rootControllerServices = new ConcurrentHashMap<String, ControllerServiceNode>();
    private final ConcurrentMap<String, Connection> allConnections = new ConcurrentHashMap<String, Connection>();
    private final ConcurrentMap<String, Port> allInputPorts = new ConcurrentHashMap<String, Port>();
    private final ConcurrentMap<String, Port> allOutputPorts = new ConcurrentHashMap<String, Port>();
    private final ConcurrentMap<String, Funnel> allFunnels = new ConcurrentHashMap<String, Funnel>();

    public StandardFlowManager(NiFiProperties nifiProperties, SSLContext sslContext, FlowController flowController, FlowFileEventRepository flowFileEventRepository) {
        this.nifiProperties = nifiProperties;
        this.flowController = flowController;
        this.bulletinRepository = flowController.getBulletinRepository();
        this.processScheduler = flowController.getProcessScheduler();
        this.authorizer = flowController.getAuthorizer();
        this.sslContext = sslContext;
        this.flowFileEventRepository = flowFileEventRepository;
        this.isSiteToSiteSecure = Boolean.TRUE.equals(nifiProperties.isSiteToSiteSecure());
    }

    public Port createRemoteInputPort(String id, String name) {
        id = Objects.requireNonNull(id).intern();
        name = Objects.requireNonNull(name).intern();
        this.verifyPortIdDoesNotExist(id);
        return new StandardRootGroupPort(id, name, null, TransferDirection.RECEIVE, ConnectableType.INPUT_PORT, this.authorizer, this.bulletinRepository, (ProcessScheduler)this.processScheduler, this.isSiteToSiteSecure, this.nifiProperties);
    }

    public Port createRemoteOutputPort(String id, String name) {
        id = Objects.requireNonNull(id).intern();
        name = Objects.requireNonNull(name).intern();
        this.verifyPortIdDoesNotExist(id);
        return new StandardRootGroupPort(id, name, null, TransferDirection.SEND, ConnectableType.OUTPUT_PORT, this.authorizer, this.bulletinRepository, (ProcessScheduler)this.processScheduler, this.isSiteToSiteSecure, this.nifiProperties);
    }

    public RemoteProcessGroup createRemoteProcessGroup(String id, String uris) {
        return new StandardRemoteProcessGroup(Objects.requireNonNull(id), uris, null, this.processScheduler, this.bulletinRepository, this.sslContext, this.nifiProperties);
    }

    public void setRootGroup(ProcessGroup rootGroup) {
        this.rootGroup = rootGroup;
        this.allProcessGroups.put("root", rootGroup);
        this.allProcessGroups.put(rootGroup.getIdentifier(), rootGroup);
    }

    public ProcessGroup getRootGroup() {
        return this.rootGroup;
    }

    public String getRootGroupId() {
        return this.rootGroup.getIdentifier();
    }

    public boolean areGroupsSame(String id1, String id2) {
        if (id1 == null || id2 == null) {
            return false;
        }
        if (id1.equals(id2)) {
            return true;
        }
        String comparable1 = id1.equals("root") ? this.getRootGroupId() : id1;
        String comparable2 = id2.equals("root") ? this.getRootGroupId() : id2;
        return comparable1.equals(comparable2);
    }

    private void verifyPortIdDoesNotExist(String id) {
        ProcessGroup rootGroup = this.getRootGroup();
        Port port = rootGroup.findOutputPort(id);
        if (port != null) {
            throw new IllegalStateException("An Input Port already exists with ID " + id);
        }
        port = rootGroup.findInputPort(id);
        if (port != null) {
            throw new IllegalStateException("An Input Port already exists with ID " + id);
        }
    }

    public Label createLabel(String id, String text) {
        return new StandardLabel(Objects.requireNonNull(id).intern(), text);
    }

    public Funnel createFunnel(String id) {
        return new StandardFunnel(id.intern(), null, (ProcessScheduler)this.processScheduler);
    }

    public Port createLocalInputPort(String id, String name) {
        id = Objects.requireNonNull(id).intern();
        name = Objects.requireNonNull(name).intern();
        this.verifyPortIdDoesNotExist(id);
        return new LocalPort(id, name, null, ConnectableType.INPUT_PORT, this.processScheduler);
    }

    public Port createLocalOutputPort(String id, String name) {
        id = Objects.requireNonNull(id).intern();
        name = Objects.requireNonNull(name).intern();
        this.verifyPortIdDoesNotExist(id);
        return new LocalPort(id, name, null, ConnectableType.OUTPUT_PORT, this.processScheduler);
    }

    public ProcessGroup createProcessGroup(String id) {
        MutableVariableRegistry mutableVariableRegistry = new MutableVariableRegistry(this.flowController.getVariableRegistry());
        StandardProcessGroup group = new StandardProcessGroup(Objects.requireNonNull(id), this.flowController.getControllerServiceProvider(), this.processScheduler, this.nifiProperties, this.flowController.getEncryptor(), this.flowController, mutableVariableRegistry);
        this.allProcessGroups.put(group.getIdentifier(), group);
        return group;
    }

    public void instantiateSnippet(ProcessGroup group, FlowSnippetDTO dto) throws ProcessorInstantiationException {
        Objects.requireNonNull(group);
        Objects.requireNonNull(dto);
        StandardFlowSnippet snippet = new StandardFlowSnippet(dto, this.flowController.getExtensionManager());
        snippet.validate(group);
        snippet.instantiate(this, group);
        group.findAllRemoteProcessGroups().forEach(RemoteProcessGroup::initialize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowFilePrioritizer createPrioritizer(String type) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            FlowFilePrioritizer prioritizer;
            List prioritizerBundles = this.flowController.getExtensionManager().getBundles(type);
            if (prioritizerBundles.size() == 0) {
                throw new IllegalStateException(String.format("The specified class '%s' is not known to this nifi.", type));
            }
            if (prioritizerBundles.size() > 1) {
                throw new IllegalStateException(String.format("Multiple bundles found for the specified class '%s', only one is allowed.", type));
            }
            Bundle bundle = (Bundle)prioritizerBundles.get(0);
            ClassLoader detectedClassLoaderForType = bundle.getClassLoader();
            Class<?> rawClass = Class.forName(type, true, detectedClassLoaderForType);
            Thread.currentThread().setContextClassLoader(detectedClassLoaderForType);
            Class<FlowFilePrioritizer> prioritizerClass = rawClass.asSubclass(FlowFilePrioritizer.class);
            FlowFilePrioritizer processorObj = prioritizerClass.newInstance();
            FlowFilePrioritizer flowFilePrioritizer = prioritizer = prioritizerClass.cast(processorObj);
            return flowFilePrioritizer;
        }
        finally {
            if (ctxClassLoader != null) {
                Thread.currentThread().setContextClassLoader(ctxClassLoader);
            }
        }
    }

    public ProcessGroup getGroup(String id) {
        return (ProcessGroup)this.allProcessGroups.get(Objects.requireNonNull(id));
    }

    public void onProcessGroupAdded(ProcessGroup group) {
        this.allProcessGroups.put(group.getIdentifier(), group);
    }

    public void onProcessGroupRemoved(ProcessGroup group) {
        this.allProcessGroups.remove(group.getIdentifier());
    }

    public ProcessorNode createProcessor(String type, String id, BundleCoordinate coordinate) {
        return this.createProcessor(type, id, coordinate, true);
    }

    public ProcessorNode createProcessor(String type, String id, BundleCoordinate coordinate, boolean firstTimeAdded) {
        return this.createProcessor(type, id, coordinate, Collections.emptySet(), firstTimeAdded, true);
    }

    public ProcessorNode createProcessor(String type, String id, BundleCoordinate coordinate, Set<URL> additionalUrls, boolean firstTimeAdded, boolean registerLogObserver) {
        LogRepository logRepository = LogRepositoryFactory.getRepository((String)id);
        ExtensionManager extensionManager = this.flowController.getExtensionManager();
        ProcessorNode procNode = new ExtensionBuilder().identifier(id).type(type).bundleCoordinate(coordinate).extensionManager(extensionManager).controllerServiceProvider(this.flowController.getControllerServiceProvider()).processScheduler(this.processScheduler).nodeTypeProvider(this.flowController).validationTrigger(this.flowController.getValidationTrigger()).reloadComponent(this.flowController.getReloadComponent()).variableRegistry(this.flowController.getVariableRegistry()).addClasspathUrls(additionalUrls).kerberosConfig(this.flowController.createKerberosConfig(this.nifiProperties)).extensionManager(extensionManager).buildProcessor();
        LogRepositoryFactory.getRepository((String)procNode.getIdentifier()).setLogger((ComponentLog)procNode.getLogger());
        if (registerLogObserver) {
            logRepository.addObserver("bulletin-observer", procNode.getBulletinLevel(), (LogObserver)new ProcessorLogObserver(this.bulletinRepository, procNode));
        }
        if (firstTimeAdded) {
            Throwable throwable;
            try {
                throwable = null;
                try (NarCloseable x = NarCloseable.withComponentNarLoader((ExtensionManager)extensionManager, procNode.getProcessor().getClass(), (String)procNode.getProcessor().getIdentifier());){
                    ReflectionUtils.invokeMethodsWithAnnotation(OnAdded.class, procNode.getProcessor(), new Object[0]);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Exception e) {
                if (registerLogObserver) {
                    logRepository.removeObserver("bulletin-observer");
                }
                throw new ComponentLifeCycleException("Failed to invoke @OnAdded methods of " + procNode.getProcessor(), (Throwable)e);
            }
            if (firstTimeAdded) {
                throwable = null;
                try (NarCloseable nc = NarCloseable.withComponentNarLoader((ExtensionManager)extensionManager, procNode.getProcessor().getClass(), (String)procNode.getProcessor().getIdentifier());){
                    ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnConfigurationRestored.class, (Object)procNode.getProcessor(), new Object[0]);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
        }
        return procNode;
    }

    public void onProcessorAdded(ProcessorNode procNode) {
        this.allProcessors.put(procNode.getIdentifier(), procNode);
    }

    public void onProcessorRemoved(ProcessorNode procNode) {
        String identifier = procNode.getIdentifier();
        this.flowFileEventRepository.purgeTransferEvents(identifier);
        this.allProcessors.remove(identifier);
    }

    public Connectable findConnectable(String id) {
        ProcessorNode procNode = this.getProcessorNode(id);
        if (procNode != null) {
            return procNode;
        }
        Port inPort = this.getInputPort(id);
        if (inPort != null) {
            return inPort;
        }
        Port outPort = this.getOutputPort(id);
        if (outPort != null) {
            return outPort;
        }
        Funnel funnel = this.getFunnel(id);
        if (funnel != null) {
            return funnel;
        }
        RemoteGroupPort remoteGroupPort = this.getRootGroup().findRemoteGroupPort(id);
        if (remoteGroupPort != null) {
            return remoteGroupPort;
        }
        return null;
    }

    public ProcessorNode getProcessorNode(String id) {
        return (ProcessorNode)this.allProcessors.get(id);
    }

    public void onConnectionAdded(Connection connection) {
        this.allConnections.put(connection.getIdentifier(), connection);
        if (this.flowController.isInitialized()) {
            connection.getFlowFileQueue().startLoadBalancing();
        }
    }

    public void onConnectionRemoved(Connection connection) {
        String identifier = connection.getIdentifier();
        this.flowFileEventRepository.purgeTransferEvents(identifier);
        this.allConnections.remove(identifier);
    }

    public Connection getConnection(String id) {
        return (Connection)this.allConnections.get(id);
    }

    public Connection createConnection(String id, String name, Connectable source, Connectable destination, Collection<String> relationshipNames) {
        return this.flowController.createConnection(id, name, source, destination, relationshipNames);
    }

    public Set<Connection> findAllConnections() {
        return new HashSet<Connection>(this.allConnections.values());
    }

    public void onInputPortAdded(Port inputPort) {
        this.allInputPorts.put(inputPort.getIdentifier(), inputPort);
    }

    public void onInputPortRemoved(Port inputPort) {
        String identifier = inputPort.getIdentifier();
        this.flowFileEventRepository.purgeTransferEvents(identifier);
        this.allInputPorts.remove(identifier);
    }

    public Port getInputPort(String id) {
        return (Port)this.allInputPorts.get(id);
    }

    public void onOutputPortAdded(Port outputPort) {
        this.allOutputPorts.put(outputPort.getIdentifier(), outputPort);
    }

    public void onOutputPortRemoved(Port outputPort) {
        String identifier = outputPort.getIdentifier();
        this.flowFileEventRepository.purgeTransferEvents(identifier);
        this.allOutputPorts.remove(identifier);
    }

    public Port getOutputPort(String id) {
        return (Port)this.allOutputPorts.get(id);
    }

    public void onFunnelAdded(Funnel funnel) {
        this.allFunnels.put(funnel.getIdentifier(), funnel);
    }

    public void onFunnelRemoved(Funnel funnel) {
        String identifier = funnel.getIdentifier();
        this.flowFileEventRepository.purgeTransferEvents(identifier);
        this.allFunnels.remove(identifier);
    }

    public Funnel getFunnel(String id) {
        return (Funnel)this.allFunnels.get(id);
    }

    public ReportingTaskNode createReportingTask(String type, BundleCoordinate bundleCoordinate) {
        return this.createReportingTask(type, bundleCoordinate, true);
    }

    public ReportingTaskNode createReportingTask(String type, BundleCoordinate bundleCoordinate, boolean firstTimeAdded) {
        return this.createReportingTask(type, UUID.randomUUID().toString(), bundleCoordinate, firstTimeAdded);
    }

    public ReportingTaskNode createReportingTask(String type, String id, BundleCoordinate bundleCoordinate, boolean firstTimeAdded) {
        return this.createReportingTask(type, id, bundleCoordinate, Collections.emptySet(), firstTimeAdded, true);
    }

    public ReportingTaskNode createReportingTask(String type, String id, BundleCoordinate bundleCoordinate, Set<URL> additionalUrls, boolean firstTimeAdded, boolean register) {
        if (type == null || id == null || bundleCoordinate == null) {
            throw new NullPointerException();
        }
        LogRepository logRepository = LogRepositoryFactory.getRepository((String)id);
        ExtensionManager extensionManager = this.flowController.getExtensionManager();
        ReportingTaskNode taskNode = new ExtensionBuilder().identifier(id).type(type).bundleCoordinate(bundleCoordinate).extensionManager(this.flowController.getExtensionManager()).controllerServiceProvider(this.flowController.getControllerServiceProvider()).processScheduler(this.processScheduler).nodeTypeProvider(this.flowController).validationTrigger(this.flowController.getValidationTrigger()).reloadComponent(this.flowController.getReloadComponent()).variableRegistry(this.flowController.getVariableRegistry()).addClasspathUrls(additionalUrls).kerberosConfig(this.flowController.createKerberosConfig(this.nifiProperties)).flowController(this.flowController).extensionManager(extensionManager).buildReportingTask();
        LogRepositoryFactory.getRepository((String)taskNode.getIdentifier()).setLogger((ComponentLog)taskNode.getLogger());
        if (firstTimeAdded) {
            Class<?> taskClass = taskNode.getReportingTask().getClass();
            String identifier = taskNode.getReportingTask().getIdentifier();
            try (NarCloseable x = NarCloseable.withComponentNarLoader((ExtensionManager)this.flowController.getExtensionManager(), taskClass, (String)identifier);){
                ReflectionUtils.invokeMethodsWithAnnotation(OnAdded.class, taskNode.getReportingTask(), new Object[0]);
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnConfigurationRestored.class, (Object)taskNode.getReportingTask(), new Object[0]);
            }
            catch (Exception e) {
                throw new ComponentLifeCycleException("Failed to invoke On-Added Lifecycle methods of " + taskNode.getReportingTask(), (Throwable)e);
            }
        }
        if (register) {
            this.allReportingTasks.put(id, taskNode);
            logRepository.addObserver("bulletin-observer", LogLevel.WARN, (LogObserver)new ReportingTaskLogObserver(this.bulletinRepository, taskNode));
        }
        return taskNode;
    }

    public ReportingTaskNode getReportingTaskNode(String taskId) {
        return (ReportingTaskNode)this.allReportingTasks.get(taskId);
    }

    public void removeReportingTask(ReportingTaskNode reportingTaskNode) {
        ReportingTaskNode existing = (ReportingTaskNode)this.allReportingTasks.get(reportingTaskNode.getIdentifier());
        if (existing == null || existing != reportingTaskNode) {
            throw new IllegalStateException("Reporting Task " + reportingTaskNode + " does not exist in this Flow");
        }
        reportingTaskNode.verifyCanDelete();
        Class<?> taskClass = reportingTaskNode.getReportingTask().getClass();
        try (NarCloseable x = NarCloseable.withComponentNarLoader((ExtensionManager)this.flowController.getExtensionManager(), taskClass, (String)reportingTaskNode.getReportingTask().getIdentifier());){
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnRemoved.class, (Object)reportingTaskNode.getReportingTask(), reportingTaskNode.getConfigurationContext());
        }
        for (Map.Entry entry : reportingTaskNode.getProperties().entrySet()) {
            ControllerServiceNode serviceNode;
            String value;
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            if (descriptor.getControllerServiceDefinition() == null || (value = entry.getValue() == null ? descriptor.getDefaultValue() : (String)entry.getValue()) == null || (serviceNode = this.flowController.getControllerServiceProvider().getControllerServiceNode(value)) == null) continue;
            serviceNode.removeReference((ComponentNode)reportingTaskNode);
        }
        this.allReportingTasks.remove(reportingTaskNode.getIdentifier());
        LogRepositoryFactory.removeRepository((String)reportingTaskNode.getIdentifier());
        this.processScheduler.onReportingTaskRemoved(reportingTaskNode);
        this.flowController.getExtensionManager().removeInstanceClassLoader(reportingTaskNode.getIdentifier());
    }

    public Set<ReportingTaskNode> getAllReportingTasks() {
        return new HashSet<ReportingTaskNode>(this.allReportingTasks.values());
    }

    public Set<ControllerServiceNode> getRootControllerServices() {
        return new HashSet<ControllerServiceNode>(this.rootControllerServices.values());
    }

    public void addRootControllerService(ControllerServiceNode serviceNode) {
        ControllerServiceNode existing = this.rootControllerServices.putIfAbsent(serviceNode.getIdentifier(), serviceNode);
        if (existing != null) {
            throw new IllegalStateException("Controller Service with ID " + serviceNode.getIdentifier() + " already exists at the Controller level");
        }
    }

    public ControllerServiceNode getRootControllerService(String serviceIdentifier) {
        return (ControllerServiceNode)this.rootControllerServices.get(serviceIdentifier);
    }

    public void removeRootControllerService(ControllerServiceNode service) {
        ControllerServiceNode existing = (ControllerServiceNode)this.rootControllerServices.get(Objects.requireNonNull(service).getIdentifier());
        if (existing == null) {
            throw new IllegalStateException(service + " is not a member of this Process Group");
        }
        service.verifyCanDelete();
        ExtensionManager extensionManager = this.flowController.getExtensionManager();
        VariableRegistry variableRegistry = this.flowController.getVariableRegistry();
        try (NarCloseable x = NarCloseable.withComponentNarLoader((ExtensionManager)extensionManager, service.getControllerServiceImplementation().getClass(), (String)service.getIdentifier());){
            StandardConfigurationContext configurationContext = new StandardConfigurationContext((ComponentNode)service, (ControllerServiceLookup)this.flowController.getControllerServiceProvider(), null, variableRegistry);
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnRemoved.class, (Object)service.getControllerServiceImplementation(), configurationContext);
        }
        for (Map.Entry entry : service.getProperties().entrySet()) {
            ControllerServiceNode referencedNode;
            String value;
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            if (descriptor.getControllerServiceDefinition() == null || (value = entry.getValue() == null ? descriptor.getDefaultValue() : (String)entry.getValue()) == null || (referencedNode = this.getRootControllerService(value)) == null) continue;
            referencedNode.removeReference((ComponentNode)service);
        }
        this.rootControllerServices.remove(service.getIdentifier());
        this.flowController.getStateManagerProvider().onComponentRemoved(service.getIdentifier());
        extensionManager.removeInstanceClassLoader(service.getIdentifier());
        logger.info("{} removed from Flow Controller", (Object)service, (Object)this);
    }

    public ControllerServiceNode createControllerService(String type, String id, BundleCoordinate bundleCoordinate, Set<URL> additionalUrls, boolean firstTimeAdded, boolean registerLogObserver) {
        LogRepository logRepository = LogRepositoryFactory.getRepository((String)id);
        ExtensionManager extensionManager = this.flowController.getExtensionManager();
        ControllerServiceProvider controllerServiceProvider = this.flowController.getControllerServiceProvider();
        ControllerServiceNode serviceNode = new ExtensionBuilder().identifier(id).type(type).bundleCoordinate(bundleCoordinate).controllerServiceProvider(this.flowController.getControllerServiceProvider()).processScheduler(this.processScheduler).nodeTypeProvider(this.flowController).validationTrigger(this.flowController.getValidationTrigger()).reloadComponent(this.flowController.getReloadComponent()).variableRegistry(this.flowController.getVariableRegistry()).addClasspathUrls(additionalUrls).kerberosConfig(this.flowController.createKerberosConfig(this.nifiProperties)).stateManagerProvider(this.flowController.getStateManagerProvider()).extensionManager(extensionManager).buildControllerService();
        LogRepositoryFactory.getRepository((String)serviceNode.getIdentifier()).setLogger((ComponentLog)serviceNode.getLogger());
        if (registerLogObserver) {
            logRepository.addObserver("bulletin-observer", LogLevel.WARN, (LogObserver)new ControllerServiceLogObserver(this.bulletinRepository, serviceNode));
        }
        if (firstTimeAdded) {
            ControllerService service = serviceNode.getControllerServiceImplementation();
            try (NarCloseable nc = NarCloseable.withComponentNarLoader((ExtensionManager)extensionManager, service.getClass(), (String)service.getIdentifier());){
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnConfigurationRestored.class, (Object)service, new Object[0]);
            }
            ControllerService serviceImpl = serviceNode.getControllerServiceImplementation();
            try (NarCloseable x = NarCloseable.withComponentNarLoader((ExtensionManager)extensionManager, serviceImpl.getClass(), (String)serviceImpl.getIdentifier());){
                ReflectionUtils.invokeMethodsWithAnnotation(OnAdded.class, serviceImpl, new Object[0]);
            }
            catch (Exception e) {
                throw new ComponentLifeCycleException("Failed to invoke On-Added Lifecycle methods of " + serviceImpl, (Throwable)e);
            }
        }
        controllerServiceProvider.onControllerServiceAdded(serviceNode);
        return serviceNode;
    }

    public Set<ControllerServiceNode> getAllControllerServices() {
        HashSet<ControllerServiceNode> allServiceNodes = new HashSet<ControllerServiceNode>();
        allServiceNodes.addAll(this.flowController.getControllerServiceProvider().getNonRootControllerServices());
        allServiceNodes.addAll(this.rootControllerServices.values());
        return allServiceNodes;
    }

    public ControllerServiceNode getControllerServiceNode(String id) {
        return this.flowController.getControllerServiceProvider().getControllerServiceNode(id);
    }
}

