/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.CounterRepository;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.provenance.ProvenanceEventRepository;
import org.apache.nifi.util.Connectables;

public class RepositoryContext {
    private final Connectable connectable;
    private final ContentRepository contentRepo;
    private final FlowFileRepository flowFileRepo;
    private final FlowFileEventRepository flowFileEventRepo;
    private final CounterRepository counterRepo;
    private final ProvenanceEventRepository provenanceRepo;
    private final AtomicLong connectionIndex;

    public RepositoryContext(Connectable connectable, AtomicLong connectionIndex, ContentRepository contentRepository, FlowFileRepository flowFileRepository, FlowFileEventRepository flowFileEventRepository, CounterRepository counterRepository, ProvenanceEventRepository provenanceRepository) {
        this.connectable = connectable;
        this.contentRepo = contentRepository;
        this.flowFileRepo = flowFileRepository;
        this.flowFileEventRepo = flowFileEventRepository;
        this.counterRepo = counterRepository;
        this.provenanceRepo = provenanceRepository;
        this.connectionIndex = connectionIndex;
    }

    Connectable getConnectable() {
        return this.connectable;
    }

    Collection<Connection> getConnections(Relationship relationship) {
        Collection collection = this.connectable.getConnections(relationship);
        if (collection == null) {
            collection = new ArrayList();
        }
        return Collections.unmodifiableCollection(collection);
    }

    List<Connection> getPollableConnections() {
        if (this.pollFromSelfLoopsOnly()) {
            ArrayList<Connection> selfLoops = new ArrayList<Connection>();
            for (Connection connection : this.connectable.getIncomingConnections()) {
                if (connection.getSource() != connection.getDestination()) continue;
                selfLoops.add(connection);
            }
            return selfLoops;
        }
        return this.connectable.getIncomingConnections();
    }

    private boolean isTriggerWhenAnyDestinationAvailable() {
        if (this.connectable.getConnectableType() != ConnectableType.PROCESSOR) {
            return false;
        }
        ProcessorNode procNode = (ProcessorNode)this.connectable;
        return procNode.isTriggerWhenAnyDestinationAvailable();
    }

    private boolean pollFromSelfLoopsOnly() {
        if (this.isTriggerWhenAnyDestinationAvailable()) {
            return !Connectables.anyRelationshipAvailable(this.connectable);
        }
        for (Connection connection : this.connectable.getConnections()) {
            if (!connection.getFlowFileQueue().isFull()) continue;
            return true;
        }
        return false;
    }

    void adjustCounter(String name, long delta) {
        String localContext = this.connectable.getName() + " (" + this.connectable.getIdentifier() + ")";
        String globalContext = "All " + this.connectable.getComponentType() + "'s";
        this.counterRepo.adjustCounter(localContext, name, delta);
        this.counterRepo.adjustCounter(globalContext, name, delta);
    }

    ContentRepository getContentRepository() {
        return this.contentRepo;
    }

    FlowFileRepository getFlowFileRepository() {
        return this.flowFileRepo;
    }

    public FlowFileEventRepository getFlowFileEventRepository() {
        return this.flowFileEventRepo;
    }

    ProvenanceEventRepository getProvenanceRepository() {
        return this.provenanceRepo;
    }

    long getNextFlowFileSequence() {
        return this.flowFileRepo.getNextFlowFileSequence();
    }

    int getNextIncomingConnectionIndex() {
        int numIncomingConnections = this.connectable.getIncomingConnections().size();
        return (int)(this.connectionIndex.getAndIncrement() % (long)Math.max(1, numIncomingConnections));
    }

    public boolean isAnyRelationshipAvailable() {
        for (Relationship relationship : this.getConnectable().getRelationships()) {
            Collection<Connection> connections = this.getConnections(relationship);
            boolean available = true;
            for (Connection connection : connections) {
                if (!connection.getFlowFileQueue().isFull()) continue;
                available = false;
                break;
            }
            if (!available) continue;
            return true;
        }
        return false;
    }

    public int getAvailableRelationshipCount() {
        int count = 0;
        for (Relationship relationship : this.connectable.getRelationships()) {
            Set connections = this.connectable.getConnections(relationship);
            if (connections == null || connections.isEmpty()) {
                ++count;
                continue;
            }
            boolean available = true;
            for (Connection connection : connections) {
                if (connection.getSource() == connection.getDestination() || !connection.getFlowFileQueue().isFull()) continue;
                available = false;
                break;
            }
            if (!available) continue;
            ++count;
        }
        return count;
    }

    public boolean isRelationshipAvailabilitySatisfied(int requiredNumber) {
        int unavailable = 0;
        Collection allRelationships = this.connectable.getRelationships();
        int numRelationships = allRelationships.size();
        int maxUnavailable = numRelationships - requiredNumber;
        for (Relationship relationship : allRelationships) {
            Set connections = this.connectable.getConnections(relationship);
            if (connections == null || connections.isEmpty()) continue;
            boolean available = true;
            for (Connection connection : connections) {
                if (connection.getSource() == connection.getDestination() || !connection.getFlowFileQueue().isFull()) continue;
                available = false;
                break;
            }
            if (available || ++unavailable <= maxUnavailable) continue;
            return false;
        }
        return true;
    }

    public Set<Relationship> getAvailableRelationships() {
        HashSet<Relationship> set = new HashSet<Relationship>();
        for (Relationship relationship : this.getConnectable().getRelationships()) {
            Collection<Connection> connections = this.getConnections(relationship);
            if (connections.isEmpty()) {
                set.add(relationship);
                continue;
            }
            boolean available = true;
            for (Connection connection : connections) {
                if (!connection.getFlowFileQueue().isFull()) continue;
                available = false;
            }
            if (!available) continue;
            set.add(relationship);
        }
        return set;
    }
}

