/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.fingerprint;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.serialization.FlowFromDOMFactory;
import org.apache.nifi.encrypt.StringEncryptor;
import org.apache.nifi.fingerprint.FingerprintException;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.util.BundleUtils;
import org.apache.nifi.util.DomUtils;
import org.apache.nifi.util.LoggingXmlParserErrorHandler;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.ReportingTaskDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FingerprintFactory {
    public static final String NO_VALUE = "NO_VALUE";
    static final String FLOW_CONFIG_XSD = "/FlowConfiguration.xsd";
    private static final String ENCRYPTED_VALUE_PREFIX = "enc{";
    private static final String ENCRYPTED_VALUE_SUFFIX = "}";
    private final StringEncryptor encryptor;
    private final DocumentBuilder flowConfigDocBuilder;
    private final ExtensionManager extensionManager;
    private static final Logger logger = LoggerFactory.getLogger(FingerprintFactory.class);

    public FingerprintFactory(StringEncryptor encryptor, ExtensionManager extensionManager) {
        Schema schema;
        this.encryptor = encryptor;
        this.extensionManager = extensionManager;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            schema = schemaFactory.newSchema(FingerprintFactory.class.getResource(FLOW_CONFIG_XSD));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse schema for file flow configuration.", e);
        }
        try {
            documentBuilderFactory.setSchema(schema);
            this.flowConfigDocBuilder = documentBuilderFactory.newDocumentBuilder();
            this.flowConfigDocBuilder.setErrorHandler(new LoggingXmlParserErrorHandler("Flow Configuration", logger));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create document builder for flow configuration.", e);
        }
    }

    public FingerprintFactory(StringEncryptor encryptor, DocumentBuilder docBuilder, ExtensionManager extensionManager) {
        this.encryptor = encryptor;
        this.flowConfigDocBuilder = docBuilder;
        this.extensionManager = extensionManager;
    }

    public synchronized String createFingerprint(byte[] flowBytes) throws FingerprintException {
        return this.createFingerprint(flowBytes, null);
    }

    public synchronized String createFingerprint(byte[] flowBytes, FlowController controller) throws FingerprintException {
        try {
            return this.createFingerprint(this.parseFlow(flowBytes), controller);
        }
        catch (NoSuchAlgorithmException e) {
            throw new FingerprintException(e);
        }
    }

    private String createFingerprint(Document flowDoc, FlowController controller) throws NoSuchAlgorithmException {
        if (flowDoc == null) {
            return "";
        }
        StringBuilder fingerprintBuilder = new StringBuilder();
        Element flowControllerElem = flowDoc.getDocumentElement();
        if (flowControllerElem == null) {
            logger.warn("Unable to create fingerprint because no 'flowController' element found in XML.");
            return "";
        }
        this.addFlowControllerFingerprint(fingerprintBuilder, flowControllerElem, controller);
        return fingerprintBuilder.toString();
    }

    private Document parseFlow(byte[] flow) throws FingerprintException {
        if (flow == null || flow.length == 0) {
            return null;
        }
        try {
            return this.flowConfigDocBuilder.parse(new ByteArrayInputStream(flow));
        }
        catch (IOException | SAXException ex) {
            throw new FingerprintException(ex);
        }
    }

    private StringBuilder addFlowControllerFingerprint(StringBuilder builder, Element flowControllerElem, FlowController controller) {
        Element reportingTasksElem;
        Element registriesElement = DomUtils.getChild(flowControllerElem, "registries");
        if (registriesElement == null) {
            builder.append(NO_VALUE);
        } else {
            List<Element> flowRegistryElems = DomUtils.getChildElementsByTagName(registriesElement, "flowRegistry");
            if (flowRegistryElems.isEmpty()) {
                builder.append(NO_VALUE);
            } else {
                for (Element flowRegistryElement : flowRegistryElems) {
                    this.addFlowRegistryFingerprint(builder, flowRegistryElement);
                }
            }
        }
        Element rootGroupElem = (Element)DomUtils.getChildNodesByTagName(flowControllerElem, "rootGroup").item(0);
        this.addProcessGroupFingerprint(builder, rootGroupElem, controller);
        Element controllerServicesElem = DomUtils.getChild(flowControllerElem, "controllerServices");
        if (controllerServicesElem != null) {
            ArrayList<ControllerServiceDTO> serviceDtos = new ArrayList<ControllerServiceDTO>();
            for (Element serviceElem : DomUtils.getChildElementsByTagName(controllerServicesElem, "controllerService")) {
                ControllerServiceDTO controllerServiceDTO = FlowFromDOMFactory.getControllerService(serviceElem, this.encryptor);
                serviceDtos.add(controllerServiceDTO);
            }
            Collections.sort(serviceDtos, new Comparator<ControllerServiceDTO>(){

                @Override
                public int compare(ControllerServiceDTO o1, ControllerServiceDTO o2) {
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null && o2 != null) {
                        return 1;
                    }
                    if (o1 != null && o2 == null) {
                        return -1;
                    }
                    return o1.getId().compareTo(o2.getId());
                }
            });
            for (ControllerServiceDTO dto : serviceDtos) {
                this.addControllerServiceFingerprint(builder, dto);
            }
        }
        if ((reportingTasksElem = DomUtils.getChild(flowControllerElem, "reportingTasks")) != null) {
            ArrayList<ReportingTaskDTO> reportingTaskDtos = new ArrayList<ReportingTaskDTO>();
            for (Element element : DomUtils.getChildElementsByTagName(reportingTasksElem, "reportingTask")) {
                ReportingTaskDTO dto = FlowFromDOMFactory.getReportingTask(element, this.encryptor);
                reportingTaskDtos.add(dto);
            }
            Collections.sort(reportingTaskDtos, new Comparator<ReportingTaskDTO>(){

                @Override
                public int compare(ReportingTaskDTO o1, ReportingTaskDTO o2) {
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null && o2 != null) {
                        return 1;
                    }
                    if (o1 != null && o2 == null) {
                        return -1;
                    }
                    return o1.getId().compareTo(o2.getId());
                }
            });
            for (ReportingTaskDTO reportingTaskDTO : reportingTaskDtos) {
                this.addReportingTaskFingerprint(builder, reportingTaskDTO);
            }
        }
        return builder;
    }

    private StringBuilder addFlowRegistryFingerprint(StringBuilder builder, Element flowRegistryElement) {
        Stream.of("id", "name", "url", "description").forEach(elementName -> this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(flowRegistryElement, elementName)));
        return builder;
    }

    private StringBuilder addProcessGroupFingerprint(StringBuilder builder, Element processGroupElem, FlowController controller) throws FingerprintException {
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(processGroupElem, "id"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(processGroupElem, "versionedComponentId"));
        Element versionControlInfo = DomUtils.getChild(processGroupElem, "versionControlInformation");
        if (versionControlInfo == null) {
            builder.append("NO_VERSION_CONTROL_INFORMATION");
        } else {
            this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(versionControlInfo, "registryId"));
            this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(versionControlInfo, "bucketId"));
            this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(versionControlInfo, "flowId"));
            this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(versionControlInfo, "version"));
        }
        List<Element> processorElems = DomUtils.getChildElementsByTagName(processGroupElem, "processor");
        Collections.sort(processorElems, this.getIdsComparator());
        for (Element processorElem : processorElems) {
            this.addFlowFileProcessorFingerprint(builder, processorElem);
        }
        NodeList inputPortElems = DomUtils.getChildNodesByTagName(processGroupElem, "inputPort");
        List<Element> sortedInputPortElems = this.sortElements(inputPortElems, this.getIdsComparator());
        for (Element inputPortElem : sortedInputPortElems) {
            this.addPortFingerprint(builder, inputPortElem);
        }
        NodeList labelElems = DomUtils.getChildNodesByTagName(processGroupElem, "label");
        List<Element> sortedLabels = this.sortElements(labelElems, this.getIdsComparator());
        for (Element labelElem : sortedLabels) {
            this.addLabelFingerprint(builder, labelElem);
        }
        NodeList outputPortElems = DomUtils.getChildNodesByTagName(processGroupElem, "outputPort");
        List<Element> sortedOutputPortElems = this.sortElements(outputPortElems, this.getIdsComparator());
        for (Element outputPortElem : sortedOutputPortElems) {
            this.addPortFingerprint(builder, outputPortElem);
        }
        NodeList nestedProcessGroupElems = DomUtils.getChildNodesByTagName(processGroupElem, "processGroup");
        List<Element> sortedNestedProcessGroupElems = this.sortElements(nestedProcessGroupElems, this.getIdsComparator());
        for (Element nestedProcessGroupElem : sortedNestedProcessGroupElems) {
            this.addProcessGroupFingerprint(builder, nestedProcessGroupElem, controller);
        }
        NodeList remoteProcessGroupElems = DomUtils.getChildNodesByTagName(processGroupElem, "remoteProcessGroup");
        List<Element> sortedRemoteProcessGroupElems = this.sortElements(remoteProcessGroupElems, this.getIdsComparator());
        for (Element remoteProcessGroupElem : sortedRemoteProcessGroupElems) {
            this.addRemoteProcessGroupFingerprint(builder, remoteProcessGroupElem);
        }
        NodeList connectionElems = DomUtils.getChildNodesByTagName(processGroupElem, "connection");
        List<Element> sortedConnectionElems = this.sortElements(connectionElems, this.getIdsComparator());
        for (Element connectionElem : sortedConnectionElems) {
            this.addConnectionFingerprint(builder, connectionElem);
        }
        NodeList funnelElems = DomUtils.getChildNodesByTagName(processGroupElem, "funnel");
        List<Element> sortedFunnelElems = this.sortElements(funnelElems, this.getIdsComparator());
        for (Element funnelElem : sortedFunnelElems) {
            this.addFunnelFingerprint(builder, funnelElem);
        }
        NodeList variableElems = DomUtils.getChildNodesByTagName(processGroupElem, "variable");
        List<Element> sortedVarList = this.sortElements(variableElems, this.getVariableNameComparator());
        for (Element varElem : sortedVarList) {
            this.addVariableFingerprint(builder, varElem);
        }
        return builder;
    }

    private void addVariableFingerprint(StringBuilder builder, Element variableElement) {
        String variableName = variableElement.getAttribute("name");
        String variableValue = variableElement.getAttribute("value");
        builder.append(variableName).append("=").append(variableValue);
    }

    private StringBuilder addFlowFileProcessorFingerprint(StringBuilder builder, Element processorElem) throws FingerprintException {
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(processorElem, "id"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(processorElem, "versionedComponentId"));
        NodeList childNodes = DomUtils.getChildNodesByTagName(processorElem, "class");
        String className = childNodes.item(0).getTextContent();
        this.appendFirstValue(builder, childNodes);
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(processorElem, "annotationData"));
        BundleDTO bundle = FlowFromDOMFactory.getBundle(DomUtils.getChild(processorElem, "bundle"));
        this.addBundleFingerprint(builder, bundle);
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(processorElem, "maxConcurrentTasks"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(processorElem, "schedulingPeriod"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(processorElem, "penalizationPeriod"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(processorElem, "yieldPeriod"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(processorElem, "bulletinLevel"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(processorElem, "lossTolerant"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(processorElem, "schedulingStrategy"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(processorElem, "executionNode"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(processorElem, "runDurationNanos"));
        BundleCoordinate coordinate = this.getCoordinate(className, bundle);
        ConfigurableComponent configurableComponent = this.extensionManager.getTempComponent(className, coordinate);
        if (configurableComponent == null) {
            logger.warn("Unable to get Processor of type {}; its default properties will be fingerprinted instead of being ignored.", (Object)className);
        }
        NodeList propertyElems = DomUtils.getChildNodesByTagName(processorElem, "property");
        List<Element> sortedPropertyElems = this.sortElements(propertyElems, this.getProcessorPropertiesComparator());
        for (Element propertyElem : sortedPropertyElems) {
            String propName = DomUtils.getChildElementsByTagName(propertyElem, "name").get(0).getTextContent();
            String propValue = this.getFirstValue(DomUtils.getChildNodesByTagName(propertyElem, "value"), null);
            this.addPropertyFingerprint(builder, configurableComponent, propName, propValue);
        }
        NodeList autoTerminateElems = DomUtils.getChildNodesByTagName(processorElem, "autoTerminatedRelationship");
        List<Element> sortedAutoTerminateElems = this.sortElements(autoTerminateElems, this.getElementTextComparator());
        for (Element autoTerminateElem : sortedAutoTerminateElems) {
            builder.append(autoTerminateElem.getTextContent());
        }
        return builder;
    }

    private StringBuilder addPropertyFingerprint(StringBuilder builder, ConfigurableComponent component, String propName, String propValue) throws FingerprintException {
        PropertyDescriptor descriptor;
        if (component != null && (descriptor = component.getPropertyDescriptor(propName)) != null && propValue != null && propValue.equals(descriptor.getDefaultValue())) {
            return builder;
        }
        if (propValue == null) {
            return builder;
        }
        builder.append(propName).append("=");
        if (this.isEncrypted(propValue)) {
            builder.append(this.decrypt(propValue));
        } else {
            builder.append(this.getValue(propValue, NO_VALUE));
        }
        return builder;
    }

    private StringBuilder addPortFingerprint(StringBuilder builder, Element portElem) throws FingerprintException {
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(portElem, "id"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(portElem, "versionedComponentId"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(portElem, "name"));
        NodeList userAccessControlNodeList = DomUtils.getChildNodesByTagName(portElem, "userAccessControl");
        if (userAccessControlNodeList == null || userAccessControlNodeList.getLength() == 0) {
            builder.append("NO_USER_ACCESS_CONTROL");
        } else {
            ArrayList<String> sortedAccessControl = new ArrayList<String>();
            for (int i = 0; i < userAccessControlNodeList.getLength(); ++i) {
                sortedAccessControl.add(userAccessControlNodeList.item(i).getTextContent());
            }
            Collections.sort(sortedAccessControl);
            for (String user : sortedAccessControl) {
                builder.append(user);
            }
        }
        NodeList groupAccessControlNodeList = DomUtils.getChildNodesByTagName(portElem, "userAccessControl");
        if (groupAccessControlNodeList == null || groupAccessControlNodeList.getLength() == 0) {
            builder.append("NO_GROUP_ACCESS_CONTROL");
        } else {
            ArrayList<String> sortedAccessControl = new ArrayList<String>();
            for (int i = 0; i < groupAccessControlNodeList.getLength(); ++i) {
                sortedAccessControl.add(groupAccessControlNodeList.item(i).getTextContent());
            }
            Collections.sort(sortedAccessControl);
            for (String user : sortedAccessControl) {
                builder.append(user);
            }
        }
        return builder;
    }

    private StringBuilder addLabelFingerprint(StringBuilder builder, Element labelElem) {
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(labelElem, "id"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(labelElem, "versionedComponentId"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(labelElem, "value"));
        return builder;
    }

    private StringBuilder addRemoteProcessGroupFingerprint(StringBuilder builder, Element remoteProcessGroupElem) throws FingerprintException {
        for (String tagName : new String[]{"id", "versionedComponentId", "urls", "networkInterface", "timeout", "yieldPeriod", "transportProtocol", "proxyHost", "proxyPort", "proxyUser", "proxyPassword"}) {
            String value = this.getFirstValue(DomUtils.getChildNodesByTagName(remoteProcessGroupElem, tagName));
            if (this.isEncrypted(value)) {
                builder.append(this.decrypt(value));
                continue;
            }
            builder.append(value);
        }
        NodeList inputPortList = DomUtils.getChildNodesByTagName(remoteProcessGroupElem, "inputPort");
        NodeList outputPortList = DomUtils.getChildNodesByTagName(remoteProcessGroupElem, "outputPort");
        Comparator<Element> portComparator = new Comparator<Element>(){

            @Override
            public int compare(Element o1, Element o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                NodeList nameList1 = DomUtils.getChildNodesByTagName(o1, "name");
                NodeList nameList2 = DomUtils.getChildNodesByTagName(o2, "name");
                if (nameList1.getLength() == 0 && nameList2.getLength() == 0) {
                    return 0;
                }
                if (nameList1.getLength() == 0) {
                    return 1;
                }
                if (nameList2.getLength() == 0) {
                    return -1;
                }
                return nameList1.item(0).getTextContent().compareTo(nameList2.item(0).getTextContent());
            }
        };
        ArrayList<Element> sortedInputPorts = new ArrayList<Element>(inputPortList.getLength());
        for (int i = 0; i < inputPortList.getLength(); ++i) {
            sortedInputPorts.add((Element)inputPortList.item(i));
        }
        Collections.sort(sortedInputPorts, portComparator);
        ArrayList<Element> sortedOutputPorts = new ArrayList<Element>(outputPortList.getLength());
        for (int i = 0; i < outputPortList.getLength(); ++i) {
            sortedOutputPorts.add((Element)outputPortList.item(i));
        }
        Collections.sort(sortedOutputPorts, portComparator);
        for (Element inputPortElement : sortedInputPorts) {
            this.addRemoteGroupPortFingerprint(builder, inputPortElement);
        }
        for (Element outputPortElement : sortedOutputPorts) {
            this.addRemoteGroupPortFingerprint(builder, outputPortElement);
        }
        return builder;
    }

    private StringBuilder addRemoteGroupPortFingerprint(StringBuilder builder, Element remoteGroupPortElement) {
        for (String childName : new String[]{"id", "targetId", "versionedComponentId", "maxConcurrentTasks", "useCompression", "batchCount", "batchSize", "batchDuration"}) {
            this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(remoteGroupPortElement, childName));
        }
        return builder;
    }

    private StringBuilder addConnectionFingerprint(StringBuilder builder, Element connectionElem) throws FingerprintException {
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(connectionElem, "id"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(connectionElem, "versionedComponentId"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(connectionElem, "sourceId"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(connectionElem, "sourceGroupId"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(connectionElem, "sourceType"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(connectionElem, "destinationId"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(connectionElem, "destinationGroupId"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(connectionElem, "destinationType"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(connectionElem, "name"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(connectionElem, "loadBalanceStrategy"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(connectionElem, "partitioningAttribute"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(connectionElem, "loadBalanceCompression"));
        NodeList relationshipElems = DomUtils.getChildNodesByTagName(connectionElem, "relationship");
        List<Element> sortedRelationshipElems = this.sortElements(relationshipElems, this.getElementTextComparator());
        for (Element relationshipElem : sortedRelationshipElems) {
            builder.append(this.getValue(relationshipElem, NO_VALUE));
        }
        return builder;
    }

    private StringBuilder addFunnelFingerprint(StringBuilder builder, Element funnelElem) throws FingerprintException {
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(funnelElem, "id"));
        this.appendFirstValue(builder, DomUtils.getChildNodesByTagName(funnelElem, "versionedComponentId"));
        return builder;
    }

    private void addControllerServiceFingerprint(StringBuilder builder, ControllerServiceDTO dto) {
        builder.append(dto.getId());
        builder.append(dto.getVersionedComponentId());
        builder.append(dto.getType());
        builder.append(dto.getName());
        this.addBundleFingerprint(builder, dto.getBundle());
        builder.append(dto.getComments());
        builder.append(dto.getAnnotationData());
        builder.append(dto.getState());
        BundleCoordinate coordinate = this.getCoordinate(dto.getType(), dto.getBundle());
        ConfigurableComponent configurableComponent = this.extensionManager.getTempComponent(dto.getType(), coordinate);
        if (configurableComponent == null) {
            logger.warn("Unable to get ControllerService of type {}; its default properties will be fingerprinted instead of being ignored.", (Object)dto.getType());
        }
        this.addPropertiesFingerprint(builder, configurableComponent, dto.getProperties());
    }

    private void addPropertiesFingerprint(StringBuilder builder, ConfigurableComponent component, Map<String, String> properties) {
        if (properties == null) {
            builder.append("NO_PROPERTIES");
        } else {
            TreeMap<String, String> sortedProps = new TreeMap<String, String>(properties);
            for (Map.Entry entry : sortedProps.entrySet()) {
                this.addPropertyFingerprint(builder, component, (String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private void addBundleFingerprint(StringBuilder builder, BundleDTO bundle) {
        if (bundle != null) {
            builder.append(bundle.getGroup());
            builder.append(bundle.getArtifact());
            builder.append(bundle.getVersion());
        } else {
            builder.append("MISSING_BUNDLE");
        }
    }

    private BundleCoordinate getCoordinate(String type, BundleDTO dto) {
        BundleCoordinate coordinate;
        try {
            coordinate = BundleUtils.getCompatibleBundle(this.extensionManager, type, dto);
        }
        catch (IllegalStateException e) {
            coordinate = dto == null ? BundleCoordinate.UNKNOWN_COORDINATE : new BundleCoordinate(dto.getGroup(), dto.getArtifact(), dto.getVersion());
        }
        return coordinate;
    }

    private void addReportingTaskFingerprint(StringBuilder builder, ReportingTaskDTO dto) {
        builder.append(dto.getId());
        builder.append(dto.getType());
        builder.append(dto.getName());
        this.addBundleFingerprint(builder, dto.getBundle());
        builder.append(dto.getComments());
        builder.append(dto.getSchedulingPeriod());
        builder.append(dto.getSchedulingStrategy());
        builder.append(dto.getAnnotationData());
        BundleCoordinate coordinate = this.getCoordinate(dto.getType(), dto.getBundle());
        ConfigurableComponent configurableComponent = this.extensionManager.getTempComponent(dto.getType(), coordinate);
        if (configurableComponent == null) {
            logger.warn("Unable to get ReportingTask of type {}; its default properties will be fingerprinted instead of being ignored.", (Object)dto.getType());
        }
        this.addPropertiesFingerprint(builder, configurableComponent, dto.getProperties());
    }

    private Comparator<Element> getIdsComparator() {
        return new Comparator<Element>(){

            @Override
            public int compare(Element e1, Element e2) {
                String e1Id = FingerprintFactory.this.getFirstValue(DomUtils.getChildNodesByTagName(e1, "id"));
                String e2Id = FingerprintFactory.this.getFirstValue(DomUtils.getChildNodesByTagName(e2, "id"));
                return e1Id.compareTo(e2Id);
            }
        };
    }

    private Comparator<Element> getVariableNameComparator() {
        return new Comparator<Element>(){

            @Override
            public int compare(Element e1, Element e2) {
                if (e1 == null && e2 == null) {
                    return 0;
                }
                if (e1 == null) {
                    return 1;
                }
                if (e2 == null) {
                    return -1;
                }
                String varName1 = e1.getAttribute("name");
                String varName2 = e2.getAttribute("name");
                return varName1.compareTo(varName2);
            }
        };
    }

    private Comparator<Element> getProcessorPropertiesComparator() {
        return new Comparator<Element>(){

            @Override
            public int compare(Element e1, Element e2) {
                String e1PropName = FingerprintFactory.this.getFirstValue(DomUtils.getChildNodesByTagName(e1, "name"));
                String e1PropValue = FingerprintFactory.this.getFirstValue(DomUtils.getChildNodesByTagName(e1, "value"));
                if (FingerprintFactory.this.isEncrypted(e1PropValue)) {
                    e1PropValue = FingerprintFactory.this.decrypt(e1PropValue);
                }
                String e1CombinedValue = e1PropName + e1PropValue;
                String e2PropName = FingerprintFactory.this.getFirstValue(DomUtils.getChildNodesByTagName(e2, "name"));
                String e2PropValue = FingerprintFactory.this.getFirstValue(DomUtils.getChildNodesByTagName(e2, "value"));
                if (FingerprintFactory.this.isEncrypted(e2PropValue)) {
                    e2PropValue = FingerprintFactory.this.decrypt(e2PropValue);
                }
                String e2CombinedValue = e2PropName + e2PropValue;
                return e1CombinedValue.compareTo(e2CombinedValue);
            }
        };
    }

    private Comparator<Element> getElementTextComparator() {
        return new Comparator<Element>(){

            @Override
            public int compare(Element e1, Element e2) {
                if (e2 == null) {
                    return -1;
                }
                if (e1 == null) {
                    return 1;
                }
                return e1.getTextContent().compareTo(e2.getTextContent());
            }
        };
    }

    private List<Element> sortElements(NodeList nodeList, Comparator<Element> comparator) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            result.add((Element)nodeList.item(i));
        }
        Collections.sort(result, comparator);
        return result;
    }

    private String getValue(Node node) {
        return this.getValue(node, NO_VALUE);
    }

    private String getValue(Node node, String defaultValue) {
        String value = node.getTextContent() == null || StringUtils.isBlank((CharSequence)node.getTextContent()) ? defaultValue : node.getTextContent().trim();
        return value;
    }

    private String getValue(String value, String defaultValue) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        return value;
    }

    private String getFirstValue(NodeList nodeList) {
        return this.getFirstValue(nodeList, NO_VALUE);
    }

    private String getFirstValue(NodeList nodeList, String defaultValue) {
        String value = nodeList == null || nodeList.getLength() == 0 ? defaultValue : this.getValue(nodeList.item(0));
        return value;
    }

    private StringBuilder appendFirstValue(StringBuilder builder, NodeList nodeList) {
        return this.appendFirstValue(builder, nodeList, NO_VALUE);
    }

    private StringBuilder appendFirstValue(StringBuilder builder, NodeList nodeList, String defaultValue) {
        return builder.append(this.getFirstValue(nodeList, defaultValue));
    }

    private boolean isEncrypted(String value) {
        return value.startsWith(ENCRYPTED_VALUE_PREFIX) && value.endsWith(ENCRYPTED_VALUE_SUFFIX);
    }

    private String decrypt(String value) throws FingerprintException {
        int decryptStartIdx = ENCRYPTED_VALUE_PREFIX.length();
        int decryptEndIdx = value.length() - ENCRYPTED_VALUE_SUFFIX.length();
        return this.encryptor.decrypt(value.substring(decryptStartIdx, decryptEndIdx));
    }
}

