/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.controller.StandardSnippet;
import org.apache.nifi.persistence.StandardSnippetDeserializer;
import org.apache.nifi.persistence.StandardSnippetSerializer;
import org.apache.nifi.stream.io.StreamUtils;

public class SnippetManager {
    private final Cache<String, StandardSnippet> snippetMap = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();

    public synchronized void addSnippet(StandardSnippet snippet) {
        if (this.snippetMap.getIfPresent((Object)snippet.getId()) != null) {
            throw new IllegalStateException("Snippet with ID " + snippet.getId() + " already exists");
        }
        this.snippetMap.put((Object)snippet.getId(), (Object)snippet);
    }

    public synchronized void removeSnippet(StandardSnippet snippet) {
        if (this.snippetMap.getIfPresent((Object)snippet.getId()) == null) {
            throw new IllegalStateException("Snippet is not contained in this SnippetManager");
        }
        this.snippetMap.invalidate((Object)snippet.getId());
    }

    public synchronized StandardSnippet getSnippet(String identifier) {
        return (StandardSnippet)this.snippetMap.getIfPresent((Object)identifier);
    }

    public synchronized Collection<StandardSnippet> getSnippets() {
        return Collections.unmodifiableCollection(this.snippetMap.asMap().values());
    }

    public synchronized void clear() {
        this.snippetMap.invalidateAll();
    }

    public static List<StandardSnippet> parseBytes(byte[] bytes) {
        ArrayList<StandardSnippet> snippets = new ArrayList<StandardSnippet>();
        try (ByteArrayInputStream rawIn = new ByteArrayInputStream(bytes);
             DataInputStream in = new DataInputStream(rawIn);){
            int length = in.readInt();
            byte[] buffer = new byte[length];
            StreamUtils.fillBuffer((InputStream)in, (byte[])buffer, (boolean)true);
            StandardSnippet snippet = StandardSnippetDeserializer.deserialize(new ByteArrayInputStream(buffer));
            snippets.add(snippet);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse bytes", e);
        }
        return snippets;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] export() {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Object object;
            try (DataOutputStream dos = new DataOutputStream(baos);){
                for (StandardSnippet snippet : this.getSnippets()) {
                    byte[] bytes = StandardSnippetSerializer.serialize(snippet);
                    dos.writeInt(bytes.length);
                    dos.write(bytes);
                }
                object = baos.toByteArray();
            }
            return object;
        }
        catch (IOException e) {
            return null;
        }
    }
}

