/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.net.URL;
import java.util.Set;
import org.apache.nifi.annotation.lifecycle.OnRemoved;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.FlowAnalysisRuleNode;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.LoggableComponent;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.controller.ParameterProviderNode;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReloadComponent;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.TerminationAwareLogger;
import org.apache.nifi.controller.exception.ControllerServiceInstantiationException;
import org.apache.nifi.controller.flowanalysis.FlowAnalysisRuleInstantiationException;
import org.apache.nifi.controller.flowrepository.FlowRepositoryClientInstantiationException;
import org.apache.nifi.controller.parameter.ParameterProviderInstantiationException;
import org.apache.nifi.controller.service.ControllerServiceInvocationHandler;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.StandardConfigurationContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.GroupedComponent;
import org.apache.nifi.logging.LogRepositoryFactory;
import org.apache.nifi.logging.LoggingContext;
import org.apache.nifi.logging.StandardLoggingContext;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.InstanceClassLoader;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.nar.PythonBundle;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.processor.StandardProcessContext;
import org.apache.nifi.registry.flow.FlowRegistryClientNode;
import org.apache.nifi.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardReloadComponent
implements ReloadComponent {
    private static final Logger logger = LoggerFactory.getLogger(StandardReloadComponent.class);
    private final FlowController flowController;

    public StandardReloadComponent(FlowController flowController) {
        this.flowController = flowController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(ProcessorNode existingNode, String newType, BundleCoordinate bundleCoordinate, Set<URL> additionalUrls) {
        if (existingNode == null) {
            throw new IllegalStateException("Existing ProcessorNode cannot be null");
        }
        String id = existingNode.getProcessor().getIdentifier();
        if (existingNode.getLogger() != null) {
            existingNode.getLogger().debug("Reloading component {} to type {} from bundle {}", new Object[]{id, newType, bundleCoordinate});
        }
        ExtensionManager extensionManager = this.flowController.getExtensionManager();
        InstanceClassLoader existingInstanceClassLoader = extensionManager.getInstanceClassLoader(id);
        StateManager stateManager = this.flowController.getStateManagerProvider().getStateManager(id);
        StandardProcessContext processContext = new StandardProcessContext(existingNode, this.flowController.getControllerServiceProvider(), stateManager, () -> false, (NodeTypeProvider)this.flowController);
        try (NarCloseable x = NarCloseable.withComponentNarLoader((ClassLoader)existingInstanceClassLoader);){
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnRemoved.class, (Object)existingNode.getProcessor(), (Object[])new Object[]{processContext});
        }
        finally {
            extensionManager.closeURLClassLoader(id, (ClassLoader)existingInstanceClassLoader);
        }
        if (PythonBundle.isPythonCoordinate((BundleCoordinate)bundleCoordinate)) {
            Thread.ofVirtual().name("Notify Python Processor " + id + " Removed").start(() -> this.flowController.getPythonBridge().onProcessorRemoved(id, existingNode.getComponentType(), existingNode.getBundleCoordinate().getVersion()));
        }
        String classloaderIsolationKey = existingNode.getClassLoaderIsolationKey((PropertyContext)processContext);
        ProcessorNode newNode = this.flowController.getFlowManager().createProcessor(newType, id, bundleCoordinate, additionalUrls, true, false, classloaderIsolationKey);
        SimpleProcessLogger componentLogger = new SimpleProcessLogger(id, (Object)newNode.getProcessor(), (LoggingContext)new StandardLoggingContext((GroupedComponent)newNode));
        TerminationAwareLogger terminationAwareLogger = new TerminationAwareLogger((ComponentLog)componentLogger);
        LogRepositoryFactory.getRepository((String)id).setLogger((ComponentLog)terminationAwareLogger);
        LoggableComponent newProcessor = new LoggableComponent((ConfigurableComponent)newNode.getProcessor(), newNode.getBundleCoordinate(), terminationAwareLogger);
        existingNode.setProcessor(newProcessor);
        existingNode.setExtensionMissing(newNode.isExtensionMissing());
        existingNode.refreshProperties();
        existingNode.onConfigurationRestored((ProcessContext)processContext);
        logger.debug("Triggering async validation of {} due to processor reload", (Object)existingNode);
        this.flowController.getValidationTrigger().trigger((ComponentNode)existingNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(ControllerServiceNode existingNode, String newType, BundleCoordinate bundleCoordinate, Set<URL> additionalUrls) throws ControllerServiceInstantiationException {
        if (existingNode == null) {
            throw new IllegalStateException("Existing ControllerServiceNode cannot be null");
        }
        String id = existingNode.getIdentifier();
        if (existingNode.getLogger() != null) {
            existingNode.getLogger().debug("Reloading component {} to type {} from bundle {}", new Object[]{id, newType, bundleCoordinate});
        }
        ExtensionManager extensionManager = this.flowController.getExtensionManager();
        InstanceClassLoader existingInstanceClassLoader = extensionManager.getInstanceClassLoader(id);
        StandardConfigurationContext configurationContext = new StandardConfigurationContext((ComponentNode)existingNode, (ControllerServiceLookup)this.flowController.getControllerServiceProvider(), null);
        try (NarCloseable x = NarCloseable.withComponentNarLoader((ClassLoader)existingInstanceClassLoader);){
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnRemoved.class, (Object)existingNode.getControllerServiceImplementation(), (Object[])new Object[]{configurationContext});
        }
        finally {
            extensionManager.closeURLClassLoader(id, (ClassLoader)existingInstanceClassLoader);
        }
        String classloaderIsolationKey = existingNode.getClassLoaderIsolationKey((PropertyContext)configurationContext);
        ControllerServiceNode newNode = this.flowController.getFlowManager().createControllerService(newType, id, bundleCoordinate, additionalUrls, true, false, classloaderIsolationKey);
        ControllerServiceInvocationHandler invocationHandler = newNode.getInvocationHandler();
        invocationHandler.setServiceNode(existingNode);
        SimpleProcessLogger componentLogger = new SimpleProcessLogger(id, (Object)newNode.getControllerServiceImplementation(), (LoggingContext)new StandardLoggingContext((GroupedComponent)newNode));
        TerminationAwareLogger terminationAwareLogger = new TerminationAwareLogger((ComponentLog)componentLogger);
        LogRepositoryFactory.getRepository((String)id).setLogger((ComponentLog)terminationAwareLogger);
        LoggableComponent loggableProxy = new LoggableComponent((ConfigurableComponent)newNode.getProxiedControllerService(), bundleCoordinate, terminationAwareLogger);
        LoggableComponent loggableImplementation = new LoggableComponent((ConfigurableComponent)newNode.getControllerServiceImplementation(), bundleCoordinate, terminationAwareLogger);
        existingNode.setControllerServiceAndProxy(loggableImplementation, loggableProxy, invocationHandler);
        existingNode.setExtensionMissing(newNode.isExtensionMissing());
        existingNode.refreshProperties();
        logger.debug("Triggering async validation of {} due to controller service reload", (Object)existingNode);
        this.flowController.getValidationTrigger().triggerAsync((ComponentNode)existingNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(ReportingTaskNode existingNode, String newType, BundleCoordinate bundleCoordinate, Set<URL> additionalUrls) {
        if (existingNode == null) {
            throw new IllegalStateException("Existing ReportingTaskNode cannot be null");
        }
        String id = existingNode.getReportingTask().getIdentifier();
        if (existingNode.getLogger() != null) {
            existingNode.getLogger().debug("Reloading component {} to type {} from bundle {}", new Object[]{id, newType, bundleCoordinate});
        }
        ExtensionManager extensionManager = this.flowController.getExtensionManager();
        InstanceClassLoader existingInstanceClassLoader = extensionManager.getInstanceClassLoader(id);
        ConfigurationContext configurationContext = existingNode.getConfigurationContext();
        try (NarCloseable x = NarCloseable.withComponentNarLoader((ClassLoader)existingInstanceClassLoader);){
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnRemoved.class, (Object)existingNode.getReportingTask(), (Object[])new Object[]{configurationContext});
        }
        finally {
            extensionManager.closeURLClassLoader(id, (ClassLoader)existingInstanceClassLoader);
        }
        String classloaderIsolationKey = existingNode.getClassLoaderIsolationKey((PropertyContext)configurationContext);
        ReportingTaskNode newNode = this.flowController.getFlowManager().createReportingTask(newType, id, bundleCoordinate, additionalUrls, true, false, classloaderIsolationKey);
        SimpleProcessLogger componentLogger = new SimpleProcessLogger(id, (Object)existingNode.getReportingTask(), (LoggingContext)new StandardLoggingContext(null));
        TerminationAwareLogger terminationAwareLogger = new TerminationAwareLogger((ComponentLog)componentLogger);
        LogRepositoryFactory.getRepository((String)id).setLogger((ComponentLog)terminationAwareLogger);
        LoggableComponent newReportingTask = new LoggableComponent((ConfigurableComponent)newNode.getReportingTask(), newNode.getBundleCoordinate(), terminationAwareLogger);
        existingNode.setReportingTask(newReportingTask);
        existingNode.setExtensionMissing(newNode.isExtensionMissing());
        existingNode.refreshProperties();
        logger.debug("Triggering async validation of {} due to reporting task reload", (Object)existingNode);
        this.flowController.getValidationTrigger().triggerAsync((ComponentNode)existingNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(FlowAnalysisRuleNode existingNode, String newType, BundleCoordinate bundleCoordinate, Set<URL> additionalUrls) throws FlowAnalysisRuleInstantiationException {
        if (existingNode == null) {
            throw new IllegalStateException("Existing FlowAnalysisRuleNode cannot be null");
        }
        String id = existingNode.getFlowAnalysisRule().getIdentifier();
        if (existingNode.getLogger() != null) {
            existingNode.getLogger().debug("Reloading component {} to type {} from bundle {}", new Object[]{id, newType, bundleCoordinate});
        }
        ExtensionManager extensionManager = this.flowController.getExtensionManager();
        InstanceClassLoader existingInstanceClassLoader = extensionManager.getInstanceClassLoader(id);
        ConfigurationContext configurationContext = existingNode.getConfigurationContext();
        try (NarCloseable x = NarCloseable.withComponentNarLoader((ClassLoader)existingInstanceClassLoader);){
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnRemoved.class, (Object)existingNode.getFlowAnalysisRule(), (Object[])new Object[]{configurationContext});
        }
        finally {
            extensionManager.closeURLClassLoader(id, (ClassLoader)existingInstanceClassLoader);
        }
        String classloaderIsolationKey = existingNode.getClassLoaderIsolationKey((PropertyContext)configurationContext);
        FlowAnalysisRuleNode newNode = this.flowController.getFlowManager().createFlowAnalysisRule(newType, id, bundleCoordinate, additionalUrls, true, false, classloaderIsolationKey);
        SimpleProcessLogger componentLogger = new SimpleProcessLogger(id, (Object)existingNode.getFlowAnalysisRule(), (LoggingContext)new StandardLoggingContext(null));
        TerminationAwareLogger terminationAwareLogger = new TerminationAwareLogger((ComponentLog)componentLogger);
        LogRepositoryFactory.getRepository((String)id).setLogger((ComponentLog)terminationAwareLogger);
        LoggableComponent newFlowAnalysisRule = new LoggableComponent((ConfigurableComponent)newNode.getFlowAnalysisRule(), newNode.getBundleCoordinate(), terminationAwareLogger);
        existingNode.setFlowAnalysisRule(newFlowAnalysisRule);
        existingNode.setExtensionMissing(newNode.isExtensionMissing());
        existingNode.refreshProperties();
        logger.debug("Triggering async validation of {} due to flow analysis rule reload", (Object)existingNode);
        this.flowController.getValidationTrigger().triggerAsync((ComponentNode)existingNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(ParameterProviderNode existingNode, String newType, BundleCoordinate bundleCoordinate, Set<URL> additionalUrls) throws ParameterProviderInstantiationException {
        if (existingNode == null) {
            throw new IllegalStateException("Existing ParameterProviderNode cannot be null");
        }
        String id = existingNode.getParameterProvider().getIdentifier();
        if (existingNode.getLogger() != null) {
            existingNode.getLogger().debug("Reloading component {} to type {} from bundle {}", new Object[]{id, newType, bundleCoordinate});
        }
        ExtensionManager extensionManager = this.flowController.getExtensionManager();
        InstanceClassLoader existingInstanceClassLoader = extensionManager.getInstanceClassLoader(id);
        ParameterProviderNode newNode = this.flowController.getFlowManager().createParameterProvider(newType, id, bundleCoordinate, additionalUrls, true, false);
        try (NarCloseable x = NarCloseable.withComponentNarLoader((ClassLoader)existingInstanceClassLoader);){
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnRemoved.class, (Object)existingNode.getParameterProvider(), (Object[])new Object[]{existingNode.getConfigurationContext()});
        }
        finally {
            extensionManager.closeURLClassLoader(id, (ClassLoader)existingInstanceClassLoader);
        }
        SimpleProcessLogger componentLogger = new SimpleProcessLogger(id, (Object)existingNode.getParameterProvider(), (LoggingContext)new StandardLoggingContext(null));
        TerminationAwareLogger terminationAwareLogger = new TerminationAwareLogger((ComponentLog)componentLogger);
        LogRepositoryFactory.getRepository((String)id).setLogger((ComponentLog)terminationAwareLogger);
        LoggableComponent newParameterProvider = new LoggableComponent((ConfigurableComponent)newNode.getParameterProvider(), newNode.getBundleCoordinate(), terminationAwareLogger);
        existingNode.setParameterProvider(newParameterProvider);
        existingNode.setExtensionMissing(newNode.isExtensionMissing());
        existingNode.refreshProperties();
        logger.debug("Triggering async validation of {} due to parameter provider reload", (Object)existingNode);
        this.flowController.getValidationTrigger().triggerAsync((ComponentNode)existingNode);
    }

    public void reload(FlowRegistryClientNode existingNode, String newType, BundleCoordinate bundleCoordinate, Set<URL> additionalUrls) throws FlowRepositoryClientInstantiationException {
        if (existingNode == null) {
            throw new IllegalStateException("Existing FlowRegistryClientNode cannot be null");
        }
        String id = existingNode.getComponent().getIdentifier();
        if (existingNode.getLogger() != null) {
            existingNode.getLogger().debug("Reloading component {} to type {} from bundle {}", new Object[]{id, newType, bundleCoordinate});
        }
        ExtensionManager extensionManager = this.flowController.getExtensionManager();
        InstanceClassLoader existingInstanceClassLoader = extensionManager.getInstanceClassLoader(id);
        FlowRegistryClientNode newNode = this.flowController.getFlowManager().createFlowRegistryClient(newType, id, bundleCoordinate, additionalUrls, true, false, null);
        extensionManager.closeURLClassLoader(id, (ClassLoader)existingInstanceClassLoader);
        SimpleProcessLogger componentLogger = new SimpleProcessLogger(id, (Object)existingNode.getComponent(), (LoggingContext)new StandardLoggingContext(null));
        TerminationAwareLogger terminationAwareLogger = new TerminationAwareLogger((ComponentLog)componentLogger);
        LogRepositoryFactory.getRepository((String)id).setLogger((ComponentLog)terminationAwareLogger);
        LoggableComponent newClient = new LoggableComponent(newNode.getComponent(), newNode.getBundleCoordinate(), terminationAwareLogger);
        existingNode.setComponent(newClient);
        existingNode.setExtensionMissing(newNode.isExtensionMissing());
        existingNode.refreshProperties();
        logger.debug("Triggering async validation of {} due to flow registry client reload", (Object)existingNode);
        this.flowController.getValidationTrigger().triggerAsync((ComponentNode)existingNode);
    }
}

