/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.flow;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.components.state.StatelessStateManagerProvider;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.kerberos.KerberosConfig;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.repository.NonPurgeableContentRepository;
import org.apache.nifi.controller.repository.StatelessBridgeFlowFileRepository;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;
import org.apache.nifi.controller.scheduling.StatelessProcessScheduler;
import org.apache.nifi.controller.scheduling.StatelessProcessSchedulerInitializationContext;
import org.apache.nifi.engine.FlowEngine;
import org.apache.nifi.extensions.BundleAvailability;
import org.apache.nifi.extensions.ExtensionRepository;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedExternalFlow;
import org.apache.nifi.flow.VersionedExternalFlowMetadata;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.groups.ComponentIdGenerator;
import org.apache.nifi.groups.ComponentScheduler;
import org.apache.nifi.groups.FlowSynchronizationOptions;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.StandardStatelessGroupNode;
import org.apache.nifi.groups.StatelessGroupFactory;
import org.apache.nifi.groups.StatelessGroupNode;
import org.apache.nifi.groups.StatelessGroupNodeFactory;
import org.apache.nifi.groups.StatelessGroupNodeInitializationContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.ConnectableLogObserver;
import org.apache.nifi.logging.GroupedComponent;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogObserver;
import org.apache.nifi.logging.LogRepository;
import org.apache.nifi.logging.LogRepositoryFactory;
import org.apache.nifi.logging.LoggingContext;
import org.apache.nifi.logging.StandardLoggingContext;
import org.apache.nifi.parameter.ParameterContextManager;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.provenance.ProvenanceEventRepository;
import org.apache.nifi.provenance.ProvenanceRepository;
import org.apache.nifi.registry.flow.mapping.ComponentIdLookup;
import org.apache.nifi.registry.flow.mapping.FlowMappingOptions;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedProcessGroup;
import org.apache.nifi.registry.flow.mapping.NiFiRegistryFlowMapper;
import org.apache.nifi.registry.flow.mapping.VersionedComponentStateLookup;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.stateless.engine.ProcessContextFactory;
import org.apache.nifi.stateless.engine.StandardStatelessEngine;
import org.apache.nifi.stateless.engine.StatelessEngine;
import org.apache.nifi.stateless.engine.StatelessEngineInitializationContext;
import org.apache.nifi.stateless.engine.StatelessFlowManager;
import org.apache.nifi.stateless.engine.StatelessProcessContextFactory;
import org.apache.nifi.stateless.repository.RepositoryContextFactory;
import org.apache.nifi.stateless.repository.StatelessProvenanceRepository;
import org.apache.nifi.stateless.repository.StatelessRepositoryContextFactory;

public class StandardStatelessGroupNodeFactory
implements StatelessGroupNodeFactory {
    private final FlowController flowController;
    private final SSLContext sslContext;
    private final KerberosConfig kerberosConfig;
    private final AtomicReference<FlowEngine> statelessComponentLifecycleThreadPool = new AtomicReference();
    private final AtomicReference<FlowEngine> statelessComponentMonitoringThreadPool = new AtomicReference();
    private final AtomicReference<FlowEngine> statelessFrameworkTaskThreadPool = new AtomicReference();

    public StandardStatelessGroupNodeFactory(FlowController flowController, SSLContext sslContext, KerberosConfig kerberosConfig) {
        this.flowController = flowController;
        this.sslContext = sslContext;
        this.kerberosConfig = kerberosConfig;
    }

    public StatelessGroupNode createStatelessGroupNode(ProcessGroup group) {
        ResourceClaimManager resourceClaimManager = this.flowController.getResourceClaimManager();
        BulletinRepository bulletinRepository = this.flowController.getBulletinRepository();
        FlowFileRepository underlyingFlowFileRepository = this.flowController.getRepositoryContextFactory().getFlowFileRepository();
        StatelessBridgeFlowFileRepository flowFileRepository = new StatelessBridgeFlowFileRepository(underlyingFlowFileRepository, resourceClaimManager);
        StatelessProvenanceRepository statelessProvenanceRepository = new StatelessProvenanceRepository(1000);
        flowFileRepository.initialize(resourceClaimManager);
        NonPurgeableContentRepository contentRepository = new NonPurgeableContentRepository(this.flowController.getRepositoryContextFactory().getContentRepository());
        StatelessRepositoryContextFactory statelessRepoContextFactory = new StatelessRepositoryContextFactory((ContentRepository)contentRepository, (FlowFileRepository)flowFileRepository, this.flowController.getFlowFileEventRepository(), this.flowController.getCounterRepository(), (ProvenanceEventRepository)statelessProvenanceRepository, this.flowController.getStateManagerProvider());
        final FlowMappingOptions flowMappingOptions = new FlowMappingOptions.Builder().componentIdLookup(ComponentIdLookup.USE_COMPONENT_ID).mapControllerServiceReferencesToVersionedId(false).mapInstanceIdentifiers(true).mapPropertyDescriptors(false).mapSensitiveConfiguration(true).sensitiveValueEncryptor(value -> value).stateLookup(VersionedComponentStateLookup.IDENTITY_LOOKUP).build();
        StatelessGroupFactory statelessGroupFactory = new StatelessGroupFactory(){
            final /* synthetic */ RepositoryContextFactory val$statelessRepoContextFactory;
            {
                this.val$statelessRepoContextFactory = repositoryContextFactory;
            }

            public VersionedExternalFlow createVersionedExternalFlow(ProcessGroup group) {
                return StandardStatelessGroupNodeFactory.this.createVersionedExternalFlow(group, flowMappingOptions);
            }

            public ProcessGroup createStatelessProcessGroup(ProcessGroup group, VersionedExternalFlow versionedExternalFlow) {
                return StandardStatelessGroupNodeFactory.this.createStatelessProcessGroup(group, versionedExternalFlow, this.val$statelessRepoContextFactory, flowMappingOptions);
            }
        };
        LogRepository logRepository = LogRepositoryFactory.getRepository((String)group.getIdentifier());
        StatelessGroupNode statelessGroupNode = new StandardStatelessGroupNode.Builder().rootGroup(group).controllerServiceProvider(this.flowController.getControllerServiceProvider()).extensionManager(this.flowController.getExtensionManager()).statelessRepositoryContextFactory((RepositoryContextFactory)statelessRepoContextFactory).nifiFlowFileRepository(underlyingFlowFileRepository).nifiContentRepository(contentRepository).nifiProvenanceRepository((ProvenanceEventRepository)this.flowController.getProvenanceRepository()).flowFileEventRepository(this.flowController.getFlowFileEventRepository()).stateManagerProvider(this.flowController.getStateManagerProvider()).bulletinRepository(this.flowController.getBulletinRepository()).statelessGroupFactory(statelessGroupFactory).lifecycleStateManager(this.flowController.getLifecycleStateManager()).boredYieldDuration(this.flowController.getBoredYieldDuration(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).build();
        logRepository.removeAllObservers();
        logRepository.addObserver(LogLevel.WARN, (LogObserver)new ConnectableLogObserver(bulletinRepository, (Connectable)statelessGroupNode));
        StandardLoggingContext loggingContext = new StandardLoggingContext((GroupedComponent)statelessGroupNode);
        SimpleProcessLogger componentLog = new SimpleProcessLogger((Object)statelessGroupNode, logRepository, (LoggingContext)loggingContext);
        StatelessGroupNodeInitializationContext initContext = () -> StandardStatelessGroupNodeFactory.lambda$createStatelessGroupNode$1((ComponentLog)componentLog);
        statelessGroupNode.initialize(initContext);
        return statelessGroupNode;
    }

    private VersionedExternalFlow createVersionedExternalFlow(ProcessGroup group, FlowMappingOptions flowMappingOptions) {
        NiFiRegistryFlowMapper flowMapper = new NiFiRegistryFlowMapper(this.flowController.getExtensionManager(), flowMappingOptions);
        InstantiatedVersionedProcessGroup versionedGroup = flowMapper.mapNonVersionedProcessGroup(group, this.flowController.getControllerServiceProvider());
        Map parameterContexts = flowMapper.mapParameterContexts(group, true, new HashMap());
        Map externalControllerServiceReferences = Optional.ofNullable(versionedGroup.getExternalControllerServiceReferences()).orElse(Collections.emptyMap());
        VersionedExternalFlow versionedExternalFlow = new VersionedExternalFlow();
        versionedExternalFlow.setFlowContents((VersionedProcessGroup)versionedGroup);
        versionedExternalFlow.setExternalControllerServices(externalControllerServiceReferences);
        versionedExternalFlow.setParameterContexts(parameterContexts);
        versionedExternalFlow.setParameterProviders(Collections.emptyMap());
        VersionedExternalFlowMetadata metadata = new VersionedExternalFlowMetadata();
        metadata.setFlowName(group.getName());
        versionedExternalFlow.setMetadata(metadata);
        return versionedExternalFlow;
    }

    private ProcessGroup createStatelessProcessGroup(ProcessGroup group, VersionedExternalFlow versionedExternalFlow, RepositoryContextFactory statelessRepositoryContextFactory, FlowMappingOptions flowMappingOptions) {
        FlowFileEventRepository flowFileEventRepository = this.flowController.getFlowFileEventRepository();
        BooleanSupplier flowInitializedCheck = this.flowController::isInitialized;
        ParameterContextManager parameterContextManager = this.flowController.getFlowManager().getParameterContextManager();
        ExtensionRepository extensionRepository = new ExtensionRepository(this){

            public void initialize() {
            }

            public BundleAvailability getBundleAvailability(BundleCoordinate bundleCoordinate) {
                return BundleAvailability.BUNDLE_AVAILABLE;
            }

            public Future<Set<Bundle>> fetch(Set<BundleCoordinate> bundleCoordinates, ExecutorService executorService, int concurrentDownloads) {
                return CompletableFuture.completedFuture(Collections.emptySet());
            }
        };
        StatelessProcessScheduler statelessScheduler = new StatelessProcessScheduler(this.flowController.getExtensionManager(), Duration.of(10L, ChronoUnit.SECONDS));
        StatelessStateManagerProvider stateManagerProvider = new StatelessStateManagerProvider();
        StandardStatelessEngine statelessEngine = new StandardStatelessEngine.Builder().bulletinRepository(this.flowController.getBulletinRepository()).counterRepository(this.flowController.getCounterRepository()).encryptor(this.flowController.getEncryptor()).extensionManager(this.flowController.getExtensionManager()).extensionRepository(extensionRepository).flowFileEventRepository(flowFileEventRepository).processScheduler((ProcessScheduler)statelessScheduler).provenanceRepository((ProvenanceRepository)statelessRepositoryContextFactory.getProvenanceRepository()).stateManagerProvider(stateManagerProvider).kerberosConfiguration(this.kerberosConfig).statusTaskInterval(null).build();
        BulletinRepository bulletinRepository = this.flowController.getBulletinRepository();
        StatelessFlowManager statelessFlowManager = new StatelessFlowManager(flowFileEventRepository, parameterContextManager, (StatelessEngine)statelessEngine, flowInitializedCheck, this.sslContext, bulletinRepository);
        StatelessProcessContextFactory processContextFactory = new StatelessProcessContextFactory(this.flowController.getControllerServiceProvider(), (StateManagerProvider)stateManagerProvider);
        StatelessEngineInitializationContext engineInitContext = new StatelessEngineInitializationContext(this.flowController.getControllerServiceProvider(), (FlowManager)statelessFlowManager, (ProcessContextFactory)processContextFactory, statelessRepositoryContextFactory);
        statelessEngine.initialize(engineInitContext);
        FlowEngine componentLifecycleThreadPool = this.lazyInitializeThreadPool(this.statelessComponentLifecycleThreadPool, () -> new FlowEngine(8, "Stateless Component Lifecycle", true));
        FlowEngine componentMonitoringThreadPool = this.lazyInitializeThreadPool(this.statelessComponentMonitoringThreadPool, () -> new FlowEngine(2, "Stateless Component Monitoring", true));
        FlowEngine frameworkTaskThreadPool = this.lazyInitializeThreadPool(this.statelessFrameworkTaskThreadPool, () -> new FlowEngine(2, "Stateless Framework Tasks", true));
        StatelessProcessSchedulerInitializationContext schedulerInitializationContext = new StatelessProcessSchedulerInitializationContext.Builder().processContextFactory((ProcessContextFactory)processContextFactory).componentLifeCycleThreadPool(componentLifecycleThreadPool).componentMonitoringThreadPool(componentMonitoringThreadPool).frameworkTaskThreadPool(frameworkTaskThreadPool).manageThreadPools(false).build();
        statelessScheduler.initialize(schedulerInitializationContext);
        ProcessGroup tempRootGroup = statelessFlowManager.createProcessGroup("root");
        tempRootGroup.setName("root");
        statelessFlowManager.setRootGroup(tempRootGroup);
        ProcessGroup child = statelessFlowManager.createProcessGroup(group.getIdentifier());
        child.setName(group.getName());
        child.setParent(tempRootGroup);
        ComponentIdGenerator idGenerator = (proposedId, instanceId, destinationGroupId) -> instanceId;
        FlowSynchronizationOptions synchronizationOptions = new FlowSynchronizationOptions.Builder().componentComparisonIdLookup(VersionedComponent::getInstanceIdentifier).componentIdGenerator(idGenerator).componentScheduler(ComponentScheduler.NOP_SCHEDULER).componentStopTimeout(Duration.ofSeconds(60L)).propertyDecryptor(value -> value).topLevelGroupId(group.getIdentifier()).updateDescendantVersionedFlows(true).updateGroupSettings(true).updateGroupVersionControlSnapshot(false).updateRpgUrls(true).ignoreLocalModifications(true).build();
        child.synchronizeFlow(versionedExternalFlow, synchronizationOptions, flowMappingOptions);
        child.setParent(group);
        return child;
    }

    private FlowEngine lazyInitializeThreadPool(AtomicReference<FlowEngine> reference, Supplier<FlowEngine> factory) {
        boolean updated;
        FlowEngine threadPool = reference.get();
        if (threadPool == null && !(updated = reference.compareAndSet(null, threadPool = factory.get()))) {
            threadPool.shutdown();
            threadPool = reference.get();
        }
        return threadPool;
    }

    private static /* synthetic */ ComponentLog lambda$createStatelessGroupNode$1(ComponentLog componentLog) {
        return componentLog;
    }
}

