/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.inheritance;

import java.util.Set;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.cluster.protocol.DataFlow;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.flow.VersionedDataflow;
import org.apache.nifi.controller.inheritance.FlowInheritability;
import org.apache.nifi.controller.inheritance.FlowInheritabilityCheck;
import org.apache.nifi.flow.VersionedControllerService;
import org.apache.nifi.flow.VersionedFlowAnalysisRule;
import org.apache.nifi.flow.VersionedFlowRegistryClient;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.flow.VersionedProcessor;
import org.apache.nifi.flow.VersionedReportingTask;
import org.apache.nifi.nar.ExtensionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class BundleCompatibilityCheck
implements FlowInheritabilityCheck {
    private static final Logger logger = LoggerFactory.getLogger(BundleCompatibilityCheck.class);

    @Override
    public FlowInheritability checkInheritability(DataFlow existingFlow, DataFlow proposedFlow, FlowController flowController) {
        return this.checkBundles(proposedFlow, flowController.getExtensionManager());
    }

    private FlowInheritability checkBundles(DataFlow proposedFlow, ExtensionManager extensionManager) {
        VersionedDataflow dataflow = proposedFlow.getVersionedDataflow();
        if (dataflow == null) {
            return FlowInheritability.inheritable();
        }
        Set missingComponents = proposedFlow.getMissingComponents();
        if (dataflow.getControllerServices() != null) {
            for (VersionedControllerService service : dataflow.getControllerServices()) {
                if (missingComponents.contains(service.getInstanceIdentifier()) || !this.isMissing(service.getBundle(), extensionManager)) continue;
                return FlowInheritability.notInheritable(String.format("Controller Service with ID %s and type %s requires bundle %s, but that bundle cannot be found in this NiFi instance", service.getInstanceIdentifier(), service.getType(), service.getBundle()));
            }
        }
        if (dataflow.getReportingTasks() != null) {
            for (VersionedReportingTask task : dataflow.getReportingTasks()) {
                if (missingComponents.contains(task.getInstanceIdentifier()) || !this.isMissing(task.getBundle(), extensionManager)) continue;
                return FlowInheritability.notInheritable(String.format("Reporting Task with ID %s and type %s requires bundle %s, but that bundle cannot be found in this NiFi instance", task.getInstanceIdentifier(), task.getType(), task.getBundle()));
            }
        }
        if (dataflow.getFlowAnalysisRules() != null) {
            for (VersionedFlowAnalysisRule rule : dataflow.getFlowAnalysisRules()) {
                if (missingComponents.contains(rule.getInstanceIdentifier()) || !this.isMissing(rule.getBundle(), extensionManager)) continue;
                return FlowInheritability.notInheritable(String.format("Flow Analysis Rule with ID %s and type %s requires bundle %s, but that bundle cannot be found in this NiFi instance", rule.getInstanceIdentifier(), rule.getType(), rule.getBundle()));
            }
        }
        if (dataflow.getParameterProviders() != null) {
            for (VersionedReportingTask task : dataflow.getParameterProviders()) {
                if (missingComponents.contains(task.getInstanceIdentifier()) || !this.isMissing(task.getBundle(), extensionManager)) continue;
                return FlowInheritability.notInheritable(String.format("Parameter Provider with ID %s and type %s requires bundle %s, but that bundle cannot be found in this NiFi instance", task.getInstanceIdentifier(), task.getType(), task.getBundle()));
            }
        }
        if (dataflow.getRegistries() != null) {
            for (VersionedFlowRegistryClient registryClient : dataflow.getRegistries()) {
                if (registryClient.getBundle() == null || missingComponents.contains(registryClient.getInstanceIdentifier()) || !this.isMissing(registryClient.getBundle(), extensionManager)) continue;
                return FlowInheritability.notInheritable(String.format("Flow Registry Client with ID %s and type %s requires bundle %s, but that bundle cannot be found in this NiFi instance", registryClient.getInstanceIdentifier(), registryClient.getType(), registryClient.getBundle()));
            }
        }
        return this.checkBundles(dataflow.getRootGroup(), extensionManager, missingComponents);
    }

    private FlowInheritability checkBundles(VersionedProcessGroup group, ExtensionManager extensionManager, Set<String> missingComponents) {
        for (VersionedProcessor processor : group.getProcessors()) {
            if (missingComponents.contains(processor.getInstanceIdentifier()) || !this.isMissing(processor.getBundle(), extensionManager)) continue;
            return FlowInheritability.notInheritable(String.format("Processor with ID %s and type %s requires bundle %s, but that bundle cannot be found in this NiFi instance", processor.getInstanceIdentifier(), processor.getType(), processor.getBundle()));
        }
        for (VersionedControllerService service : group.getControllerServices()) {
            if (missingComponents.contains(service.getInstanceIdentifier()) || !this.isMissing(service.getBundle(), extensionManager)) continue;
            return FlowInheritability.notInheritable(String.format("Controller Service with ID %s and type %s requires bundle %s, but that bundle cannot be found in this NiFi instance", service.getInstanceIdentifier(), service.getType(), service.getBundle()));
        }
        for (VersionedProcessGroup childGroup : group.getProcessGroups()) {
            FlowInheritability childInheritability = this.checkBundles(childGroup, extensionManager, missingComponents);
            if (childInheritability.isInheritable()) continue;
            return childInheritability;
        }
        return FlowInheritability.inheritable();
    }

    private boolean isMissing(org.apache.nifi.flow.Bundle bundle, ExtensionManager extensionManager) {
        BundleCoordinate coordinate = new BundleCoordinate(bundle.getGroup(), bundle.getArtifact(), bundle.getVersion());
        Bundle existingBundle = extensionManager.getBundle(coordinate);
        return existingBundle == null;
    }

    private FlowInheritability checkInheritability(Document configuration, FlowController flowController) {
        return FlowInheritability.inheritable();
    }
}

